/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin2.Span;

public final class V2SpanConverter {
    public static List<zipkin2.Span> fromSpan(Span source) {
        Builders builders = new Builders(source);
        builders.processAnnotations(source);
        builders.processBinaryAnnotations(source);
        return builders.build();
    }

    static boolean closeEnough(Endpoint left, Endpoint right) {
        return left.serviceName.equals(right.serviceName);
    }

    static Span.Builder newBuilder(Span source) {
        return zipkin2.Span.newBuilder().traceId(source.traceIdString()).parentId(source.parentId != null ? Util.toLowerHex(source.parentId) : null).id(Util.toLowerHex(source.id)).name(source.name).debug(source.debug);
    }

    public static Span toSpan(zipkin2.Span in) {
        long endTs;
        String traceId = in.traceId();
        Span.Builder result = Span.builder().traceId(Util.lowerHexToUnsignedLong(traceId)).parentId(in.parentId() != null ? Long.valueOf(Util.lowerHexToUnsignedLong(in.parentId())) : null).id(Util.lowerHexToUnsignedLong(in.id())).debug(in.debug()).name(in.name() != null ? in.name() : "");
        if (traceId.length() == 32) {
            result.traceIdHigh(Util.lowerHexToUnsignedLong(traceId, 0));
        }
        long startTs = in.timestampAsLong();
        long duration = in.durationAsLong();
        long l = endTs = startTs != 0L && duration != 0L ? startTs + duration : 0L;
        if (startTs != 0L) {
            result.timestamp(startTs);
            result.duration(duration);
        }
        Endpoint local = in.localEndpoint() != null ? V2SpanConverter.toEndpoint(in.localEndpoint()) : null;
        Endpoint remote = in.remoteEndpoint() != null ? V2SpanConverter.toEndpoint(in.remoteEndpoint()) : null;
        Span.Kind kind = in.kind();
        Annotation cs = null;
        Annotation sr = null;
        Annotation ss = null;
        Annotation cr = null;
        Annotation ms = null;
        Annotation mr = null;
        Annotation ws = null;
        Annotation wr = null;
        String remoteEndpointType = null;
        boolean wroteEndpoint = false;
        int length = in.annotations().size();
        for (int i = 0; i < length; ++i) {
            zipkin2.Annotation input = (zipkin2.Annotation)in.annotations().get(i);
            Annotation a = Annotation.create(input.timestamp(), input.value(), local);
            if (a.value.length() == 2) {
                if (a.value.equals("cs")) {
                    kind = Span.Kind.CLIENT;
                    cs = a;
                    remoteEndpointType = "sa";
                    continue;
                }
                if (a.value.equals("sr")) {
                    kind = Span.Kind.SERVER;
                    sr = a;
                    remoteEndpointType = "ca";
                    continue;
                }
                if (a.value.equals("ss")) {
                    kind = Span.Kind.SERVER;
                    ss = a;
                    continue;
                }
                if (a.value.equals("cr")) {
                    kind = Span.Kind.CLIENT;
                    cr = a;
                    continue;
                }
                if (a.value.equals("ms")) {
                    kind = Span.Kind.PRODUCER;
                    ms = a;
                    continue;
                }
                if (a.value.equals("mr")) {
                    kind = Span.Kind.CONSUMER;
                    mr = a;
                    continue;
                }
                if (a.value.equals("ws")) {
                    ws = a;
                    continue;
                }
                if (a.value.equals("wr")) {
                    wr = a;
                    continue;
                }
                wroteEndpoint = true;
                result.addAnnotation(a);
                continue;
            }
            wroteEndpoint = true;
            result.addAnnotation(a);
        }
        if (kind != null) {
            switch (kind) {
                case CLIENT: {
                    remoteEndpointType = "sa";
                    if (startTs != 0L) {
                        cs = Annotation.create(startTs, "cs", local);
                    }
                    if (endTs == 0L) break;
                    cr = Annotation.create(endTs, "cr", local);
                    break;
                }
                case SERVER: {
                    remoteEndpointType = "ca";
                    if (startTs != 0L) {
                        sr = Annotation.create(startTs, "sr", local);
                    }
                    if (endTs == 0L) break;
                    ss = Annotation.create(endTs, "ss", local);
                    break;
                }
                case PRODUCER: {
                    remoteEndpointType = "ma";
                    if (startTs != 0L) {
                        ms = Annotation.create(startTs, "ms", local);
                    }
                    if (endTs == 0L) break;
                    ws = Annotation.create(endTs, "ws", local);
                    break;
                }
                case CONSUMER: {
                    remoteEndpointType = "ma";
                    if (startTs != 0L && endTs != 0L) {
                        wr = Annotation.create(startTs, "wr", local);
                        mr = Annotation.create(endTs, "mr", local);
                        break;
                    }
                    if (startTs == 0L) break;
                    mr = Annotation.create(startTs, "mr", local);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"update kind mapping");
                }
            }
        }
        for (Map.Entry tag : in.tags().entrySet()) {
            wroteEndpoint = true;
            result.addBinaryAnnotation(BinaryAnnotation.create((String)tag.getKey(), (String)tag.getValue(), local));
        }
        if (cs != null || sr != null || ss != null || cr != null || ws != null || wr != null || ms != null || mr != null) {
            if (cs != null) {
                result.addAnnotation(cs);
            }
            if (sr != null) {
                result.addAnnotation(sr);
            }
            if (ss != null) {
                result.addAnnotation(ss);
            }
            if (cr != null) {
                result.addAnnotation(cr);
            }
            if (ws != null) {
                result.addAnnotation(ws);
            }
            if (wr != null) {
                result.addAnnotation(wr);
            }
            if (ms != null) {
                result.addAnnotation(ms);
            }
            if (mr != null) {
                result.addAnnotation(mr);
            }
            wroteEndpoint = true;
        } else if (local != null && remote != null) {
            result.addBinaryAnnotation(BinaryAnnotation.address("ca", local));
            wroteEndpoint = true;
            remoteEndpointType = "sa";
        }
        if (remoteEndpointType != null && remote != null) {
            result.addBinaryAnnotation(BinaryAnnotation.address(remoteEndpointType, remote));
        }
        if (Boolean.TRUE.equals(in.shared()) && sr != null) {
            result.timestamp(null).duration(null);
        }
        if (local != null && !wroteEndpoint) {
            result.addBinaryAnnotation(BinaryAnnotation.create("lc", "", local));
        }
        return result.build();
    }

    public static Endpoint toEndpoint(zipkin2.Endpoint input) {
        Endpoint.Builder result = Endpoint.builder().serviceName(input.serviceName() != null ? input.serviceName() : "").port(input.port() != null ? input.port() : 0);
        if (input.ipv6() != null) {
            result.parseIp(input.ipv6());
        }
        if (input.ipv4() != null) {
            result.parseIp(input.ipv4());
        }
        return result.build();
    }

    static boolean endTimestampReflectsSpanDuration(Annotation end, Span source) {
        return end != null && source.timestamp != null && source.duration != null && source.timestamp + source.duration == end.timestamp;
    }

    static List<Span> toSpans(List<zipkin2.Span> spans) {
        if (spans.isEmpty()) {
            return Collections.emptyList();
        }
        int length = spans.size();
        ArrayList<Span> span1s = new ArrayList<Span>(length);
        for (int i = 0; i < length; ++i) {
            span1s.add(V2SpanConverter.toSpan(spans.get(i)));
        }
        return span1s;
    }

    public static zipkin2.DependencyLink fromLink(DependencyLink link) {
        return zipkin2.DependencyLink.newBuilder().parent(link.parent).child(link.child).callCount(link.callCount).errorCount(link.errorCount).build();
    }

    public static DependencyLink toLink(zipkin2.DependencyLink link) {
        return DependencyLink.builder().parent(link.parent()).child(link.child()).callCount(link.callCount()).errorCount(link.errorCount()).build();
    }

    public static List<DependencyLink> toLinks(List<zipkin2.DependencyLink> links) {
        if (links.isEmpty()) {
            return Collections.emptyList();
        }
        int length = links.size();
        ArrayList<DependencyLink> result = new ArrayList<DependencyLink>(length);
        for (int i = 0; i < length; ++i) {
            zipkin2.DependencyLink link2 = links.get(i);
            result.add(DependencyLink.builder().parent(link2.parent()).child(link2.child()).callCount(link2.callCount()).errorCount(link2.errorCount()).build());
        }
        return result;
    }

    public static List<zipkin2.DependencyLink> fromLinks(Iterable<DependencyLink> links) {
        ArrayList<zipkin2.DependencyLink> result = new ArrayList<zipkin2.DependencyLink>();
        for (DependencyLink link1 : links) {
            result.add(zipkin2.DependencyLink.newBuilder().parent(link1.parent).child(link1.child).callCount(link1.callCount).errorCount(link1.errorCount).build());
        }
        return result;
    }

    public static List<zipkin2.Span> fromSpans(Iterable<Span> spans) {
        ArrayList<zipkin2.Span> result = new ArrayList<zipkin2.Span>();
        for (Span span1 : spans) {
            result.addAll(V2SpanConverter.fromSpan(span1));
        }
        return result;
    }

    static final class Builders {
        final List<Span.Builder> spans = new ArrayList<Span.Builder>();
        Annotation cs = null;
        Annotation sr = null;
        Annotation ss = null;
        Annotation cr = null;
        Annotation ms = null;
        Annotation mr = null;
        Annotation ws = null;
        Annotation wr = null;

        Builders(Span source) {
            this.spans.add(V2SpanConverter.newBuilder(source));
        }

        void processAnnotations(Span source) {
            int length = source.annotations.size();
            for (int i = 0; i < length; ++i) {
                Annotation a = source.annotations.get(i);
                Span.Builder currentSpan = this.forEndpoint(source, a.endpoint);
                if (a.value.length() == 2 && a.endpoint != null) {
                    if (a.value.equals("cs")) {
                        currentSpan.kind(Span.Kind.CLIENT);
                        this.cs = a;
                        continue;
                    }
                    if (a.value.equals("sr")) {
                        currentSpan.kind(Span.Kind.SERVER);
                        this.sr = a;
                        continue;
                    }
                    if (a.value.equals("ss")) {
                        currentSpan.kind(Span.Kind.SERVER);
                        this.ss = a;
                        continue;
                    }
                    if (a.value.equals("cr")) {
                        currentSpan.kind(Span.Kind.CLIENT);
                        this.cr = a;
                        continue;
                    }
                    if (a.value.equals("ms")) {
                        currentSpan.kind(Span.Kind.PRODUCER);
                        this.ms = a;
                        continue;
                    }
                    if (a.value.equals("mr")) {
                        currentSpan.kind(Span.Kind.CONSUMER);
                        this.mr = a;
                        continue;
                    }
                    if (a.value.equals("ws")) {
                        this.ws = a;
                        continue;
                    }
                    if (a.value.equals("wr")) {
                        this.wr = a;
                        continue;
                    }
                    currentSpan.addAnnotation(a.timestamp, a.value);
                    continue;
                }
                currentSpan.addAnnotation(a.timestamp, a.value);
            }
            if (this.cs == null && Builders.endTimestampReflectsSpanDuration(this.cr, source)) {
                this.cs = Annotation.create(source.timestamp, "cs", this.cr.endpoint);
            }
            if (this.sr == null && Builders.endTimestampReflectsSpanDuration(this.ss, source)) {
                this.sr = Annotation.create(source.timestamp, "sr", this.ss.endpoint);
            }
            if (this.cs != null && this.sr != null) {
                Span.Builder server;
                this.maybeTimestampDuration(source, this.cs, this.cr);
                Span.Builder client = this.forEndpoint(source, this.cs.endpoint);
                if (V2SpanConverter.closeEnough(this.cs.endpoint, this.sr.endpoint)) {
                    client.kind(Span.Kind.CLIENT);
                    server = this.newSpanBuilder(source, this.sr.endpoint.toV2()).kind(Span.Kind.SERVER);
                } else {
                    server = this.forEndpoint(source, this.sr.endpoint);
                }
                server.shared(true).timestamp(this.sr.timestamp);
                if (this.ss != null) {
                    server.duration(this.ss.timestamp - this.sr.timestamp);
                }
                if (this.cr == null && source.duration == null) {
                    client.duration(null);
                }
            } else if (this.cs != null && this.cr != null) {
                this.maybeTimestampDuration(source, this.cs, this.cr);
            } else if (this.sr != null && this.ss != null) {
                this.maybeTimestampDuration(source, this.sr, this.ss);
            } else {
                for (Span.Builder next : this.spans) {
                    if (Span.Kind.CLIENT.equals((Object)next.kind())) {
                        if (this.cs != null) {
                            next.timestamp(this.cs.timestamp);
                        }
                        if (this.cr == null) continue;
                        next.addAnnotation(this.cr.timestamp, this.cr.value);
                        continue;
                    }
                    if (!Span.Kind.SERVER.equals((Object)next.kind())) continue;
                    if (this.sr != null) {
                        next.timestamp(this.sr.timestamp);
                    }
                    if (this.ss == null) continue;
                    next.addAnnotation(this.ss.timestamp, this.ss.value);
                }
                if (source.timestamp != null) {
                    this.spans.get(0).timestamp(source.timestamp).duration(source.duration);
                }
            }
            if (this.cs == null && this.sr != null && source.timestamp == null) {
                this.forEndpoint(source, this.sr.endpoint).shared(true);
            }
            if (this.ms != null && this.mr != null) {
                Span.Builder consumer;
                Span.Builder producer = this.forEndpoint(source, this.ms.endpoint);
                if (V2SpanConverter.closeEnough(this.ms.endpoint, this.mr.endpoint)) {
                    producer.kind(Span.Kind.PRODUCER);
                    consumer = this.newSpanBuilder(source, this.mr.endpoint.toV2()).kind(Span.Kind.CONSUMER);
                } else {
                    consumer = this.forEndpoint(source, this.mr.endpoint);
                }
                consumer.shared(true);
                if (this.wr != null) {
                    consumer.timestamp(this.wr.timestamp).duration(this.mr.timestamp - this.wr.timestamp);
                } else {
                    consumer.timestamp(this.mr.timestamp);
                }
                producer.timestamp(this.ms.timestamp).duration(this.ws != null ? Long.valueOf(this.ws.timestamp - this.ms.timestamp) : null);
            } else if (this.ms != null) {
                this.maybeTimestampDuration(source, this.ms, this.ws);
            } else if (this.mr != null) {
                if (this.wr != null) {
                    this.maybeTimestampDuration(source, this.wr, this.mr);
                } else {
                    this.maybeTimestampDuration(source, this.mr, null);
                }
            } else {
                if (this.ws != null) {
                    this.forEndpoint(source, this.ws.endpoint).addAnnotation(this.ws.timestamp, this.ws.value);
                }
                if (this.wr != null) {
                    this.forEndpoint(source, this.wr.endpoint).addAnnotation(this.wr.timestamp, this.wr.value);
                }
            }
        }

        static boolean endTimestampReflectsSpanDuration(Annotation end, Span source) {
            return end != null && source.timestamp != null && source.duration != null && source.timestamp + source.duration == end.timestamp;
        }

        void maybeTimestampDuration(Span source, Annotation begin, @Nullable Annotation end) {
            Span.Builder span2 = this.forEndpoint(source, begin.endpoint);
            if (source.timestamp != null && source.duration != null) {
                span2.timestamp(source.timestamp).duration(source.duration);
            } else {
                span2.timestamp(begin.timestamp);
                if (end != null) {
                    span2.duration(end.timestamp - begin.timestamp);
                }
            }
        }

        void processBinaryAnnotations(Span source) {
            Endpoint ca = null;
            Endpoint sa = null;
            Endpoint ma = null;
            int length = source.binaryAnnotations.size();
            block9: for (int i = 0; i < length; ++i) {
                BinaryAnnotation b = source.binaryAnnotations.get(i);
                if (b.type == BinaryAnnotation.Type.BOOL) {
                    if ("ca".equals(b.key)) {
                        ca = b.endpoint;
                        continue;
                    }
                    if ("sa".equals(b.key)) {
                        sa = b.endpoint;
                        continue;
                    }
                    if ("ma".equals(b.key)) {
                        ma = b.endpoint;
                        continue;
                    }
                    this.forEndpoint(source, b.endpoint).putTag(b.key, b.value[0] == 1 ? "true" : "false");
                    continue;
                }
                Span.Builder currentSpan = this.forEndpoint(source, b.endpoint);
                switch (b.type) {
                    case BOOL: {
                        continue block9;
                    }
                    case STRING: {
                        if ("lc".equals(b.key) && b.value.length == 0) continue block9;
                        currentSpan.putTag(b.key, new String(b.value, Util.UTF_8));
                        continue block9;
                    }
                    case BYTES: {
                        currentSpan.putTag(b.key, Util.writeBase64Url(b.value));
                        continue block9;
                    }
                    case I16: {
                        currentSpan.putTag(b.key, Short.toString(ByteBuffer.wrap(b.value).getShort()));
                        continue block9;
                    }
                    case I32: {
                        currentSpan.putTag(b.key, Integer.toString(ByteBuffer.wrap(b.value).getInt()));
                        continue block9;
                    }
                    case I64: {
                        currentSpan.putTag(b.key, Long.toString(ByteBuffer.wrap(b.value).getLong()));
                        continue block9;
                    }
                    case DOUBLE: {
                        double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(b.value).getLong());
                        currentSpan.putTag(b.key, Double.toString(wrapped));
                    }
                }
            }
            if (this.cs == null && this.sr == null && ca != null && sa != null) {
                this.forEndpoint(source, ca).remoteEndpoint(sa.toV2());
                return;
            }
            if (sa != null) {
                if (this.cs != null && !V2SpanConverter.closeEnough(sa, this.cs.endpoint)) {
                    this.forEndpoint(source, this.cs.endpoint).remoteEndpoint(sa.toV2());
                } else if (this.cr != null && !V2SpanConverter.closeEnough(sa, this.cr.endpoint)) {
                    this.forEndpoint(source, this.cr.endpoint).remoteEndpoint(sa.toV2());
                } else if (this.cs == null && this.cr == null && this.sr == null && this.ss == null) {
                    this.forEndpoint(source, null).kind(Span.Kind.CLIENT).remoteEndpoint(sa.toV2());
                }
            }
            if (ca != null) {
                if (this.sr != null && !V2SpanConverter.closeEnough(ca, this.sr.endpoint)) {
                    this.forEndpoint(source, this.sr.endpoint).remoteEndpoint(ca.toV2());
                }
                if (this.ss != null && !V2SpanConverter.closeEnough(ca, this.ss.endpoint)) {
                    this.forEndpoint(source, this.ss.endpoint).remoteEndpoint(ca.toV2());
                } else if (this.cs == null && this.cr == null && this.sr == null && this.ss == null) {
                    this.forEndpoint(source, null).kind(Span.Kind.SERVER).remoteEndpoint(ca.toV2());
                }
            }
            if (ma != null) {
                if (this.ms != null && !V2SpanConverter.closeEnough(ma, this.ms.endpoint)) {
                    this.forEndpoint(source, this.ms.endpoint).remoteEndpoint(ma.toV2());
                }
                if (this.mr != null && !V2SpanConverter.closeEnough(ma, this.mr.endpoint)) {
                    this.forEndpoint(source, this.mr.endpoint).remoteEndpoint(ma.toV2());
                }
            }
        }

        Span.Builder forEndpoint(Span source, @Nullable Endpoint e) {
            if (e == null) {
                return this.spans.get(0);
            }
            zipkin2.Endpoint converted = e.toV2();
            int length = this.spans.size();
            for (int i = 0; i < length; ++i) {
                Span.Builder next = this.spans.get(i);
                zipkin2.Endpoint nextLocalEndpoint = next.localEndpoint();
                if (nextLocalEndpoint == null) {
                    next.localEndpoint(converted);
                    return next;
                }
                if (!V2SpanConverter.closeEnough(V2SpanConverter.toEndpoint(nextLocalEndpoint), e)) continue;
                return next;
            }
            return this.newSpanBuilder(source, converted);
        }

        Span.Builder newSpanBuilder(Span source, zipkin2.Endpoint e) {
            Span.Builder result = V2SpanConverter.newBuilder(source).localEndpoint(e);
            this.spans.add(result);
            return result;
        }

        List<zipkin2.Span> build() {
            int length = this.spans.size();
            if (length == 1) {
                return Collections.singletonList(this.spans.get(0).build());
            }
            ArrayList<zipkin2.Span> result = new ArrayList<zipkin2.Span>(length);
            for (int i = 0; i < length; ++i) {
                result.add(this.spans.get(i).build());
            }
            return result;
        }
    }
}

