/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export.io;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import net.biville.florent.sproccompiler.export.DsvConfiguration;
import net.biville.florent.sproccompiler.export.DsvGroupingStrategy;
import net.biville.florent.sproccompiler.export.DsvSplitStrategy;
import net.biville.florent.sproccompiler.export.Either;
import net.biville.florent.sproccompiler.export.MethodPartition;
import net.biville.florent.sproccompiler.export.elements.ConstantQualifiedNameable;
import net.biville.florent.sproccompiler.export.io.DsvFieldExporter;
import net.biville.florent.sproccompiler.export.io.DsvFileWriter;
import net.biville.florent.sproccompiler.export.messages.DsvExportError;
import net.biville.florent.sproccompiler.messages.MessagePrinter;

public class DsvSerializer {
    private final Elements elements;
    private final ElementVisitor<TypeElement, Void> enclosingTypeVisitor;
    private final MessagePrinter messagePrinter;
    private final DsvFieldExporter fieldExporter;

    public DsvSerializer(Elements elements, ElementVisitor<TypeElement, Void> enclosingTypeVisitor, MessagePrinter messagePrinter) {
        this.elements = elements;
        this.enclosingTypeVisitor = enclosingTypeVisitor;
        this.messagePrinter = messagePrinter;
        this.fieldExporter = new DsvFieldExporter(elements);
    }

    public void serialize(Path root, DsvConfiguration configuration, Collection<ExecutableElement> procedures, Collection<ExecutableElement> functions) {
        DsvSplitStrategy splitStrategy = configuration.getSplitStrategy();
        configuration.getGroupingStrategies().forEach(grouping -> {
            Collection<MethodPartition> partitions = splitStrategy.partition(procedures, functions);
            Function<ExecutableElement, QualifiedNameable> keyFunction = this.groupByFileBasename((DsvGroupingStrategy)((Object)grouping));
            this.serialize(root, configuration, partitions, keyFunction);
        });
    }

    private void serialize(Path root, DsvConfiguration configuration, Collection<MethodPartition> partitions, Function<ExecutableElement, QualifiedNameable> keyFunction) {
        partitions.forEach(partition -> {
            String fileSuffix = partition.getFileSuffix();
            partition.getMethods().stream().collect(Collectors.groupingBy(keyFunction)).entrySet().forEach(kv -> {
                Either<DsvExportError, List<String>> headerParsingResult = this.fieldExporter.exportHeaders(configuration.getFieldDelimiter(), configuration.getRawHeaders());
                headerParsingResult.consume(this.messagePrinter::print, headers -> {
                    File file = new File(root.toFile(), String.format("%s%s.csv", ((QualifiedNameable)kv.getKey()).getQualifiedName(), fileSuffix));
                    this.serializeWithHeaders(file, configuration, (Collection)kv.getValue(), (Collection<String>)headers);
                });
            });
        });
    }

    private void serializeWithHeaders(File file, DsvConfiguration configuration, Collection<ExecutableElement> methods, Collection<String> headers) {
        try (FileWriter resource = new FileWriter(file);
             DsvFileWriter writer = new DsvFileWriter(headers, resource, configuration.getFieldDelimiter(), configuration.isFirstFieldDelimited(), configuration.areFieldsQuoted());){
            writer.write(methods.stream(), method -> this.fieldExporter.exportFields((ExecutableElement)method, headers), this.messagePrinter::print);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Function<ExecutableElement, QualifiedNameable> groupByFileBasename(DsvGroupingStrategy grouping) {
        switch (grouping) {
            case SINGLE: {
                return ignored -> new ConstantQualifiedNameable("documentation");
            }
            case PACKAGE: {
                return this.elements::getPackageOf;
            }
            case CLASS: {
                return method -> this.enclosingTypeVisitor.visit(method.getEnclosingElement());
            }
        }
        throw new IllegalArgumentException("Unknown grouping strategy: " + (Object)((Object)grouping));
    }
}

