/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.Value;

public class MethodOptimizationInfo {
    private boolean hasNoSideEffects = false;
    private boolean hasSideEffects = false;
    private boolean canBeMadePrivate = true;
    private boolean catchesExceptions = false;
    private boolean branchesBackward = false;
    private boolean invokesSuperMethods = false;
    private boolean invokesDynamically = false;
    private boolean accessesPrivateCode = false;
    private boolean accessesPackageCode = false;
    private boolean accessesProtectedCode = false;
    private boolean returnsWithNonEmptyStack = false;
    private int invocationCount = 0;
    private int parameterSize = 0;
    private long usedParameters = 0L;
    private Value[] parameters;
    private Value returnValue;

    public MethodOptimizationInfo(Clazz clazz, Method method) {
        int parameterCount = ClassUtil.internalMethodParameterCount(method.getDescriptor(clazz));
        if ((method.getAccessFlags() & 8) == 0) {
            ++parameterCount;
        }
        if (parameterCount > 0) {
            this.parameters = new Value[parameterCount];
        }
    }

    public void setNoSideEffects() {
        this.hasNoSideEffects = true;
    }

    public boolean hasNoSideEffects() {
        return this.hasNoSideEffects;
    }

    public void setSideEffects() {
        this.hasSideEffects = true;
    }

    public boolean hasSideEffects() {
        return this.hasSideEffects;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void setCatchesExceptions() {
        this.catchesExceptions = true;
    }

    public boolean catchesExceptions() {
        return this.catchesExceptions;
    }

    public void setBranchesBackward() {
        this.branchesBackward = true;
    }

    public boolean branchesBackward() {
        return this.branchesBackward;
    }

    public void setInvokesSuperMethods() {
        this.invokesSuperMethods = true;
    }

    public boolean invokesSuperMethods() {
        return this.invokesSuperMethods;
    }

    public void setInvokesDynamically() {
        this.invokesDynamically = true;
    }

    public boolean invokesDynamically() {
        return this.invokesDynamically;
    }

    public void setAccessesPrivateCode() {
        this.accessesPrivateCode = true;
    }

    public boolean accessesPrivateCode() {
        return this.accessesPrivateCode;
    }

    public void setAccessesPackageCode() {
        this.accessesPackageCode = true;
    }

    public boolean accessesPackageCode() {
        return this.accessesPackageCode;
    }

    public void setAccessesProtectedCode() {
        this.accessesProtectedCode = true;
    }

    public boolean accessesProtectedCode() {
        return this.accessesProtectedCode;
    }

    public void setReturnsWithNonEmptyStack() {
        this.returnsWithNonEmptyStack = true;
    }

    public boolean returnsWithNonEmptyStack() {
        return this.returnsWithNonEmptyStack;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public void setParameterSize(int parameterSize) {
        this.parameterSize = parameterSize;
    }

    public int getParameterSize() {
        return this.parameterSize;
    }

    public void setParameterUsed(int parameterIndex) {
        this.usedParameters |= 1L << parameterIndex;
    }

    public void setUsedParameters(long usedParameters) {
        this.usedParameters = usedParameters;
    }

    public boolean isParameterUsed(int parameterIndex) {
        return parameterIndex >= 64 || (this.usedParameters & 1L << parameterIndex) != 0L;
    }

    public long getUsedParameters() {
        return this.usedParameters;
    }

    public void generalizeParameter(int parameterIndex, Value parameter) {
        this.parameters[parameterIndex] = this.parameters[parameterIndex] != null ? this.parameters[parameterIndex].generalize(parameter) : parameter;
    }

    public Value getParameter(int parameterIndex) {
        return this.parameters != null ? this.parameters[parameterIndex] : null;
    }

    public void generalizeReturnValue(Value returnValue) {
        this.returnValue = this.returnValue != null ? this.returnValue.generalize(returnValue) : returnValue;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Value returnValue) {
        this.returnValue = returnValue;
    }

    public void merge(MethodOptimizationInfo other) {
        if (other != null) {
            this.hasNoSideEffects &= other.hasNoSideEffects;
            this.hasSideEffects |= other.hasSideEffects;
            this.catchesExceptions |= other.catchesExceptions;
            this.branchesBackward |= other.branchesBackward;
            this.invokesSuperMethods |= other.invokesSuperMethods;
            this.invokesDynamically |= other.invokesDynamically;
            this.accessesPrivateCode |= other.accessesPrivateCode;
            this.accessesPackageCode |= other.accessesPackageCode;
            this.accessesProtectedCode |= other.accessesProtectedCode;
        } else {
            this.hasNoSideEffects = false;
            this.hasSideEffects = true;
            this.catchesExceptions = true;
            this.branchesBackward = true;
            this.invokesSuperMethods = true;
            this.accessesPrivateCode = true;
            this.accessesPackageCode = true;
            this.accessesProtectedCode = true;
        }
    }

    public static void setMethodOptimizationInfo(Clazz clazz, Method method) {
        MethodLinker.lastMember(method).setVisitorInfo(new MethodOptimizationInfo(clazz, method));
    }

    public static MethodOptimizationInfo getMethodOptimizationInfo(Method method) {
        Object visitorInfo = MethodLinker.lastMember(method).getVisitorInfo();
        return visitorInfo instanceof MethodOptimizationInfo ? (MethodOptimizationInfo)visitorInfo : null;
    }
}

