/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.DefaultTextProvider;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.CompoundRootAccessor;
import com.opensymphony.xwork.util.InstantiatingNullHandler;
import com.opensymphony.xwork.util.ObjectProxy;
import com.opensymphony.xwork.util.ObjectProxyPropertyAccessor;
import com.opensymphony.xwork.util.OgnlContextState;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.util.XWorkCollectionPropertyAccessor;
import com.opensymphony.xwork.util.XWorkConverter;
import com.opensymphony.xwork.util.XWorkEnumerationAcccessor;
import com.opensymphony.xwork.util.XWorkIteratorPropertyAccessor;
import com.opensymphony.xwork.util.XWorkListPropertyAccessor;
import com.opensymphony.xwork.util.XWorkMapPropertyAccessor;
import com.opensymphony.xwork.util.XWorkMethodAccessor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlValueStack
implements Serializable {
    private static final long serialVersionUID = -3444677371593148954L;
    public static final String VALUE_STACK = "com.opensymphony.xwork.util.OgnlValueStack.ValueStack";
    public static final String REPORT_ERRORS_ON_NO_PROP = "com.opensymphony.xwork.util.OgnlValueStack.ReportErrorsOnNoProp";
    private static CompoundRootAccessor accessor;
    private static Log LOG;
    CompoundRoot root;
    transient Map context;
    Class defaultType;
    Map overrides;

    public static void reset() {
        accessor = new CompoundRootAccessor();
        OgnlRuntime.setPropertyAccessor((Class)CompoundRoot.class, (PropertyAccessor)accessor);
        OgnlRuntime.setPropertyAccessor((Class)Object.class, (PropertyAccessor)new ObjectAccessor());
        OgnlRuntime.setPropertyAccessor((Class)Iterator.class, (PropertyAccessor)new XWorkIteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)Enumeration.class, (PropertyAccessor)new XWorkEnumerationAcccessor());
        OgnlRuntime.setPropertyAccessor((Class)List.class, (PropertyAccessor)new XWorkListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)Map.class, (PropertyAccessor)new XWorkMapPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)Collection.class, (PropertyAccessor)new XWorkCollectionPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)Set.class, (PropertyAccessor)new XWorkCollectionPropertyAccessor());
        OgnlRuntime.setPropertyAccessor((Class)ObjectProxy.class, (PropertyAccessor)new ObjectProxyPropertyAccessor());
        OgnlRuntime.setMethodAccessor((Class)Object.class, (MethodAccessor)new XWorkMethodAccessor());
        OgnlRuntime.setMethodAccessor((Class)CompoundRoot.class, (MethodAccessor)accessor);
        OgnlRuntime.setNullHandler((Class)Object.class, (NullHandler)new InstantiatingNullHandler());
    }

    public static void link(Map context, Class clazz, String name) {
        context.put("__link", new Object[]{clazz, name});
    }

    public OgnlValueStack() {
        this.setRoot(new CompoundRoot());
        this.push(DefaultTextProvider.INSTANCE);
    }

    public OgnlValueStack(OgnlValueStack vs) {
        this.setRoot(new CompoundRoot(vs.getRoot()));
    }

    public static CompoundRootAccessor getAccessor() {
        return accessor;
    }

    public Map getContext() {
        return this.context;
    }

    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    public void setExprOverrides(Map overrides) {
        if (this.overrides == null) {
            this.overrides = overrides;
        } else {
            this.overrides.putAll(overrides);
        }
    }

    public CompoundRoot getRoot() {
        return this.root;
    }

    public boolean isDevModeEnabled() {
        Boolean devMode = (Boolean)this.context.get("__devMode");
        if (devMode != null) {
            return devMode;
        }
        return false;
    }

    public void setValue(String expr, Object value) {
        this.setValue(expr, value, this.isDevModeEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        Map context = this.getContext();
        try {
            context.put("conversion.property.fullName", expr);
            context.put(REPORT_ERRORS_ON_NO_PROP, throwExceptionOnFailure ? Boolean.TRUE : Boolean.FALSE);
            OgnlUtil.setValue(expr, context, this.root, value);
        }
        catch (OgnlException e) {
            if (throwExceptionOnFailure) {
                String msg = "Error setting expr '" + expr + "' with value '" + value + "'";
                LOG.error((Object)msg, (Throwable)e);
                throw new XworkException(msg, e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error setting value", (Throwable)e);
            }
        }
        catch (XworkException re) {
            if (throwExceptionOnFailure) {
                String msg = "Error setting expr '" + expr + "' with value '" + value + "'";
                LOG.error((Object)msg, (Throwable)re);
                throw re;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error setting value", (Throwable)re);
            }
        }
        catch (RuntimeException re) {
            if (throwExceptionOnFailure) {
                String msg = "Error setting expr '" + expr + "' with value '" + value + "'";
                LOG.error((Object)msg, (Throwable)re);
                throw new XworkException(msg, re);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error setting value", (Throwable)re);
            }
        }
        finally {
            OgnlContextState.clear(context);
            context.remove("conversion.property.fullName");
            context.remove(REPORT_ERRORS_ON_NO_PROP);
        }
    }

    public String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr) {
        try {
            if (expr == null) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if (this.defaultType != null) {
                Object object = this.findValue(expr, this.defaultType);
                return object;
            }
            Object value = OgnlUtil.getValue(expr, this.context, this.root);
            if (value != null) {
                Object object = value;
                return object;
            }
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            OgnlContextState.clear(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr, Class asType) {
        try {
            Object value;
            if (expr == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if ((value = OgnlUtil.getValue(expr, this.context, this.root, asType)) != null) {
                Object object = value;
                return object;
            }
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            OgnlContextState.clear(this.context);
        }
    }

    private Object findInContext(String name) {
        return this.getContext().get(name);
    }

    private void logLookupFailure(String expr, Exception e) {
        StringBuffer msg = new StringBuffer();
        msg.append("Caught an exception while evaluating expression '").append(expr).append("' against value stack");
        if (this.isDevModeEnabled() && LOG.isWarnEnabled()) {
            LOG.warn((Object)msg, (Throwable)e);
            LOG.warn((Object)"NOTE: Previous warning message was issued due to devMode set to true.");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)msg, (Throwable)e);
        }
    }

    public Object peek() {
        return this.root.peek();
    }

    public Object pop() {
        return this.root.pop();
    }

    public void push(Object o) {
        this.root.push(o);
    }

    public int size() {
        return this.root.size();
    }

    private void setRoot(CompoundRoot compoundRoot) {
        this.root = compoundRoot;
        this.context = Ognl.createDefaultContext((Object)this.root, (ClassResolver)accessor, (TypeConverter)XWorkConverter.getInstance());
        this.context.put(VALUE_STACK, this);
        Ognl.setClassResolver((Map)this.context, (ClassResolver)accessor);
        ((OgnlContext)this.context).setTraceEvaluations(false);
        ((OgnlContext)this.context).setKeepLastEvaluation(false);
    }

    private Object readResolve() {
        OgnlValueStack aStack = new OgnlValueStack();
        aStack.setRoot(this.root);
        return aStack;
    }

    static {
        LOG = LogFactory.getLog((Class)OgnlValueStack.class);
        OgnlValueStack.reset();
    }

    public static class ObjectAccessor
    extends ObjectPropertyAccessor {
        public Object getProperty(Map map, Object o, Object o1) throws OgnlException {
            Object obj = super.getProperty(map, o, o1);
            OgnlValueStack.link(map, o.getClass(), (String)o1);
            map.put("last.bean.accessed", o.getClass());
            map.put("last.property.accessed", o1.toString());
            OgnlContextState.updateCurrentPropertyPath(map, o1);
            return obj;
        }

        public void setProperty(Map map, Object o, Object o1, Object o2) throws OgnlException {
            super.setProperty(map, o, o1, o2);
        }
    }
}

