/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import android.util.Log;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.Proxies;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class RetryExec
implements ClientExecChain {
    private static final String TAG = "HttpClient";
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryHandler, "HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route, request, context, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Request has been aborted");
                    }
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, (HttpContext)context)) {
                    if (Log.isLoggable((String)TAG, (int)4)) {
                        Log.i((String)TAG, (String)("I/O exception (" + ex.getClass().getName() + ") caught when processing request to " + route + ": " + ex.getMessage()));
                    }
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    }
                    if (!Proxies.isRepeatable((HttpRequest)request)) {
                        if (Log.isLoggable((String)TAG, (int)3)) {
                            Log.d((String)TAG, (String)"Cannot retry non-repeatable request");
                        }
                        NonRepeatableRequestException nreex = new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity");
                        nreex.initCause((Throwable)ex);
                    }
                    request.setHeaders(origheaders);
                    if (Log.isLoggable((String)TAG, (int)4)) {
                        Log.i((String)TAG, (String)("Retrying request to " + route));
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                ++execCount;
                continue;
            }
            break;
        }
    }
}

