/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u0001\u001d\u0011Q\"\u00113nS:T6n\u00117jK:$(BA\u0002\u0005\u0003\tQ8NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!Q8n\u00117jK:$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055Y\u0015MZ6b5.\u001cE.[3oi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002\"\u0002\u0011\u0001\t\u0003\t\u0013aC2sK\u0006$X\rV8qS\u000e$bAI\u0013/gUz\u0004CA\u0005$\u0013\t!#B\u0001\u0003V]&$\b\"\u0002\u0014 \u0001\u00049\u0013!\u0002;pa&\u001c\u0007C\u0001\u0015,\u001d\tI\u0011&\u0003\u0002+\u0015\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQ#\u0002C\u00030?\u0001\u0007\u0001'\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\"!C\u0019\n\u0005IR!aA%oi\")Ag\ba\u0001a\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000fYz\u0002\u0013!a\u0001o\u0005YAo\u001c9jG\u000e{gNZ5h!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0001u\u0004%AA\u0002\u0005\u000bQB]1dW\u0006;\u0018M]3N_\u0012,\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0015\tG-\\5o\u0013\t15IA\u0007SC\u000e\\\u0017i^1sK6{G-\u001a\u0005\u0006\u0011\u0002!\t!S\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000fF\u0002K'R\u00032a\u0013(Q\u001b\u0005a%BA'\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f2\u00131aU3r!\t\u0011\u0015+\u0003\u0002S\u0007\nq!I]8lKJlU\r^1eCR\f\u0007b\u0002!H!\u0003\u0005\r!\u0011\u0005\b+\u001e\u0003\n\u00111\u0001W\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0004\u0013]K\u0016B\u0001-\u000b\u0005\u0019y\u0005\u000f^5p]B\u00191J\u0014\u0019\t\u000bm\u0003A\u0011\u0001/\u00023\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u000b\u0005Eus\u0006\rC\u0003'5\u0002\u0007q\u0005C\u0003`5\u0002\u0007q'\u0001\u0004d_:4\u0017n\u001a\u0005\u0006Cj\u0003\rAY\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\u0005\u0017\u000e\u0004\u0014,\u0003\u0002e\u0019\n\u0019Q*\u00199\t\u000b\u0019\u0004A\u0011A4\u0002'Y\fG.\u001b3bi\u0016$v\u000e]5d\u0007J,\u0017\r^3\u0015\t\tB\u0017N\u001b\u0005\u0006M\u0015\u0004\ra\n\u0005\u0006C\u0016\u0004\rA\u0019\u0005\u0006?\u0016\u0004\ra\u000e\u0005\u0006Y\u0002!I!\\\u0001\u001eoJLG/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\!tg&<g.\\3oiR!!E\\8r\u0011\u001513\u000e1\u0001(\u0011\u0015\u00018\u000e1\u0001c\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\u0006e.\u0004\ra]\u0001\tSN,\u0006\u000fZ1uKB\u0011\u0011\u0002^\u0005\u0003k*\u0011qAQ8pY\u0016\fg\u000eC\u0003x\u0001\u0011\u0005\u00010A\u0006eK2,G/\u001a+pa&\u001cGC\u0001\u0012z\u0011\u00151c\u000f1\u0001(\u0011\u0015Y\b\u0001\"\u0001}\u00035\tG\r\u001a)beRLG/[8ogRY!- @\u0002\u0002\u0005\u0015\u0011\u0011BA\u0007\u0011\u00151#\u00101\u0001(\u0011\u0015y(\u00101\u0001c\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\t\r\u0005\r!\u00101\u0001K\u0003)\tG\u000e\u001c\"s_.,'o\u001d\u0005\t\u0003\u000fQ\b\u0013!a\u0001a\u0005ia.^7QCJ$\u0018\u000e^5p]ND\u0001\u0002\u001d>\u0011\u0002\u0003\u0007\u00111\u0002\t\u0004\u0013]\u0013\u0007\u0002CA\buB\u0005\t\u0019A:\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001d\u0011\u0013qCA\r\u0003;Aa\u0001]A\t\u0001\u0004\u0011\u0007bBA\u000e\u0003#\u0001\r\u0001M\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005\u0002 \u0005E\u0001\u0019AA\u0011\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t!\n\u0019\u0003M\u0005\u0004\u0003Ki#aA*fi\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012a\u00039beN,'I]8lKJ$B!!\f\u00020A\u0019\u0011b\u0016\u0019\t\u000f\u0005E\u0012q\u0005a\u0001O\u00051!M]8lKJDq!!\u000e\u0001\t\u0003\t9$A\u0007dQ\u0006tw-Z\"p]\u001aLwm\u001d\u000b\bE\u0005e\u0012QHA!\u0011\u001d\tY$a\rA\u0002\u001d\n!\"\u001a8uSRLH+\u001f9f\u0011\u001d\ty$a\rA\u0002\u001d\n!\"\u001a8uSRLh*Y7f\u0011\u001d\t\u0019%a\rA\u0002]\nqaY8oM&<7\u000fC\u0004\u0002H\u0001!\t!!\u0013\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0011\u00131JA(\u0011\u001d\ti%!\u0012A\u0002\u001d\n\u0011c]1oSRL'0\u001a3DY&,g\u000e^%e\u0011\u001d\t\u0019%!\u0012A\u0002]Bq!a\u0015\u0001\t\u0003\t)&\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)!%a\u0016\u0002\\!9\u0011\u0011LA)\u0001\u00049\u0013aE:b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007bBA\"\u0003#\u0002\ra\u000e\u0005\b\u0003?\u0002A\u0011AA1\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h)\u0015\u0011\u00131MA3\u0011\u00191\u0013Q\fa\u0001O!9\u00111IA/\u0001\u00049\u0004bBA5\u0001\u0011\u0005\u00111N\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u0002\u0012\u0002n\u0005=\u0004B\u0002\u0014\u0002h\u0001\u0007q\u0005C\u0004\u0002D\u0005\u001d\u0004\u0019A\u001c\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015\u0011\u0013qOA>\u0011\u001d\tI(!\u001dA\u0002e\u000bqA\u0019:pW\u0016\u00148\u000fC\u0004\u0002D\u0005E\u0004\u0019A\u001c\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u0000Q)!%!!\u0002\u0004\"A\u0011\u0011GA?\u0001\u0004\ti\u0003C\u0004\u0002D\u0005u\u0004\u0019A\u001c\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006!b/\u00197jI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$2AIAF\u0011\u001d\t\u0019%!\"A\u0002]Bq!a$\u0001\t\u0013\t\t*\u0001\ndQ\u0006tw-Z#oi&$\u0018pQ8oM&<Gc\u0002\u0012\u0002\u0014\u0006]\u00151\u0014\u0005\b\u0003+\u000bi\t1\u0001(\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016Dq!!'\u0002\u000e\u0002\u0007q%A\fgk2d7+\u00198ji&TX\rZ#oi&$\u0018PT1nK\"9\u00111IAG\u0001\u00049\u0004bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\u0012M\u0016$8\r[#oi&$\u0018pQ8oM&<G#B\u001c\u0002$\u0006\u0015\u0006bBAK\u0003;\u0003\ra\n\u0005\b\u00033\ni\n1\u0001(\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000b!cZ3u\u00032dGk\u001c9jG\u000e{gNZ5hgR\u0011\u0011Q\u0016\t\u0005\u0017\u000e<s\u0007C\u0004\u00022\u0002!\t!a-\u0002+\u0019,Go\u00195BY2,e\u000e^5us\u000e{gNZ5hgR!\u0011QVA[\u0011\u001d\tY$a,A\u0002\u001dBq!!/\u0001\t\u0003\tY,\u0001\u000egKR\u001c\u0007.\u00117m\u0007\"LG\u000eZ#oi&$\u0018pQ8oM&<7\u000f\u0006\u0004\u0002.\u0006u\u0016q\u0018\u0005\b\u0003+\u000b9\f1\u0001(\u0011\u001d\t\t-a.A\u0002\u001d\nqb\u00195jY\u0012,e\u000e^5usRK\b/\u001a\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u000f\fAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002J*\u001a\u0011)a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a6\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a8\u0001#\u0003%\t!!9\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001d\u0016\u0004-\u0006-\u0007\"CAt\u0001E\u0005I\u0011AAu\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQ*\"!a;+\u0007]\nY\rC\u0005\u0002p\u0002\t\n\u0011\"\u0001\u0002H\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*\u0004\"CAz\u0001E\u0005I\u0011AA{\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0002x*\u001a\u0001'a3\t\u0013\u0005m\b!%A\u0005\u0002\u0005u\u0018aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tyP\u000b\u0003\u0002\f\u0005-\u0007\"\u0003B\u0002\u0001E\u0005I\u0011\u0001B\u0003\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\b)\u001a1/a3")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment2);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1)new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$2.filter((Function1)new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        }).getOrElse((Function0)new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply() {
                return this.allBrokers$2;
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$1) {
                return x$1.rack().nonEmpty();
            }
        });
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), broker.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$2) {
                return x$2.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment2) {
        this.validateTopicCreate(topic, partitionReplicaAssignment2, config);
        this.info((Function0<String>)new Serializable(this, topic, config, partitionReplicaAssignment2){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Properties config$1;
            private final Map partitionReplicaAssignment$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating topic ", " with configuration ", " and initial partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.config$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assignment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionReplicaAssignment$1}))).toString();
            }
            {
                this.topic$1 = topic$1;
                this.config$1 = config$1;
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment2, false);
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment2, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Seq<String> allTopics = this.zkClient.getAllTopicsInCluster();
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            Seq collidingTopics = (Seq)allTopics.filter((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$3;

                public final boolean apply(String x$3) {
                    return Topic.hasCollision((String)this.topic$3, (String)x$3);
                }
                {
                    this.topic$3 = topic$3;
                }
            });
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' collides with existing topics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$4) {
                return x$4.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment2.values().foreach((Function1)new Serializable(this, partitionReplicaAssignment2){
            public static final long serialVersionUID = 0L;
            private final Map partitionReplicaAssignment$2;

            public final void apply(Seq<Object> reps) {
                if (reps.size() != reps.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)"Duplicate replica assignment found: ").append((Object)this.partitionReplicaAssignment$2).toString());
                }
            }
            {
                this.partitionReplicaAssignment$2 = partitionReplicaAssignment$2;
            }
        });
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, Seq<Object>> replicaAssignment2, boolean isUpdate) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment2.map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;

                public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$1) {
                    Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int partitionId = tuple2._1$mcI$sp();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(this.topic$4, partitionId), (Object)replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topic$4 = topic$4;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (isUpdate) {
                this.zkClient.setTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment, this.zkClient.setTopicAssignment$default$3());
            } else {
                this.zkClient.createTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment);
            }
            this.debug((Function0<String>)new Serializable(this, topic, assignment){
                public static final long serialVersionUID = 0L;
                private final String topic$4;
                private final scala.collection.immutable.Map assignment$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(this.topic$4), this.assignment$1}));
                }
                {
                    this.topic$4 = topic$4;
                    this.assignment$1 = assignment$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTopic(String topic) {
        if (!this.zkClient.topicExists(topic)) throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        try {
            this.zkClient.createDeleteTopicPath(topic);
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.getMessage());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment2, boolean validateOnly) {
        Seq existingAssignmentPartition0 = (Seq)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0)new Serializable(this, topic, existingAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final Map existingAssignment$1;

            public final Nothing$ apply() {
                throw new AdminOperationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected existing replica assignment for topic '", "', partition id 0 is missing. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.existingAssignment$1}))).toString());
            }
            {
                this.topic$2 = topic$2;
                this.existingAssignment$1 = existingAssignment$1;
            }
        });
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions for a topic can only be increased. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " currently has ", " partitions, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)existingAssignment.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " would not be an increase."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitions)}))).toString());
        }
        replicaAssignment2.foreach((Function1)new Serializable(this, allBrokers, existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Seq allBrokers$1;
            private final Seq existingAssignmentPartition0$1;

            public final void apply(Map<Object, Seq<Object>> proposedReplicaAssignment) {
                this.$outer.kafka$zk$AdminZkClient$$validateReplicaAssignment(proposedReplicaAssignment, this.existingAssignmentPartition0$1.size(), (Set<Object>)((TraversableOnce)this.allBrokers$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$5) {
                        return x$5.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
            }
        });
        Map proposedAssignmentForNewPartitions = (Map)replicaAssignment2.getOrElse((Function0)new Serializable(this, existingAssignment, allBrokers, existingAssignmentPartition0, partitionsToAdd){
            public static final long serialVersionUID = 0L;
            private final Map existingAssignment$1;
            private final Seq allBrokers$1;
            public final Seq existingAssignmentPartition0$1;
            private final int partitionsToAdd$1;

            public final Map<Object, Seq<Object>> apply() {
                int startIndex = package$.MODULE$.max(0, this.allBrokers$1.indexWhere((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final boolean apply(BrokerMetadata x$6) {
                        return x$6.id() >= BoxesRunTime.unboxToInt((Object)this.$outer.existingAssignmentPartition0$1.head());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.allBrokers$1, this.partitionsToAdd$1, this.existingAssignmentPartition0$1.size(), startIndex, this.existingAssignment$1.size());
            }
            {
                this.existingAssignment$1 = existingAssignment$1;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
                this.partitionsToAdd$1 = partitionsToAdd$1;
            }
        });
        Map proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
        if (!validateOnly) {
            this.info((Function0<String>)new Serializable(this, topic, partitionsToAdd, proposedAssignmentForNewPartitions){
                public static final long serialVersionUID = 0L;
                private final String topic$2;
                private final int partitionsToAdd$1;
                private final Map proposedAssignmentForNewPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", " partitions for '", "' with the following replica assignment: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitionsToAdd$1), this.topic$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.proposedAssignmentForNewPartitions$1}))).toString();
                }
                {
                    this.topic$2 = topic$2;
                    this.partitionsToAdd$1 = partitionsToAdd$1;
                    this.proposedAssignmentForNewPartitions$1 = proposedAssignmentForNewPartitions$1;
                }
            });
            this.writeTopicPartitionAssignment(topic, (Map<Object, Seq<Object>>)proposedAssignment, true);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public void kafka$zk$AdminZkClient$$validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment2, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment2.foreach((Function1)new Serializable(this, availableBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerIds$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    if (replicas.isEmpty()) {
                        throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot have replication factor of 0 for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                    }
                    if (replicas.size() != replicas.toSet().size()) {
                        throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate brokers not allowed in replica assignment: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", "), BoxesRunTime.boxToInteger((int)partitionId)}))).toString());
                    }
                    if (replicas.toSet().subsetOf((GenSet)this.availableBrokerIds$1)) {
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return tuple22;
                    }
                    throw new BrokerNotAvailableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers specified for partition id ", " are not available. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified brokers: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available brokers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.availableBrokerIds$1.mkString(", ")}))).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                this.availableBrokerIds$1 = availableBrokerIds$1;
            }
        });
        Map badRepFactors = (Map)replicaAssignment2.collect((PartialFunction)new Serializable(this, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    Seq replicas = (Seq)A1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = (Seq)tuple2._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$4) {
                    Tuple2<Object, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        int rf;
                        int n = rf = tuple2._2$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent replication factor between partitions, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition 0 has ", " while partitions [", "] have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedReplicationFactor), partitions.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factors [", "], respectively."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repFactors.mkString(", ")}))).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> parseBroker(String broker) {
        String string = broker;
        String string2 = ConfigEntityName$.MODULE$.Default();
        String string3 = string;
        if (string2 == null) {
            if (string3 == null) return None$.MODULE$;
        } else if (string2.equals(string3)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker})));
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        block6: {
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = entityType;
                            String string2 = ConfigType$.MODULE$.Topic();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            this.changeTopicConfig(entityName, configs);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        String string4 = ConfigType$.MODULE$.Client();
                        String string5 = string;
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        this.changeClientIdConfig(entityName, configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    String string6 = ConfigType$.MODULE$.User();
                    String string7 = string;
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block5;
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string8 = ConfigType$.MODULE$.Broker();
                String string9 = string;
                if (string8 != null ? !string8.equals(string9) : string9 != null) break block6;
                this.changeBrokerConfig(this.parseBroker(entityName), configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            LogConfig$.MODULE$.validate(configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)new Serializable(this, configs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Properties configs$1;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                this.$outer.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), this.configs$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configs$1 = configs$1;
            }
        });
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$7) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        }), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void kafka$zk$AdminZkClient$$changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder().append((Object)rootEntityType).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2((Object)topic, (Object)this.$outer.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1)new Serializable(this, entityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String entityType$1;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2((Object)entity, (Object)this.$outer.fetchEntityConfig(this.entityType$1, entity));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entityType$1 = entityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.kafka$zk$AdminZkClient$$entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1)new Serializable(this, rootEntityType, childEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;
            private final String childEntityType$1;

            public final Seq<String> apply(String entity) {
                return this.$outer.kafka$zk$AdminZkClient$$entityPaths$1((Option)new Some((Object)new StringBuilder().append((Object)entity).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)this.childEntityType$1).toString()), this.rootEntityType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
                this.childEntityType$1 = childEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, rootEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;

            public final Tuple2<String, Properties> apply(String entityPath) {
                return new Tuple2((Object)entityPath, (Object)this.$outer.fetchEntityConfig(this.rootEntityType$1, entityPath));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public final Seq kafka$zk$AdminZkClient$$entityPaths$1(Option rootPath, String rootEntityType$1) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Seq seq;
                block6: {
                    Seq entityNames2;
                    block5: {
                        String string;
                        block3: {
                            block2: {
                                option = rootPath;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String path = (String)some.x();
                                string = new StringBuilder().append((Object)rootEntityType$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)path).toString();
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string = rootEntityType$1;
                        }
                        String root = string;
                        entityNames2 = this.zkClient.getAllEntitiesWithConfig(root);
                        option2 = rootPath;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String path = (String)some.x();
                        seq = (Seq)entityNames2.map((Function1)new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply(String entityName) {
                                return new StringBuilder().append((Object)this.path$1).append((Object)BoxesRunTime.boxToCharacter((char)'/')).append((Object)entityName).toString();
                            }
                            {
                                this.path$1 = path$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    seq = entityNames2;
                }
                return seq;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging$class.$init$(this);
    }
}

