/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.AsyncListenerWrapper;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class AsyncContextImpl
implements AsyncContext {
    private static final Log log = LogFactory.getLog(AsyncContextImpl.class);
    private ServletRequest servletRequest = null;
    private ServletResponse servletResponse = null;
    private List<AsyncListenerWrapper> listeners = new ArrayList<AsyncListenerWrapper>();
    private boolean hasOriginalRequestAndResponse = true;
    private volatile Runnable dispatch = null;
    private Context context = null;
    private AtomicReference<AsyncState> state = new AtomicReference<AsyncState>(AsyncState.NOT_STARTED);
    private long timeout = -1L;
    private AsyncEvent event = null;
    private Request request;

    public AsyncContextImpl(Request request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AsyncContext created[" + request.getRequestURI() + "?" + request.getQueryString() + "]"), (Throwable)new DebugException());
        }
        this.request = request;
    }

    @Override
    public void complete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AsyncContext Complete Called[" + (Object)((Object)this.state.get()) + "; " + this.request.getRequestURI() + "?" + this.request.getQueryString() + "]"), (Throwable)new DebugException());
        }
        if (this.state.get() != AsyncState.COMPLETING) {
            if (this.state.compareAndSet(AsyncState.DISPATCHED, AsyncState.COMPLETING) || this.state.compareAndSet(AsyncState.STARTED, AsyncState.COMPLETING)) {
                AtomicBoolean dispatched = new AtomicBoolean(false);
                this.request.getCoyoteRequest().action(ActionCode.ACTION_ASYNC_COMPLETE, dispatched);
                if (!dispatched.get()) {
                    this.doInternalComplete(false);
                }
            } else {
                throw new IllegalStateException("Complete not allowed. Invalid state:" + (Object)((Object)this.state.get()));
            }
        }
    }

    @Override
    public void dispatch() {
        HttpServletRequest sr = (HttpServletRequest)this.getServletRequest();
        String path = sr.getRequestURI();
        String cpath = sr.getContextPath();
        if (cpath.length() > 1) {
            path = path.substring(cpath.length());
        }
        this.dispatch(path);
    }

    @Override
    public void dispatch(String path) {
        this.dispatch(this.request.getServletContext(), path);
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AsyncContext Dispatch Called[" + (Object)((Object)this.state.get()) + "; " + path + "; " + this.request.getRequestURI() + "?" + this.request.getQueryString() + "]"), (Throwable)new DebugException());
        }
        if (this.state.compareAndSet(AsyncState.STARTED, AsyncState.DISPATCHING) || this.state.compareAndSet(AsyncState.DISPATCHED, AsyncState.DISPATCHING)) {
            Runnable run;
            if (this.request.getAttribute("javax.servlet.async.request_uri") == null) {
                this.request.setAttribute("javax.servlet.async.request_uri", this.request.getRequestURI() + "?" + this.request.getQueryString());
                this.request.setAttribute("javax.servlet.async.context_path", this.request.getContextPath());
                this.request.setAttribute("javax.servlet.async.servlet_path", this.request.getServletPath());
                this.request.setAttribute("javax.servlet.async.query_string", this.request.getQueryString());
            }
            final RequestDispatcher requestDispatcher = context.getRequestDispatcher(path);
            final HttpServletRequest servletRequest = (HttpServletRequest)this.getRequest();
            final HttpServletResponse servletResponse = (HttpServletResponse)this.getResponse();
            this.dispatch = run = new Runnable(){

                @Override
                public void run() {
                    DispatcherType type = (DispatcherType)((Object)AsyncContextImpl.this.request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
                    try {
                        AsyncContextImpl.this.request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
                        requestDispatcher.include(servletRequest, servletResponse);
                    }
                    catch (Exception x) {
                        throw new RuntimeException(x);
                    }
                    finally {
                        AsyncContextImpl.this.request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)type);
                    }
                }
            };
            AtomicBoolean dispatched = new AtomicBoolean(false);
            this.request.getCoyoteRequest().action(ActionCode.ACTION_ASYNC_DISPATCH, dispatched);
            if (!dispatched.get()) {
                try {
                    this.doInternalDispatch();
                }
                catch (ServletException sx) {
                    throw new RuntimeException(sx);
                }
                catch (IOException ix) {
                    throw new RuntimeException(ix);
                }
            }
            if (this.state.get().equals((Object)AsyncState.DISPATCHED)) {
                this.complete();
            }
        } else {
            throw new IllegalStateException("Dispatch not allowed. Invalid state:" + (Object)((Object)this.state.get()));
        }
    }

    @Override
    public ServletRequest getRequest() {
        return this.getServletRequest();
    }

    @Override
    public ServletResponse getResponse() {
        return this.getServletResponse();
    }

    @Override
    public void start(final Runnable run) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AsyncContext Start Called[" + (Object)((Object)this.state.get()) + "; " + this.request.getRequestURI() + "?" + this.request.getQueryString() + "]"), (Throwable)new DebugException());
        }
        if (this.state.compareAndSet(AsyncState.STARTED, AsyncState.DISPATCHING) || this.state.compareAndSet(AsyncState.DISPATCHED, AsyncState.DISPATCHING)) {
            Runnable r;
            ServletContext sctx = this.getServletRequest().getServletContext();
            this.dispatch = r = new Runnable(){

                @Override
                public void run() {
                    try {
                        run.run();
                    }
                    catch (Exception x) {
                        log.error((Object)"Unable to run async task.", (Throwable)x);
                    }
                }
            };
            AtomicBoolean dispatched = new AtomicBoolean(false);
            this.request.getCoyoteRequest().action(ActionCode.ACTION_ASYNC_DISPATCH, dispatched);
            if (!dispatched.get()) {
                try {
                    this.doInternalDispatch();
                }
                catch (ServletException sx) {
                    throw new RuntimeException(sx);
                }
                catch (IOException ix) {
                    throw new RuntimeException(ix);
                }
            }
        } else {
            throw new IllegalStateException("Dispatch not allowed. Invalid state:" + (Object)((Object)this.state.get()));
        }
    }

    @Override
    public void addListener(AsyncListener listener) {
        AsyncListenerWrapper wrapper = new AsyncListenerWrapper();
        wrapper.setListener(listener);
        this.listeners.add(wrapper);
    }

    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        AsyncListenerWrapper wrapper = new AsyncListenerWrapper();
        wrapper.setListener(listener);
        this.listeners.add(wrapper);
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        try {
            listener = (AsyncListener)clazz.newInstance();
        }
        catch (InstantiationException e) {
            ServletException se = new ServletException(e);
            throw se;
        }
        catch (IllegalAccessException e) {
            ServletException se = new ServletException(e);
            throw se;
        }
        return (T)listener;
    }

    public void recycle() {
        this.servletRequest = null;
        this.servletResponse = null;
        this.listeners.clear();
        this.hasOriginalRequestAndResponse = true;
        this.state.set(AsyncState.NOT_STARTED);
        this.context = null;
        this.timeout = -1L;
        this.event = null;
    }

    public boolean isStarted() {
        return this.state.get() == AsyncState.STARTED || this.state.get() == AsyncState.DISPATCHING;
    }

    public void setStarted(Context context) {
        if (!this.state.compareAndSet(AsyncState.NOT_STARTED, AsyncState.STARTED) && !this.state.compareAndSet(AsyncState.DISPATCHED, AsyncState.STARTED)) {
            throw new IllegalStateException("Start illegal. Invalid state: " + (Object)((Object)this.state.get()));
        }
        this.context = context;
    }

    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.hasOriginalRequestAndResponse;
    }

    public void setHasOriginalRequestAndResponse(boolean hasOriginalRequestAndResponse) {
        this.hasOriginalRequestAndResponse = hasOriginalRequestAndResponse;
    }

    public boolean isCompleted() {
        return this.state.get() == AsyncState.NOT_STARTED;
    }

    public void setCompleted() {
        this.state.set(AsyncState.NOT_STARTED);
    }

    public void doInternalDispatch() throws ServletException, IOException {
        if (this.state.compareAndSet(AsyncState.TIMING_OUT, AsyncState.COMPLETING)) {
            log.debug((Object)"TIMING OUT!");
            boolean listenerInvoked = false;
            for (AsyncListenerWrapper listener : this.listeners) {
                listener.fireOnTimeout(this.event);
                listenerInvoked = true;
            }
            if (!listenerInvoked) {
                ((HttpServletResponse)this.servletResponse).setStatus(500);
            }
            this.doInternalComplete(true);
        } else if (this.state.compareAndSet(AsyncState.ERROR_DISPATCHING, AsyncState.COMPLETING)) {
            log.debug((Object)"ON ERROR!");
            boolean listenerInvoked = false;
            for (AsyncListenerWrapper listener : this.listeners) {
                try {
                    listener.fireOnError(this.event);
                }
                catch (IllegalStateException x) {
                    log.debug((Object)"Listener invoked invalid state.", (Throwable)x);
                }
                catch (Exception x) {
                    log.debug((Object)"Exception during onError.", (Throwable)x);
                }
                listenerInvoked = true;
            }
            if (!listenerInvoked) {
                ((HttpServletResponse)this.servletResponse).setStatus(500);
            }
            this.doInternalComplete(true);
        } else if (this.state.compareAndSet(AsyncState.DISPATCHING, AsyncState.DISPATCHED)) {
            if (this.dispatch != null) {
                try {
                    this.dispatch.run();
                }
                catch (RuntimeException x) {
                    this.doInternalComplete(true);
                    if (x.getCause() instanceof ServletException) {
                        throw (ServletException)x.getCause();
                    }
                    if (x.getCause() instanceof IOException) {
                        throw (IOException)x.getCause();
                    }
                    throw new ServletException(x);
                }
                finally {
                    this.dispatch = null;
                }
            }
        } else if (this.state.get() == AsyncState.COMPLETING) {
            this.doInternalComplete(false);
        } else {
            throw new IllegalStateException("Dispatch illegal. Invalid state: " + (Object)((Object)this.state.get()));
        }
    }

    public void doInternalComplete(boolean error) {
        if (this.isCompleted()) {
            return;
        }
        if (this.state.compareAndSet(AsyncState.STARTED, AsyncState.NOT_STARTED)) {
            this.recycle();
        } else if (this.state.compareAndSet(AsyncState.COMPLETING, AsyncState.NOT_STARTED)) {
            for (AsyncListenerWrapper wrapper : this.listeners) {
                try {
                    wrapper.fireOnComplete(this.event);
                }
                catch (IOException x) {
                    log.error((Object)"", (Throwable)x);
                }
            }
            try {
                if (!error) {
                    this.getResponse().flushBuffer();
                }
            }
            catch (Exception x) {
                log.error((Object)"", (Throwable)x);
            }
            this.recycle();
        } else {
            throw new IllegalStateException("Complete illegal. Invalid state:" + (Object)((Object)this.state.get()));
        }
    }

    public AsyncState getState() {
        return this.state.get();
    }

    protected void setState(AsyncState st) {
        this.state.set(st);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.request.getCoyoteRequest().action(ActionCode.ACTION_ASYNC_SETTIMEOUT, new Long(timeout));
    }

    public void setTimeoutState() {
        this.state.set(AsyncState.TIMING_OUT);
    }

    public void setErrorState(Throwable t) {
        if (t != null) {
            this.request.setAttribute("javax.servlet.error.exception", t);
        }
        this.state.set(AsyncState.ERROR_DISPATCHING);
    }

    public void init(ServletRequest request, ServletResponse response) {
        this.servletRequest = request;
        this.servletResponse = response;
        this.event = new AsyncEvent(this, request, response);
    }

    public static class DebugException
    extends Exception {
    }

    public static enum AsyncState {
        NOT_STARTED,
        STARTED,
        DISPATCHING,
        DISPATCHED,
        COMPLETING,
        TIMING_OUT,
        ERROR_DISPATCHING;

    }
}

