/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;

final class StandardWrapperValve
extends ValveBase {
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private volatile int requestCount;
    private volatile int errorCount;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");

    public StandardWrapperValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block55: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block54: {
                boolean unavailable = false;
                throwable = null;
                t1 = System.currentTimeMillis();
                ++this.requestCount;
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                if (!context.getAvailable()) {
                    response.sendError(503, sm.getString("standardContext.isUnavailable"));
                    unavailable = true;
                }
                if (!unavailable && wrapper.isUnavailable()) {
                    this.container.getLogger().info((Object)sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                    }
                    unavailable = true;
                }
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), (Throwable)e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                    }
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                boolean comet = false;
                if (servlet instanceof CometProcessor && request.getAttribute("org.apache.tomcat.comet.support") == Boolean.TRUE) {
                    comet = true;
                    request.setComet(true);
                }
                try {
                    response.sendAcknowledgement();
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().warn((Object)sm.getString("standardWrapper.acknowledgeException", new Object[]{wrapper.getName()}), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.acknowledgeException", new Object[]{wrapper.getName()}), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                MessageBytes requestPathMB = request.getRequestPathMB();
                DispatcherType dispatcherType = DispatcherType.REQUEST;
                if (request.getDispatcherType() == DispatcherType.ASYNC) {
                    dispatcherType = DispatcherType.ASYNC;
                }
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)dispatcherType);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                ApplicationFilterChain filterChain = factory.createFilterChain(request, wrapper, servlet);
                request.setComet(false);
                try {
                    String jspFile = wrapper.getJspFile();
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    if (servlet != null && filterChain != null) {
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                if (request.isAsyncDispatching()) {
                                    ((AsyncContextImpl)request.getAsyncContext()).doInternalDispatch();
                                }
                                if (comet) {
                                    filterChain.doFilterEvent(request.getEvent());
                                    request.setComet(true);
                                }
                                filterChain.doFilter(request.getRequest(), response.getResponse());
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        } else if (request.isAsyncDispatching()) {
                            ((AsyncContextImpl)request.getAsyncContext()).doInternalDispatch();
                        } else if (comet) {
                            request.setComet(true);
                            filterChain.doFilterEvent(request.getEvent());
                        } else {
                            filterChain.doFilter(request.getRequest(), response.getResponse());
                        }
                    }
                    request.removeAttribute("org.apache.catalina.jsp_file");
                }
                catch (ClientAbortException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), (Throwable)e);
                    wrapper.unavailable(e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                    }
                }
                catch (ServletException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                if (filterChain != null) {
                    if (request.isComet()) {
                        filterChain.reuse();
                    } else {
                        filterChain.release();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", new Object[]{wrapper.getName()}), e);
                    if (throwable != null) break block54;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", new Object[]{wrapper.getName()}), e);
                if (throwable != null) break block55;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        long t1;
        block31: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block30: {
                throwable = null;
                t1 = System.currentTimeMillis();
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                boolean unavailable = !context.getAvailable() || wrapper.isUnavailable();
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                MessageBytes requestPathMB = request.getRequestPathMB();
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.REQUEST);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                ApplicationFilterChain filterChain = (ApplicationFilterChain)request.getFilterChain();
                try {
                    String jspFile = wrapper.getJspFile();
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    if (servlet != null && filterChain != null) {
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                filterChain.doFilterEvent(request.getEvent());
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        } else {
                            filterChain.doFilterEvent(request.getEvent());
                        }
                    }
                    request.removeAttribute("org.apache.catalina.jsp_file");
                }
                catch (ClientAbortException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), (Throwable)e);
                }
                catch (ServletException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName()}), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                if (filterChain != null) {
                    filterChain.reuse();
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", new Object[]{wrapper.getName()}), e);
                    if (throwable != null) break block30;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", new Object[]{wrapper.getName()}), e);
                if (throwable != null) break block31;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    @Override
    protected void initInternal() throws LifecycleException {
    }
}

