/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.management.MBeanException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ServerLifecycleListener
implements ContainerListener,
LifecycleListener,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(ServerLifecycleListener.class);
    protected String descriptors = null;

    public String getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(String descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        try {
            String type = event.getType();
            if ("addChild".equals(type)) {
                this.processContainerAddChild(event.getContainer(), (Container)event.getData());
            } else if ("removeChild".equals(type)) {
                this.processContainerRemoveChild(event.getContainer(), (Container)event.getData());
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception processing event " + event), (Throwable)e);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context;
        Lifecycle lifecycle = event.getLifecycle();
        if ("start".equals(event.getType())) {
            try {
                MBeanFactory factory;
                if (lifecycle instanceof Server) {
                    factory = new MBeanFactory();
                    factory.setContainer(lifecycle);
                    this.createMBeans(factory);
                    this.createMBeans((Server)lifecycle);
                }
                if (lifecycle instanceof Service) {
                    factory = new MBeanFactory();
                    factory.setContainer(lifecycle);
                    this.createMBeans(factory);
                    this.createMBeans((Service)lifecycle);
                }
            }
            catch (MBeanException t) {
                Exception e = t.getTargetException();
                if (e == null) {
                    e = t;
                }
                log.error((Object)"createMBeans: MBeanException", (Throwable)e);
            }
            catch (Throwable t) {
                log.error((Object)"createMBeans: Throwable", t);
            }
        } else if ("after_stop".equals(event.getType())) {
            try {
                if (lifecycle instanceof Server) {
                    this.destroyMBeans((Server)lifecycle);
                }
                if (lifecycle instanceof Service) {
                    this.destroyMBeans((Service)lifecycle);
                }
            }
            catch (MBeanException t) {
                Exception e = t.getTargetException();
                if (e == null) {
                    e = t;
                }
                log.error((Object)"destroyMBeans: MBeanException", (Throwable)e);
            }
            catch (Throwable t) {
                log.error((Object)"destroyMBeans: Throwable", t);
            }
        }
        if (("reload".equals(event.getType()) || "start".equals(event.getType())) && lifecycle instanceof StandardContext && (context = (StandardContext)lifecycle).getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", MBeanUtils.createServer());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Container) {
            try {
                this.processContainerPropertyChange((Container)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error((Object)"Exception handling Container property change", (Throwable)e);
            }
        } else if (event.getSource() instanceof NamingResources) {
            try {
                this.processNamingResourcesPropertyChange((NamingResources)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error((Object)"Exception handling NamingResources property change", (Throwable)e);
            }
        } else if (event.getSource() instanceof Server) {
            try {
                this.processServerPropertyChange((Server)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error((Object)"Exception handing Server property change", (Throwable)e);
            }
        } else if (event.getSource() instanceof Service) {
            try {
                this.processServicePropertyChange((Service)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error((Object)"Exception handing Service property change", (Throwable)e);
            }
        }
    }

    protected void createMBeans(Connector connector) throws Exception {
    }

    protected void createMBeans(Context context) throws Exception {
        Manager cManager;
        Loader cLoader;
        context.addContainerListener(this);
        if (context instanceof StandardContext) {
            ((StandardContext)context).addPropertyChangeListener(this);
            context.addLifecycleListener(this);
        }
        if (context.getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", MBeanUtils.createServer());
        }
        if ((cLoader = context.getLoader()) != null && log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Loader " + cLoader));
        }
        if ((cManager = context.getManager()) != null && log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Manager " + cManager));
        }
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm && log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Realm " + cRealm));
        }
        NamingResources resources = context.getNamingResources();
        this.createMBeans(resources);
    }

    protected void createMBeans(ContextEnvironment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for ContextEnvironment " + environment));
        }
        MBeanUtils.createMBean(environment);
    }

    protected void createMBeans(ContextResource resource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for ContextResource " + resource));
        }
        MBeanUtils.createMBean(resource);
    }

    protected void createMBeans(ContextResourceLink resourceLink) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for ContextResourceLink " + resourceLink));
        }
        MBeanUtils.createMBean(resourceLink);
    }

    protected void createMBeans(Engine engine) throws Exception {
        Realm eRealm;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Engine " + engine));
        }
        engine.addContainerListener(this);
        if (engine instanceof StandardEngine) {
            ((StandardEngine)engine).addPropertyChangeListener(this);
        }
        if ((eRealm = engine.getRealm()) != null && log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Realm " + eRealm));
        }
        Container[] hosts = engine.findChildren();
        for (int j = 0; j < hosts.length; ++j) {
            this.createMBeans((Host)hosts[j]);
        }
    }

    protected void createMBeans(Host host) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Host " + host));
        }
        host.addContainerListener(this);
        if (host instanceof StandardHost) {
            ((StandardHost)host).addPropertyChangeListener(this);
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm && log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Realm " + hRealm));
        }
        Container[] contexts = host.findChildren();
        for (int k = 0; k < contexts.length; ++k) {
            this.createMBeans((Context)contexts[k]);
        }
    }

    protected void createMBeans(MBeanFactory factory) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for MBeanFactory " + factory));
        }
        MBeanUtils.createMBean(factory);
    }

    protected void createMBeans(NamingResources resources) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for NamingResources " + resources));
        }
        MBeanUtils.createMBean(resources);
        resources.addPropertyChangeListener(this);
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.createMBeans(environments[i]);
        }
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.createMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.createMBeans(cresourcelinks[i]);
        }
    }

    protected void createMBeans(Server server) throws Exception {
        NamingResources resources;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBean for Server " + server));
        }
        if (server instanceof StandardServer) {
            ((StandardServer)server).addPropertyChangeListener(this);
        }
        if ((resources = server.getGlobalNamingResources()) != null) {
            this.createMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            if (services[i].getContainer().getClass().getName().equals("org.apache.catalina.connector.warp.WarpEngine")) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping MBean for Service " + services[i]));
                continue;
            }
            this.createMBeans(services[i]);
        }
    }

    protected void createMBeans(Service service) throws Exception {
        if (service instanceof StandardService) {
            ((StandardService)service).addPropertyChangeListener(this);
        }
        Connector[] connectors = service.findConnectors();
        for (int j = 0; j < connectors.length; ++j) {
            this.createMBeans(connectors[j]);
        }
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            this.createMBeans(engine);
        }
    }

    protected void destroyMBeans(Connector connector, Service service) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Connector " + connector));
        }
        MBeanUtils.destroyMBean(connector, service);
    }

    protected void destroyMBeans(Context context) throws Exception {
        NamingResources resources;
        Loader cLoader;
        Manager cManager;
        context.removeContainerListener(this);
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm && log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Realm " + cRealm));
        }
        if ((cManager = context.getManager()) != null && log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Manager " + cManager));
        }
        if ((cLoader = context.getLoader()) != null && log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Loader " + cLoader));
        }
        if ((resources = context.getNamingResources()) != null) {
            this.destroyMBeans(resources);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Context " + context));
        }
        MBeanUtils.destroyMBean(context);
        if (context instanceof StandardContext) {
            ((StandardContext)context).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(ContextEnvironment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for ContextEnvironment " + environment));
        }
        MBeanUtils.destroyMBean(environment);
    }

    protected void destroyMBeans(ContextResource resource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for ContextResource " + resource));
        }
        MBeanUtils.destroyMBean(resource);
    }

    protected void destroyMBeans(ContextResourceLink resourceLink) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for ContextResourceLink " + resourceLink));
        }
        MBeanUtils.destroyMBean(resourceLink);
    }

    protected void destroyMBeans(Engine engine) throws Exception {
        engine.removeContainerListener(this);
        Container[] hosts = engine.findChildren();
        for (int k = 0; k < hosts.length; ++k) {
            this.destroyMBeans((Host)hosts[k]);
        }
        Realm eRealm = engine.getRealm();
        if (eRealm != null && log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Realm " + eRealm));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Engine " + engine));
        }
        MBeanUtils.destroyMBean(engine);
    }

    protected void destroyMBeans(Host host) throws Exception {
        host.removeContainerListener(this);
        Container[] contexts = host.findChildren();
        for (int k = 0; k < contexts.length; ++k) {
            this.destroyMBeans((Context)contexts[k]);
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm && log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Realm " + hRealm));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Host " + host));
        }
        MBeanUtils.destroyMBean(host);
    }

    protected void destroyMBeans(NamingResources resources) throws Exception {
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.destroyMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.destroyMBeans(cresourcelinks[i]);
        }
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.destroyMBeans(environments[i]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for NamingResources " + resources));
        }
        MBeanUtils.destroyMBean(resources);
        resources.removePropertyChangeListener(this);
    }

    protected void destroyMBeans(Server server) throws Exception {
        NamingResources resources = server.getGlobalNamingResources();
        if (resources != null) {
            this.destroyMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            this.destroyMBeans(services[i]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying MBean for Server " + server));
        }
        MBeanUtils.destroyMBean(server);
        if (server instanceof StandardServer) {
            ((StandardServer)server).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(Service service) throws Exception {
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            this.destroyMBeans(engine);
        }
        Connector[] connectors = service.findConnectors();
        for (int j = 0; j < connectors.length; ++j) {
            this.destroyMBeans(connectors[j], service);
        }
        if (service instanceof StandardService) {
            ((StandardService)service).removePropertyChangeListener(this);
        }
    }

    protected void processContainerAddChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process addChild[parent=" + parent + ",child=" + child + "]"));
        }
        try {
            if (child instanceof Context) {
                this.createMBeans((Context)child);
            } else if (child instanceof Engine) {
                this.createMBeans((Engine)child);
            } else if (child instanceof Host) {
                this.createMBeans((Host)child);
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            log.error((Object)"processContainerAddChild: MBeanException", (Throwable)e);
        }
        catch (Throwable t) {
            log.error((Object)"processContainerAddChild: Throwable", t);
        }
    }

    protected void processContainerPropertyChange(Container container, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("propertyChange[container=" + container + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]"));
        }
        if ("loader".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing MBean for Loader " + oldValue));
                }
                MBeanUtils.destroyMBean((Loader)oldValue);
            }
            if (newValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating MBean for Loader " + newValue));
                }
                MBeanUtils.createMBean((Loader)newValue);
            }
        } else if ("logger".equals(propertyName)) {
            if (oldValue != null && log.isDebugEnabled()) {
                log.debug((Object)("Removing MBean for Logger " + oldValue));
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug((Object)("Creating MBean for Logger " + newValue));
            }
        } else if ("manager".equals(propertyName)) {
            if (oldValue != null && log.isDebugEnabled()) {
                log.debug((Object)("Removing MBean for Manager " + oldValue));
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug((Object)("Creating MBean for Manager " + newValue));
            }
        } else if ("realm".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing MBean for Realm " + oldValue));
                }
                MBeanUtils.destroyMBean((Realm)oldValue);
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug((Object)("Creating MBean for Realm " + newValue));
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processContainerRemoveChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process removeChild[parent=" + parent + ",child=" + child + "]"));
        }
        try {
            if (child instanceof Context) {
                Context context = (Context)child;
                if (context.getPrivileged()) {
                    context.getServletContext().removeAttribute("org.apache.catalina.Registry");
                    context.getServletContext().removeAttribute("org.apache.catalina.MBeanServer");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Removing MBean for Context " + context));
                }
                this.destroyMBeans(context);
                if (context instanceof StandardContext) {
                    ((StandardContext)context).removePropertyChangeListener(this);
                }
            } else if (child instanceof Host) {
                Host host = (Host)child;
                this.destroyMBeans(host);
                if (host instanceof StandardHost) {
                    ((StandardHost)host).removePropertyChangeListener(this);
                }
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            log.error((Object)"processContainerRemoveChild: MBeanException", (Throwable)e);
        }
        catch (Throwable t) {
            log.error((Object)"processContainerRemoveChild: Throwable", t);
        }
    }

    protected void processNamingResourcesPropertyChange(NamingResources resources, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("propertyChange[namingResources=" + resources + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]"));
        }
        if ("environment".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextEnvironment)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextEnvironment)newValue);
            }
        } else if ("resource".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResource)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResource)newValue);
            }
        } else if ("resourceLink".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResourceLink)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResourceLink)newValue);
            }
        }
    }

    protected void processServerPropertyChange(Server server, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("propertyChange[server=" + server + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]"));
        }
        if ("globalNamingResources".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((NamingResources)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((NamingResources)newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processServicePropertyChange(Service service, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("propertyChange[service=" + service + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]"));
        }
        if ("connector".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Connector)oldValue, service);
            }
            if (newValue != null) {
                this.createMBeans((Connector)newValue);
            }
        } else if ("container".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Engine)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Engine)newValue);
            }
        }
    }
}

