/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Base64;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class ManagerBase
extends LifecycleMBeanBase
implements Manager {
    private final Log log = LogFactory.getLog(ManagerBase.class);
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Container container;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 16;
    protected static String name = "ManagerBase";
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected long expiredSessions = 0L;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected long sessionCounter = 0L;
    protected volatile int maxActive = 0;
    private final Object maxActiveUpdateLock = new Object();
    protected volatile int duplicates = 0;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.getting", new Object[]{this.algorithm}));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)sm.getString("managerBase.digest", new Object[]{this.algorithm}), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)sm.getString("managerBase.digest", new Object[]{DEFAULT_ALGORITHM}), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
    }

    public String getEntropy() {
        if (this.entropy == null) {
            byte[] result = new byte[32];
            boolean apr = false;
            try {
                String methodName = "random";
                Class[] paramTypes = new Class[]{result.getClass(), Integer.TYPE};
                Object[] paramValues = new Object[]{result, 32};
                Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                apr = true;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
            if (apr) {
                this.setEntropy(Base64.encode(result));
            } else {
                this.setEntropy(this.toString());
            }
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    public String getName() {
        return name;
    }

    public void setRandomFile(String s) {
        if (Globals.IS_SECURITY_ENABLED) {
            this.randomIS = AccessController.doPrivileged(new PrivilegedSetRandomFile(s));
        } else {
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                this.randomIS = new DataInputStream(new FileInputStream(f));
                this.randomIS.readLong();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening " + this.devRandomSource));
                }
            }
            catch (IOException ex) {
                this.log.warn((Object)("Error reading " + this.devRandomSource), (Throwable)ex);
                if (this.randomIS != null) {
                    try {
                        this.randomIS.close();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"Failed to close randomIS.");
                    }
                }
                this.devRandomSource = null;
                this.randomIS = null;
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    public Random getRandom() {
        if (this.random == null) {
            long t2;
            long seed;
            long t1 = seed = System.currentTimeMillis();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (byte)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.log.error((Object)sm.getString("managerBase.random", new Object[]{this.randomClass}), (Throwable)e);
                this.random = new Random();
                this.random.setSeed(seed);
            }
            if (this.log.isDebugEnabled() && (t2 = System.currentTimeMillis()) - t1 > 100L) {
                this.log.debug((Object)(sm.getString("managerBase.seeding", new Object[]{this.randomClass}) + " " + (t2 - t1)));
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    @Override
    public long getExpiredSessions() {
        return this.expiredSessions;
    }

    @Override
    public void setExpiredSessions(long expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        int oldProcessExpiresFrequency = this.processExpiresFrequency;
        this.processExpiresFrequency = processExpiresFrequency;
        this.support.firePropertyChange("processExpiresFrequency", (Object)oldProcessExpiresFrequency, (Object)this.processExpiresFrequency);
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        if (this.randomIS != null) {
            try {
                this.randomIS.close();
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        super.destroyInternal();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.setDistributable(((Context)this.getContainer()).getDistributable());
        this.getRandomBytes(new byte[16]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    @Deprecated
    public Session createSession() {
        return this.createSession(null);
    }

    @Override
    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        if (sessionId == null) {
            sessionId = this.generateSessionId();
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    @Override
    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void changeSessionId(Session session) {
        session.setId(this.generateSessionId());
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got " + len + " " + bytes.length));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.devRandomSource = null;
            try {
                this.randomIS.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId() {
        byte[] random = new byte[16];
        String jvmRoute = this.getJvmRoute();
        String result = null;
        StringBuilder buffer = new StringBuilder();
        do {
            int resultLenBytes = 0;
            if (result != null) {
                buffer = new StringBuilder();
                ++this.duplicates;
            }
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        buffer.append((char)(48 + b1));
                    } else {
                        buffer.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        buffer.append((char)(48 + b2));
                        continue;
                    }
                    buffer.append((char)(65 + (b2 - 10)));
                }
            }
            if (jvmRoute == null) continue;
            buffer.append('.').append(jvmRoute);
        } while (this.sessions.containsKey(result = buffer.toString()));
        return result;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    @Override
    public void setSessionCounter(long sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    @Override
    public long getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    @Override
    public int getSessionAverageAliveTime() {
        return this.sessionAverageAliveTime;
    }

    @Override
    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap<String, String> getSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration<String> ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ee.hasMoreElements()) {
            String attrName = ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return;
        }
        s.expire();
    }

    public long getThisAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getThisAccessedTime();
    }

    public String getThisAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getThisAccessedTime()).toString();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getLastAccessedTime();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getCreationTime()).toString();
    }

    public long getCreationTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getCreationTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Manager");
        if (this.container instanceof Context) {
            name.append(",path=");
            Context context = (Context)this.container;
            String path = context.getPath();
            if (path.equals("")) {
                path = "/";
            }
            name.append(path);
            name.append(",host=");
            name.append(context.getParent().getName());
        } else {
            name.append(",container=");
            name.append(this.container.getName());
        }
        return name.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction<DataInputStream> {
        public PrivilegedSetRandomFile(String s) {
            ManagerBase.this.devRandomSource = s;
        }

        @Override
        public DataInputStream run() {
            try {
                File f = new File(ManagerBase.this.devRandomSource);
                if (!f.exists()) {
                    return null;
                }
                ManagerBase.this.randomIS = new DataInputStream(new FileInputStream(f));
                ManagerBase.this.randomIS.readLong();
                if (ManagerBase.this.log.isDebugEnabled()) {
                    ManagerBase.this.log.debug((Object)("Opening " + ManagerBase.this.devRandomSource));
                }
                return ManagerBase.this.randomIS;
            }
            catch (IOException ex) {
                ManagerBase.this.log.warn((Object)("Error reading " + ManagerBase.this.devRandomSource), (Throwable)ex);
                if (ManagerBase.this.randomIS != null) {
                    try {
                        ManagerBase.this.randomIS.close();
                    }
                    catch (Exception e) {
                        ManagerBase.this.log.warn((Object)"Failed to close randomIS.");
                    }
                }
                ManagerBase.this.devRandomSource = null;
                ManagerBase.this.randomIS = null;
                return null;
            }
        }
    }
}

