/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class StandardManager
extends ManagerBase
implements PropertyChangeListener {
    private final Log log = LogFactory.getLog(StandardManager.class);
    protected static final String info = "StandardManager/1.0";
    protected int maxActiveSessions = -1;
    protected static String name = "StandardManager";
    protected String pathname = "SESSIONS.ser";
    protected int rejectedSessions = 0;
    protected long processingTime = 0L;

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    @Override
    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public Session createSession(String sessionId) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession(sessionId);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unreported exception in load() " + exception));
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.loading", new Object[]{this.pathname}));
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Creating custom object input stream for class loader ");
                }
                ois = new CustomObjectInputStream(bis, classLoader);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Creating standard object input stream");
                }
                ois = new ObjectInputStream(bis);
            }
        }
        catch (FileNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No persisted data file found");
            }
            return;
        }
        catch (IOException e) {
            this.log.error((Object)sm.getString("standardManager.loading.ioe", new Object[]{e}), (Throwable)e);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw e;
        }
        Map map = this.sessions;
        synchronized (map) {
            try {
                Integer count = (Integer)ois.readObject();
                int n = count;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading " + n + " persisted sessions"));
                }
                for (int i = 0; i < n; ++i) {
                    StandardSession session = this.getNewSession();
                    session.readObjectData(ois);
                    session.setManager(this);
                    this.sessions.put(session.getIdInternal(), session);
                    session.activate();
                    if (!session.isValidInternal()) {
                        session.setValid(true);
                        session.expire();
                    }
                    ++this.sessionCounter;
                }
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)sm.getString("standardManager.loading.cnfe", new Object[]{e}), (Throwable)e);
                try {
                    ois.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                throw e;
            }
            catch (IOException e) {
                this.log.error((Object)sm.getString("standardManager.loading.ioe", new Object[]{e}), (Throwable)e);
                try {
                    ois.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    ois.close();
                }
                catch (IOException f) {}
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unreported exception in unLoad() " + exception));
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        File file;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unloading persisted sessions");
        }
        if ((file = this.file()) == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.unloading", new Object[]{this.pathname}));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            this.log.error((Object)sm.getString("standardManager.unloading.ioe", new Object[]{e}), (Throwable)e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw e;
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        Map f = this.sessions;
        synchronized (f) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unloading " + this.sessions.size() + " sessions"));
            }
            try {
                oos.writeObject(new Integer(this.sessions.size()));
                for (StandardSession session : this.sessions.values()) {
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
            catch (IOException e) {
                this.log.error((Object)sm.getString("standardManager.unloading.ioe", new Object[]{e}), (Throwable)e);
                try {
                    oos.close();
                }
                catch (IOException f2) {
                    // empty catch block
                }
                throw e;
            }
        }
        try {
            oos.flush();
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException f3) {}
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Expiring " + list.size() + " persisted sessions"));
        }
        for (StandardSession session : list) {
            try {
                session.expire(false);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
            finally {
                session.recycle();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unloading complete");
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization starting");
        }
        this.generateSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization completed");
        }
        try {
            this.load();
        }
        catch (Throwable t) {
            this.log.error((Object)sm.getString("standardManager.managerLoad"), t);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable t) {
            this.log.error((Object)sm.getString("standardManager.managerUnload"), t);
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Session session = sessions[i];
            try {
                if (!session.isValid()) continue;
                session.expire();
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                continue;
            }
            finally {
                session.recycle();
            }
        }
        this.random = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)sm.getString("standardManager.sessionTimeout", new Object[]{event.getNewValue().toString()}));
            }
        }
    }

    protected File file() {
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && this.container instanceof Context && (tempdir = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoUnload() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doUnload();
            return null;
        }
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoad() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doLoad();
            return null;
        }
    }
}

