/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public class AjpAprProtocol
implements ProtocolHandler,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(AjpAprProtocol.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected ObjectName tpOname;
    protected ObjectName rgOname;
    protected AprEndpoint endpoint = new AprEndpoint();
    protected Hashtable<String, Object> attributes = new Hashtable();
    private Adapter adapter;
    private AjpConnectionHandler cHandler = new AjpConnectionHandler(this);
    protected int processorCache = -1;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    protected int packetSize = 8192;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AjpAprProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.setattribute", new Object[]{name, value}));
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.getattribute", new Object[]{key}));
        }
        return this.attributes.get(key);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        this.endpoint.setUseSendfile(false);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.init", new Object[]{this.getName()}));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.start", new Object[]{this.getName()}));
        }
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.pause", new Object[]{this.getName()}));
        }
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.resume", new Object[]{this.getName()}));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.stop", new Object[]{this.getName()}));
        }
        this.endpoint.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "ajp-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int timeout) {
        this.endpoint.setKeepAliveTimeout(timeout);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
    }

    public int getPollTime() {
        return this.endpoint.getPollTime();
    }

    public void setPollTime(int pollTime) {
        this.endpoint.setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getPollerSize();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected static class AjpConnectionHandler
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, AjpAprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<AjpAprProcessor> recycledProcessors = new ConcurrentLinkedQueue<AjpAprProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(AjpAprProcessor processor) {
                boolean offer = AjpConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < AjpConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    AjpConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public AjpAprProcessor poll() {
                AjpAprProcessor result = (AjpAprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                AjpAprProcessor next = this.poll();
                while (next != null) {
                    AjpConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState event(long socket, SocketStatus status) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState process(long socket) {
            AjpAprProcessor processor = this.recycledProcessors.poll();
            try {
                if (processor == null) {
                    processor = this.createProcessor();
                }
                processor.action(ActionCode.ACTION_START, null);
                if (processor.process(socket)) {
                    this.connections.put(socket, processor);
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    return socketState;
                }
                AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                return socketState;
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("ajpprotocol.proto.error"), e);
            }
            finally {
                processor.action(ActionCode.ACTION_STOP, null);
                this.recycledProcessors.offer(processor);
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState asyncDispatch(long socket, SocketStatus status) {
            AjpAprProcessor result = this.connections.get(socket);
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                try {
                    state = result.asyncDispatch(socket, status);
                }
                catch (SocketException e) {
                    log.debug((Object)sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
                }
                catch (IOException e) {
                    log.debug((Object)sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)sm.getString("ajpprotocol.proto.error"), e);
                }
                finally {
                    if (state != AbstractEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            this.proto.endpoint.getPoller().add(socket);
                        }
                    }
                }
            }
            return state;
        }

        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor processor = new AjpAprProcessor(this.proto.packetSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AjpAprProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=AjpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Register " + rpName));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(AjpAprProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unregister " + rpName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error unregistering request", (Throwable)e);
                    }
                }
            }
        }
    }
}

