/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class AbstractHttp11Processor {
    private static final Log log = LogFactory.getLog(AbstractHttp11Processor.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected static boolean isSecurityEnabled = Constants.IS_SECURITY_ENABLED;
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected Pattern[] restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected String server = null;

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void addNoCompressionUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.noCompressionUserAgents = this.addREArray(this.noCompressionUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)sm.getString("http11processor.regexp.error", new Object[]{userAgent}), (Throwable)pse);
        }
    }

    public void setNoCompressionUserAgents(Pattern[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        if (noCompressionUserAgents != null) {
            StringTokenizer st = new StringTokenizer(noCompressionUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addNoCompressionUserAgent(st.nextToken().trim());
            }
        }
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    private String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    private Pattern[] addREArray(Pattern[] rArray, Pattern value) {
        Pattern[] result = null;
        if (rArray == null) {
            result = new Pattern[]{value};
        } else {
            result = new Pattern[rArray.length + 1];
            for (int i = 0; i < rArray.length; ++i) {
                result[i] = rArray[i];
            }
            result[rArray.length] = value;
        }
        return result;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.restrictedUserAgents = this.addREArray(this.restrictedUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)sm.getString("http11processor.regexp.error", new Object[]{userAgent}), (Throwable)pse);
        }
    }

    public void setRestrictedUserAgents(Pattern[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        if (restrictedUserAgents != null) {
            StringTokenizer st = new StringTokenizer(restrictedUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addRestrictedUserAgent(st.nextToken().trim());
            }
        }
    }

    public String[] findRestrictedUserAgents() {
        String[] sarr = new String[this.restrictedUserAgents.length];
        for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
            sarr[i] = this.restrictedUserAgents[i].toString();
        }
        return sarr;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public String getServer() {
        return this.server;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected boolean isCompressable() {
        long contentLength;
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.noCompressionUserAgents.length; ++i) {
                if (!this.noCompressionUserAgents[i].matcher(userAgentValue).matches()) continue;
                return false;
            }
        }
        if (((contentLength = this.response.getContentLengthLong()) == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }
}

