/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor
implements ActionHook {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected SSLSupport sslSupport;
    protected boolean async = false;
    protected boolean started = false;
    protected SocketWrapper<Socket> socket;
    protected JIoEndpoint endpoint;

    public Http11Processor(int headerBufferSize, JIoEndpoint endpoint) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
        HexUtils.load();
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socketWrapper) throws IOException {
        RequestInfo rp;
        block34: {
            rp = this.request.getRequestProcessor();
            rp.setStage(1);
            this.remoteAddr = null;
            this.remoteHost = null;
            this.localAddr = null;
            this.localName = null;
            this.remotePort = -1;
            this.localPort = -1;
            this.socket = socketWrapper;
            this.inputBuffer.setInputStream(this.socket.getSocket().getInputStream());
            this.outputBuffer.setOutputStream(this.socket.getSocket().getOutputStream());
            this.error = false;
            this.keepAlive = true;
            int keepAliveLeft = this.maxKeepAliveRequests > 0 ? socketWrapper.decrementKeepAlive() : -1;
            int soTimeout = this.endpoint.getSoTimeout();
            try {
                this.socket.getSocket().setSoTimeout(soTimeout);
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("http11processor.socket.timeout"), t);
                this.error = true;
            }
            boolean keptAlive = socketWrapper.isKeptAlive();
            if (this.started && !this.error && this.keepAlive) {
                try {
                    if (keptAlive) {
                        if (this.keepAliveTimeout > 0) {
                            this.socket.getSocket().setSoTimeout(this.keepAliveTimeout);
                        } else if (soTimeout > 0) {
                            this.socket.getSocket().setSoTimeout(soTimeout);
                        }
                    }
                    this.inputBuffer.parseRequestLine(false);
                    this.request.setStartTime(System.currentTimeMillis());
                    keptAlive = true;
                    if (this.disableUploadTimeout) {
                        this.socket.getSocket().setSoTimeout(soTimeout);
                    } else {
                        this.socket.getSocket().setSoTimeout(this.timeout);
                    }
                    this.inputBuffer.parseHeaders();
                }
                catch (IOException e) {
                    this.error = true;
                    break block34;
                }
                catch (Throwable t) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.header.parse"), t);
                    }
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
                if (!this.error) {
                    rp.setStage(2);
                    try {
                        this.prepareRequest();
                    }
                    catch (Throwable t) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("http11processor.request.prepare"), t);
                        }
                        this.response.setStatus(400);
                        this.adapter.log(this.request, this.response, 0L);
                        this.error = true;
                    }
                }
                if (this.maxKeepAliveRequests > 0 && keepAliveLeft == 0) {
                    this.keepAlive = false;
                }
                if (!this.error) {
                    try {
                        rp.setStage(3);
                        this.adapter.service(this.request, this.response);
                        if (this.keepAlive && !this.error) {
                            this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                        }
                    }
                    catch (InterruptedIOException e) {
                        this.error = true;
                    }
                    catch (Throwable t) {
                        log.error((Object)sm.getString("http11processor.request.process"), t);
                        this.response.setStatus(500);
                        this.adapter.log(this.request, this.response, 0L);
                        this.error = true;
                    }
                }
                try {
                    rp.setStage(4);
                    if (this.error && !this.async) {
                        this.inputBuffer.setSwallowInput(false);
                    }
                    if (!this.async) {
                        this.endRequest();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("http11processor.request.finish"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
                try {
                    rp.setStage(5);
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("http11processor.response.finish"), t);
                    this.error = true;
                }
                if (this.error) {
                    this.response.setStatus(500);
                }
                this.request.updateCounters();
                rp.setStage(6);
                if (!this.async || this.error) {
                    this.inputBuffer.nextRequest();
                    this.outputBuffer.nextRequest();
                }
            }
        }
        rp.setStage(7);
        if (this.error) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.async) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (!this.keepAlive) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.asyncDispatch(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.async) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (!this.keepAlive) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    public void endRequest() {
        try {
            this.inputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("http11processor.request.finish"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("http11processor.response.finish"), t);
            this.error = true;
        }
    }

    public void recycle() {
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.socket = null;
        this.async = false;
        this.sslSupport = null;
    }

    @Override
    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            this.prepareResponse();
            try {
                this.outputBuffer.commit();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_ACK) {
            if (this.response.isCommitted() || !this.expectation) {
                return;
            }
            this.inputBuffer.setSwallowInput(true);
            try {
                this.outputBuffer.sendAck();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
            try {
                this.outputBuffer.flush();
            }
            catch (IOException e) {
                this.error = true;
                this.response.setErrorException(e);
            }
        } else if (actionCode == ActionCode.ACTION_CLOSE) {
            this.async = false;
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_RESET) {
            this.outputBuffer.reset();
        } else if (actionCode != ActionCode.ACTION_CUSTOM) {
            if (actionCode == ActionCode.ACTION_START) {
                this.started = true;
            } else if (actionCode == ActionCode.ACTION_STOP) {
                this.started = false;
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                try {
                    if (this.sslSupport != null) {
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                        this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                InetAddress inetAddr;
                if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getSocket().getInetAddress()) != null) {
                    this.remoteAddr = inetAddr.getHostAddress();
                }
                this.request.remoteAddr().setString(this.remoteAddr);
            } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                InetAddress inetAddr;
                if (this.localName == null && this.socket != null && (inetAddr = this.socket.getSocket().getLocalAddress()) != null) {
                    this.localName = inetAddr.getHostName();
                }
                this.request.localName().setString(this.localName);
            } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                if (this.remoteHost == null && this.socket != null) {
                    InetAddress inetAddr = this.socket.getSocket().getInetAddress();
                    if (inetAddr != null) {
                        this.remoteHost = inetAddr.getHostName();
                    }
                    if (this.remoteHost == null) {
                        if (this.remoteAddr != null) {
                            this.remoteHost = this.remoteAddr;
                        } else {
                            this.request.remoteHost().recycle();
                        }
                    }
                }
                this.request.remoteHost().setString(this.remoteHost);
            } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                if (this.localAddr == null) {
                    this.localAddr = this.socket.getSocket().getLocalAddress().getHostAddress();
                }
                this.request.localAddr().setString(this.localAddr);
            } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                if (this.remotePort == -1 && this.socket != null) {
                    this.remotePort = this.socket.getSocket().getPort();
                }
                this.request.setRemotePort(this.remotePort);
            } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                if (this.localPort == -1 && this.socket != null) {
                    this.localPort = this.socket.getSocket().getLocalPort();
                }
                this.request.setLocalPort(this.localPort);
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                if (this.sslSupport != null) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                    }
                }
            } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
                ByteChunk body = (ByteChunk)param;
                SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
                savedBody.setRequest(this.request);
                InternalInputBuffer internalBuffer = (InternalInputBuffer)this.request.getInputBuffer();
                internalBuffer.addActiveFilter(savedBody);
            } else if (actionCode == ActionCode.ACTION_ASYNC_START) {
                this.async = true;
            } else if (actionCode == ActionCode.ACTION_ASYNC_COMPLETE) {
                AtomicBoolean dispatch = (AtomicBoolean)param;
                RequestInfo rp = this.request.getRequestProcessor();
                if (rp.getStage() != 3) {
                    dispatch.set(true);
                    this.endpoint.processSocket(this.socket, SocketStatus.STOP);
                } else {
                    dispatch.set(false);
                }
            } else if (actionCode == ActionCode.ACTION_ASYNC_SETTIMEOUT) {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socket.setTimeout(timeout);
            } else if (actionCode == ActionCode.ACTION_ASYNC_DISPATCH) {
                RequestInfo rp = this.request.getRequestProcessor();
                AtomicBoolean dispatch = (AtomicBoolean)param;
                if (rp.getStage() != 3) {
                    this.endpoint.processSocket(this.socket, SocketStatus.OPEN);
                    dispatch.set(true);
                } else {
                    dispatch.set(true);
                }
            }
        }
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + protocolMB + "\""));
            }
            this.response.setStatus(505);
            this.adapter.log(this.request, this.response, 0L);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].matcher(userAgentValue).matches()) continue;
                this.http11 = false;
                this.keepAlive = false;
                break;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase(Locale.ENGLISH).trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                    this.adapter.log(this.request, this.response, 0L);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase(Locale.ENGLISH).trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding \"" + encodingName + "\""));
                }
                this.response.setStatus(501);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L && !this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " host header missing"));
            }
            this.response.setStatus(400);
            this.adapter.log(this.request, this.response, 0L);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            headers.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
            MessageBytes vary = headers.getValue("Vary");
            if (vary == null) {
                headers.setValue("Vary").setString("Accept-Encoding");
            } else if (!vary.equals("*")) {
                headers.setValue("Vary").setString(vary.getString() + ",Accept-Encoding");
            }
        }
        headers.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            headers.addValue("Connection").setString("close");
        } else if (!this.http11 && !this.error) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.outputBuffer.sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else if (headers.getValue("Server") == null) {
            this.outputBuffer.write(Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                log.warn((Object)sm.getString("http11processor.filter.unknown", new Object[]{className}));
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("http11processor.filter.error", new Object[]{className}), (Throwable)e);
        }
    }

    protected void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getSocket().getLocalPort());
            InetAddress localAddress = this.socket.getSocket().getLocalAddress();
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.getDec(valueB[i + valueS]);
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    @Override
    public void setSocketBuffer(int socketBuffer) {
        super.setSocketBuffer(socketBuffer);
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }
}

