/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Protocol
extends AbstractHttp11Protocol {
    private static final Log log = LogFactory.getLog(Http11Protocol.class);
    protected Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected ServerSocketFactory socketFactory = null;
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;

    @Override
    public Log getLog() {
        return log;
    }

    public Http11Protocol() {
        this.endpoint = new JIoEndpoint();
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    @Override
    public void init() throws Exception {
        ((JIoEndpoint)this.endpoint).setName(this.getName());
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        try {
            if (this.isSSLEnabled()) {
                this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
                this.socketFactory = this.sslImplementation.getServerSocketFactory();
                ((JIoEndpoint)this.endpoint).setServerSocketFactory(this.socketFactory);
            } else if (this.socketFactoryName != null) {
                this.socketFactory = (ServerSocketFactory)Class.forName(this.socketFactoryName).newInstance();
                ((JIoEndpoint)this.endpoint).setServerSocketFactory(this.socketFactory);
            }
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.socketfactory.initerror"), (Throwable)ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            for (String key : this.attributes.keySet()) {
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.init", new Object[]{this.getName()}));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register endpoint");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.start", new Object[]{this.getName()}));
        }
    }

    @Override
    public void destroy() throws Exception {
        this.cHandler.recycledProcessors.clear();
        super.destroy();
    }

    public String getSocketFactory() {
        return this.socketFactoryName;
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
    }

    public String getSSLImplementation() {
        return this.sslImplementationName;
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
        this.setSecure(true);
    }

    protected static class Http11ConnectionHandler
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<SocketWrapper<Socket>, Http11Processor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11Processor> recycledProcessors = new ConcurrentLinkedQueue<Http11Processor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11Processor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.getProcessorCache() == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.getProcessorCache();
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11Processor poll() {
                Http11Processor result = (Http11Processor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11Processor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) {
            return this.process(socket, SocketStatus.OPEN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            Http11Processor processor = this.connections.remove(socket);
            boolean recycle = true;
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                processor.action(ActionCode.ACTION_START, null);
                if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null) {
                    processor.setSSLSupport(this.proto.sslImplementation.getSSLSupport(socket.getSocket()));
                } else {
                    processor.setSSLSupport(null);
                }
                AbstractEndpoint.Handler.SocketState socketState = state = socket.isAsync() ? processor.asyncDispatch(status) : processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                    recycle = false;
                } else {
                    this.connections.remove(socket);
                    socket.setAsync(false);
                }
                AbstractEndpoint.Handler.SocketState socketState2 = state;
                return socketState2;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.error"), e);
            }
            finally {
                if (recycle) {
                    processor.action(ActionCode.ACTION_STOP, null);
                    this.recycledProcessors.offer(processor);
                }
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11Processor createProcessor() {
            Http11Processor processor = new Http11Processor(this.proto.getMaxHttpHeaderSize(), (JIoEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setTimeout(this.proto.getTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11Processor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Register " + rpName));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11Processor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unregister " + rpName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error unregistering request", (Throwable)e);
                    }
                }
            }
        }
    }
}

