/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.bcel.Constants;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;

public class AnnotationEntry
implements Constants,
Serializable {
    private int type_index;
    private int num_element_value_pairs;
    private List element_value_pairs;
    private ConstantPool constant_pool;
    private boolean isRuntimeVisible;

    public AnnotationEntry(int type_index, ConstantPool constant_pool, boolean isRuntimeVisible) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public static AnnotationEntry read(DataInputStream file, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(file.readUnsignedShort(), constant_pool, isRuntimeVisible);
        annotationEntry.num_element_value_pairs = file.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList();
        for (int i = 0; i < annotationEntry.num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(file.readUnsignedShort(), ElementValue.readElementValue(file, constant_pool), constant_pool));
        }
        return annotationEntry;
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.type_index);
        dos.writeShort(this.element_value_pairs.size());
        for (int i = 0; i < this.element_value_pairs.size(); ++i) {
            ElementValuePair envp = (ElementValuePair)this.element_value_pairs.get(i);
            envp.dump(dos);
        }
    }
}

