/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.LineNumber;

public final class LineNumberTable
extends Attribute {
    private int line_number_table_length;
    private LineNumber[] line_number_table;

    public LineNumberTable(int name_index, int length, LineNumber[] line_number_table, ConstantPool constant_pool) {
        super((byte)4, name_index, length, constant_pool);
        this.setLineNumberTable(line_number_table);
    }

    LineNumberTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        this.line_number_table_length = file.readUnsignedShort();
        this.line_number_table = new LineNumber[this.line_number_table_length];
        for (int i = 0; i < this.line_number_table_length; ++i) {
            this.line_number_table[i] = new LineNumber(file);
        }
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.line_number_table_length);
        for (int i = 0; i < this.line_number_table_length; ++i) {
            this.line_number_table[i].dump(file);
        }
    }

    public final void setLineNumberTable(LineNumber[] line_number_table) {
        this.line_number_table = line_number_table;
        this.line_number_table_length = line_number_table == null ? 0 : line_number_table.length;
    }

    @Override
    public final String toString() {
        StringBuffer buf = new StringBuffer();
        StringBuffer line = new StringBuffer();
        String newLine = System.getProperty("line.separator", "\n");
        for (int i = 0; i < this.line_number_table_length; ++i) {
            line.append(this.line_number_table[i].toString());
            if (i < this.line_number_table_length - 1) {
                line.append(", ");
            }
            if (line.length() <= 72) continue;
            line.append(newLine);
            buf.append(line.toString());
            line.setLength(0);
        }
        buf.append(line);
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        LineNumberTable c = (LineNumberTable)this.clone();
        c.line_number_table = new LineNumber[this.line_number_table_length];
        for (int i = 0; i < this.line_number_table_length; ++i) {
            c.line_number_table[i] = this.line_number_table[i].copy();
        }
        c.constant_pool = _constant_pool;
        return c;
    }
}

