/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;

public final class PMGClass
extends Attribute {
    private int pmg_class_index;
    private int pmg_index;

    PMGClass(int name_index, int length, DataInput file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), constant_pool);
    }

    public PMGClass(int name_index, int length, int pmg_index, int pmg_class_index, ConstantPool constant_pool) {
        super((byte)9, name_index, length, constant_pool);
        this.pmg_index = pmg_index;
        this.pmg_class_index = pmg_class_index;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.pmg_index);
        file.writeShort(this.pmg_class_index);
    }

    public final String getPMGName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_index, (byte)1);
        return c.getBytes();
    }

    public final String getPMGClassName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_class_index, (byte)1);
        return c.getBytes();
    }

    @Override
    public final String toString() {
        return "PMGClass(" + this.getPMGName() + ", " + this.getPMGClassName() + ")";
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        return (PMGClass)this.clone();
    }
}

