/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;

public final class Signature
extends Attribute {
    private int signature_index;

    Signature(int name_index, int length, DataInput file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), constant_pool);
    }

    public Signature(int name_index, int length, int signature_index, ConstantPool constant_pool) {
        super((byte)10, name_index, length, constant_pool);
        this.signature_index = signature_index;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.signature_index);
    }

    public final String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    @Override
    public final String toString() {
        String s = this.getSignature();
        return "Signature(" + s + ")";
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        return (Signature)this.clone();
    }
}

