/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.catalina.Globals;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class JIoEndpoint
extends AbstractEndpoint {
    private static final Log log = LogFactory.getLog(JIoEndpoint.class);
    protected ServerSocket serverSocket = null;
    protected int acceptorThreadCount = 0;
    protected Handler handler = null;
    protected ServerSocketFactory serverSocketFactory = null;
    protected ConcurrentLinkedQueue<SocketWrapper<Socket>> waitingRequests = new ConcurrentLinkedQueue();

    @Override
    public boolean setProperty(String name, String value) {
        String socketName = "socket.";
        try {
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty(this.socketProperties, name.substring("socket.".length()), value);
            }
            return super.setProperty(name, value);
        }
        catch (Exception x) {
            log.error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.isSSLEnabled()) {
            this.serverSocketFactory.setAttribute("algorithm", this.getAlgorithm());
            this.serverSocketFactory.setAttribute("clientAuth", this.getClientAuth());
            this.serverSocketFactory.setAttribute("keystoreFile", this.getKeystoreFile());
            this.serverSocketFactory.setAttribute("keystorePass", this.getKeystorePass());
            this.serverSocketFactory.setAttribute("keystoreType", this.getKeystoreType());
            this.serverSocketFactory.setAttribute("keystoreProvider", this.getKeystoreProvider());
            this.serverSocketFactory.setAttribute("sslProtocol", this.getSslProtocol());
            this.serverSocketFactory.setAttribute("ciphers", this.getCiphers());
            this.serverSocketFactory.setAttribute("keyAlias", this.getKeyAlias());
            this.serverSocketFactory.setAttribute("keyPass", this.getKeyPass());
            this.serverSocketFactory.setAttribute("truststoreFile", this.getTruststoreFile());
            this.serverSocketFactory.setAttribute("truststorePass", this.getTruststorePass());
            this.serverSocketFactory.setAttribute("truststoreType", this.getTruststoreType());
            this.serverSocketFactory.setAttribute("truststoreProvider", this.getTruststoreProvider());
            this.serverSocketFactory.setAttribute("truststoreAlgorithm", this.getTruststoreAlgorithm());
            this.serverSocketFactory.setAttribute("crlFile", this.getCrlFile());
            this.serverSocketFactory.setAttribute("trustMaxCertLength", this.getTrustMaxCertLength());
            this.serverSocketFactory.setAttribute("sessionCacheSize", this.getSessionCacheSize());
            this.serverSocketFactory.setAttribute("sessionTimeout", this.getSessionTimeout());
            this.serverSocketFactory.setAttribute("allowUnsafeLegacyRenegotiation", this.getAllowUnsafeLegacyRenegotiation());
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.getAddress() == null ? this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog()) : this.serverSocketFactory.createSocket(this.getPort(), this.getBacklog(), this.getAddress());
            }
            catch (BindException orig) {
                String msg = this.getAddress() == null ? orig.getMessage() + " <null>:" + this.getPort() : orig.getMessage() + " " + this.getAddress().toString() + ":" + this.getPort();
                BindException be = new BindException(msg);
                be.initCause(orig);
                throw be;
            }
        }
        this.initialized = true;
    }

    @Override
    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            for (int i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.getDaemon());
                acceptorThread.start();
            }
        }
    }

    @Override
    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    @Override
    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
        this.shutdownExecutor();
    }

    @Override
    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("endpoint.err.close"), (Throwable)e);
            }
            this.serverSocket = null;
        }
        this.initialized = false;
    }

    protected boolean setSocketOptions(Socket socket) {
        try {
            this.socketProperties.setProperties(socket);
        }
        catch (SocketException s) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.err.unexpected"), (Throwable)s);
            }
            return false;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.err.unexpected"), t);
            return false;
        }
        try {
            this.serverSocketFactory.handshake(socket);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.err.handshake"), t);
            }
            return false;
        }
        return true;
    }

    protected boolean processSocket(Socket socket) {
        try {
            SocketWrapper<Socket> wrapper = new SocketWrapper<Socket>(socket);
            wrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            this.getExecutor().execute(new SocketProcessor(wrapper));
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSocket(SocketWrapper<Socket> socket, SocketStatus status) {
        block9: {
            try {
                PrivilegedSetTccl pa;
                if (status != SocketStatus.OPEN && status != SocketStatus.STOP && status != SocketStatus.TIMEOUT || !this.waitingRequests.remove(socket)) break block9;
                SocketProcessor proc = new SocketProcessor(socket, status);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    if (Globals.IS_SECURITY_ENABLED) {
                        pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    }
                    this.getExecutor().execute(proc);
                }
                finally {
                    if (Globals.IS_SECURITY_ENABLED) {
                        pa = new PrivilegedSetTccl(loader);
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("endpoint.process.fail"), t);
                return false;
            }
        }
        return true;
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected SocketWrapper<Socket> socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Socket> socket) {
            if (socket == null) {
                throw new NullPointerException();
            }
            this.socket = socket;
        }

        public SocketProcessor(SocketWrapper<Socket> socket, SocketStatus status) {
            this(socket);
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean launch = false;
            try {
                if (!this.socket.processing.compareAndSet(false, true)) {
                    log.error((Object)"Unable to process socket. Invalid state.");
                    return;
                }
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                if (!this.socket.isInitialized() && !JIoEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                    state = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                this.socket.setInitialized(true);
                if (state != AbstractEndpoint.Handler.SocketState.CLOSED) {
                    AbstractEndpoint.Handler.SocketState socketState = state = this.status == null ? JIoEndpoint.this.handler.process(this.socket) : JIoEndpoint.this.handler.process(this.socket, this.status);
                }
                if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Closing socket:" + this.socket));
                    }
                    try {
                        this.socket.getSocket().close();
                    }
                    catch (IOException iOException) {}
                } else if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                    this.socket.setKeptAlive(true);
                    this.socket.access();
                    launch = true;
                } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.socket.access();
                    JIoEndpoint.this.waitingRequests.add(this.socket);
                }
            }
            finally {
                this.socket.processing.set(false);
                if (launch) {
                    JIoEndpoint.this.getExecutor().execute(new SocketProcessor(this.socket));
                }
                this.socket = null;
            }
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    Socket socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    JIoEndpoint.this.serverSocketFactory.initSocket(socket);
                    if (JIoEndpoint.this.processSocket(socket)) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException x) {
                    if (!JIoEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)x);
                }
                catch (Throwable t) {
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapper<Socket> socket : JIoEndpoint.this.waitingRequests) {
                    long access = socket.getLastAccess();
                    if (now - access <= socket.getTimeout()) continue;
                    JIoEndpoint.this.processSocket(socket, SocketStatus.TIMEOUT);
                }
                while (JIoEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public static interface Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> var1);

        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> var1, SocketStatus var2);
    }
}

