/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.concurrent.atomic.AtomicBoolean;

public class SocketWrapper<E> {
    protected volatile E socket;
    protected volatile long lastAccess = -1L;
    protected volatile boolean currentAccess = false;
    protected long timeout = -1L;
    protected boolean error = false;
    protected long lastRegistered = 0L;
    protected volatile int keepAliveLeft = 100;
    protected boolean async = false;
    protected boolean keptAlive = false;
    protected boolean initialized = false;
    public AtomicBoolean processing = new AtomicBoolean(false);

    public SocketWrapper(E socket) {
        this.socket = socket;
    }

    public E getSocket() {
        return this.socket;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void access() {
        this.access(System.currentTimeMillis());
    }

    public void access(long access) {
        this.lastAccess = access;
    }

    public boolean getCurrentAccess() {
        return this.currentAccess;
    }

    public void setCurrentAccess(boolean access) {
        this.currentAccess = access;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public int getKeepAliveLeft() {
        return this.keepAliveLeft;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean keptAlive) {
        this.keptAlive = keptAlive;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

