/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskQueue
extends LinkedBlockingQueue<Runnable> {
    private ThreadPoolExecutor parent = null;

    public TaskQueue() {
    }

    public TaskQueue(int capacity) {
        super(capacity);
    }

    public TaskQueue(Collection<? extends Runnable> c) {
        super(c);
    }

    public void setParent(ThreadPoolExecutor tp) {
        this.parent = tp;
    }

    public boolean force(Runnable o) {
        if (this.parent.isShutdown()) {
            throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
        }
        return super.offer(o);
    }

    public boolean force(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.parent.isShutdown()) {
            throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
        }
        return super.offer(o, timeout, unit);
    }

    @Override
    public boolean offer(Runnable o) {
        if (this.parent == null) {
            return super.offer(o);
        }
        if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
            return super.offer(o);
        }
        if (this.parent.getActiveCount() < this.parent.getPoolSize()) {
            return super.offer(o);
        }
        if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(o);
    }
}

