/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Integers;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIntegerAssert<SELF extends AbstractIntegerAssert<SELF>>
extends AbstractComparableAssert<SELF, Integer>
implements NumberAssert<SELF, Integer> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    public AbstractIntegerAssert(Integer actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(int expected) {
        this.integers.assertEqual(this.info, (Integer)this.actual, expected);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    public SELF isEqualTo(long expected) {
        if (AbstractIntegerAssert.canBeCastToInt(expected)) {
            this.integers.assertEqual(this.info, (Integer)this.actual, (int)expected);
        } else {
            this.integers.assertEqual(this.info, (Number)this.actual, expected);
        }
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    private static boolean canBeCastToInt(long expected) {
        return expected <= Integer.MAX_VALUE && expected >= Integer.MIN_VALUE;
    }

    public SELF isNotEqualTo(int other) {
        this.integers.assertNotEqual(this.info, (Integer)this.actual, other);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        this.integers.assertIsZero(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.integers.assertIsNotZero(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.integers.assertIsOne(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.integers.assertIsPositive(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.integers.assertIsNegative(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.integers.assertIsNotNegative(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.integers.assertIsNotPositive(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    public SELF isEven() {
        this.integers.assertIsEven(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    public SELF isOdd() {
        this.integers.assertIsOdd(this.info, (Integer)this.actual);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isLessThan(int other) {
        this.integers.assertLessThan(this.info, (Integer)this.actual, other);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(int other) {
        this.integers.assertLessThanOrEqualTo(this.info, (Integer)this.actual, other);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(int other) {
        this.integers.assertGreaterThan(this.info, (Integer)this.actual, other);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(int other) {
        this.integers.assertGreaterThanOrEqualTo(this.info, (Integer)this.actual, other);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isBetween(Integer start, Integer end) {
        this.integers.assertIsBetween(this.info, (Integer)this.actual, start, end);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Integer start, Integer end) {
        this.integers.assertIsStrictlyBetween(this.info, (Integer)this.actual, start, end);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(int expected, Offset<Integer> offset) {
        this.integers.assertIsCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(int expected, Offset<Integer> offset) {
        this.integers.assertIsNotCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Integer expected, Offset<Integer> offset) {
        this.integers.assertIsCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Integer expected, Offset<Integer> offset) {
        this.integers.assertIsNotCloseTo(this.info, (Integer)this.actual, expected, offset);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Integer expected, Percentage percentage) {
        this.integers.assertIsCloseToPercentage(this.info, (Integer)this.actual, expected, percentage);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Integer expected, Percentage percentage) {
        this.integers.assertIsNotCloseToPercentage(this.info, (Integer)this.actual, expected, percentage);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(int expected, Percentage percentage) {
        this.integers.assertIsCloseToPercentage(this.info, (Integer)this.actual, expected, percentage);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(int expected, Percentage percentage) {
        this.integers.assertIsNotCloseToPercentage(this.info, (Integer)this.actual, expected, percentage);
        return (SELF)((AbstractIntegerAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Integer> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Integer> customComparator, String customComparatorDescription) {
        this.integers = new Integers(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractIntegerAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.integers = Integers.instance();
        return (SELF)((AbstractIntegerAssert)super.usingDefaultComparator());
    }
}

