/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.attoparser.select.IMarkupSelectorItem;
import org.attoparser.select.IMarkupSelectorReferenceResolver;
import org.attoparser.select.MarkupSelectorAndItem;
import org.attoparser.select.MarkupSelectorItem;
import org.attoparser.select.MarkupSelectorOrItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MarkupSelectorItems {
    private static final SelectorRepository NO_REFERENCE_RESOLVER_REPOSITORY = new SelectorRepository();
    private static final ConcurrentHashMap<IMarkupSelectorReferenceResolver, SelectorRepository> REPOSITORIES_BY_REFERENCE_RESOLVER = new ConcurrentHashMap(20);
    private static final String selectorPatternStr = "^(/{1,2})([^/\\s]*?)(\\[(?:.*)\\])?$";
    private static final Pattern selectorPattern = Pattern.compile("^(/{1,2})([^/\\s]*?)(\\[(?:.*)\\])?$");
    private static final String modifiersPatternStr = "^(?:\\[(.*?)\\])(\\[(?:.*)\\])?$";
    private static final Pattern modifiersPattern = Pattern.compile("^(?:\\[(.*?)\\])(\\[(?:.*)\\])?$");

    static List<IMarkupSelectorItem> forSelector(boolean html, String selector, IMarkupSelectorReferenceResolver referenceResolver) {
        ConcurrentHashMap<String, List<IMarkupSelectorItem>> map;
        if (MarkupSelectorItems.isEmptyOrWhitespace(selector)) {
            throw new IllegalArgumentException("Selector cannot be null");
        }
        if (referenceResolver == null) {
            map = NO_REFERENCE_RESOLVER_REPOSITORY.getMap(html);
        } else {
            if (!REPOSITORIES_BY_REFERENCE_RESOLVER.containsKey(referenceResolver) && REPOSITORIES_BY_REFERENCE_RESOLVER.size() < 1000) {
                REPOSITORIES_BY_REFERENCE_RESOLVER.putIfAbsent(referenceResolver, new SelectorRepository());
            }
            map = REPOSITORIES_BY_REFERENCE_RESOLVER.get(referenceResolver).getMap(html);
        }
        List<IMarkupSelectorItem> items = map.get(selector);
        if (items != null) {
            return items;
        }
        items = Collections.unmodifiableList(MarkupSelectorItems.parseSelector(html, selector, referenceResolver));
        if (map.size() < 1000) {
            map.putIfAbsent(selector, items);
        }
        return items;
    }

    static List<IMarkupSelectorItem> parseSelector(boolean html, String selector, IMarkupSelectorReferenceResolver referenceResolver) {
        return MarkupSelectorItems.parseSelector(html, selector, null, null, referenceResolver);
    }

    private static List<IMarkupSelectorItem> parseSelector(boolean html, String selector, MarkupSelectorItem.IAttributeCondition initialAttributeCondition, MarkupSelectorItem.IndexCondition initialIndexCondition, IMarkupSelectorReferenceResolver referenceResolver) {
        String selectorPath;
        String caseSensitiveSelectorPath;
        boolean isNonElementSelector;
        MarkupSelectorItem.AttributeCondition newAttributeCondition;
        boolean anyLevel;
        List<Object> result;
        int firstNonSlash;
        String selectorSpecStr = selector.trim();
        if (!selectorSpecStr.startsWith("/")) {
            selectorSpecStr = "//" + selectorSpecStr;
        }
        int selectorSpecStrLen = selectorSpecStr.length();
        for (firstNonSlash = 0; firstNonSlash < selectorSpecStrLen && selectorSpecStr.charAt(firstNonSlash) == '/'; ++firstNonSlash) {
        }
        if (firstNonSlash >= selectorSpecStrLen) {
            throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": '/' should be followed by further selector specification");
        }
        int selEnd = selectorSpecStr.substring(firstNonSlash).indexOf(47);
        if (selEnd != -1) {
            String tail = selectorSpecStr.substring(firstNonSlash).substring(selEnd);
            selectorSpecStr = selectorSpecStr.substring(0, firstNonSlash + selEnd);
            result = MarkupSelectorItems.parseSelector(html, tail, referenceResolver);
        } else {
            result = new ArrayList(3);
        }
        Matcher matcher = selectorPattern.matcher(selectorSpecStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
        }
        String rootGroup = matcher.group(1);
        String selectorNameGroup = matcher.group(2);
        String modifiersGroup = matcher.group(3);
        if (rootGroup == null) {
            throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
        }
        if ("//".equals(rootGroup)) {
            anyLevel = true;
        } else if ("/".equals(rootGroup)) {
            anyLevel = false;
        } else {
            throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
        }
        if (selectorNameGroup == null) {
            throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
        }
        String path = selectorNameGroup;
        MarkupSelectorItem.IndexCondition index = initialIndexCondition;
        MarkupSelectorItem.IAttributeCondition attributeCondition = initialAttributeCondition;
        int idModifierPos = html ? path.indexOf("#") : -1;
        int classModifierPos = html ? path.indexOf(".") : -1;
        int referenceModifierPos = path.indexOf("%");
        if (idModifierPos != -1) {
            if (classModifierPos != -1 || referenceModifierPos != -1) {
                throw new IllegalArgumentException("More than one modifier (id, class, reference) have been specified at selector expression \"" + selector + "\", which is forbidden.");
            }
            String selectorPathIdModifier = path.substring(idModifierPos + "#".length());
            path = path.substring(0, idModifierPos);
            if (MarkupSelectorItems.isEmptyOrWhitespace(selectorPathIdModifier)) {
                throw new IllegalArgumentException("Empty id modifier in selector expression \"" + selector + "\", which is forbidden.");
            }
            newAttributeCondition = new MarkupSelectorItem.AttributeCondition("id", MarkupSelectorItem.AttributeCondition.Operator.EQUALS, selectorPathIdModifier);
            attributeCondition = attributeCondition == null ? newAttributeCondition : new MarkupSelectorItem.AttributeConditionRelation(MarkupSelectorItem.AttributeConditionRelation.Type.AND, attributeCondition, newAttributeCondition);
        }
        if (classModifierPos != -1) {
            if (idModifierPos != -1 || referenceModifierPos != -1) {
                throw new IllegalArgumentException("More than one modifier (id, class, reference) have been specified at selector expression \"" + selector + "\", which is forbidden.");
            }
            String selectorPathClassModifier = path.substring(classModifierPos + ".".length());
            path = path.substring(0, classModifierPos);
            if (MarkupSelectorItems.isEmptyOrWhitespace(selectorPathClassModifier)) {
                throw new IllegalArgumentException("Empty id modifier in selector expression \"" + selector + "\", which is forbidden.");
            }
            newAttributeCondition = new MarkupSelectorItem.AttributeCondition("class", MarkupSelectorItem.AttributeCondition.Operator.EQUALS, selectorPathClassModifier);
            attributeCondition = attributeCondition == null ? newAttributeCondition : new MarkupSelectorItem.AttributeConditionRelation(MarkupSelectorItem.AttributeConditionRelation.Type.AND, attributeCondition, newAttributeCondition);
        }
        String selectorPathReferenceModifier = null;
        if (referenceModifierPos != -1) {
            if (idModifierPos != -1 || classModifierPos != -1) {
                throw new IllegalArgumentException("More than one modifier (id, class, reference) have been specified at selector expression \"" + selector + "\", which is forbidden.");
            }
            selectorPathReferenceModifier = path.substring(referenceModifierPos + "%".length());
            path = path.substring(0, referenceModifierPos);
            if (MarkupSelectorItems.isEmptyOrWhitespace(selectorPathReferenceModifier)) {
                throw new IllegalArgumentException("Empty id modifier in selector expression \"" + selector + "\", which is forbidden.");
            }
        }
        boolean contentSelector = "content()".equals(path);
        boolean textSelector = "text()".equals(path);
        boolean commentSelector = "comment()".equals(path);
        boolean cdataSectionSelector = "cdata()".equals(path);
        boolean docTypeClauseSelector = "doctype()".equals(path);
        boolean xmlDeclarationSelector = "xmldecl()".equals(path);
        boolean processingInstructionSelector = "procinstr()".equals(path);
        boolean bl = isNonElementSelector = textSelector || commentSelector || cdataSectionSelector || docTypeClauseSelector || xmlDeclarationSelector || processingInstructionSelector;
        String string = isNonElementSelector ? null : (caseSensitiveSelectorPath = MarkupSelectorItems.isEmptyOrWhitespace(path) ? null : path);
        String string2 = caseSensitiveSelectorPath == null ? null : (selectorPath = html ? caseSensitiveSelectorPath.toLowerCase() : caseSensitiveSelectorPath);
        if (modifiersGroup != null) {
            String remainingModifiers = modifiersGroup;
            while (remainingModifiers != null) {
                Matcher modifiersMatcher = modifiersPattern.matcher(remainingModifiers);
                if (!modifiersMatcher.matches()) {
                    throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
                }
                String currentModifier = modifiersMatcher.group(1);
                remainingModifiers = modifiersMatcher.group(2);
                MarkupSelectorItem.IndexCondition newIndex = MarkupSelectorItems.parseIndex(currentModifier);
                if (newIndex != null) {
                    if (remainingModifiers != null) {
                        throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: ((/|//)?selector)?([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
                    }
                    if (index != null) {
                        throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": cannot combine two different index modifiers (probably one was specified in the expression itself, and the other one comes from a reference resolver).");
                    }
                    index = newIndex;
                    continue;
                }
                MarkupSelectorItem.IAttributeCondition newAttributeCondition2 = MarkupSelectorItems.parseAttributeCondition(html, selector, currentModifier);
                if (newAttributeCondition2 == null) {
                    throw new IllegalArgumentException("Invalid syntax in selector \"" + selector + "\": selector does not match selector syntax: (/|//)(selector)([@attrib=\"value\" ((and|or) @attrib2=\"value\")?])?([index])?");
                }
                if (attributeCondition == null) {
                    attributeCondition = newAttributeCondition2;
                    continue;
                }
                attributeCondition = new MarkupSelectorItem.AttributeConditionRelation(MarkupSelectorItem.AttributeConditionRelation.Type.AND, attributeCondition, newAttributeCondition2);
            }
        }
        IMarkupSelectorItem thisItem = new MarkupSelectorItem(html, anyLevel, contentSelector, textSelector, commentSelector, cdataSectionSelector, docTypeClauseSelector, xmlDeclarationSelector, processingInstructionSelector, selectorPath, index, attributeCondition);
        if (referenceResolver != null && (selectorPathReferenceModifier != null || selectorPath != null)) {
            List<IMarkupSelectorItem> parsedReference;
            String resolvedSelector;
            if (selectorPathReferenceModifier != null) {
                resolvedSelector = referenceResolver.resolveSelectorFromReference(selectorPathReferenceModifier);
                if (resolvedSelector != null) {
                    if (resolvedSelector.startsWith("//")) {
                        if (!anyLevel) {
                            resolvedSelector = resolvedSelector.substring(1);
                        }
                    } else if (resolvedSelector.startsWith("/")) {
                        if (anyLevel) {
                            resolvedSelector = "/" + resolvedSelector;
                        }
                    } else if (!anyLevel) {
                        resolvedSelector = "/" + resolvedSelector;
                    }
                    if ((parsedReference = MarkupSelectorItems.parseSelector(html, resolvedSelector, null)) != null && parsedReference.size() > 1) {
                        throw new IllegalArgumentException("Invalid selector resolved by reference resolver of class " + referenceResolver.getClass().getName() + "  for selector " + selectorPath + ": resolved selector has more than one level, which is forbidden.");
                    }
                    if (parsedReference != null && parsedReference.size() == 1) {
                        thisItem = new MarkupSelectorAndItem(thisItem, parsedReference.get(0));
                    }
                }
            } else {
                resolvedSelector = referenceResolver.resolveSelectorFromReference(caseSensitiveSelectorPath);
                if (resolvedSelector != null) {
                    if (resolvedSelector.startsWith("//")) {
                        if (!anyLevel) {
                            resolvedSelector = resolvedSelector.substring(1);
                        }
                    } else if (resolvedSelector.startsWith("/")) {
                        if (anyLevel) {
                            resolvedSelector = "/" + resolvedSelector;
                        }
                    } else if (!anyLevel) {
                        resolvedSelector = "/" + resolvedSelector;
                    }
                    if ((parsedReference = MarkupSelectorItems.parseSelector(html, resolvedSelector, attributeCondition, index, null)) != null && parsedReference.size() > 1) {
                        throw new IllegalArgumentException("Invalid selector resolved by reference resolver of class " + referenceResolver.getClass().getName() + "  for selector " + selectorPath + ": resolved selector has more than one level, which is forbidden.");
                    }
                    if (parsedReference != null && parsedReference.size() == 1) {
                        thisItem = new MarkupSelectorOrItem(thisItem, parsedReference.get(0));
                    }
                }
            }
        }
        result.add(0, thisItem);
        return result;
    }

    private static MarkupSelectorItem.IndexCondition parseIndex(String indexGroup) {
        if ("odd()".equals(indexGroup.toLowerCase())) {
            return MarkupSelectorItem.IndexCondition.INDEX_CONDITION_ODD;
        }
        if ("even()".equals(indexGroup.toLowerCase())) {
            return MarkupSelectorItem.IndexCondition.INDEX_CONDITION_EVEN;
        }
        if (indexGroup.charAt(0) == '>') {
            try {
                return new MarkupSelectorItem.IndexCondition(MarkupSelectorItem.IndexCondition.IndexConditionType.MORE_THAN, Integer.valueOf(indexGroup.substring(1).trim()));
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (indexGroup.charAt(0) == '<') {
            try {
                return new MarkupSelectorItem.IndexCondition(MarkupSelectorItem.IndexCondition.IndexConditionType.LESS_THAN, Integer.valueOf(indexGroup.substring(1).trim()));
            }
            catch (Exception ignored) {
                return null;
            }
        }
        try {
            return new MarkupSelectorItem.IndexCondition(MarkupSelectorItem.IndexCondition.IndexConditionType.VALUE, Integer.valueOf(indexGroup.trim()));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static MarkupSelectorItem.IAttributeCondition parseAttributeCondition(boolean html, String selectorSpec, String attrGroup) {
        String text = attrGroup.trim();
        if (text.startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        int textLen = text.length();
        if (MarkupSelectorItems.isEmptyOrWhitespace(text)) {
            throw new IllegalArgumentException("Invalid syntax in selector: \"" + selectorSpec + "\"");
        }
        boolean inDoubleLiteral = false;
        boolean inSimpleLiteral = false;
        int nestingLevel = 0;
        int i = 0;
        while (i < textLen) {
            char c = text.charAt(i);
            if (c == '\'' && !inDoubleLiteral) {
                inSimpleLiteral = !inSimpleLiteral;
                ++i;
                continue;
            }
            if (c == '\"' && !inSimpleLiteral) {
                inDoubleLiteral = !inDoubleLiteral;
                ++i;
                continue;
            }
            if (!inSimpleLiteral && !inDoubleLiteral) {
                if (c == '(') {
                    ++nestingLevel;
                    continue;
                }
                if (c == ')') {
                    --nestingLevel;
                    continue;
                }
                if (!(nestingLevel != 0 || i + 4 >= textLen || !Character.isWhitespace(c) || text.charAt(i + 1) != 'a' && text.charAt(i + 1) != 'A' || text.charAt(i + 2) != 'n' && text.charAt(i + 2) != 'N' || text.charAt(i + 3) != 'd' && text.charAt(i + 3) != 'D' || !Character.isWhitespace(text.charAt(i + 4)))) {
                    MarkupSelectorItem.IAttributeCondition left = MarkupSelectorItems.parseAttributeCondition(html, selectorSpec, text.substring(0, i));
                    MarkupSelectorItem.IAttributeCondition right = MarkupSelectorItems.parseAttributeCondition(html, selectorSpec, text.substring(i + 5, textLen));
                    return new MarkupSelectorItem.AttributeConditionRelation(MarkupSelectorItem.AttributeConditionRelation.Type.AND, left, right);
                }
                if (nestingLevel == 0 && i + 3 < textLen && Character.isWhitespace(c) && (text.charAt(i + 1) == 'o' || text.charAt(i + 1) == 'O') && (text.charAt(i + 2) == 'r' || text.charAt(i + 2) == 'R') && Character.isWhitespace(text.charAt(i + 3))) {
                    MarkupSelectorItem.IAttributeCondition left = MarkupSelectorItems.parseAttributeCondition(html, selectorSpec, text.substring(0, i));
                    MarkupSelectorItem.IAttributeCondition right = MarkupSelectorItems.parseAttributeCondition(html, selectorSpec, text.substring(i + 4, textLen));
                    return new MarkupSelectorItem.AttributeConditionRelation(MarkupSelectorItem.AttributeConditionRelation.Type.OR, left, right);
                }
            }
            ++i;
        }
        return MarkupSelectorItems.parseSimpleAttributeCondition(html, selectorSpec, text);
    }

    private static MarkupSelectorItem.AttributeCondition parseSimpleAttributeCondition(boolean html, String selectorSpec, String attributeSpec) {
        String[] fragments = MarkupSelectorItems.tokenizeAttributeSpec(attributeSpec);
        String attrName = fragments[0];
        if (attrName.startsWith("@")) {
            attrName = attrName.substring(1);
        }
        attrName = html ? attrName.toLowerCase() : attrName;
        MarkupSelectorItem.AttributeCondition.Operator operator = MarkupSelectorItems.parseAttributeOperator(fragments[1]);
        String attrValue = fragments[2];
        if (attrValue != null) {
            if (!(attrValue.startsWith("\"") && attrValue.endsWith("\"") || attrValue.startsWith("'") && attrValue.endsWith("'"))) {
                throw new IllegalArgumentException("Invalid syntax in selector: \"" + selectorSpec + "\"");
            }
            return new MarkupSelectorItem.AttributeCondition(attrName, operator, attrValue.substring(1, attrValue.length() - 1));
        }
        return new MarkupSelectorItem.AttributeCondition(attrName, operator, null);
    }

    private static String[] tokenizeAttributeSpec(String specification) {
        int equalsPos = specification.indexOf(61);
        if (equalsPos == -1) {
            if (specification.charAt(0) == '!') {
                return new String[]{specification.substring(1).trim(), "!", null};
            }
            return new String[]{specification.trim(), "", null};
        }
        char cprev = specification.charAt(equalsPos - 1);
        switch (cprev) {
            case '!': {
                return new String[]{specification.substring(0, equalsPos - 1).trim(), "!=", specification.substring(equalsPos + 1).trim()};
            }
            case '^': {
                return new String[]{specification.substring(0, equalsPos - 1).trim(), "^=", specification.substring(equalsPos + 1).trim()};
            }
            case '$': {
                return new String[]{specification.substring(0, equalsPos - 1).trim(), "$=", specification.substring(equalsPos + 1).trim()};
            }
            case '*': {
                return new String[]{specification.substring(0, equalsPos - 1).trim(), "*=", specification.substring(equalsPos + 1).trim()};
            }
        }
        return new String[]{specification.substring(0, equalsPos).trim(), "=", specification.substring(equalsPos + 1).trim()};
    }

    private static MarkupSelectorItem.AttributeCondition.Operator parseAttributeOperator(String operatorStr) {
        if (operatorStr == null) {
            return null;
        }
        if ("=".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.EQUALS;
        }
        if ("!=".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.NOT_EQUALS;
        }
        if ("^=".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.STARTS_WITH;
        }
        if ("$=".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.ENDS_WITH;
        }
        if ("*=".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.CONTAINS;
        }
        if ("!".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.NOT_EXISTS;
        }
        if ("".equals(operatorStr)) {
            return MarkupSelectorItem.AttributeCondition.Operator.EXISTS;
        }
        return null;
    }

    private static boolean isEmptyOrWhitespace(String target) {
        if (target == null) {
            return true;
        }
        int targetLen = target.length();
        if (targetLen == 0) {
            return true;
        }
        char c0 = target.charAt(0);
        if (c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') {
            return false;
        }
        for (int i = 0; i < targetLen; ++i) {
            char c = target.charAt(i);
            if (c == ' ' || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private MarkupSelectorItems() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SelectorRepository {
        private static final int SELECTOR_ITEMS_MAX_SIZE = 1000;
        private final ConcurrentHashMap<String, List<IMarkupSelectorItem>> CASE_INSENSITIVE_SELECTOR_ITEMS = new ConcurrentHashMap(20);
        private final ConcurrentHashMap<String, List<IMarkupSelectorItem>> CASE_SENSITIVE_SELECTOR_ITEMS = new ConcurrentHashMap(20);

        SelectorRepository() {
        }

        ConcurrentHashMap<String, List<IMarkupSelectorItem>> getMap(boolean html) {
            return html ? this.CASE_INSENSITIVE_SELECTOR_ITEMS : this.CASE_SENSITIVE_SELECTOR_ITEMS;
        }
    }
}

