/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.bytedeco.javacpp.indexer.IntIndexer;

public class IntBufferIndexer
extends IntIndexer {
    protected IntBuffer buffer;

    public IntBufferIndexer(IntBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public int get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public IntIndexer get(int i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public IntIndexer get(int i, int j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public int get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public IntIndexer get(int[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int n) {
        this.buffer.put(i, n);
        return this;
    }

    @Override
    public IntIndexer put(int i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, m[offset + n]);
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int n) {
        this.buffer.put(i * this.strides[0] + j, n);
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, m[offset + n]);
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int k, int n) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, n);
        return this;
    }

    @Override
    public IntIndexer put(int[] indices, int n) {
        this.buffer.put(this.index(indices), n);
        return this;
    }

    @Override
    public IntIndexer put(int[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, m[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

