/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Logger;

public class DefaultScriptSessionManager
implements ScriptSessionManager {
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected PageNormalizer pageNormalizer;
    protected volatile long scriptSessionTimeout = 300000L;
    protected volatile long scriptSessionCheckTime = 30000L;
    protected volatile long lastSessionCheckAt = System.currentTimeMillis();
    protected Map sessionMap = Collections.synchronizedMap(new HashMap());
    protected Map pageSessionMap = Collections.synchronizedMap(new HashMap());
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultScriptSessionManager == null ? (class$org$directwebremoting$impl$DefaultScriptSessionManager = DefaultScriptSessionManager.class$("org.directwebremoting.impl.DefaultScriptSessionManager")) : class$org$directwebremoting$impl$DefaultScriptSessionManager);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealScriptSession getScriptSession(String id) {
        this.maybeCheckTimeouts();
        DefaultScriptSession scriptSession = (DefaultScriptSession)this.sessionMap.get(id);
        if (scriptSession == null) {
            scriptSession = new DefaultScriptSession(id, this);
            Map map = this.sessionMap;
            synchronized (map) {
                this.sessionMap.put(id, scriptSession);
            }
        } else {
            scriptSession.updateLastAccessedTime();
        }
        return scriptSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageForScriptSession(RealScriptSession scriptSession, String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Map map = this.pageSessionMap;
        synchronized (map) {
            HashSet<RealScriptSession> pageSessions = (HashSet<RealScriptSession>)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet<RealScriptSession>();
                this.pageSessionMap.put(normalizedPage, pageSessions);
            }
            pageSessions.add(scriptSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getScriptSessionsByPage(String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Map map = this.pageSessionMap;
        synchronized (map) {
            HashSet pageSessions = (HashSet)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet();
            }
            HashSet reply = new HashSet();
            reply.addAll(pageSessions);
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllScriptSessions() {
        Map map = this.sessionMap;
        synchronized (map) {
            HashSet reply = new HashSet();
            reply.addAll(this.sessionMap.values());
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(RealScriptSession scriptSession) {
        RealScriptSession removed = (RealScriptSession)this.sessionMap.remove(scriptSession.getId());
        if (!scriptSession.equals(removed)) {
            log.debug("ScriptSession already removed from manager. scriptSession=" + scriptSession + " removed=" + removed);
        }
        int removeCount = 0;
        Map map = this.pageSessionMap;
        synchronized (map) {
            Iterator it = this.pageSessionMap.values().iterator();
            while (it.hasNext()) {
                Set pageSessions = (Set)it.next();
                boolean isRemoved = pageSessions.remove(scriptSession);
                if (!isRemoved) continue;
                ++removeCount;
            }
        }
        if (removeCount != 1) {
            log.debug("DefaultScriptSessionManager.invalidate(): removeCount=" + removeCount + " when invalidating: " + scriptSession);
        }
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        Map map = this.sessionMap;
        synchronized (map) {
            Iterator it = this.sessionMap.values().iterator();
            while (it.hasNext()) {
                long age;
                DefaultScriptSession session = (DefaultScriptSession)it.next();
                if (session.isInvalidated() || (age = now - session.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
                timeouts.add(session);
            }
        }
        Iterator it = timeouts.iterator();
        while (it.hasNext()) {
            DefaultScriptSession session = (DefaultScriptSession)it.next();
            session.invalidate();
        }
    }

    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long timeout) {
        this.scriptSessionTimeout = timeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

