/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.testng.listener;

import java.io.File;
import org.fest.util.FilesException;
import org.fest.util.Strings;
import org.testng.ITestContext;

class OutputDirectory {
    private final String path;

    OutputDirectory(ITestContext context) {
        this.path = context.getOutputDirectory();
    }

    boolean hasPath() {
        return !Strings.isEmpty((String)this.path);
    }

    String path() {
        return this.path;
    }

    void createIfNecessary() {
        File f = new File(this.path);
        if (f.isDirectory()) {
            return;
        }
        if (f.mkdirs()) {
            return;
        }
        throw new FilesException(Strings.concat((Object[])new Object[]{"Unable to create output directory ", this.path}));
    }
}

