/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Configuration;
import org.ehcache.core.EhcacheManager;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.jsr107.ConfigurationMerger;
import org.ehcache.jsr107.DefaultConfigurationResolver;
import org.ehcache.jsr107.DefaultJsr107SerializationProvider;
import org.ehcache.jsr107.Eh107CacheLoaderWriterProvider;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.config.Jsr107Configuration;
import org.ehcache.jsr107.internal.DefaultJsr107Service;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.XmlConfiguration;

public class EhcacheCachingProvider
implements CachingProvider {
    private static final String DEFAULT_URI_STRING = "urn:X-ehcache:jsr107-default-config";
    private static final URI URI_DEFAULT;
    private final Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>>();

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI override;
        uri = uri == null ? this.getDefaultURI() : uri;
        classLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties properties2 = properties = properties == null ? new Properties() : EhcacheCachingProvider.cloneProperties(properties);
        if (URI_DEFAULT.equals(uri) && (override = DefaultConfigurationResolver.resolveConfigURI(properties)) != null) {
            uri = override;
        }
        return this.getCacheManager(new ConfigSupplier(uri, classLoader), properties);
    }

    public CacheManager getCacheManager(URI uri, Configuration config) {
        return this.getCacheManager(new ConfigSupplier(uri, config), new Properties());
    }

    public CacheManager getCacheManager(URI uri, Configuration config, Properties properties) {
        return this.getCacheManager(new ConfigSupplier(uri, config), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Eh107CacheManager getCacheManager(ConfigSupplier configSupplier, Properties properties) {
        Eh107CacheManager cacheManager;
        ClassLoader classLoader = configSupplier.getClassLoader();
        URI uri = configSupplier.getUri();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> byURI = this.cacheManagers.get(classLoader);
            if (byURI == null) {
                byURI = new ConcurrentHashMap<URI, Eh107CacheManager>();
                this.cacheManagers.put(classLoader, byURI);
            }
            if ((cacheManager = (Eh107CacheManager)byURI.get(uri)) == null || cacheManager.isClosed()) {
                if (cacheManager != null) {
                    byURI.remove(uri, cacheManager);
                }
                cacheManager = this.createCacheManager(uri, configSupplier.getConfiguration(), properties);
                byURI.put(uri, cacheManager);
            }
        }
        return cacheManager;
    }

    private Eh107CacheManager createCacheManager(URI uri, Configuration config, Properties properties) {
        Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory = new Eh107CacheLoaderWriterProvider();
        DefaultJsr107Service jsr107Service = new DefaultJsr107Service(ServiceUtils.findSingletonAmongst(Jsr107Configuration.class, config.getServiceCreationConfigurations().toArray()));
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(cacheLoaderWriterFactory);
        services.add(jsr107Service);
        if (ServiceUtils.findSingletonAmongst(DefaultSerializationProviderConfiguration.class, config.getServiceCreationConfigurations().toArray()) == null) {
            services.add(new DefaultJsr107SerializationProvider());
        }
        EhcacheManager ehcacheManager = new EhcacheManager(config, services, !jsr107Service.jsr107CompliantAtomics());
        ehcacheManager.init();
        return new Eh107CacheManager(this, ehcacheManager, properties, config.getClassLoader(), uri, new ConfigurationMerger(config, jsr107Service, cacheLoaderWriterFactory));
    }

    public ClassLoader getDefaultClassLoader() {
        return ClassLoading.getDefaultClassLoader();
    }

    public URI getDefaultURI() {
        return URI_DEFAULT;
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> entry : this.cacheManagers.entrySet()) {
                for (Eh107CacheManager cacheManager : entry.getValue().values()) {
                    cacheManager.close();
                }
            }
            this.cacheManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.remove(classLoader);
            if (map2 != null) {
                for (Eh107CacheManager cacheManager : map2.values()) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        if (uri == null || classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Eh107CacheManager cacheManager;
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 != null && (cacheManager = (Eh107CacheManager)map2.remove(uri)) != null) {
                cacheManager.closeInternal(closeException);
            }
        }
        closeException.throwIfNotEmpty();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        if (optionalFeature == null) {
            throw new NullPointerException();
        }
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown OptionalFeature: " + optionalFeature.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Eh107CacheManager cacheManager, MultiCacheException closeException) {
        try {
            Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(cacheManager.getClassLoader());
                if (map2 != null && map2.remove(cacheManager.getURI()) != null) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    private static Properties cloneProperties(Properties properties) {
        Properties clone = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    static {
        try {
            URI_DEFAULT = new URI(DEFAULT_URI_STRING);
        }
        catch (URISyntaxException e) {
            throw new CacheException((Throwable)e);
        }
    }

    static class ConfigSupplier {
        private final URI uri;
        private final ClassLoader classLoader;
        private Configuration configuration;

        public ConfigSupplier(URI uri, ClassLoader classLoader) {
            this.uri = uri;
            this.classLoader = classLoader;
            this.configuration = null;
        }

        public ConfigSupplier(URI uri, Configuration configuration) {
            this.uri = uri;
            this.classLoader = configuration.getClassLoader();
            this.configuration = configuration;
        }

        public URI getUri() {
            return this.uri;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Configuration getConfiguration() {
            if (this.configuration == null) {
                try {
                    this.configuration = URI_DEFAULT.equals(this.uri) ? new DefaultConfiguration(this.classLoader, new ServiceCreationConfiguration[0]) : new XmlConfiguration(this.uri.toURL(), this.classLoader);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
            return this.configuration;
        }
    }
}

