/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.exists.indices;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesExistsAction
extends TransportMasterNodeReadOperationAction<IndicesExistsRequest, IndicesExistsResponse> {
    @Inject
    public TransportIndicesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "indices:admin/exists", transportService, clusterService, threadPool, actionFilters);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesExistsRequest newRequest() {
        return new IndicesExistsRequest(new String[0]);
    }

    @Override
    protected IndicesExistsResponse newResponse() {
        return new IndicesExistsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesExistsRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.clusterService.state().metaData().concreteIndices(indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(IndicesExistsRequest request, ClusterState state, ActionListener<IndicesExistsResponse> listener) throws ElasticsearchException {
        boolean exists;
        try {
            this.clusterService.state().metaData().concreteIndices(request.indicesOptions(), request.indices());
            exists = true;
        }
        catch (IndexMissingException e) {
            exists = false;
        }
        listener.onResponse(new IndicesExistsResponse(exists));
    }
}

