/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.log4j;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;

public class LogConfigurator {
    static final List<String> ALLOWED_SUFFIXES = ImmutableList.of(".yml", ".yaml", ".json", ".properties");
    private static boolean loaded;
    private static ImmutableMap<String, String> replacements;

    public static void configure(Settings settings) {
        if (loaded) {
            return;
        }
        loaded = true;
        Environment environment = new Environment(settings);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(settings);
        LogConfigurator.resolveConfig(environment, settingsBuilder);
        settingsBuilder.putProperties("elasticsearch.", System.getProperties()).putProperties("es.", System.getProperties()).replacePropertyPlaceholders();
        Properties props = new Properties();
        for (Map.Entry entry : settingsBuilder.build().getAsMap().entrySet()) {
            String key = "log4j." + (String)entry.getKey();
            String value = (String)entry.getValue();
            if (replacements.containsKey(value)) {
                value = replacements.get(value);
            }
            if (key.endsWith(".value")) {
                props.setProperty(key.substring(0, key.length() - ".value".length()), value);
                continue;
            }
            if (key.endsWith(".type")) {
                props.setProperty(key.substring(0, key.length() - ".type".length()), value);
                continue;
            }
            props.setProperty(key, value);
        }
        PropertyConfigurator.configure((Properties)props);
    }

    public static void reset() {
        loaded = false;
    }

    public static void resolveConfig(Environment env, final ImmutableSettings.Builder settingsBuilder) {
        try {
            Files.walkFileTree(env.configFile().toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.startsWith("logging.")) {
                        for (String allowedSuffix : ALLOWED_SUFFIXES) {
                            if (!fileName.endsWith(allowedSuffix)) continue;
                            LogConfigurator.loadConfig(file, settingsBuilder);
                            break;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("Failed to load logging configuration", ioe);
        }
    }

    public static void loadConfig(Path file, ImmutableSettings.Builder settingsBuilder) {
        try {
            settingsBuilder.loadFromUrl(file.toUri().toURL());
        }
        catch (NoClassDefFoundError | MalformedURLException | FailedToResolveConfigException throwable) {
            // empty catch block
        }
    }

    static {
        replacements = new MapBuilder<String, String>().put("console", "org.elasticsearch.common.logging.log4j.ConsoleAppender").put("async", "org.apache.log4j.AsyncAppender").put("dailyRollingFile", "org.apache.log4j.DailyRollingFileAppender").put("externallyRolledFile", "org.apache.log4j.ExternallyRolledFileAppender").put("file", "org.apache.log4j.FileAppender").put("jdbc", "org.apache.log4j.jdbc.JDBCAppender").put("jms", "org.apache.log4j.net.JMSAppender").put("lf5", "org.apache.log4j.lf5.LF5Appender").put("ntevent", "org.apache.log4j.nt.NTEventLogAppender").put("null", "org.apache.log4j.NullAppender").put("rollingFile", "org.apache.log4j.RollingFileAppender").put("extrasRollingFile", "org.apache.log4j.rolling.RollingFileAppender").put("smtp", "org.apache.log4j.net.SMTPAppender").put("socket", "org.apache.log4j.net.SocketAppender").put("socketHub", "org.apache.log4j.net.SocketHubAppender").put("syslog", "org.apache.log4j.net.SyslogAppender").put("telnet", "org.apache.log4j.net.TelnetAppender").put("timeBased", "org.apache.log4j.rolling.TimeBasedRollingPolicy").put("sizeBased", "org.apache.log4j.rolling.SizeBasedTriggeringPolicy").put("simple", "org.apache.log4j.SimpleLayout").put("html", "org.apache.log4j.HTMLLayout").put("pattern", "org.apache.log4j.PatternLayout").put("consolePattern", "org.apache.log4j.PatternLayout").put("enhancedPattern", "org.apache.log4j.EnhancedPatternLayout").put("ttcc", "org.apache.log4j.TTCCLayout").put("xml", "org.apache.log4j.XMLLayout").immutableMap();
    }
}

