/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delegate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemVariableAggregator;
import org.flowable.cmmn.api.delegate.PlanItemVariableAggregatorContext;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.VariableService;

public class JsonPlanItemVariableAggregator
implements PlanItemVariableAggregator {
    protected final CmmnEngineConfiguration cmmnEngineConfiguration;

    public JsonPlanItemVariableAggregator(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public Object aggregateSingleVariable(DelegatePlanItemInstance planItemInstance, PlanItemVariableAggregatorContext context) {
        ObjectNode objectNode = this.cmmnEngineConfiguration.getObjectMapper().createObjectNode();
        VariableService variableService = this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        VariableTypes variableTypes = this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableTypes();
        block32: for (VariableAggregationDefinition.Variable definition : context.getDefinition().getDefinitions()) {
            String varInstanceTypeName;
            String targetVarName = null;
            if (StringUtils.isNotEmpty((CharSequence)definition.getTargetExpression())) {
                Object value = this.cmmnEngineConfiguration.getExpressionManager().createExpression(definition.getTargetExpression()).getValue((VariableContainer)planItemInstance);
                if (value != null) {
                    targetVarName = value.toString();
                }
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getTarget())) {
                targetVarName = definition.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getSource())) {
                targetVarName = definition.getSource();
            }
            if (targetVarName == null) continue;
            VariableInstance varInstance = null;
            if (StringUtils.isNotEmpty((CharSequence)definition.getSource())) {
                varInstance = planItemInstance.getVariableInstance(definition.getSource());
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getSourceExpression())) {
                Object sourceValue = this.cmmnEngineConfiguration.getExpressionManager().createExpression(definition.getSourceExpression()).getValue((VariableContainer)planItemInstance);
                VariableType variableType = variableTypes.findVariableType(sourceValue);
                varInstance = variableService.createVariableInstance(targetVarName, variableType, sourceValue);
            }
            if (varInstance == null) continue;
            switch (varInstanceTypeName = varInstance.getTypeName()) {
                case "string": 
                case "longString": {
                    objectNode.put(targetVarName, (String)varInstance.getValue());
                    continue block32;
                }
                case "json": {
                    objectNode.set(targetVarName, (JsonNode)varInstance.getValue());
                    continue block32;
                }
                case "boolean": {
                    objectNode.put(targetVarName, (Boolean)varInstance.getValue());
                    continue block32;
                }
                case "short": {
                    objectNode.put(targetVarName, (Short)varInstance.getValue());
                    continue block32;
                }
                case "integer": {
                    objectNode.put(targetVarName, (Integer)varInstance.getValue());
                    continue block32;
                }
                case "long": {
                    objectNode.put(targetVarName, (Long)varInstance.getValue());
                    continue block32;
                }
                case "double": {
                    objectNode.put(targetVarName, (Double)varInstance.getValue());
                    continue block32;
                }
                case "date": {
                    objectNode.put(targetVarName, ((Date)varInstance.getValue()).toInstant().toString());
                    continue block32;
                }
                case "null": {
                    objectNode.putNull(targetVarName);
                    continue block32;
                }
                case "instant": 
                case "localdate": 
                case "localdatetime": 
                case "jodadate": 
                case "jodadatetime": 
                case "uuid": {
                    objectNode.put(targetVarName, varInstance.getValue().toString());
                    continue block32;
                }
                case "bytes": {
                    objectNode.put(targetVarName, (byte[])varInstance.getValue());
                    continue block32;
                }
            }
            if ("overview".equals(context.getState())) {
                Object value = varInstance.getValue();
                if (value instanceof JsonNode) {
                    objectNode.set(targetVarName, (JsonNode)value);
                    continue;
                }
                throw new FlowableException("Cannot aggregate overview variable: " + varInstance);
            }
            throw new FlowableException("Cannot aggregate variable: " + varInstance);
        }
        return objectNode;
    }

    public Object aggregateMultiVariables(DelegatePlanItemInstance planItemInstance, List<? extends VariableInstance> instances, PlanItemVariableAggregatorContext context) {
        ObjectMapper objectMapper = this.cmmnEngineConfiguration.getObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (VariableInstance variableInstance : instances) {
            arrayNode.add((JsonNode)variableInstance.getValue());
        }
        return arrayNode;
    }
}

