/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.behavior.SendEventTaskActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncSendEventJobHandler
implements JobHandler {
    public static final String TYPE = "async-send-event";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        FlowElement flowElement = executionEntity.getCurrentFlowElement();
        if (!(flowElement instanceof SendEventServiceTask)) {
            throw new FlowableException(String.format("unexpected activity type found for job %s, at activity %s", job.getId(), flowElement.getId()));
        }
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)flowElement;
        SendEventTaskActivityBehavior sendEventTaskBehavior = CommandContextUtil.getProcessEngineConfiguration(commandContext).getActivityBehaviorFactory().createSendEventTaskBehavior(sendEventServiceTask);
        sendEventTaskBehavior.setExecutedAsAsyncJob(true);
        sendEventTaskBehavior.execute(executionEntity);
    }
}

