/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.repository;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.DeploymentMergeStrategy;
import org.flowable.engine.repository.ProcessDefinition;

public class AddAsNewDeploymentMergeStrategy
implements DeploymentMergeStrategy {
    @Override
    public void prepareMerge(CommandContext commandContext, String deploymentId, String newTenantId) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionEntityManager.updateProcessDefinitionVersionForProcessDefinitionId(processDefinition.getId(), 0);
        }
    }

    @Override
    public void finalizeMerge(CommandContext commandContext, String deploymentId, String newTenantId) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl();
        if (StringUtils.isEmpty((CharSequence)newTenantId)) {
            processDefinitionQuery.processDefinitionWithoutTenantId();
        } else {
            processDefinitionQuery.processDefinitionTenantId(newTenantId);
        }
        Map<String, Integer> latestVersionNumberLookupTable = processDefinitionQuery.latestVersion().list().stream().collect(Collectors.toMap(ProcessDefinition::getKey, ProcessDefinition::getVersion));
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        for (ProcessDefinition processDefinition : processDefinitions) {
            int nextVersionNumber = latestVersionNumberLookupTable.getOrDefault(processDefinition.getKey(), 0) + 1;
            processDefinitionEntityManager.updateProcessDefinitionVersionForProcessDefinitionId(processDefinition.getId(), nextVersionNumber);
        }
    }
}

