/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.impl.ChannelDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityImpl;
import org.flowable.eventregistry.impl.persistence.entity.data.AbstractEventDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.ChannelDefinitionDataManager;

public class MybatisChannelDefinitionDataManager
extends AbstractEventDataManager<ChannelDefinitionEntity>
implements ChannelDefinitionDataManager {
    public MybatisChannelDefinitionDataManager(EventRegistryEngineConfiguration eventRegistryConfiguration) {
        super(eventRegistryConfiguration);
    }

    public Class<? extends ChannelDefinitionEntity> getManagedEntityClass() {
        return ChannelDefinitionEntityImpl.class;
    }

    public ChannelDefinitionEntity create() {
        return new ChannelDefinitionEntityImpl();
    }

    @Override
    public ChannelDefinitionEntity findLatestChannelDefinitionByKey(String channelDefinitionKey) {
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestChannelDefinitionByKey", (Object)channelDefinitionKey);
    }

    @Override
    public ChannelDefinitionEntity findLatestChannelDefinitionByKeyAndTenantId(String channelDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("channelDefinitionKey", channelDefinitionKey);
        params.put("tenantId", tenantId);
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestChannelDefinitionByKeyAndTenantId", params);
    }

    @Override
    public ChannelDefinitionEntity findLatestChannelDefinitionByKeyAndParentDeploymentId(String channelDefinitionKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("channelDefinitionKey", channelDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectChannelDefinitionByKeyAndParentDeploymentId", params);
    }

    @Override
    public ChannelDefinitionEntity findLatestChannelDefinitionByKeyParentDeploymentIdAndTenantId(String channelDefinitionKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("channelDefinitionKey", channelDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectChannelDefinitionByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteChannelDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteChannelDefinitionsByDeploymentId", (Object)deploymentId, this.getManagedEntityClass());
    }

    @Override
    public List<ChannelDefinition> findChannelDefinitionsByQueryCriteria(ChannelDefinitionQueryImpl ChannelDefinitionQuery2) {
        return this.getDbSqlSession().selectList("selectChannelDefinitionsByQueryCriteria", (ListQueryParameterObject)ChannelDefinitionQuery2);
    }

    @Override
    public long findChannelDefinitionCountByQueryCriteria(ChannelDefinitionQueryImpl ChannelDefinitionQuery2) {
        return (Long)this.getDbSqlSession().selectOne("selectChannelDefinitionCountByQueryCriteria", (Object)ChannelDefinitionQuery2);
    }

    @Override
    public ChannelDefinitionEntity findChannelDefinitionByDeploymentAndKey(String deploymentId, String channelDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("channelDefinitionKey", channelDefinitionKey);
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectChannelDefinitionByDeploymentAndKey", parameters);
    }

    @Override
    public ChannelDefinitionEntity findChannelDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String channelDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("channelDefinitionKey", channelDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (ChannelDefinitionEntity)this.getDbSqlSession().selectOne("selectChannelDefinitionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public ChannelDefinitionEntity findChannelDefinitionByKeyAndVersion(String channelDefinitionKey, Integer eventVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("channelDefinitionKey", channelDefinitionKey);
        params.put("eventVersion", eventVersion);
        List results = this.getDbSqlSession().selectList("selectChannelDefinitionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (ChannelDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " event definitions with key = '" + channelDefinitionKey + "' and version = '" + eventVersion + "'.");
        }
        return null;
    }

    @Override
    public ChannelDefinitionEntity findChannelDefinitionByKeyAndVersionAndTenantId(String channelDefinitionKey, Integer eventVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("channelDefinitionKey", channelDefinitionKey);
        params.put("eventVersion", eventVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectChannelDefinitionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (ChannelDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " event definitions with key = '" + channelDefinitionKey + "' and version = '" + eventVersion + "'.");
        }
        return null;
    }

    @Override
    public List<ChannelDefinition> findChannelDefinitionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectChannelDefinitionByNativeQuery", parameterMap);
    }

    @Override
    public long findChannelDefinitionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectChannelDefinitionCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateChannelDefinitionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateChannelDefinitionTenantIdForDeploymentId", params);
    }
}

