
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FetchStyleEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="FetchStyleEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="join"/&gt;
 *     &lt;enumeration value="select"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "FetchStyleEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmFetchStyleEnum {

    @XmlEnumValue("join")
    JOIN("join"),
    @XmlEnumValue("select")
    SELECT("select");
    private final String value;

    JaxbHbmFetchStyleEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmFetchStyleEnum fromValue(String v) {
        for (JaxbHbmFetchStyleEnum c: JaxbHbmFetchStyleEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
