
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for NotFoundEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="NotFoundEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="exception"/&gt;
 *     &lt;enumeration value="ignore"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "NotFoundEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmNotFoundEnum {

    @XmlEnumValue("exception")
    EXCEPTION("exception"),
    @XmlEnumValue("ignore")
    IGNORE("ignore");
    private final String value;

    JaxbHbmNotFoundEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmNotFoundEnum fromValue(String v) {
        for (JaxbHbmNotFoundEnum c: JaxbHbmNotFoundEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
