
package org.hibernate.boot.jaxb.cfg.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CacheUsageEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="CacheUsageEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="nonstrict-read-write"/&gt;
 *     &lt;enumeration value="read-only"/&gt;
 *     &lt;enumeration value="read-write"/&gt;
 *     &lt;enumeration value="transactional"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "CacheUsageEnum", namespace = "http://www.hibernate.org/xsd/orm/cfg")
@XmlEnum
public enum JaxbCfgCacheUsageEnum {

    @XmlEnumValue("nonstrict-read-write")
    NONSTRICT_READ_WRITE("nonstrict-read-write"),
    @XmlEnumValue("read-only")
    READ_ONLY("read-only"),
    @XmlEnumValue("read-write")
    READ_WRITE("read-write"),
    @XmlEnumValue("transactional")
    TRANSACTIONAL("transactional");
    private final String value;

    JaxbCfgCacheUsageEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbCfgCacheUsageEnum fromValue(String v) {
        for (JaxbCfgCacheUsageEnum c: JaxbCfgCacheUsageEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
