
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Describes the key of a java.util.Map where the key is a composite type
 *             
 * 
 * <p>Java class for MapKeyCompositeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="MapKeyCompositeType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice maxOccurs="unbounded"&gt;
 *           &lt;element name="key-property" type="{http://www.hibernate.org/xsd/orm/hbm}CompositeKeyBasicAttributeType"/&gt;
 *           &lt;element name="key-many-to-one" type="{http://www.hibernate.org/xsd/orm/hbm}CompositeKeyManyToOneType"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="class" use="required" type="{http://www.hibernate.org/xsd/orm/hbm}ClassNameType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MapKeyCompositeType", namespace = "http://www.hibernate.org/xsd/orm/hbm", propOrder = {
    "attributes"
})
public class JaxbHbmMapKeyCompositeType
    implements Serializable
{

    @XmlElements({
        @XmlElement(name = "key-property", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmCompositeKeyBasicAttributeType.class),
        @XmlElement(name = "key-many-to-one", namespace = "http://www.hibernate.org/xsd/orm/hbm", type = JaxbHbmCompositeKeyManyToOneType.class)
    })
    protected List<JaxbHbmToolingHintContainer> attributes;
    @XmlAttribute(name = "class", required = true)
    protected String clazz;

    /**
     * Gets the value of the attributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the attributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmCompositeKeyBasicAttributeType }
     * {@link JaxbHbmCompositeKeyManyToOneType }
     * 
     * 
     */
    public List<JaxbHbmToolingHintContainer> getAttributes() {
        if (attributes == null) {
            attributes = new ArrayList<JaxbHbmToolingHintContainer>();
        }
        return this.attributes;
    }

    /**
     * Gets the value of the clazz property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClazz() {
        return clazz;
    }

    /**
     * Sets the value of the clazz property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setClazz(String value) {
        this.clazz = value;
    }

}
