
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OnDeleteEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="OnDeleteEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="cascade"/&gt;
 *     &lt;enumeration value="noaction"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "OnDeleteEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmOnDeleteEnum {

    @XmlEnumValue("cascade")
    CASCADE("cascade"),
    @XmlEnumValue("noaction")
    NOACTION("noaction");
    private final String value;

    JaxbHbmOnDeleteEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmOnDeleteEnum fromValue(String v) {
        for (JaxbHbmOnDeleteEnum c: JaxbHbmOnDeleteEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
