
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for UnsavedValueVersionEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="UnsavedValueVersionEnum"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&gt;
 *     &lt;enumeration value="negative"/&gt;
 *     &lt;enumeration value="null"/&gt;
 *     &lt;enumeration value="undefined"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "UnsavedValueVersionEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmUnsavedValueVersionEnum {

    @XmlEnumValue("negative")
    NEGATIVE("negative"),
    @XmlEnumValue("null")
    NULL("null"),
    @XmlEnumValue("undefined")
    UNDEFINED("undefined");
    private final String value;

    JaxbHbmUnsavedValueVersionEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmUnsavedValueVersionEnum fromValue(String v) {
        for (JaxbHbmUnsavedValueVersionEnum c: JaxbHbmUnsavedValueVersionEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
