
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.graph;

import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.*;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class GraphLanguageLexer extends Lexer {
	static { RuntimeMetaData.checkVersion("4.9.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COLON=2, COMMA=3, DOT=4, LPAREN=5, RPAREN=6, ATTR_NAME=7, TYPE_NAME=8;
	public static final int
		WHITESPACE_CHANNEL=2;
	public static String[] channelNames = {
		"DEFAULT_TOKEN_CHANNEL", "HIDDEN", "WHITESPACE_CHANNEL"
	};

	public static String[] modeNames = {
		"DEFAULT_MODE"
	};

	private static String[] makeRuleNames() {
		return new String[] {
			"WS", "EOL", "COLON", "COMMA", "DOT", "LPAREN", "RPAREN", "ATTR_NAME", 
			"TYPE_NAME", "NON_ALPHANUM_EXTENTION", "ATTR_NAME_START", "TYPE_NAME_START", 
			"NAME_CONTINUATION"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, "':'", "','", "'.'", "'('", "')'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COLON", "COMMA", "DOT", "LPAREN", "RPAREN", "ATTR_NAME", 
			"TYPE_NAME"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}


	/*
	 * Lexer for the Hibernate EntityGraph Language
	 *
	 * It is generated by Antlr via the lexer grammar file `GraphLanguageLexer.g4`
	 */


	public GraphLanguageLexer(CharStream input) {
		super(input);
		_interp = new LexerATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	@Override
	public String getGrammarFileName() { return "GraphLanguageLexer.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public String[] getChannelNames() { return channelNames; }

	@Override
	public String[] getModeNames() { return modeNames; }

	@Override
	public ATN getATN() { return _ATN; }

	public static final String _serializedATN =
		"\3\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964\2\nN\b\1\4\2\t\2\4"+
		"\3\t\3\4\4\t\4\4\5\t\5\4\6\t\6\4\7\t\7\4\b\t\b\4\t\t\t\4\n\t\n\4\13\t"+
		"\13\4\f\t\f\4\r\t\r\4\16\t\16\3\2\3\2\5\2 \n\2\3\2\3\2\3\3\6\3%\n\3\r"+
		"\3\16\3&\3\4\3\4\3\5\3\5\3\6\3\6\3\7\3\7\3\b\3\b\3\t\3\t\7\t\65\n\t\f"+
		"\t\16\t8\13\t\3\n\3\n\7\n<\n\n\f\n\16\n?\13\n\3\13\3\13\3\f\3\f\5\fE\n"+
		"\f\3\r\3\r\5\rI\n\r\3\16\3\16\5\16M\n\16\2\2\17\3\3\5\2\7\4\t\5\13\6\r"+
		"\7\17\b\21\t\23\n\25\2\27\2\31\2\33\2\3\2\6\5\2\13\13\16\16\"\"\4\2\f"+
		"\f\17\17\4\2&&aa\5\2\62;C\\c|\2O\2\3\3\2\2\2\2\7\3\2\2\2\2\t\3\2\2\2\2"+
		"\13\3\2\2\2\2\r\3\2\2\2\2\17\3\2\2\2\2\21\3\2\2\2\2\23\3\2\2\2\3\37\3"+
		"\2\2\2\5$\3\2\2\2\7(\3\2\2\2\t*\3\2\2\2\13,\3\2\2\2\r.\3\2\2\2\17\60\3"+
		"\2\2\2\21\62\3\2\2\2\239\3\2\2\2\25@\3\2\2\2\27D\3\2\2\2\31H\3\2\2\2\33"+
		"L\3\2\2\2\35 \t\2\2\2\36 \5\5\3\2\37\35\3\2\2\2\37\36\3\2\2\2 !\3\2\2"+
		"\2!\"\b\2\2\2\"\4\3\2\2\2#%\t\3\2\2$#\3\2\2\2%&\3\2\2\2&$\3\2\2\2&\'\3"+
		"\2\2\2\'\6\3\2\2\2()\7<\2\2)\b\3\2\2\2*+\7.\2\2+\n\3\2\2\2,-\7\60\2\2"+
		"-\f\3\2\2\2./\7*\2\2/\16\3\2\2\2\60\61\7+\2\2\61\20\3\2\2\2\62\66\5\27"+
		"\f\2\63\65\5\33\16\2\64\63\3\2\2\2\658\3\2\2\2\66\64\3\2\2\2\66\67\3\2"+
		"\2\2\67\22\3\2\2\28\66\3\2\2\29=\5\31\r\2:<\5\33\16\2;:\3\2\2\2<?\3\2"+
		"\2\2=;\3\2\2\2=>\3\2\2\2>\24\3\2\2\2?=\3\2\2\2@A\t\4\2\2A\26\3\2\2\2B"+
		"E\5\25\13\2CE\4c|\2DB\3\2\2\2DC\3\2\2\2E\30\3\2\2\2FI\5\25\13\2GI\4C\\"+
		"\2HF\3\2\2\2HG\3\2\2\2I\32\3\2\2\2JM\5\25\13\2KM\t\5\2\2LJ\3\2\2\2LK\3"+
		"\2\2\2M\34\3\2\2\2\n\2\37&\66=DHL\3\2\4\2";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
