
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.graph;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class GraphLanguageParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.9.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COLON=2, COMMA=3, DOT=4, LPAREN=5, RPAREN=6, ATTR_NAME=7, TYPE_NAME=8;
	public static final int
		RULE_graph = 0, RULE_attributeList = 1, RULE_attributeNode = 2, RULE_attributePath = 3, 
		RULE_attributeQualifier = 4, RULE_subGraph = 5, RULE_subType = 6;
	private static String[] makeRuleNames() {
		return new String[] {
			"graph", "attributeList", "attributeNode", "attributePath", "attributeQualifier", 
			"subGraph", "subType"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, "':'", "','", "'.'", "'('", "')'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COLON", "COMMA", "DOT", "LPAREN", "RPAREN", "ATTR_NAME", 
			"TYPE_NAME"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "GraphLanguageParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


	/*
	 * Antlr grammar describing the Hibernate EntityGraph Language - for parsing a structured
	 * textual representation of an entity graph
	 *
	 * `GraphLanguageParser.g4`
	 */

	public GraphLanguageParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	public static class GraphContext extends ParserRuleContext {
		public AttributeListContext attributeList() {
			return getRuleContext(AttributeListContext.class,0);
		}
		public GraphContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_graph; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterGraph(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitGraph(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitGraph(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GraphContext graph() throws RecognitionException {
		GraphContext _localctx = new GraphContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_graph);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(14);
			attributeList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AttributeListContext extends ParserRuleContext {
		public List<AttributeNodeContext> attributeNode() {
			return getRuleContexts(AttributeNodeContext.class);
		}
		public AttributeNodeContext attributeNode(int i) {
			return getRuleContext(AttributeNodeContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(GraphLanguageParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(GraphLanguageParser.COMMA, i);
		}
		public AttributeListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_attributeList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterAttributeList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitAttributeList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitAttributeList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AttributeListContext attributeList() throws RecognitionException {
		AttributeListContext _localctx = new AttributeListContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_attributeList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(16);
			attributeNode();
			setState(21);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(17);
				match(COMMA);
				setState(18);
				attributeNode();
				}
				}
				setState(23);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AttributeNodeContext extends ParserRuleContext {
		public AttributePathContext attributePath() {
			return getRuleContext(AttributePathContext.class,0);
		}
		public SubGraphContext subGraph() {
			return getRuleContext(SubGraphContext.class,0);
		}
		public AttributeNodeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_attributeNode; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterAttributeNode(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitAttributeNode(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitAttributeNode(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AttributeNodeContext attributeNode() throws RecognitionException {
		AttributeNodeContext _localctx = new AttributeNodeContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_attributeNode);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(24);
			attributePath();
			setState(26);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LPAREN) {
				{
				setState(25);
				subGraph();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AttributePathContext extends ParserRuleContext {
		public TerminalNode ATTR_NAME() { return getToken(GraphLanguageParser.ATTR_NAME, 0); }
		public AttributeQualifierContext attributeQualifier() {
			return getRuleContext(AttributeQualifierContext.class,0);
		}
		public AttributePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_attributePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterAttributePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitAttributePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitAttributePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AttributePathContext attributePath() throws RecognitionException {
		AttributePathContext _localctx = new AttributePathContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_attributePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(28);
			match(ATTR_NAME);
			setState(30);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==DOT) {
				{
				setState(29);
				attributeQualifier();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AttributeQualifierContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(GraphLanguageParser.DOT, 0); }
		public TerminalNode ATTR_NAME() { return getToken(GraphLanguageParser.ATTR_NAME, 0); }
		public AttributeQualifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_attributeQualifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterAttributeQualifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitAttributeQualifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitAttributeQualifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AttributeQualifierContext attributeQualifier() throws RecognitionException {
		AttributeQualifierContext _localctx = new AttributeQualifierContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_attributeQualifier);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(32);
			match(DOT);
			setState(33);
			match(ATTR_NAME);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubGraphContext extends ParserRuleContext {
		public TerminalNode LPAREN() { return getToken(GraphLanguageParser.LPAREN, 0); }
		public AttributeListContext attributeList() {
			return getRuleContext(AttributeListContext.class,0);
		}
		public TerminalNode RPAREN() { return getToken(GraphLanguageParser.RPAREN, 0); }
		public SubTypeContext subType() {
			return getRuleContext(SubTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(GraphLanguageParser.COLON, 0); }
		public SubGraphContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subGraph; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterSubGraph(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitSubGraph(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitSubGraph(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubGraphContext subGraph() throws RecognitionException {
		SubGraphContext _localctx = new SubGraphContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_subGraph);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(35);
			match(LPAREN);
			setState(39);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==TYPE_NAME) {
				{
				setState(36);
				subType();
				setState(37);
				match(COLON);
				}
			}

			setState(41);
			attributeList();
			setState(42);
			match(RPAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubTypeContext extends ParserRuleContext {
		public TerminalNode TYPE_NAME() { return getToken(GraphLanguageParser.TYPE_NAME, 0); }
		public SubTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).enterSubType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof GraphLanguageParserListener ) ((GraphLanguageParserListener)listener).exitSubType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof GraphLanguageParserVisitor ) return ((GraphLanguageParserVisitor<? extends T>)visitor).visitSubType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubTypeContext subType() throws RecognitionException {
		SubTypeContext _localctx = new SubTypeContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_subType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(44);
			match(TYPE_NAME);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static final String _serializedATN =
		"\3\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964\3\n\61\4\2\t\2\4\3"+
		"\t\3\4\4\t\4\4\5\t\5\4\6\t\6\4\7\t\7\4\b\t\b\3\2\3\2\3\3\3\3\3\3\7\3\26"+
		"\n\3\f\3\16\3\31\13\3\3\4\3\4\5\4\35\n\4\3\5\3\5\5\5!\n\5\3\6\3\6\3\6"+
		"\3\7\3\7\3\7\3\7\5\7*\n\7\3\7\3\7\3\7\3\b\3\b\3\b\2\2\t\2\4\6\b\n\f\16"+
		"\2\2\2-\2\20\3\2\2\2\4\22\3\2\2\2\6\32\3\2\2\2\b\36\3\2\2\2\n\"\3\2\2"+
		"\2\f%\3\2\2\2\16.\3\2\2\2\20\21\5\4\3\2\21\3\3\2\2\2\22\27\5\6\4\2\23"+
		"\24\7\5\2\2\24\26\5\6\4\2\25\23\3\2\2\2\26\31\3\2\2\2\27\25\3\2\2\2\27"+
		"\30\3\2\2\2\30\5\3\2\2\2\31\27\3\2\2\2\32\34\5\b\5\2\33\35\5\f\7\2\34"+
		"\33\3\2\2\2\34\35\3\2\2\2\35\7\3\2\2\2\36 \7\t\2\2\37!\5\n\6\2 \37\3\2"+
		"\2\2 !\3\2\2\2!\t\3\2\2\2\"#\7\6\2\2#$\7\t\2\2$\13\3\2\2\2%)\7\7\2\2&"+
		"\'\5\16\b\2\'(\7\4\2\2(*\3\2\2\2)&\3\2\2\2)*\3\2\2\2*+\3\2\2\2+,\5\4\3"+
		"\2,-\7\b\2\2-\r\3\2\2\2./\7\n\2\2/\17\3\2\2\2\6\27\34 )";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
