
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.graph;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

/**
 * This interface defines a complete generic visitor for a parse tree produced
 * by {@link GraphLanguageParser}.
 *
 * @param <T> The return type of the visit operation. Use {@link Void} for
 * operations with no return type.
 */
public interface GraphLanguageParserVisitor<T> extends ParseTreeVisitor<T> {
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#graph}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGraph(GraphLanguageParser.GraphContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#attributeList}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAttributeList(GraphLanguageParser.AttributeListContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#attributeNode}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAttributeNode(GraphLanguageParser.AttributeNodeContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#attributePath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAttributePath(GraphLanguageParser.AttributePathContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#attributeQualifier}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAttributeQualifier(GraphLanguageParser.AttributeQualifierContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#subGraph}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubGraph(GraphLanguageParser.SubGraphContext ctx);
	/**
	 * Visit a parse tree produced by {@link GraphLanguageParser#subType}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubType(GraphLanguageParser.SubTypeContext ctx);
}
