
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.hql;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class HqlParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.9.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COMMENT=2, INTEGER_LITERAL=3, LONG_LITERAL=4, FLOAT_LITERAL=5, DOUBLE_LITERAL=6, 
		BIG_INTEGER_LITERAL=7, BIG_DECIMAL_LITERAL=8, HEX_LITERAL=9, STRING_LITERAL=10, 
		BINARY_LITERAL=11, TIMESTAMP_ESCAPE_START=12, DATE_ESCAPE_START=13, TIME_ESCAPE_START=14, 
		EQUAL=15, NOT_EQUAL=16, GREATER=17, GREATER_EQUAL=18, LESS=19, LESS_EQUAL=20, 
		COMMA=21, DOT=22, LEFT_PAREN=23, RIGHT_PAREN=24, LEFT_BRACKET=25, RIGHT_BRACKET=26, 
		LEFT_BRACE=27, RIGHT_BRACE=28, PLUS=29, MINUS=30, ASTERISK=31, SLASH=32, 
		PERCENT_OP=33, AMPERSAND=34, SEMICOLON=35, COLON=36, PIPE=37, DOUBLE_PIPE=38, 
		QUESTION_MARK=39, ARROW=40, ID=41, VERSION=42, VERSIONED=43, NATURALID=44, 
		FK=45, ALL=46, AND=47, ANY=48, AS=49, ASC=50, AVG=51, BETWEEN=52, BOTH=53, 
		BY=54, CASE=55, CAST=56, COLLATE=57, COUNT=58, CROSS=59, CUBE=60, CURRENT=61, 
		CURRENT_DATE=62, CURRENT_INSTANT=63, CURRENT_TIME=64, CURRENT_TIMESTAMP=65, 
		DATE=66, DATETIME=67, DAY=68, DELETE=69, DESC=70, DISTINCT=71, ELEMENT=72, 
		ELEMENTS=73, ELSE=74, EMPTY=75, END=76, ENTRY=77, ERROR=78, ESCAPE=79, 
		EVERY=80, EXCEPT=81, EXCLUDE=82, EXISTS=83, EXTRACT=84, FETCH=85, FILTER=86, 
		FIRST=87, FOLLOWING=88, FOR=89, FORMAT=90, FROM=91, FULL=92, FUNCTION=93, 
		GROUP=94, GROUPS=95, HAVING=96, HOUR=97, IGNORE=98, ILIKE=99, IN=100, 
		INDEX=101, INDICES=102, INNER=103, INSERT=104, INSTANT=105, INTERSECT=106, 
		INTO=107, IS=108, JOIN=109, KEY=110, LAST=111, LEADING=112, LEFT=113, 
		LIKE=114, LIMIT=115, LIST=116, LISTAGG=117, LOCAL=118, LOCAL_DATE=119, 
		LOCAL_DATETIME=120, LOCAL_TIME=121, MAP=122, MAX=123, MAXELEMENT=124, 
		MAXINDEX=125, MEMBER=126, MICROSECOND=127, MILLISECOND=128, MIN=129, MINELEMENT=130, 
		MININDEX=131, MINUTE=132, MONTH=133, NANOSECOND=134, NEW=135, NEXT=136, 
		NO=137, NOT=138, NULLS=139, OBJECT=140, OF=141, OFFSET=142, OFFSET_DATETIME=143, 
		ON=144, ONLY=145, OR=146, ORDER=147, OTHERS=148, OUTER=149, OVER=150, 
		OVERFLOW=151, OVERLAY=152, PAD=153, PARTITION=154, PERCENT=155, PLACING=156, 
		POSITION=157, PRECEDING=158, QUARTER=159, RANGE=160, RESPECT=161, RIGHT=162, 
		ROLLUP=163, ROW=164, ROWS=165, SECOND=166, SELECT=167, SET=168, SIZE=169, 
		SOME=170, SUBSTRING=171, SUM=172, THEN=173, TIES=174, TIME=175, TIMESTAMP=176, 
		TIMEZONE_HOUR=177, TIMEZONE_MINUTE=178, TRAILING=179, TREAT=180, TRIM=181, 
		TRUNCATE=182, TYPE=183, UNBOUNDED=184, UNION=185, UPDATE=186, VALUE=187, 
		VALUES=188, WEEK=189, WHEN=190, WHERE=191, WITH=192, WITHIN=193, WITHOUT=194, 
		YEAR=195, TRUE=196, FALSE=197, NULL=198, IDENTIFIER=199, QUOTED_IDENTIFIER=200;
	public static final int
		RULE_statement = 0, RULE_selectStatement = 1, RULE_subquery = 2, RULE_targetEntity = 3, 
		RULE_deleteStatement = 4, RULE_updateStatement = 5, RULE_setClause = 6, 
		RULE_assignment = 7, RULE_insertStatement = 8, RULE_targetFields = 9, 
		RULE_valuesList = 10, RULE_values = 11, RULE_queryExpression = 12, RULE_orderedQuery = 13, 
		RULE_setOperator = 14, RULE_queryOrder = 15, RULE_query = 16, RULE_fromClause = 17, 
		RULE_entityWithJoins = 18, RULE_rootEntity = 19, RULE_entityName = 20, 
		RULE_variable = 21, RULE_crossJoin = 22, RULE_jpaCollectionJoin = 23, 
		RULE_join = 24, RULE_joinType = 25, RULE_joinPath = 26, RULE_joinRestriction = 27, 
		RULE_selectClause = 28, RULE_selectionList = 29, RULE_selection = 30, 
		RULE_selectExpression = 31, RULE_mapEntrySelection = 32, RULE_instantiation = 33, 
		RULE_instantiationTarget = 34, RULE_instantiationArguments = 35, RULE_instantiationArgument = 36, 
		RULE_instantiationArgumentExpression = 37, RULE_jpaSelectObjectSyntax = 38, 
		RULE_simplePath = 39, RULE_simplePathElement = 40, RULE_path = 41, RULE_pathContinuation = 42, 
		RULE_syntacticDomainPath = 43, RULE_generalPathFragment = 44, RULE_indexedPathAccessFragment = 45, 
		RULE_treatedNavigablePath = 46, RULE_collectionValueNavigablePath = 47, 
		RULE_mapKeyNavigablePath = 48, RULE_groupByClause = 49, RULE_groupByExpression = 50, 
		RULE_havingClause = 51, RULE_orderByClause = 52, RULE_orderByFragment = 53, 
		RULE_sortSpecification = 54, RULE_nullsPrecedence = 55, RULE_sortExpression = 56, 
		RULE_sortDirection = 57, RULE_collateFunction = 58, RULE_collation = 59, 
		RULE_limitClause = 60, RULE_offsetClause = 61, RULE_fetchClause = 62, 
		RULE_parameterOrIntegerLiteral = 63, RULE_parameterOrNumberLiteral = 64, 
		RULE_whereClause = 65, RULE_predicate = 66, RULE_comparisonOperator = 67, 
		RULE_inList = 68, RULE_likeEscape = 69, RULE_expression = 70, RULE_primaryExpression = 71, 
		RULE_expressionOrPredicate = 72, RULE_multiplicativeOperator = 73, RULE_additiveOperator = 74, 
		RULE_signOperator = 75, RULE_entityTypeReference = 76, RULE_entityIdReference = 77, 
		RULE_entityVersionReference = 78, RULE_entityNaturalIdReference = 79, 
		RULE_toOneFkReference = 80, RULE_caseList = 81, RULE_simpleCaseList = 82, 
		RULE_simpleCaseWhen = 83, RULE_caseOtherwise = 84, RULE_searchedCaseList = 85, 
		RULE_searchedCaseWhen = 86, RULE_literal = 87, RULE_booleanLiteral = 88, 
		RULE_numericLiteral = 89, RULE_binaryLiteral = 90, RULE_temporalLiteral = 91, 
		RULE_dateTimeLiteral = 92, RULE_dateLiteral = 93, RULE_timeLiteral = 94, 
		RULE_dateTime = 95, RULE_date = 96, RULE_time = 97, RULE_offset = 98, 
		RULE_year = 99, RULE_month = 100, RULE_day = 101, RULE_hour = 102, RULE_minute = 103, 
		RULE_second = 104, RULE_zoneId = 105, RULE_jdbcTimestampLiteral = 106, 
		RULE_jdbcDateLiteral = 107, RULE_jdbcTimeLiteral = 108, RULE_genericTemporalLiteralText = 109, 
		RULE_generalizedLiteral = 110, RULE_generalizedLiteralType = 111, RULE_generalizedLiteralText = 112, 
		RULE_parameter = 113, RULE_function = 114, RULE_jpaNonstandardFunction = 115, 
		RULE_jpaNonstandardFunctionName = 116, RULE_genericFunction = 117, RULE_genericFunctionName = 118, 
		RULE_genericFunctionArguments = 119, RULE_collectionSizeFunction = 120, 
		RULE_indexAggregateFunction = 121, RULE_elementAggregateFunction = 122, 
		RULE_collectionFunctionMisuse = 123, RULE_aggregateFunction = 124, RULE_everyFunction = 125, 
		RULE_anyFunction = 126, RULE_listaggFunction = 127, RULE_onOverflowClause = 128, 
		RULE_withinGroupClause = 129, RULE_filterClause = 130, RULE_nullsClause = 131, 
		RULE_nthSideClause = 132, RULE_overClause = 133, RULE_partitionClause = 134, 
		RULE_frameClause = 135, RULE_frameStart = 136, RULE_frameEnd = 137, RULE_frameExclusion = 138, 
		RULE_standardFunction = 139, RULE_castFunction = 140, RULE_castTarget = 141, 
		RULE_castTargetType = 142, RULE_substringFunction = 143, RULE_substringFunctionStartArgument = 144, 
		RULE_substringFunctionLengthArgument = 145, RULE_trimFunction = 146, RULE_trimSpecification = 147, 
		RULE_trimCharacter = 148, RULE_padFunction = 149, RULE_padSpecification = 150, 
		RULE_padCharacter = 151, RULE_padLength = 152, RULE_overlayFunction = 153, 
		RULE_overlayFunctionStringArgument = 154, RULE_overlayFunctionReplacementArgument = 155, 
		RULE_overlayFunctionStartArgument = 156, RULE_overlayFunctionLengthArgument = 157, 
		RULE_currentDateFunction = 158, RULE_currentTimeFunction = 159, RULE_currentTimestampFunction = 160, 
		RULE_instantFunction = 161, RULE_localDateTimeFunction = 162, RULE_offsetDateTimeFunction = 163, 
		RULE_localDateFunction = 164, RULE_localTimeFunction = 165, RULE_formatFunction = 166, 
		RULE_format = 167, RULE_extractFunction = 168, RULE_extractField = 169, 
		RULE_datetimeField = 170, RULE_dayField = 171, RULE_weekField = 172, RULE_timeZoneField = 173, 
		RULE_dateOrTimeField = 174, RULE_positionFunction = 175, RULE_positionFunctionPatternArgument = 176, 
		RULE_positionFunctionStringArgument = 177, RULE_cube = 178, RULE_rollup = 179, 
		RULE_nakedIdentifier = 180, RULE_identifier = 181;
	private static String[] makeRuleNames() {
		return new String[] {
			"statement", "selectStatement", "subquery", "targetEntity", "deleteStatement", 
			"updateStatement", "setClause", "assignment", "insertStatement", "targetFields", 
			"valuesList", "values", "queryExpression", "orderedQuery", "setOperator", 
			"queryOrder", "query", "fromClause", "entityWithJoins", "rootEntity", 
			"entityName", "variable", "crossJoin", "jpaCollectionJoin", "join", "joinType", 
			"joinPath", "joinRestriction", "selectClause", "selectionList", "selection", 
			"selectExpression", "mapEntrySelection", "instantiation", "instantiationTarget", 
			"instantiationArguments", "instantiationArgument", "instantiationArgumentExpression", 
			"jpaSelectObjectSyntax", "simplePath", "simplePathElement", "path", "pathContinuation", 
			"syntacticDomainPath", "generalPathFragment", "indexedPathAccessFragment", 
			"treatedNavigablePath", "collectionValueNavigablePath", "mapKeyNavigablePath", 
			"groupByClause", "groupByExpression", "havingClause", "orderByClause", 
			"orderByFragment", "sortSpecification", "nullsPrecedence", "sortExpression", 
			"sortDirection", "collateFunction", "collation", "limitClause", "offsetClause", 
			"fetchClause", "parameterOrIntegerLiteral", "parameterOrNumberLiteral", 
			"whereClause", "predicate", "comparisonOperator", "inList", "likeEscape", 
			"expression", "primaryExpression", "expressionOrPredicate", "multiplicativeOperator", 
			"additiveOperator", "signOperator", "entityTypeReference", "entityIdReference", 
			"entityVersionReference", "entityNaturalIdReference", "toOneFkReference", 
			"caseList", "simpleCaseList", "simpleCaseWhen", "caseOtherwise", "searchedCaseList", 
			"searchedCaseWhen", "literal", "booleanLiteral", "numericLiteral", "binaryLiteral", 
			"temporalLiteral", "dateTimeLiteral", "dateLiteral", "timeLiteral", "dateTime", 
			"date", "time", "offset", "year", "month", "day", "hour", "minute", "second", 
			"zoneId", "jdbcTimestampLiteral", "jdbcDateLiteral", "jdbcTimeLiteral", 
			"genericTemporalLiteralText", "generalizedLiteral", "generalizedLiteralType", 
			"generalizedLiteralText", "parameter", "function", "jpaNonstandardFunction", 
			"jpaNonstandardFunctionName", "genericFunction", "genericFunctionName", 
			"genericFunctionArguments", "collectionSizeFunction", "indexAggregateFunction", 
			"elementAggregateFunction", "collectionFunctionMisuse", "aggregateFunction", 
			"everyFunction", "anyFunction", "listaggFunction", "onOverflowClause", 
			"withinGroupClause", "filterClause", "nullsClause", "nthSideClause", 
			"overClause", "partitionClause", "frameClause", "frameStart", "frameEnd", 
			"frameExclusion", "standardFunction", "castFunction", "castTarget", "castTargetType", 
			"substringFunction", "substringFunctionStartArgument", "substringFunctionLengthArgument", 
			"trimFunction", "trimSpecification", "trimCharacter", "padFunction", 
			"padSpecification", "padCharacter", "padLength", "overlayFunction", "overlayFunctionStringArgument", 
			"overlayFunctionReplacementArgument", "overlayFunctionStartArgument", 
			"overlayFunctionLengthArgument", "currentDateFunction", "currentTimeFunction", 
			"currentTimestampFunction", "instantFunction", "localDateTimeFunction", 
			"offsetDateTimeFunction", "localDateFunction", "localTimeFunction", "formatFunction", 
			"format", "extractFunction", "extractField", "datetimeField", "dayField", 
			"weekField", "timeZoneField", "dateOrTimeField", "positionFunction", 
			"positionFunctionPatternArgument", "positionFunctionStringArgument", 
			"cube", "rollup", "nakedIdentifier", "identifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			"'{ts'", "'{d'", "'{t'", "'='", null, "'>'", "'>='", "'<'", "'<='", "','", 
			"'.'", "'('", "')'", "'['", "']'", "'{'", "'}'", "'+'", "'-'", "'*'", 
			"'/'", "'%'", "'&'", "';'", "':'", "'|'", "'||'", "'?'", "'->'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COMMENT", "INTEGER_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", 
			"DOUBLE_LITERAL", "BIG_INTEGER_LITERAL", "BIG_DECIMAL_LITERAL", "HEX_LITERAL", 
			"STRING_LITERAL", "BINARY_LITERAL", "TIMESTAMP_ESCAPE_START", "DATE_ESCAPE_START", 
			"TIME_ESCAPE_START", "EQUAL", "NOT_EQUAL", "GREATER", "GREATER_EQUAL", 
			"LESS", "LESS_EQUAL", "COMMA", "DOT", "LEFT_PAREN", "RIGHT_PAREN", "LEFT_BRACKET", 
			"RIGHT_BRACKET", "LEFT_BRACE", "RIGHT_BRACE", "PLUS", "MINUS", "ASTERISK", 
			"SLASH", "PERCENT_OP", "AMPERSAND", "SEMICOLON", "COLON", "PIPE", "DOUBLE_PIPE", 
			"QUESTION_MARK", "ARROW", "ID", "VERSION", "VERSIONED", "NATURALID", 
			"FK", "ALL", "AND", "ANY", "AS", "ASC", "AVG", "BETWEEN", "BOTH", "BY", 
			"CASE", "CAST", "COLLATE", "COUNT", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", 
			"CURRENT_INSTANT", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATE", "DATETIME", 
			"DAY", "DELETE", "DESC", "DISTINCT", "ELEMENT", "ELEMENTS", "ELSE", "EMPTY", 
			"END", "ENTRY", "ERROR", "ESCAPE", "EVERY", "EXCEPT", "EXCLUDE", "EXISTS", 
			"EXTRACT", "FETCH", "FILTER", "FIRST", "FOLLOWING", "FOR", "FORMAT", 
			"FROM", "FULL", "FUNCTION", "GROUP", "GROUPS", "HAVING", "HOUR", "IGNORE", 
			"ILIKE", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSTANT", "INTERSECT", 
			"INTO", "IS", "JOIN", "KEY", "LAST", "LEADING", "LEFT", "LIKE", "LIMIT", 
			"LIST", "LISTAGG", "LOCAL", "LOCAL_DATE", "LOCAL_DATETIME", "LOCAL_TIME", 
			"MAP", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER", "MICROSECOND", "MILLISECOND", 
			"MIN", "MINELEMENT", "MININDEX", "MINUTE", "MONTH", "NANOSECOND", "NEW", 
			"NEXT", "NO", "NOT", "NULLS", "OBJECT", "OF", "OFFSET", "OFFSET_DATETIME", 
			"ON", "ONLY", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "OVERFLOW", "OVERLAY", 
			"PAD", "PARTITION", "PERCENT", "PLACING", "POSITION", "PRECEDING", "QUARTER", 
			"RANGE", "RESPECT", "RIGHT", "ROLLUP", "ROW", "ROWS", "SECOND", "SELECT", 
			"SET", "SIZE", "SOME", "SUBSTRING", "SUM", "THEN", "TIES", "TIME", "TIMESTAMP", 
			"TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TREAT", "TRIM", "TRUNCATE", 
			"TYPE", "UNBOUNDED", "UNION", "UPDATE", "VALUE", "VALUES", "WEEK", "WHEN", 
			"WHERE", "WITH", "WITHIN", "WITHOUT", "YEAR", "TRUE", "FALSE", "NULL", 
			"IDENTIFIER", "QUOTED_IDENTIFIER"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "HqlParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


		protected void logUseOfReservedWordAsIdentifier(Token token) {
		}

	public HqlParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	public static class StatementContext extends ParserRuleContext {
		public TerminalNode EOF() { return getToken(HqlParser.EOF, 0); }
		public SelectStatementContext selectStatement() {
			return getRuleContext(SelectStatementContext.class,0);
		}
		public UpdateStatementContext updateStatement() {
			return getRuleContext(UpdateStatementContext.class,0);
		}
		public DeleteStatementContext deleteStatement() {
			return getRuleContext(DeleteStatementContext.class,0);
		}
		public InsertStatementContext insertStatement() {
			return getRuleContext(InsertStatementContext.class,0);
		}
		public StatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_statement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StatementContext statement() throws RecognitionException {
		StatementContext _localctx = new StatementContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_statement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(368);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
				{
				setState(364);
				selectStatement();
				}
				break;
			case UPDATE:
				{
				setState(365);
				updateStatement();
				}
				break;
			case DELETE:
				{
				setState(366);
				deleteStatement();
				}
				break;
			case INSERT:
				{
				setState(367);
				insertStatement();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(370);
			match(EOF);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectStatementContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SelectStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectStatementContext selectStatement() throws RecognitionException {
		SelectStatementContext _localctx = new SelectStatementContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_selectStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(372);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubqueryContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SubqueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subquery; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubqueryContext subquery() throws RecognitionException {
		SubqueryContext _localctx = new SubqueryContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_subquery);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(374);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public TargetEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetEntityContext targetEntity() throws RecognitionException {
		TargetEntityContext _localctx = new TargetEntityContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_targetEntity);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(376);
			entityName();
			setState(378);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,1,_ctx) ) {
			case 1:
				{
				setState(377);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DeleteStatementContext extends ParserRuleContext {
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public DeleteStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_deleteStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDeleteStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDeleteStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDeleteStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DeleteStatementContext deleteStatement() throws RecognitionException {
		DeleteStatementContext _localctx = new DeleteStatementContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_deleteStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(380);
			match(DELETE);
			setState(382);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,2,_ctx) ) {
			case 1:
				{
				setState(381);
				match(FROM);
				}
				break;
			}
			setState(384);
			targetEntity();
			setState(386);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(385);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class UpdateStatementContext extends ParserRuleContext {
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public UpdateStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_updateStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUpdateStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUpdateStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUpdateStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final UpdateStatementContext updateStatement() throws RecognitionException {
		UpdateStatementContext _localctx = new UpdateStatementContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_updateStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(388);
			match(UPDATE);
			setState(390);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				{
				setState(389);
				match(VERSIONED);
				}
				break;
			}
			setState(392);
			targetEntity();
			setState(393);
			setClause();
			setState(395);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(394);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetClauseContext extends ParserRuleContext {
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<AssignmentContext> assignment() {
			return getRuleContexts(AssignmentContext.class);
		}
		public AssignmentContext assignment(int i) {
			return getRuleContext(AssignmentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetClauseContext setClause() throws RecognitionException {
		SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_setClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(397);
			match(SET);
			setState(398);
			assignment();
			setState(403);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(399);
				match(COMMA);
				setState(400);
				assignment();
				}
				}
				setState(405);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AssignmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public AssignmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_assignment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAssignment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAssignment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAssignment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AssignmentContext assignment() throws RecognitionException {
		AssignmentContext _localctx = new AssignmentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_assignment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(406);
			simplePath();
			setState(407);
			match(EQUAL);
			setState(408);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InsertStatementContext extends ParserRuleContext {
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TargetFieldsContext targetFields() {
			return getRuleContext(TargetFieldsContext.class,0);
		}
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public ValuesListContext valuesList() {
			return getRuleContext(ValuesListContext.class,0);
		}
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public InsertStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_insertStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInsertStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInsertStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInsertStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InsertStatementContext insertStatement() throws RecognitionException {
		InsertStatementContext _localctx = new InsertStatementContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_insertStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(410);
			match(INSERT);
			setState(412);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,7,_ctx) ) {
			case 1:
				{
				setState(411);
				match(INTO);
				}
				break;
			}
			setState(414);
			targetEntity();
			setState(415);
			targetFields();
			setState(418);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
				{
				setState(416);
				queryExpression();
				}
				break;
			case VALUES:
				{
				setState(417);
				valuesList();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetFieldsContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TargetFieldsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetFields; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetFields(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetFields(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetFields(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetFieldsContext targetFields() throws RecognitionException {
		TargetFieldsContext _localctx = new TargetFieldsContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_targetFields);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(420);
			match(LEFT_PAREN);
			setState(421);
			simplePath();
			setState(426);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(422);
				match(COMMA);
				setState(423);
				simplePath();
				}
				}
				setState(428);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(429);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesListContext extends ParserRuleContext {
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public List<ValuesContext> values() {
			return getRuleContexts(ValuesContext.class);
		}
		public ValuesContext values(int i) {
			return getRuleContext(ValuesContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_valuesList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValuesList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValuesList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValuesList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesListContext valuesList() throws RecognitionException {
		ValuesListContext _localctx = new ValuesListContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_valuesList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(431);
			match(VALUES);
			setState(432);
			values();
			setState(437);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(433);
				match(COMMA);
				setState(434);
				values();
				}
				}
				setState(439);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_values; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValues(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValues(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValues(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesContext values() throws RecognitionException {
		ValuesContext _localctx = new ValuesContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_values);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(440);
			match(LEFT_PAREN);
			setState(441);
			expressionOrPredicate();
			setState(446);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(442);
				match(COMMA);
				setState(443);
				expressionOrPredicate();
				}
				}
				setState(448);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(449);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryExpressionContext extends ParserRuleContext {
		public QueryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryExpression; }
	 
		public QueryExpressionContext() { }
		public void copyFrom(QueryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SetQueryGroupContext extends QueryExpressionContext {
		public List<OrderedQueryContext> orderedQuery() {
			return getRuleContexts(OrderedQueryContext.class);
		}
		public OrderedQueryContext orderedQuery(int i) {
			return getRuleContext(OrderedQueryContext.class,i);
		}
		public List<SetOperatorContext> setOperator() {
			return getRuleContexts(SetOperatorContext.class);
		}
		public SetOperatorContext setOperator(int i) {
			return getRuleContext(SetOperatorContext.class,i);
		}
		public SetQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SimpleQueryGroupContext extends QueryExpressionContext {
		public OrderedQueryContext orderedQuery() {
			return getRuleContext(OrderedQueryContext.class,0);
		}
		public SimpleQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryExpressionContext queryExpression() throws RecognitionException {
		QueryExpressionContext _localctx = new QueryExpressionContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_queryExpression);
		int _la;
		try {
			setState(460);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,13,_ctx) ) {
			case 1:
				_localctx = new SimpleQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(451);
				orderedQuery();
				}
				break;
			case 2:
				_localctx = new SetQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(452);
				orderedQuery();
				setState(456); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(453);
					setOperator();
					setState(454);
					orderedQuery();
					}
					}
					setState(458); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==EXCEPT || _la==INTERSECT || _la==UNION );
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderedQueryContext extends ParserRuleContext {
		public OrderedQueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderedQuery; }
	 
		public OrderedQueryContext() { }
		public void copyFrom(OrderedQueryContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class QuerySpecExpressionContext extends OrderedQueryContext {
		public QueryContext query() {
			return getRuleContext(QueryContext.class,0);
		}
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QuerySpecExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuerySpecExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuerySpecExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuerySpecExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NestedQueryExpressionContext extends OrderedQueryContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public NestedQueryExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNestedQueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNestedQueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNestedQueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderedQueryContext orderedQuery() throws RecognitionException {
		OrderedQueryContext _localctx = new OrderedQueryContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_orderedQuery);
		int _la;
		try {
			setState(472);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case FROM:
			case SELECT:
				_localctx = new QuerySpecExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(462);
				query();
				setState(464);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(463);
					queryOrder();
					}
				}

				}
				break;
			case LEFT_PAREN:
				_localctx = new NestedQueryExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(466);
				match(LEFT_PAREN);
				setState(467);
				queryExpression();
				setState(468);
				match(RIGHT_PAREN);
				setState(470);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(469);
					queryOrder();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetOperatorContext extends ParserRuleContext {
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public SetOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetOperatorContext setOperator() throws RecognitionException {
		SetOperatorContext _localctx = new SetOperatorContext(_ctx, getState());
		enterRule(_localctx, 28, RULE_setOperator);
		int _la;
		try {
			setState(486);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case UNION:
				enterOuterAlt(_localctx, 1);
				{
				setState(474);
				match(UNION);
				setState(476);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(475);
					match(ALL);
					}
				}

				}
				break;
			case INTERSECT:
				enterOuterAlt(_localctx, 2);
				{
				setState(478);
				match(INTERSECT);
				setState(480);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(479);
					match(ALL);
					}
				}

				}
				break;
			case EXCEPT:
				enterOuterAlt(_localctx, 3);
				{
				setState(482);
				match(EXCEPT);
				setState(484);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(483);
					match(ALL);
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryOrderContext extends ParserRuleContext {
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public LimitClauseContext limitClause() {
			return getRuleContext(LimitClauseContext.class,0);
		}
		public OffsetClauseContext offsetClause() {
			return getRuleContext(OffsetClauseContext.class,0);
		}
		public FetchClauseContext fetchClause() {
			return getRuleContext(FetchClauseContext.class,0);
		}
		public QueryOrderContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryOrder; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrder(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrder(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrder(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryOrderContext queryOrder() throws RecognitionException {
		QueryOrderContext _localctx = new QueryOrderContext(_ctx, getState());
		enterRule(_localctx, 30, RULE_queryOrder);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(488);
			orderByClause();
			setState(490);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LIMIT) {
				{
				setState(489);
				limitClause();
				}
			}

			setState(493);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==OFFSET) {
				{
				setState(492);
				offsetClause();
				}
			}

			setState(496);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FETCH) {
				{
				setState(495);
				fetchClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryContext extends ParserRuleContext {
		public SelectClauseContext selectClause() {
			return getRuleContext(SelectClauseContext.class,0);
		}
		public FromClauseContext fromClause() {
			return getRuleContext(FromClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public GroupByClauseContext groupByClause() {
			return getRuleContext(GroupByClauseContext.class,0);
		}
		public HavingClauseContext havingClause() {
			return getRuleContext(HavingClauseContext.class,0);
		}
		public QueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_query; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryContext query() throws RecognitionException {
		QueryContext _localctx = new QueryContext(_ctx, getState());
		enterRule(_localctx, 32, RULE_query);
		int _la;
		try {
			setState(524);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case SELECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(498);
				selectClause();
				setState(500);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FROM) {
					{
					setState(499);
					fromClause();
					}
				}

				setState(503);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(502);
					whereClause();
					}
				}

				setState(509);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(505);
					groupByClause();
					setState(507);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(506);
						havingClause();
						}
					}

					}
				}

				}
				break;
			case FROM:
				enterOuterAlt(_localctx, 2);
				{
				setState(511);
				fromClause();
				setState(513);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(512);
					whereClause();
					}
				}

				setState(519);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(515);
					groupByClause();
					setState(517);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(516);
						havingClause();
						}
					}

					}
				}

				setState(522);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==SELECT) {
					{
					setState(521);
					selectClause();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FromClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public List<EntityWithJoinsContext> entityWithJoins() {
			return getRuleContexts(EntityWithJoinsContext.class);
		}
		public EntityWithJoinsContext entityWithJoins(int i) {
			return getRuleContext(EntityWithJoinsContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public FromClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromClauseContext fromClause() throws RecognitionException {
		FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
		enterRule(_localctx, 34, RULE_fromClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(526);
			match(FROM);
			setState(527);
			entityWithJoins();
			setState(532);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(528);
				match(COMMA);
				setState(529);
				entityWithJoins();
				}
				}
				setState(534);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityWithJoinsContext extends ParserRuleContext {
		public RootEntityContext rootEntity() {
			return getRuleContext(RootEntityContext.class,0);
		}
		public List<JoinContext> join() {
			return getRuleContexts(JoinContext.class);
		}
		public JoinContext join(int i) {
			return getRuleContext(JoinContext.class,i);
		}
		public List<CrossJoinContext> crossJoin() {
			return getRuleContexts(CrossJoinContext.class);
		}
		public CrossJoinContext crossJoin(int i) {
			return getRuleContext(CrossJoinContext.class,i);
		}
		public List<JpaCollectionJoinContext> jpaCollectionJoin() {
			return getRuleContexts(JpaCollectionJoinContext.class);
		}
		public JpaCollectionJoinContext jpaCollectionJoin(int i) {
			return getRuleContext(JpaCollectionJoinContext.class,i);
		}
		public EntityWithJoinsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityWithJoins; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityWithJoins(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityWithJoins(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityWithJoins(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityWithJoinsContext entityWithJoins() throws RecognitionException {
		EntityWithJoinsContext _localctx = new EntityWithJoinsContext(_ctx, getState());
		enterRule(_localctx, 36, RULE_entityWithJoins);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(535);
			rootEntity();
			setState(541);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,35,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					setState(539);
					_errHandler.sync(this);
					switch (_input.LA(1)) {
					case FULL:
					case INNER:
					case JOIN:
					case LEFT:
					case OUTER:
					case RIGHT:
						{
						setState(536);
						join();
						}
						break;
					case CROSS:
						{
						setState(537);
						crossJoin();
						}
						break;
					case COMMA:
						{
						setState(538);
						jpaCollectionJoin();
						}
						break;
					default:
						throw new NoViableAltException(this);
					}
					} 
				}
				setState(543);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,35,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class RootEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rootEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RootEntityContext rootEntity() throws RecognitionException {
		RootEntityContext _localctx = new RootEntityContext(_ctx, getState());
		enterRule(_localctx, 38, RULE_rootEntity);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(544);
			entityName();
			setState(546);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,36,_ctx) ) {
			case 1:
				{
				setState(545);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNameContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public EntityNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNameContext entityName() throws RecognitionException {
		EntityNameContext _localctx = new EntityNameContext(_ctx, getState());
		enterRule(_localctx, 40, RULE_entityName);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(548);
			identifier();
			setState(553);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(549);
				match(DOT);
				setState(550);
				identifier();
				}
				}
				setState(555);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class VariableContext extends ParserRuleContext {
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public VariableContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_variable; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterVariable(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitVariable(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitVariable(this);
			else return visitor.visitChildren(this);
		}
	}

	public final VariableContext variable() throws RecognitionException {
		VariableContext _localctx = new VariableContext(_ctx, getState());
		enterRule(_localctx, 42, RULE_variable);
		try {
			setState(559);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,38,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(556);
				match(AS);
				setState(557);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(558);
				nakedIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CrossJoinContext extends ParserRuleContext {
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public CrossJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_crossJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCrossJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCrossJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCrossJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CrossJoinContext crossJoin() throws RecognitionException {
		CrossJoinContext _localctx = new CrossJoinContext(_ctx, getState());
		enterRule(_localctx, 44, RULE_crossJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(561);
			match(CROSS);
			setState(562);
			match(JOIN);
			setState(563);
			entityName();
			setState(565);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,39,_ctx) ) {
			case 1:
				{
				setState(564);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaCollectionJoinContext extends ParserRuleContext {
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JpaCollectionJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaCollectionJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaCollectionJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaCollectionJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaCollectionJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaCollectionJoinContext jpaCollectionJoin() throws RecognitionException {
		JpaCollectionJoinContext _localctx = new JpaCollectionJoinContext(_ctx, getState());
		enterRule(_localctx, 46, RULE_jpaCollectionJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(567);
			match(COMMA);
			setState(568);
			match(IN);
			setState(569);
			match(LEFT_PAREN);
			setState(570);
			path();
			setState(571);
			match(RIGHT_PAREN);
			setState(573);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,40,_ctx) ) {
			case 1:
				{
				setState(572);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinContext extends ParserRuleContext {
		public JoinTypeContext joinType() {
			return getRuleContext(JoinTypeContext.class,0);
		}
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public JoinPathContext joinPath() {
			return getRuleContext(JoinPathContext.class,0);
		}
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public JoinRestrictionContext joinRestriction() {
			return getRuleContext(JoinRestrictionContext.class,0);
		}
		public JoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_join; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinContext join() throws RecognitionException {
		JoinContext _localctx = new JoinContext(_ctx, getState());
		enterRule(_localctx, 48, RULE_join);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(575);
			joinType();
			setState(576);
			match(JOIN);
			setState(578);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,41,_ctx) ) {
			case 1:
				{
				setState(577);
				match(FETCH);
				}
				break;
			}
			setState(580);
			joinPath();
			setState(582);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON || _la==WITH) {
				{
				setState(581);
				joinRestriction();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinTypeContext extends ParserRuleContext {
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public JoinTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTypeContext joinType() throws RecognitionException {
		JoinTypeContext _localctx = new JoinTypeContext(_ctx, getState());
		enterRule(_localctx, 50, RULE_joinType);
		int _la;
		try {
			setState(593);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,46,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(585);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==INNER) {
					{
					setState(584);
					match(INNER);
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(588);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FULL || _la==LEFT || _la==RIGHT) {
					{
					setState(587);
					_la = _input.LA(1);
					if ( !(_la==FULL || _la==LEFT || _la==RIGHT) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				setState(591);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OUTER) {
					{
					setState(590);
					match(OUTER);
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinPathContext extends ParserRuleContext {
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinPathContext joinPath() throws RecognitionException {
		JoinPathContext _localctx = new JoinPathContext(_ctx, getState());
		enterRule(_localctx, 52, RULE_joinPath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(595);
			path();
			setState(597);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,47,_ctx) ) {
			case 1:
				{
				setState(596);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinRestrictionContext extends ParserRuleContext {
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public JoinRestrictionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinRestriction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinRestriction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinRestriction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinRestriction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinRestrictionContext joinRestriction() throws RecognitionException {
		JoinRestrictionContext _localctx = new JoinRestrictionContext(_ctx, getState());
		enterRule(_localctx, 54, RULE_joinRestriction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(599);
			_la = _input.LA(1);
			if ( !(_la==ON || _la==WITH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(600);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectClauseContext extends ParserRuleContext {
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public SelectionListContext selectionList() {
			return getRuleContext(SelectionListContext.class,0);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public SelectClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectClauseContext selectClause() throws RecognitionException {
		SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
		enterRule(_localctx, 56, RULE_selectClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(602);
			match(SELECT);
			setState(604);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,48,_ctx) ) {
			case 1:
				{
				setState(603);
				match(DISTINCT);
				}
				break;
			}
			setState(606);
			selectionList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionListContext extends ParserRuleContext {
		public List<SelectionContext> selection() {
			return getRuleContexts(SelectionContext.class);
		}
		public SelectionContext selection(int i) {
			return getRuleContext(SelectionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SelectionListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectionList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectionList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectionList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectionList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionListContext selectionList() throws RecognitionException {
		SelectionListContext _localctx = new SelectionListContext(_ctx, getState());
		enterRule(_localctx, 58, RULE_selectionList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(608);
			selection();
			setState(613);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(609);
				match(COMMA);
				setState(610);
				selection();
				}
				}
				setState(615);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionContext extends ParserRuleContext {
		public SelectExpressionContext selectExpression() {
			return getRuleContext(SelectExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public SelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionContext selection() throws RecognitionException {
		SelectionContext _localctx = new SelectionContext(_ctx, getState());
		enterRule(_localctx, 60, RULE_selection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(616);
			selectExpression();
			setState(618);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,50,_ctx) ) {
			case 1:
				{
				setState(617);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectExpressionContext extends ParserRuleContext {
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public MapEntrySelectionContext mapEntrySelection() {
			return getRuleContext(MapEntrySelectionContext.class,0);
		}
		public JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() {
			return getRuleContext(JpaSelectObjectSyntaxContext.class,0);
		}
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectExpressionContext selectExpression() throws RecognitionException {
		SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
		enterRule(_localctx, 62, RULE_selectExpression);
		try {
			setState(624);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,51,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(620);
				instantiation();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(621);
				mapEntrySelection();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(622);
				jpaSelectObjectSyntax();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(623);
				expressionOrPredicate();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapEntrySelectionContext extends ParserRuleContext {
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public MapEntrySelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapEntrySelection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapEntrySelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapEntrySelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapEntrySelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapEntrySelectionContext mapEntrySelection() throws RecognitionException {
		MapEntrySelectionContext _localctx = new MapEntrySelectionContext(_ctx, getState());
		enterRule(_localctx, 64, RULE_mapEntrySelection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(626);
			match(ENTRY);
			setState(627);
			match(LEFT_PAREN);
			setState(628);
			path();
			setState(629);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationContext extends ParserRuleContext {
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public InstantiationTargetContext instantiationTarget() {
			return getRuleContext(InstantiationTargetContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public InstantiationArgumentsContext instantiationArguments() {
			return getRuleContext(InstantiationArgumentsContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public InstantiationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationContext instantiation() throws RecognitionException {
		InstantiationContext _localctx = new InstantiationContext(_ctx, getState());
		enterRule(_localctx, 66, RULE_instantiation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(631);
			match(NEW);
			setState(632);
			instantiationTarget();
			setState(633);
			match(LEFT_PAREN);
			setState(634);
			instantiationArguments();
			setState(635);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationTargetContext extends ParserRuleContext {
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public InstantiationTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationTargetContext instantiationTarget() throws RecognitionException {
		InstantiationTargetContext _localctx = new InstantiationTargetContext(_ctx, getState());
		enterRule(_localctx, 68, RULE_instantiationTarget);
		try {
			setState(640);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,52,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(637);
				match(LIST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(638);
				match(MAP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(639);
				simplePath();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentsContext extends ParserRuleContext {
		public List<InstantiationArgumentContext> instantiationArgument() {
			return getRuleContexts(InstantiationArgumentContext.class);
		}
		public InstantiationArgumentContext instantiationArgument(int i) {
			return getRuleContext(InstantiationArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public InstantiationArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentsContext instantiationArguments() throws RecognitionException {
		InstantiationArgumentsContext _localctx = new InstantiationArgumentsContext(_ctx, getState());
		enterRule(_localctx, 70, RULE_instantiationArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(642);
			instantiationArgument();
			setState(647);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(643);
				match(COMMA);
				setState(644);
				instantiationArgument();
				}
				}
				setState(649);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentContext extends ParserRuleContext {
		public InstantiationArgumentExpressionContext instantiationArgumentExpression() {
			return getRuleContext(InstantiationArgumentExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public InstantiationArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentContext instantiationArgument() throws RecognitionException {
		InstantiationArgumentContext _localctx = new InstantiationArgumentContext(_ctx, getState());
		enterRule(_localctx, 72, RULE_instantiationArgument);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(650);
			instantiationArgumentExpression();
			setState(652);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 41)) & ~0x3f) == 0 && ((1L << (_la - 41)) & ((1L << (ID - 41)) | (1L << (VERSION - 41)) | (1L << (VERSIONED - 41)) | (1L << (NATURALID - 41)) | (1L << (ALL - 41)) | (1L << (AND - 41)) | (1L << (ANY - 41)) | (1L << (AS - 41)) | (1L << (ASC - 41)) | (1L << (AVG - 41)) | (1L << (BETWEEN - 41)) | (1L << (BOTH - 41)) | (1L << (BY - 41)) | (1L << (CASE - 41)) | (1L << (CAST - 41)) | (1L << (COLLATE - 41)) | (1L << (COUNT - 41)) | (1L << (CROSS - 41)) | (1L << (CUBE - 41)) | (1L << (CURRENT - 41)) | (1L << (CURRENT_DATE - 41)) | (1L << (CURRENT_INSTANT - 41)) | (1L << (CURRENT_TIME - 41)) | (1L << (CURRENT_TIMESTAMP - 41)) | (1L << (DATE - 41)) | (1L << (DATETIME - 41)) | (1L << (DAY - 41)) | (1L << (DELETE - 41)) | (1L << (DESC - 41)) | (1L << (DISTINCT - 41)) | (1L << (ELEMENT - 41)) | (1L << (ELEMENTS - 41)) | (1L << (ELSE - 41)) | (1L << (EMPTY - 41)) | (1L << (END - 41)) | (1L << (ENTRY - 41)) | (1L << (ERROR - 41)) | (1L << (ESCAPE - 41)) | (1L << (EVERY - 41)) | (1L << (EXCEPT - 41)) | (1L << (EXCLUDE - 41)) | (1L << (EXISTS - 41)) | (1L << (EXTRACT - 41)) | (1L << (FETCH - 41)) | (1L << (FILTER - 41)) | (1L << (FIRST - 41)) | (1L << (FOLLOWING - 41)) | (1L << (FOR - 41)) | (1L << (FORMAT - 41)) | (1L << (FROM - 41)) | (1L << (FUNCTION - 41)) | (1L << (GROUP - 41)) | (1L << (GROUPS - 41)) | (1L << (HAVING - 41)) | (1L << (HOUR - 41)) | (1L << (IGNORE - 41)) | (1L << (ILIKE - 41)) | (1L << (IN - 41)) | (1L << (INDEX - 41)) | (1L << (INDICES - 41)) | (1L << (INSERT - 41)))) != 0) || ((((_la - 105)) & ~0x3f) == 0 && ((1L << (_la - 105)) & ((1L << (INSTANT - 105)) | (1L << (INTERSECT - 105)) | (1L << (INTO - 105)) | (1L << (IS - 105)) | (1L << (JOIN - 105)) | (1L << (KEY - 105)) | (1L << (LAST - 105)) | (1L << (LEADING - 105)) | (1L << (LIKE - 105)) | (1L << (LIMIT - 105)) | (1L << (LIST - 105)) | (1L << (LISTAGG - 105)) | (1L << (LOCAL - 105)) | (1L << (LOCAL_DATE - 105)) | (1L << (LOCAL_DATETIME - 105)) | (1L << (LOCAL_TIME - 105)) | (1L << (MAP - 105)) | (1L << (MAX - 105)) | (1L << (MAXELEMENT - 105)) | (1L << (MAXINDEX - 105)) | (1L << (MEMBER - 105)) | (1L << (MICROSECOND - 105)) | (1L << (MILLISECOND - 105)) | (1L << (MIN - 105)) | (1L << (MINELEMENT - 105)) | (1L << (MININDEX - 105)) | (1L << (MINUTE - 105)) | (1L << (MONTH - 105)) | (1L << (NANOSECOND - 105)) | (1L << (NEW - 105)) | (1L << (NEXT - 105)) | (1L << (NO - 105)) | (1L << (NOT - 105)) | (1L << (NULLS - 105)) | (1L << (OBJECT - 105)) | (1L << (OF - 105)) | (1L << (OFFSET - 105)) | (1L << (OFFSET_DATETIME - 105)) | (1L << (ON - 105)) | (1L << (ONLY - 105)) | (1L << (OR - 105)) | (1L << (ORDER - 105)) | (1L << (OTHERS - 105)) | (1L << (OVER - 105)) | (1L << (OVERFLOW - 105)) | (1L << (OVERLAY - 105)) | (1L << (PAD - 105)) | (1L << (PARTITION - 105)) | (1L << (PERCENT - 105)) | (1L << (PLACING - 105)) | (1L << (POSITION - 105)) | (1L << (PRECEDING - 105)) | (1L << (QUARTER - 105)) | (1L << (RANGE - 105)) | (1L << (RESPECT - 105)) | (1L << (ROLLUP - 105)) | (1L << (ROW - 105)) | (1L << (ROWS - 105)) | (1L << (SECOND - 105)) | (1L << (SELECT - 105)) | (1L << (SET - 105)))) != 0) || ((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & ((1L << (SIZE - 169)) | (1L << (SOME - 169)) | (1L << (SUBSTRING - 169)) | (1L << (SUM - 169)) | (1L << (THEN - 169)) | (1L << (TIES - 169)) | (1L << (TIME - 169)) | (1L << (TIMESTAMP - 169)) | (1L << (TIMEZONE_HOUR - 169)) | (1L << (TIMEZONE_MINUTE - 169)) | (1L << (TRAILING - 169)) | (1L << (TREAT - 169)) | (1L << (TRIM - 169)) | (1L << (TRUNCATE - 169)) | (1L << (TYPE - 169)) | (1L << (UNBOUNDED - 169)) | (1L << (UNION - 169)) | (1L << (UPDATE - 169)) | (1L << (VALUE - 169)) | (1L << (VALUES - 169)) | (1L << (WEEK - 169)) | (1L << (WHEN - 169)) | (1L << (WHERE - 169)) | (1L << (WITH - 169)) | (1L << (WITHIN - 169)) | (1L << (WITHOUT - 169)) | (1L << (YEAR - 169)) | (1L << (IDENTIFIER - 169)) | (1L << (QUOTED_IDENTIFIER - 169)))) != 0)) {
				{
				setState(651);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentExpressionContext extends ParserRuleContext {
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public InstantiationArgumentExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgumentExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgumentExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgumentExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgumentExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentExpressionContext instantiationArgumentExpression() throws RecognitionException {
		InstantiationArgumentExpressionContext _localctx = new InstantiationArgumentExpressionContext(_ctx, getState());
		enterRule(_localctx, 74, RULE_instantiationArgumentExpression);
		try {
			setState(656);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,55,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(654);
				expressionOrPredicate();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(655);
				instantiation();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaSelectObjectSyntaxContext extends ParserRuleContext {
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public JpaSelectObjectSyntaxContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaSelectObjectSyntax; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaSelectObjectSyntax(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaSelectObjectSyntax(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaSelectObjectSyntax(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() throws RecognitionException {
		JpaSelectObjectSyntaxContext _localctx = new JpaSelectObjectSyntaxContext(_ctx, getState());
		enterRule(_localctx, 76, RULE_jpaSelectObjectSyntax);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(658);
			match(OBJECT);
			setState(659);
			match(LEFT_PAREN);
			setState(660);
			identifier();
			setState(661);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public List<SimplePathElementContext> simplePathElement() {
			return getRuleContexts(SimplePathElementContext.class);
		}
		public SimplePathElementContext simplePathElement(int i) {
			return getRuleContext(SimplePathElementContext.class,i);
		}
		public SimplePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathContext simplePath() throws RecognitionException {
		SimplePathContext _localctx = new SimplePathContext(_ctx, getState());
		enterRule(_localctx, 78, RULE_simplePath);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(663);
			identifier();
			setState(667);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,56,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					{
					setState(664);
					simplePathElement();
					}
					} 
				}
				setState(669);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,56,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathElementContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SimplePathElementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePathElement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePathElement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePathElement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePathElement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathElementContext simplePathElement() throws RecognitionException {
		SimplePathElementContext _localctx = new SimplePathElementContext(_ctx, getState());
		enterRule(_localctx, 80, RULE_simplePathElement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(670);
			match(DOT);
			setState(671);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContext extends ParserRuleContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public PathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_path; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContext path() throws RecognitionException {
		PathContext _localctx = new PathContext(_ctx, getState());
		enterRule(_localctx, 82, RULE_path);
		try {
			setState(678);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,58,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(673);
				syntacticDomainPath();
				setState(675);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,57,_ctx) ) {
				case 1:
					{
					setState(674);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(677);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContinuationContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public PathContinuationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_pathContinuation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPathContinuation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPathContinuation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPathContinuation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContinuationContext pathContinuation() throws RecognitionException {
		PathContinuationContext _localctx = new PathContinuationContext(_ctx, getState());
		enterRule(_localctx, 84, RULE_pathContinuation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(680);
			match(DOT);
			setState(681);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SyntacticDomainPathContext extends ParserRuleContext {
		public TreatedNavigablePathContext treatedNavigablePath() {
			return getRuleContext(TreatedNavigablePathContext.class,0);
		}
		public CollectionValueNavigablePathContext collectionValueNavigablePath() {
			return getRuleContext(CollectionValueNavigablePathContext.class,0);
		}
		public MapKeyNavigablePathContext mapKeyNavigablePath() {
			return getRuleContext(MapKeyNavigablePathContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public SyntacticDomainPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_syntacticDomainPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticDomainPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticDomainPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticDomainPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SyntacticDomainPathContext syntacticDomainPath() throws RecognitionException {
		SyntacticDomainPathContext _localctx = new SyntacticDomainPathContext(_ctx, getState());
		enterRule(_localctx, 86, RULE_syntacticDomainPath);
		try {
			setState(689);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,59,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(683);
				treatedNavigablePath();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(684);
				collectionValueNavigablePath();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(685);
				mapKeyNavigablePath();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(686);
				simplePath();
				setState(687);
				indexedPathAccessFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralPathFragmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public GeneralPathFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalPathFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralPathFragmentContext generalPathFragment() throws RecognitionException {
		GeneralPathFragmentContext _localctx = new GeneralPathFragmentContext(_ctx, getState());
		enterRule(_localctx, 88, RULE_generalPathFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(691);
			simplePath();
			setState(693);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,60,_ctx) ) {
			case 1:
				{
				setState(692);
				indexedPathAccessFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public IndexedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexedPathAccessFragmentContext indexedPathAccessFragment() throws RecognitionException {
		IndexedPathAccessFragmentContext _localctx = new IndexedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 90, RULE_indexedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(695);
			match(LEFT_BRACKET);
			setState(696);
			expression(0);
			setState(697);
			match(RIGHT_BRACKET);
			setState(700);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,61,_ctx) ) {
			case 1:
				{
				setState(698);
				match(DOT);
				setState(699);
				generalPathFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TreatedNavigablePathContext extends ParserRuleContext {
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public TreatedNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_treatedNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTreatedNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTreatedNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTreatedNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TreatedNavigablePathContext treatedNavigablePath() throws RecognitionException {
		TreatedNavigablePathContext _localctx = new TreatedNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 92, RULE_treatedNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(702);
			match(TREAT);
			setState(703);
			match(LEFT_PAREN);
			setState(704);
			path();
			setState(705);
			match(AS);
			setState(706);
			simplePath();
			setState(707);
			match(RIGHT_PAREN);
			setState(709);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,62,_ctx) ) {
			case 1:
				{
				setState(708);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionValueNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public CollectionValueNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionValueNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionValueNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionValueNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionValueNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionValueNavigablePathContext collectionValueNavigablePath() throws RecognitionException {
		CollectionValueNavigablePathContext _localctx = new CollectionValueNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 94, RULE_collectionValueNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(711);
			_la = _input.LA(1);
			if ( !(_la==ELEMENT || _la==VALUE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(712);
			match(LEFT_PAREN);
			setState(713);
			path();
			setState(714);
			match(RIGHT_PAREN);
			setState(716);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,63,_ctx) ) {
			case 1:
				{
				setState(715);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapKeyNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public MapKeyNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapKeyNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapKeyNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapKeyNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapKeyNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapKeyNavigablePathContext mapKeyNavigablePath() throws RecognitionException {
		MapKeyNavigablePathContext _localctx = new MapKeyNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 96, RULE_mapKeyNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(718);
			_la = _input.LA(1);
			if ( !(_la==INDEX || _la==KEY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(719);
			match(LEFT_PAREN);
			setState(720);
			path();
			setState(721);
			match(RIGHT_PAREN);
			setState(723);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,64,_ctx) ) {
			case 1:
				{
				setState(722);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByClauseContext extends ParserRuleContext {
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<GroupByExpressionContext> groupByExpression() {
			return getRuleContexts(GroupByExpressionContext.class);
		}
		public GroupByExpressionContext groupByExpression(int i) {
			return getRuleContext(GroupByExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GroupByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByClauseContext groupByClause() throws RecognitionException {
		GroupByClauseContext _localctx = new GroupByClauseContext(_ctx, getState());
		enterRule(_localctx, 98, RULE_groupByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(725);
			match(GROUP);
			setState(726);
			match(BY);
			setState(727);
			groupByExpression();
			setState(732);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(728);
				match(COMMA);
				setState(729);
				groupByExpression();
				}
				}
				setState(734);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByExpressionContext groupByExpression() throws RecognitionException {
		GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
		enterRule(_localctx, 100, RULE_groupByExpression);
		try {
			setState(738);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,66,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(735);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(736);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(737);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HavingClauseContext extends ParserRuleContext {
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public HavingClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_havingClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHavingClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHavingClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHavingClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HavingClauseContext havingClause() throws RecognitionException {
		HavingClauseContext _localctx = new HavingClauseContext(_ctx, getState());
		enterRule(_localctx, 102, RULE_havingClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(740);
			match(HAVING);
			setState(741);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByClauseContext extends ParserRuleContext {
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByClauseContext orderByClause() throws RecognitionException {
		OrderByClauseContext _localctx = new OrderByClauseContext(_ctx, getState());
		enterRule(_localctx, 104, RULE_orderByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(743);
			match(ORDER);
			setState(744);
			match(BY);
			setState(745);
			sortSpecification();
			setState(750);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(746);
				match(COMMA);
				setState(747);
				sortSpecification();
				}
				}
				setState(752);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 106, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(753);
			sortSpecification();
			setState(758);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(754);
				match(COMMA);
				setState(755);
				sortSpecification();
				}
				}
				setState(760);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortSpecificationContext extends ParserRuleContext {
		public SortExpressionContext sortExpression() {
			return getRuleContext(SortExpressionContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 108, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(761);
			sortExpression();
			setState(763);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(762);
				sortDirection();
				}
			}

			setState(766);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(765);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 110, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(768);
			match(NULLS);
			setState(769);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SortExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortExpressionContext sortExpression() throws RecognitionException {
		SortExpressionContext _localctx = new SortExpressionContext(_ctx, getState());
		enterRule(_localctx, 112, RULE_sortExpression);
		try {
			setState(774);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,71,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(771);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(772);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(773);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortDirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public SortDirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortDirection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortDirectionContext sortDirection() throws RecognitionException {
		SortDirectionContext _localctx = new SortDirectionContext(_ctx, getState());
		enterRule(_localctx, 114, RULE_sortDirection);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(776);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollateFunctionContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CollationContext collation() {
			return getRuleContext(CollationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollateFunctionContext collateFunction() throws RecognitionException {
		CollateFunctionContext _localctx = new CollateFunctionContext(_ctx, getState());
		enterRule(_localctx, 116, RULE_collateFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(778);
			match(COLLATE);
			setState(779);
			match(LEFT_PAREN);
			setState(780);
			expression(0);
			setState(781);
			match(AS);
			setState(782);
			collation();
			setState(783);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollationContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public CollationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationContext collation() throws RecognitionException {
		CollationContext _localctx = new CollationContext(_ctx, getState());
		enterRule(_localctx, 118, RULE_collation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(785);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LimitClauseContext extends ParserRuleContext {
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public LimitClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_limitClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLimitClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLimitClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLimitClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LimitClauseContext limitClause() throws RecognitionException {
		LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
		enterRule(_localctx, 120, RULE_limitClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(787);
			match(LIMIT);
			setState(788);
			parameterOrIntegerLiteral();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetClauseContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetClauseContext offsetClause() throws RecognitionException {
		OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
		enterRule(_localctx, 122, RULE_offsetClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(790);
			match(OFFSET);
			setState(791);
			parameterOrIntegerLiteral();
			setState(793);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ROW || _la==ROWS) {
				{
				setState(792);
				_la = _input.LA(1);
				if ( !(_la==ROW || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FetchClauseContext extends ParserRuleContext {
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public ParameterOrNumberLiteralContext parameterOrNumberLiteral() {
			return getRuleContext(ParameterOrNumberLiteralContext.class,0);
		}
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public FetchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchClauseContext fetchClause() throws RecognitionException {
		FetchClauseContext _localctx = new FetchClauseContext(_ctx, getState());
		enterRule(_localctx, 124, RULE_fetchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(795);
			match(FETCH);
			setState(796);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==NEXT) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(801);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,73,_ctx) ) {
			case 1:
				{
				setState(797);
				parameterOrIntegerLiteral();
				}
				break;
			case 2:
				{
				setState(798);
				parameterOrNumberLiteral();
				setState(799);
				match(PERCENT);
				}
				break;
			}
			setState(803);
			_la = _input.LA(1);
			if ( !(_la==ROW || _la==ROWS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(807);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ONLY:
				{
				setState(804);
				match(ONLY);
				}
				break;
			case WITH:
				{
				setState(805);
				match(WITH);
				setState(806);
				match(TIES);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrIntegerLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ParameterOrIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrIntegerLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrIntegerLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrIntegerLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrIntegerLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() throws RecognitionException {
		ParameterOrIntegerLiteralContext _localctx = new ParameterOrIntegerLiteralContext(_ctx, getState());
		enterRule(_localctx, 126, RULE_parameterOrIntegerLiteral);
		try {
			setState(811);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(809);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(810);
				match(INTEGER_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrNumberLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public ParameterOrNumberLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrNumberLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrNumberLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrNumberLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrNumberLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrNumberLiteralContext parameterOrNumberLiteral() throws RecognitionException {
		ParameterOrNumberLiteralContext _localctx = new ParameterOrNumberLiteralContext(_ctx, getState());
		enterRule(_localctx, 128, RULE_parameterOrNumberLiteral);
		try {
			setState(817);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(813);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(814);
				match(INTEGER_LITERAL);
				}
				break;
			case FLOAT_LITERAL:
				enterOuterAlt(_localctx, 3);
				{
				setState(815);
				match(FLOAT_LITERAL);
				}
				break;
			case DOUBLE_LITERAL:
				enterOuterAlt(_localctx, 4);
				{
				setState(816);
				match(DOUBLE_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WhereClauseContext extends ParserRuleContext {
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public WhereClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_whereClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWhereClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWhereClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWhereClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WhereClauseContext whereClause() throws RecognitionException {
		WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
		enterRule(_localctx, 130, RULE_whereClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(819);
			match(WHERE);
			setState(820);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PredicateContext extends ParserRuleContext {
		public PredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_predicate; }
	 
		public PredicateContext() { }
		public void copyFrom(PredicateContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class BetweenPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public BetweenPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBetweenPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBetweenPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBetweenPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ExistsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class AndPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public AndPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAndPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAndPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAndPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedPredicateContext extends PredicateContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LikePredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public LikeEscapeContext likeEscape() {
			return getRuleContext(LikeEscapeContext.class,0);
		}
		public LikePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class InPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public InListContext inList() {
			return getRuleContext(InListContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public InPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ComparisonPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public ComparisonOperatorContext comparisonOperator() {
			return getRuleContext(ComparisonOperatorContext.class,0);
		}
		public ComparisonPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsCollectionPartPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public ExistsCollectionPartPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsCollectionPartPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsCollectionPartPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsCollectionPartPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NegatedPredicateContext extends PredicateContext {
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public NegatedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNegatedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNegatedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNegatedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BooleanExpressionPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public BooleanExpressionPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanExpressionPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanExpressionPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanExpressionPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class OrPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public OrPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MemberOfPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public MemberOfPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMemberOfPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMemberOfPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMemberOfPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsEmptyPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsEmptyPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsEmptyPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsEmptyPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsEmptyPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsNullPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsNullPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsNullPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsNullPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsNullPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PredicateContext predicate() throws RecognitionException {
		return predicate(0);
	}

	private PredicateContext predicate(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		PredicateContext _localctx = new PredicateContext(_ctx, _parentState);
		PredicateContext _prevctx = _localctx;
		int _startState = 132;
		enterRecursionRule(_localctx, 132, RULE_predicate, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(891);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,85,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(823);
				match(LEFT_PAREN);
				setState(824);
				predicate(0);
				setState(825);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new IsNullPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(827);
				expression(0);
				setState(828);
				match(IS);
				setState(830);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(829);
					match(NOT);
					}
				}

				setState(832);
				match(NULL);
				}
				break;
			case 3:
				{
				_localctx = new IsEmptyPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(834);
				expression(0);
				setState(835);
				match(IS);
				setState(837);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(836);
					match(NOT);
					}
				}

				setState(839);
				match(EMPTY);
				}
				break;
			case 4:
				{
				_localctx = new InPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(841);
				expression(0);
				setState(843);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(842);
					match(NOT);
					}
				}

				setState(845);
				match(IN);
				setState(846);
				inList();
				}
				break;
			case 5:
				{
				_localctx = new BetweenPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(848);
				expression(0);
				setState(850);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(849);
					match(NOT);
					}
				}

				setState(852);
				match(BETWEEN);
				setState(853);
				expression(0);
				setState(854);
				match(AND);
				setState(855);
				expression(0);
				}
				break;
			case 6:
				{
				_localctx = new LikePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(857);
				expression(0);
				setState(859);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(858);
					match(NOT);
					}
				}

				setState(861);
				_la = _input.LA(1);
				if ( !(_la==ILIKE || _la==LIKE) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(862);
				expression(0);
				setState(864);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,82,_ctx) ) {
				case 1:
					{
					setState(863);
					likeEscape();
					}
					break;
				}
				}
				break;
			case 7:
				{
				_localctx = new ComparisonPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(866);
				expression(0);
				setState(867);
				comparisonOperator();
				setState(868);
				expression(0);
				}
				break;
			case 8:
				{
				_localctx = new ExistsCollectionPartPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(870);
				match(EXISTS);
				setState(871);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(872);
				match(LEFT_PAREN);
				setState(873);
				simplePath();
				setState(874);
				match(RIGHT_PAREN);
				}
				break;
			case 9:
				{
				_localctx = new ExistsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(876);
				match(EXISTS);
				setState(877);
				expression(0);
				}
				break;
			case 10:
				{
				_localctx = new MemberOfPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(878);
				expression(0);
				setState(880);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(879);
					match(NOT);
					}
				}

				setState(882);
				match(MEMBER);
				setState(884);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,84,_ctx) ) {
				case 1:
					{
					setState(883);
					match(OF);
					}
					break;
				}
				setState(886);
				path();
				}
				break;
			case 11:
				{
				_localctx = new NegatedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(888);
				match(NOT);
				setState(889);
				predicate(4);
				}
				break;
			case 12:
				{
				_localctx = new BooleanExpressionPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(890);
				expression(0);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(901);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,87,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(899);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,86,_ctx) ) {
					case 1:
						{
						_localctx = new AndPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(893);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(894);
						match(AND);
						setState(895);
						predicate(4);
						}
						break;
					case 2:
						{
						_localctx = new OrPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(896);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(897);
						match(OR);
						setState(898);
						predicate(3);
						}
						break;
					}
					} 
				}
				setState(903);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,87,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class ComparisonOperatorContext extends ParserRuleContext {
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public TerminalNode NOT_EQUAL() { return getToken(HqlParser.NOT_EQUAL, 0); }
		public TerminalNode GREATER() { return getToken(HqlParser.GREATER, 0); }
		public TerminalNode GREATER_EQUAL() { return getToken(HqlParser.GREATER_EQUAL, 0); }
		public TerminalNode LESS() { return getToken(HqlParser.LESS, 0); }
		public TerminalNode LESS_EQUAL() { return getToken(HqlParser.LESS_EQUAL, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public ComparisonOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_comparisonOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ComparisonOperatorContext comparisonOperator() throws RecognitionException {
		ComparisonOperatorContext _localctx = new ComparisonOperatorContext(_ctx, getState());
		enterRule(_localctx, 134, RULE_comparisonOperator);
		try {
			setState(917);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,88,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(904);
				match(EQUAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(905);
				match(NOT_EQUAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(906);
				match(GREATER);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(907);
				match(GREATER_EQUAL);
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(908);
				match(LESS);
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(909);
				match(LESS_EQUAL);
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(910);
				match(IS);
				setState(911);
				match(DISTINCT);
				setState(912);
				match(FROM);
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(913);
				match(IS);
				setState(914);
				match(NOT);
				setState(915);
				match(DISTINCT);
				setState(916);
				match(FROM);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InListContext extends ParserRuleContext {
		public InListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_inList; }
	 
		public InListContext() { }
		public void copyFrom(InListContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SubqueryInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PersistentCollectionReferenceInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public PersistentCollectionReferenceInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPersistentCollectionReferenceInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPersistentCollectionReferenceInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPersistentCollectionReferenceInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParamInListContext extends InListContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParamInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParamInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParamInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParamInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExplicitTupleInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ExplicitTupleInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExplicitTupleInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExplicitTupleInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExplicitTupleInList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InListContext inList() throws RecognitionException {
		InListContext _localctx = new InListContext(_ctx, getState());
		enterRule(_localctx, 136, RULE_inList);
		int _la;
		try {
			setState(941);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,91,_ctx) ) {
			case 1:
				_localctx = new PersistentCollectionReferenceInListContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(919);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(920);
				match(LEFT_PAREN);
				setState(921);
				simplePath();
				setState(922);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new ExplicitTupleInListContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(924);
				match(LEFT_PAREN);
				setState(933);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if ((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL) | (1L << STRING_LITERAL) | (1L << BINARY_LITERAL) | (1L << TIMESTAMP_ESCAPE_START) | (1L << DATE_ESCAPE_START) | (1L << TIME_ESCAPE_START) | (1L << LEFT_PAREN) | (1L << LEFT_BRACE) | (1L << PLUS) | (1L << MINUS) | (1L << COLON) | (1L << QUESTION_MARK) | (1L << ID) | (1L << VERSION) | (1L << VERSIONED) | (1L << NATURALID) | (1L << FK) | (1L << ALL) | (1L << AND) | (1L << ANY) | (1L << AS) | (1L << ASC) | (1L << AVG) | (1L << BETWEEN) | (1L << BOTH) | (1L << BY) | (1L << CASE) | (1L << CAST) | (1L << COLLATE) | (1L << COUNT) | (1L << CROSS) | (1L << CUBE) | (1L << CURRENT) | (1L << CURRENT_DATE) | (1L << CURRENT_INSTANT))) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & ((1L << (CURRENT_TIME - 64)) | (1L << (CURRENT_TIMESTAMP - 64)) | (1L << (DATE - 64)) | (1L << (DATETIME - 64)) | (1L << (DAY - 64)) | (1L << (DELETE - 64)) | (1L << (DESC - 64)) | (1L << (DISTINCT - 64)) | (1L << (ELEMENT - 64)) | (1L << (ELEMENTS - 64)) | (1L << (ELSE - 64)) | (1L << (EMPTY - 64)) | (1L << (END - 64)) | (1L << (ENTRY - 64)) | (1L << (ERROR - 64)) | (1L << (ESCAPE - 64)) | (1L << (EVERY - 64)) | (1L << (EXCEPT - 64)) | (1L << (EXCLUDE - 64)) | (1L << (EXISTS - 64)) | (1L << (EXTRACT - 64)) | (1L << (FETCH - 64)) | (1L << (FILTER - 64)) | (1L << (FIRST - 64)) | (1L << (FOLLOWING - 64)) | (1L << (FOR - 64)) | (1L << (FORMAT - 64)) | (1L << (FROM - 64)) | (1L << (FULL - 64)) | (1L << (FUNCTION - 64)) | (1L << (GROUP - 64)) | (1L << (GROUPS - 64)) | (1L << (HAVING - 64)) | (1L << (HOUR - 64)) | (1L << (IGNORE - 64)) | (1L << (ILIKE - 64)) | (1L << (IN - 64)) | (1L << (INDEX - 64)) | (1L << (INDICES - 64)) | (1L << (INNER - 64)) | (1L << (INSERT - 64)) | (1L << (INSTANT - 64)) | (1L << (INTERSECT - 64)) | (1L << (INTO - 64)) | (1L << (IS - 64)) | (1L << (JOIN - 64)) | (1L << (KEY - 64)) | (1L << (LAST - 64)) | (1L << (LEADING - 64)) | (1L << (LEFT - 64)) | (1L << (LIKE - 64)) | (1L << (LIMIT - 64)) | (1L << (LIST - 64)) | (1L << (LISTAGG - 64)) | (1L << (LOCAL - 64)) | (1L << (LOCAL_DATE - 64)) | (1L << (LOCAL_DATETIME - 64)) | (1L << (LOCAL_TIME - 64)) | (1L << (MAP - 64)) | (1L << (MAX - 64)) | (1L << (MAXELEMENT - 64)) | (1L << (MAXINDEX - 64)) | (1L << (MEMBER - 64)) | (1L << (MICROSECOND - 64)))) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & ((1L << (MILLISECOND - 128)) | (1L << (MIN - 128)) | (1L << (MINELEMENT - 128)) | (1L << (MININDEX - 128)) | (1L << (MINUTE - 128)) | (1L << (MONTH - 128)) | (1L << (NANOSECOND - 128)) | (1L << (NEW - 128)) | (1L << (NEXT - 128)) | (1L << (NO - 128)) | (1L << (NOT - 128)) | (1L << (NULLS - 128)) | (1L << (OBJECT - 128)) | (1L << (OF - 128)) | (1L << (OFFSET - 128)) | (1L << (OFFSET_DATETIME - 128)) | (1L << (ON - 128)) | (1L << (ONLY - 128)) | (1L << (OR - 128)) | (1L << (ORDER - 128)) | (1L << (OTHERS - 128)) | (1L << (OUTER - 128)) | (1L << (OVER - 128)) | (1L << (OVERFLOW - 128)) | (1L << (OVERLAY - 128)) | (1L << (PAD - 128)) | (1L << (PARTITION - 128)) | (1L << (PERCENT - 128)) | (1L << (PLACING - 128)) | (1L << (POSITION - 128)) | (1L << (PRECEDING - 128)) | (1L << (QUARTER - 128)) | (1L << (RANGE - 128)) | (1L << (RESPECT - 128)) | (1L << (RIGHT - 128)) | (1L << (ROLLUP - 128)) | (1L << (ROW - 128)) | (1L << (ROWS - 128)) | (1L << (SECOND - 128)) | (1L << (SELECT - 128)) | (1L << (SET - 128)) | (1L << (SIZE - 128)) | (1L << (SOME - 128)) | (1L << (SUBSTRING - 128)) | (1L << (SUM - 128)) | (1L << (THEN - 128)) | (1L << (TIES - 128)) | (1L << (TIME - 128)) | (1L << (TIMESTAMP - 128)) | (1L << (TIMEZONE_HOUR - 128)) | (1L << (TIMEZONE_MINUTE - 128)) | (1L << (TRAILING - 128)) | (1L << (TREAT - 128)) | (1L << (TRIM - 128)) | (1L << (TRUNCATE - 128)) | (1L << (TYPE - 128)) | (1L << (UNBOUNDED - 128)) | (1L << (UNION - 128)) | (1L << (UPDATE - 128)) | (1L << (VALUE - 128)) | (1L << (VALUES - 128)) | (1L << (WEEK - 128)) | (1L << (WHEN - 128)) | (1L << (WHERE - 128)))) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & ((1L << (WITH - 192)) | (1L << (WITHIN - 192)) | (1L << (WITHOUT - 192)) | (1L << (YEAR - 192)) | (1L << (TRUE - 192)) | (1L << (FALSE - 192)) | (1L << (NULL - 192)) | (1L << (IDENTIFIER - 192)) | (1L << (QUOTED_IDENTIFIER - 192)))) != 0)) {
					{
					setState(925);
					expressionOrPredicate();
					setState(930);
					_errHandler.sync(this);
					_la = _input.LA(1);
					while (_la==COMMA) {
						{
						{
						setState(926);
						match(COMMA);
						setState(927);
						expressionOrPredicate();
						}
						}
						setState(932);
						_errHandler.sync(this);
						_la = _input.LA(1);
					}
					}
				}

				setState(935);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new SubqueryInListContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(936);
				match(LEFT_PAREN);
				setState(937);
				subquery();
				setState(938);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new ParamInListContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(940);
				parameter();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LikeEscapeContext extends ParserRuleContext {
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public LikeEscapeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_likeEscape; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikeEscape(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikeEscape(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikeEscape(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LikeEscapeContext likeEscape() throws RecognitionException {
		LikeEscapeContext _localctx = new LikeEscapeContext(_ctx, getState());
		enterRule(_localctx, 138, RULE_likeEscape);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(943);
			match(ESCAPE);
			setState(946);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				{
				setState(944);
				match(STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(945);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class AdditionExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public AdditiveOperatorContext additiveOperator() {
			return getRuleContext(AdditiveOperatorContext.class,0);
		}
		public AdditionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class FromDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public FromDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BarePrimaryExpressionContext extends ExpressionContext {
		public PrimaryExpressionContext primaryExpression() {
			return getRuleContext(PrimaryExpressionContext.class,0);
		}
		public BarePrimaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBarePrimaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBarePrimaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBarePrimaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class TupleExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TupleExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTupleExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTupleExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTupleExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public UnaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ConcatenationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode DOUBLE_PIPE() { return getToken(HqlParser.DOUBLE_PIPE, 0); }
		public ConcatenationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConcatenationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConcatenationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConcatenationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MultiplicationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public MultiplicativeOperatorContext multiplicativeOperator() {
			return getRuleContext(MultiplicativeOperatorContext.class,0);
		}
		public MultiplicationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ToDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SubqueryExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryNumericLiteralExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public UnaryNumericLiteralExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryNumericLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryNumericLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryNumericLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		return expression(0);
	}

	private ExpressionContext expression(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		ExpressionContext _localctx = new ExpressionContext(_ctx, _parentState);
		ExpressionContext _prevctx = _localctx;
		int _startState = 140;
		enterRecursionRule(_localctx, 140, RULE_expression, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(974);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,94,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(949);
				match(LEFT_PAREN);
				setState(950);
				expression(0);
				setState(951);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new TupleExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(953);
				match(LEFT_PAREN);
				setState(954);
				expressionOrPredicate();
				setState(957); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(955);
					match(COMMA);
					setState(956);
					expressionOrPredicate();
					}
					}
					setState(959); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==COMMA );
				setState(961);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				{
				_localctx = new SubqueryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(963);
				match(LEFT_PAREN);
				setState(964);
				subquery();
				setState(965);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				{
				_localctx = new BarePrimaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(967);
				primaryExpression();
				}
				break;
			case 5:
				{
				_localctx = new UnaryNumericLiteralExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(968);
				signOperator();
				setState(969);
				numericLiteral();
				}
				break;
			case 6:
				{
				_localctx = new UnaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(971);
				signOperator();
				setState(972);
				expression(6);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(994);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,96,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(992);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,95,_ctx) ) {
					case 1:
						{
						_localctx = new MultiplicationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(976);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(977);
						multiplicativeOperator();
						setState(978);
						expression(4);
						}
						break;
					case 2:
						{
						_localctx = new AdditionExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(980);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(981);
						additiveOperator();
						setState(982);
						expression(3);
						}
						break;
					case 3:
						{
						_localctx = new ConcatenationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(984);
						if (!(precpred(_ctx, 1))) throw new FailedPredicateException(this, "precpred(_ctx, 1)");
						setState(985);
						match(DOUBLE_PIPE);
						setState(986);
						expression(2);
						}
						break;
					case 4:
						{
						_localctx = new ToDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(987);
						if (!(precpred(_ctx, 5))) throw new FailedPredicateException(this, "precpred(_ctx, 5)");
						setState(988);
						datetimeField();
						}
						break;
					case 5:
						{
						_localctx = new FromDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(989);
						if (!(precpred(_ctx, 4))) throw new FailedPredicateException(this, "precpred(_ctx, 4)");
						setState(990);
						match(BY);
						setState(991);
						datetimeField();
						}
						break;
					}
					} 
				}
				setState(996);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,96,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class PrimaryExpressionContext extends ParserRuleContext {
		public PrimaryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_primaryExpression; }
	 
		public PrimaryExpressionContext() { }
		public void copyFrom(PrimaryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class FunctionExpressionContext extends PrimaryExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LiteralExpressionContext extends PrimaryExpressionContext {
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public LiteralExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParameterExpressionContext extends PrimaryExpressionContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParameterExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityTypeExpressionContext extends PrimaryExpressionContext {
		public EntityTypeReferenceContext entityTypeReference() {
			return getRuleContext(EntityTypeReferenceContext.class,0);
		}
		public EntityTypeExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityIdExpressionContext extends PrimaryExpressionContext {
		public EntityIdReferenceContext entityIdReference() {
			return getRuleContext(EntityIdReferenceContext.class,0);
		}
		public EntityIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityVersionExpressionContext extends PrimaryExpressionContext {
		public EntityVersionReferenceContext entityVersionReference() {
			return getRuleContext(EntityVersionReferenceContext.class,0);
		}
		public EntityVersionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GeneralPathExpressionContext extends PrimaryExpressionContext {
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public GeneralPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityNaturalIdExpressionContext extends PrimaryExpressionContext {
		public EntityNaturalIdReferenceContext entityNaturalIdReference() {
			return getRuleContext(EntityNaturalIdReferenceContext.class,0);
		}
		public EntityNaturalIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class CaseExpressionContext extends PrimaryExpressionContext {
		public CaseListContext caseList() {
			return getRuleContext(CaseListContext.class,0);
		}
		public CaseExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToOneFkExpressionContext extends PrimaryExpressionContext {
		public ToOneFkReferenceContext toOneFkReference() {
			return getRuleContext(ToOneFkReferenceContext.class,0);
		}
		public ToOneFkExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SyntacticPathExpressionContext extends PrimaryExpressionContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PrimaryExpressionContext primaryExpression() throws RecognitionException {
		PrimaryExpressionContext _localctx = new PrimaryExpressionContext(_ctx, getState());
		enterRule(_localctx, 142, RULE_primaryExpression);
		try {
			setState(1011);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,98,_ctx) ) {
			case 1:
				_localctx = new CaseExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(997);
				caseList();
				}
				break;
			case 2:
				_localctx = new LiteralExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(998);
				literal();
				}
				break;
			case 3:
				_localctx = new ParameterExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(999);
				parameter();
				}
				break;
			case 4:
				_localctx = new EntityTypeExpressionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1000);
				entityTypeReference();
				}
				break;
			case 5:
				_localctx = new EntityIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1001);
				entityIdReference();
				}
				break;
			case 6:
				_localctx = new EntityVersionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 6);
				{
				setState(1002);
				entityVersionReference();
				}
				break;
			case 7:
				_localctx = new EntityNaturalIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 7);
				{
				setState(1003);
				entityNaturalIdReference();
				}
				break;
			case 8:
				_localctx = new ToOneFkExpressionContext(_localctx);
				enterOuterAlt(_localctx, 8);
				{
				setState(1004);
				toOneFkReference();
				}
				break;
			case 9:
				_localctx = new SyntacticPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 9);
				{
				setState(1005);
				syntacticDomainPath();
				setState(1007);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,97,_ctx) ) {
				case 1:
					{
					setState(1006);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 10:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 10);
				{
				setState(1009);
				function();
				}
				break;
			case 11:
				_localctx = new GeneralPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 11);
				{
				setState(1010);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionOrPredicateContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public ExpressionOrPredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expressionOrPredicate; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExpressionOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExpressionOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExpressionOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionOrPredicateContext expressionOrPredicate() throws RecognitionException {
		ExpressionOrPredicateContext _localctx = new ExpressionOrPredicateContext(_ctx, getState());
		enterRule(_localctx, 144, RULE_expressionOrPredicate);
		try {
			setState(1015);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,99,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1013);
				expression(0);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1014);
				predicate(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MultiplicativeOperatorContext extends ParserRuleContext {
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode PERCENT_OP() { return getToken(HqlParser.PERCENT_OP, 0); }
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public MultiplicativeOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_multiplicativeOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicativeOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicativeOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicativeOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MultiplicativeOperatorContext multiplicativeOperator() throws RecognitionException {
		MultiplicativeOperatorContext _localctx = new MultiplicativeOperatorContext(_ctx, getState());
		enterRule(_localctx, 146, RULE_multiplicativeOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1017);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << ASTERISK) | (1L << SLASH) | (1L << PERCENT_OP))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AdditiveOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public AdditiveOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_additiveOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditiveOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditiveOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditiveOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AdditiveOperatorContext additiveOperator() throws RecognitionException {
		AdditiveOperatorContext _localctx = new AdditiveOperatorContext(_ctx, getState());
		enterRule(_localctx, 148, RULE_additiveOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1019);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SignOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public SignOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_signOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSignOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSignOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSignOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SignOperatorContext signOperator() throws RecognitionException {
		SignOperatorContext _localctx = new SignOperatorContext(_ctx, getState());
		enterRule(_localctx, 150, RULE_signOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1021);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityTypeReferenceContext extends ParserRuleContext {
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public EntityTypeReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityTypeReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityTypeReferenceContext entityTypeReference() throws RecognitionException {
		EntityTypeReferenceContext _localctx = new EntityTypeReferenceContext(_ctx, getState());
		enterRule(_localctx, 152, RULE_entityTypeReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1023);
			match(TYPE);
			setState(1024);
			match(LEFT_PAREN);
			setState(1027);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1025);
				path();
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1026);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1029);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityIdReferenceContext extends ParserRuleContext {
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityIdReferenceContext entityIdReference() throws RecognitionException {
		EntityIdReferenceContext _localctx = new EntityIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 154, RULE_entityIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1031);
			match(ID);
			setState(1032);
			match(LEFT_PAREN);
			setState(1033);
			path();
			setState(1034);
			match(RIGHT_PAREN);
			setState(1036);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,101,_ctx) ) {
			case 1:
				{
				setState(1035);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityVersionReferenceContext extends ParserRuleContext {
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public EntityVersionReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityVersionReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityVersionReferenceContext entityVersionReference() throws RecognitionException {
		EntityVersionReferenceContext _localctx = new EntityVersionReferenceContext(_ctx, getState());
		enterRule(_localctx, 156, RULE_entityVersionReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1038);
			match(VERSION);
			setState(1039);
			match(LEFT_PAREN);
			setState(1040);
			path();
			setState(1041);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNaturalIdReferenceContext extends ParserRuleContext {
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityNaturalIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityNaturalIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNaturalIdReferenceContext entityNaturalIdReference() throws RecognitionException {
		EntityNaturalIdReferenceContext _localctx = new EntityNaturalIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 158, RULE_entityNaturalIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1043);
			match(NATURALID);
			setState(1044);
			match(LEFT_PAREN);
			setState(1045);
			path();
			setState(1046);
			match(RIGHT_PAREN);
			setState(1048);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,102,_ctx) ) {
			case 1:
				{
				setState(1047);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ToOneFkReferenceContext extends ParserRuleContext {
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ToOneFkReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_toOneFkReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ToOneFkReferenceContext toOneFkReference() throws RecognitionException {
		ToOneFkReferenceContext _localctx = new ToOneFkReferenceContext(_ctx, getState());
		enterRule(_localctx, 160, RULE_toOneFkReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1050);
			match(FK);
			setState(1051);
			match(LEFT_PAREN);
			setState(1052);
			path();
			setState(1053);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseListContext extends ParserRuleContext {
		public SimpleCaseListContext simpleCaseList() {
			return getRuleContext(SimpleCaseListContext.class,0);
		}
		public SearchedCaseListContext searchedCaseList() {
			return getRuleContext(SearchedCaseListContext.class,0);
		}
		public CaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseListContext caseList() throws RecognitionException {
		CaseListContext _localctx = new CaseListContext(_ctx, getState());
		enterRule(_localctx, 162, RULE_caseList);
		try {
			setState(1057);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,103,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1055);
				simpleCaseList();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1056);
				searchedCaseList();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SimpleCaseWhenContext> simpleCaseWhen() {
			return getRuleContexts(SimpleCaseWhenContext.class);
		}
		public SimpleCaseWhenContext simpleCaseWhen(int i) {
			return getRuleContext(SimpleCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SimpleCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseListContext simpleCaseList() throws RecognitionException {
		SimpleCaseListContext _localctx = new SimpleCaseListContext(_ctx, getState());
		enterRule(_localctx, 164, RULE_simpleCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1059);
			match(CASE);
			setState(1060);
			expressionOrPredicate();
			setState(1062); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1061);
				simpleCaseWhen();
				}
				}
				setState(1064); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1067);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1066);
				caseOtherwise();
				}
			}

			setState(1069);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SimpleCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseWhenContext simpleCaseWhen() throws RecognitionException {
		SimpleCaseWhenContext _localctx = new SimpleCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 166, RULE_simpleCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1071);
			match(WHEN);
			setState(1072);
			expression(0);
			setState(1073);
			match(THEN);
			setState(1074);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseOtherwiseContext extends ParserRuleContext {
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public CaseOtherwiseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseOtherwise; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseOtherwise(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseOtherwise(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseOtherwise(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseOtherwiseContext caseOtherwise() throws RecognitionException {
		CaseOtherwiseContext _localctx = new CaseOtherwiseContext(_ctx, getState());
		enterRule(_localctx, 168, RULE_caseOtherwise);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1076);
			match(ELSE);
			setState(1077);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SearchedCaseWhenContext> searchedCaseWhen() {
			return getRuleContexts(SearchedCaseWhenContext.class);
		}
		public SearchedCaseWhenContext searchedCaseWhen(int i) {
			return getRuleContext(SearchedCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SearchedCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseListContext searchedCaseList() throws RecognitionException {
		SearchedCaseListContext _localctx = new SearchedCaseListContext(_ctx, getState());
		enterRule(_localctx, 170, RULE_searchedCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1079);
			match(CASE);
			setState(1081); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1080);
				searchedCaseWhen();
				}
				}
				setState(1083); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1086);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1085);
				caseOtherwise();
				}
			}

			setState(1088);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SearchedCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseWhenContext searchedCaseWhen() throws RecognitionException {
		SearchedCaseWhenContext _localctx = new SearchedCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 172, RULE_searchedCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1090);
			match(WHEN);
			setState(1091);
			predicate(0);
			setState(1092);
			match(THEN);
			setState(1093);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public BooleanLiteralContext booleanLiteral() {
			return getRuleContext(BooleanLiteralContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public BinaryLiteralContext binaryLiteral() {
			return getRuleContext(BinaryLiteralContext.class,0);
		}
		public TemporalLiteralContext temporalLiteral() {
			return getRuleContext(TemporalLiteralContext.class,0);
		}
		public GeneralizedLiteralContext generalizedLiteral() {
			return getRuleContext(GeneralizedLiteralContext.class,0);
		}
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 174, RULE_literal);
		try {
			setState(1102);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,108,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1095);
				match(STRING_LITERAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1096);
				match(NULL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1097);
				booleanLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1098);
				numericLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1099);
				binaryLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1100);
				temporalLiteral();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1101);
				generalizedLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BooleanLiteralContext extends ParserRuleContext {
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public BooleanLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_booleanLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BooleanLiteralContext booleanLiteral() throws RecognitionException {
		BooleanLiteralContext _localctx = new BooleanLiteralContext(_ctx, getState());
		enterRule(_localctx, 176, RULE_booleanLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1104);
			_la = _input.LA(1);
			if ( !(_la==TRUE || _la==FALSE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NumericLiteralContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(HqlParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(HqlParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(HqlParser.HEX_LITERAL, 0); }
		public NumericLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_numericLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNumericLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNumericLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNumericLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NumericLiteralContext numericLiteral() throws RecognitionException {
		NumericLiteralContext _localctx = new NumericLiteralContext(_ctx, getState());
		enterRule(_localctx, 178, RULE_numericLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1106);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BinaryLiteralContext extends ParserRuleContext {
		public TerminalNode BINARY_LITERAL() { return getToken(HqlParser.BINARY_LITERAL, 0); }
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public List<TerminalNode> HEX_LITERAL() { return getTokens(HqlParser.HEX_LITERAL); }
		public TerminalNode HEX_LITERAL(int i) {
			return getToken(HqlParser.HEX_LITERAL, i);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public BinaryLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_binaryLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBinaryLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBinaryLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBinaryLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BinaryLiteralContext binaryLiteral() throws RecognitionException {
		BinaryLiteralContext _localctx = new BinaryLiteralContext(_ctx, getState());
		enterRule(_localctx, 180, RULE_binaryLiteral);
		int _la;
		try {
			setState(1119);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case BINARY_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1108);
				match(BINARY_LITERAL);
				}
				break;
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1109);
				match(LEFT_BRACE);
				setState(1110);
				match(HEX_LITERAL);
				setState(1115);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1111);
					match(COMMA);
					setState(1112);
					match(HEX_LITERAL);
					}
					}
					setState(1117);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(1118);
				match(RIGHT_BRACE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TemporalLiteralContext extends ParserRuleContext {
		public DateTimeLiteralContext dateTimeLiteral() {
			return getRuleContext(DateTimeLiteralContext.class,0);
		}
		public DateLiteralContext dateLiteral() {
			return getRuleContext(DateLiteralContext.class,0);
		}
		public TimeLiteralContext timeLiteral() {
			return getRuleContext(TimeLiteralContext.class,0);
		}
		public JdbcTimestampLiteralContext jdbcTimestampLiteral() {
			return getRuleContext(JdbcTimestampLiteralContext.class,0);
		}
		public JdbcDateLiteralContext jdbcDateLiteral() {
			return getRuleContext(JdbcDateLiteralContext.class,0);
		}
		public JdbcTimeLiteralContext jdbcTimeLiteral() {
			return getRuleContext(JdbcTimeLiteralContext.class,0);
		}
		public TemporalLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_temporalLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTemporalLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTemporalLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTemporalLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TemporalLiteralContext temporalLiteral() throws RecognitionException {
		TemporalLiteralContext _localctx = new TemporalLiteralContext(_ctx, getState());
		enterRule(_localctx, 182, RULE_temporalLiteral);
		try {
			setState(1127);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,111,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1121);
				dateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1122);
				dateLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1123);
				timeLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1124);
				jdbcTimestampLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1125);
				jdbcDateLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1126);
				jdbcTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public DateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeLiteralContext dateTimeLiteral() throws RecognitionException {
		DateTimeLiteralContext _localctx = new DateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 184, RULE_dateTimeLiteral);
		try {
			setState(1135);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1129);
				match(LEFT_BRACE);
				setState(1130);
				dateTime();
				setState(1131);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1133);
				match(DATETIME);
				setState(1134);
				dateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public DateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateLiteralContext dateLiteral() throws RecognitionException {
		DateLiteralContext _localctx = new DateLiteralContext(_ctx, getState());
		enterRule(_localctx, 186, RULE_dateLiteral);
		try {
			setState(1143);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1137);
				match(LEFT_BRACE);
				setState(1138);
				date();
				setState(1139);
				match(RIGHT_BRACE);
				}
				break;
			case DATE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1141);
				match(DATE);
				setState(1142);
				date();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeLiteralContext timeLiteral() throws RecognitionException {
		TimeLiteralContext _localctx = new TimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 188, RULE_timeLiteral);
		try {
			setState(1151);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1145);
				match(LEFT_BRACE);
				setState(1146);
				time();
				setState(1147);
				match(RIGHT_BRACE);
				}
				break;
			case TIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1149);
				match(TIME);
				setState(1150);
				time();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public ZoneIdContext zoneId() {
			return getRuleContext(ZoneIdContext.class,0);
		}
		public OffsetContext offset() {
			return getRuleContext(OffsetContext.class,0);
		}
		public DateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeContext dateTime() throws RecognitionException {
		DateTimeContext _localctx = new DateTimeContext(_ctx, getState());
		enterRule(_localctx, 190, RULE_dateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1153);
			date();
			setState(1154);
			time();
			setState(1157);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,115,_ctx) ) {
			case 1:
				{
				setState(1155);
				zoneId();
				}
				break;
			case 2:
				{
				setState(1156);
				offset();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateContext extends ParserRuleContext {
		public YearContext year() {
			return getRuleContext(YearContext.class,0);
		}
		public List<TerminalNode> MINUS() { return getTokens(HqlParser.MINUS); }
		public TerminalNode MINUS(int i) {
			return getToken(HqlParser.MINUS, i);
		}
		public MonthContext month() {
			return getRuleContext(MonthContext.class,0);
		}
		public DayContext day() {
			return getRuleContext(DayContext.class,0);
		}
		public DateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_date; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateContext date() throws RecognitionException {
		DateContext _localctx = new DateContext(_ctx, getState());
		enterRule(_localctx, 192, RULE_date);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1159);
			year();
			setState(1160);
			match(MINUS);
			setState(1161);
			month();
			setState(1162);
			match(MINUS);
			setState(1163);
			day();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public List<TerminalNode> COLON() { return getTokens(HqlParser.COLON); }
		public TerminalNode COLON(int i) {
			return getToken(HqlParser.COLON, i);
		}
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public SecondContext second() {
			return getRuleContext(SecondContext.class,0);
		}
		public TimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_time; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeContext time() throws RecognitionException {
		TimeContext _localctx = new TimeContext(_ctx, getState());
		enterRule(_localctx, 194, RULE_time);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1165);
			hour();
			setState(1166);
			match(COLON);
			setState(1167);
			minute();
			setState(1170);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,116,_ctx) ) {
			case 1:
				{
				setState(1168);
				match(COLON);
				setState(1169);
				second();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public OffsetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offset; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffset(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffset(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffset(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetContext offset() throws RecognitionException {
		OffsetContext _localctx = new OffsetContext(_ctx, getState());
		enterRule(_localctx, 196, RULE_offset);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1172);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1173);
			hour();
			setState(1176);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,117,_ctx) ) {
			case 1:
				{
				setState(1174);
				match(COLON);
				setState(1175);
				minute();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class YearContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public YearContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_year; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterYear(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitYear(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitYear(this);
			else return visitor.visitChildren(this);
		}
	}

	public final YearContext year() throws RecognitionException {
		YearContext _localctx = new YearContext(_ctx, getState());
		enterRule(_localctx, 198, RULE_year);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1178);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MonthContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MonthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_month; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMonth(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMonth(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMonth(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MonthContext month() throws RecognitionException {
		MonthContext _localctx = new MonthContext(_ctx, getState());
		enterRule(_localctx, 200, RULE_month);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1180);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public DayContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_day; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDay(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDay(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDay(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayContext day() throws RecognitionException {
		DayContext _localctx = new DayContext(_ctx, getState());
		enterRule(_localctx, 202, RULE_day);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1182);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HourContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public HourContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_hour; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHour(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHour(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHour(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HourContext hour() throws RecognitionException {
		HourContext _localctx = new HourContext(_ctx, getState());
		enterRule(_localctx, 204, RULE_hour);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1184);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MinuteContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MinuteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_minute; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMinute(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMinute(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMinute(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MinuteContext minute() throws RecognitionException {
		MinuteContext _localctx = new MinuteContext(_ctx, getState());
		enterRule(_localctx, 206, RULE_minute);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1186);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SecondContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public SecondContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_second; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSecond(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSecond(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSecond(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SecondContext second() throws RecognitionException {
		SecondContext _localctx = new SecondContext(_ctx, getState());
		enterRule(_localctx, 208, RULE_second);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1188);
			_la = _input.LA(1);
			if ( !(_la==INTEGER_LITERAL || _la==FLOAT_LITERAL) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ZoneIdContext extends ParserRuleContext {
		public List<TerminalNode> IDENTIFIER() { return getTokens(HqlParser.IDENTIFIER); }
		public TerminalNode IDENTIFIER(int i) {
			return getToken(HqlParser.IDENTIFIER, i);
		}
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ZoneIdContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zoneId; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZoneId(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZoneId(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZoneId(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZoneIdContext zoneId() throws RecognitionException {
		ZoneIdContext _localctx = new ZoneIdContext(_ctx, getState());
		enterRule(_localctx, 210, RULE_zoneId);
		try {
			setState(1196);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1190);
				match(IDENTIFIER);
				setState(1193);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,118,_ctx) ) {
				case 1:
					{
					setState(1191);
					match(SLASH);
					setState(1192);
					match(IDENTIFIER);
					}
					break;
				}
				}
				break;
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1195);
				match(STRING_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimestampLiteralContext extends ParserRuleContext {
		public TerminalNode TIMESTAMP_ESCAPE_START() { return getToken(HqlParser.TIMESTAMP_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimestampLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimestampLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimestampLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimestampLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimestampLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimestampLiteralContext jdbcTimestampLiteral() throws RecognitionException {
		JdbcTimestampLiteralContext _localctx = new JdbcTimestampLiteralContext(_ctx, getState());
		enterRule(_localctx, 212, RULE_jdbcTimestampLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1198);
			match(TIMESTAMP_ESCAPE_START);
			setState(1201);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1199);
				dateTime();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1200);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1203);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcDateLiteralContext extends ParserRuleContext {
		public TerminalNode DATE_ESCAPE_START() { return getToken(HqlParser.DATE_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcDateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcDateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcDateLiteralContext jdbcDateLiteral() throws RecognitionException {
		JdbcDateLiteralContext _localctx = new JdbcDateLiteralContext(_ctx, getState());
		enterRule(_localctx, 214, RULE_jdbcDateLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1205);
			match(DATE_ESCAPE_START);
			setState(1208);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1206);
				date();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1207);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1210);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimeLiteralContext extends ParserRuleContext {
		public TerminalNode TIME_ESCAPE_START() { return getToken(HqlParser.TIME_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimeLiteralContext jdbcTimeLiteral() throws RecognitionException {
		JdbcTimeLiteralContext _localctx = new JdbcTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 216, RULE_jdbcTimeLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1212);
			match(TIME_ESCAPE_START);
			setState(1215);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1213);
				time();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1214);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1217);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericTemporalLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GenericTemporalLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericTemporalLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericTemporalLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericTemporalLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericTemporalLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericTemporalLiteralTextContext genericTemporalLiteralText() throws RecognitionException {
		GenericTemporalLiteralTextContext _localctx = new GenericTemporalLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 218, RULE_genericTemporalLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1219);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public GeneralizedLiteralTypeContext generalizedLiteralType() {
			return getRuleContext(GeneralizedLiteralTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public GeneralizedLiteralTextContext generalizedLiteralText() {
			return getRuleContext(GeneralizedLiteralTextContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public GeneralizedLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralContext generalizedLiteral() throws RecognitionException {
		GeneralizedLiteralContext _localctx = new GeneralizedLiteralContext(_ctx, getState());
		enterRule(_localctx, 220, RULE_generalizedLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1221);
			match(LEFT_BRACE);
			setState(1222);
			generalizedLiteralType();
			setState(1223);
			match(COLON);
			setState(1224);
			generalizedLiteralText();
			setState(1225);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTypeContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTypeContext generalizedLiteralType() throws RecognitionException {
		GeneralizedLiteralTypeContext _localctx = new GeneralizedLiteralTypeContext(_ctx, getState());
		enterRule(_localctx, 222, RULE_generalizedLiteralType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1227);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTextContext generalizedLiteralText() throws RecognitionException {
		GeneralizedLiteralTextContext _localctx = new GeneralizedLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 224, RULE_generalizedLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1229);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterContext extends ParserRuleContext {
		public ParameterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameter; }
	 
		public ParameterContext() { }
		public void copyFrom(ParameterContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class NamedParameterContext extends ParameterContext {
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NamedParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNamedParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNamedParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNamedParameter(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PositionalParameterContext extends ParameterContext {
		public TerminalNode QUESTION_MARK() { return getToken(HqlParser.QUESTION_MARK, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public PositionalParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionalParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionalParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionalParameter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterContext parameter() throws RecognitionException {
		ParameterContext _localctx = new ParameterContext(_ctx, getState());
		enterRule(_localctx, 226, RULE_parameter);
		try {
			setState(1237);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
				_localctx = new NamedParameterContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1231);
				match(COLON);
				setState(1232);
				identifier();
				}
				break;
			case QUESTION_MARK:
				_localctx = new PositionalParameterContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1233);
				match(QUESTION_MARK);
				setState(1235);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,123,_ctx) ) {
				case 1:
					{
					setState(1234);
					match(INTEGER_LITERAL);
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionContext extends ParserRuleContext {
		public StandardFunctionContext standardFunction() {
			return getRuleContext(StandardFunctionContext.class,0);
		}
		public AggregateFunctionContext aggregateFunction() {
			return getRuleContext(AggregateFunctionContext.class,0);
		}
		public CollectionSizeFunctionContext collectionSizeFunction() {
			return getRuleContext(CollectionSizeFunctionContext.class,0);
		}
		public IndexAggregateFunctionContext indexAggregateFunction() {
			return getRuleContext(IndexAggregateFunctionContext.class,0);
		}
		public ElementAggregateFunctionContext elementAggregateFunction() {
			return getRuleContext(ElementAggregateFunctionContext.class,0);
		}
		public CollectionFunctionMisuseContext collectionFunctionMisuse() {
			return getRuleContext(CollectionFunctionMisuseContext.class,0);
		}
		public JpaNonstandardFunctionContext jpaNonstandardFunction() {
			return getRuleContext(JpaNonstandardFunctionContext.class,0);
		}
		public GenericFunctionContext genericFunction() {
			return getRuleContext(GenericFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 228, RULE_function);
		try {
			setState(1247);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,125,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1239);
				standardFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1240);
				aggregateFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1241);
				collectionSizeFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1242);
				indexAggregateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1243);
				elementAggregateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1244);
				collectionFunctionMisuse();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1245);
				jpaNonstandardFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1246);
				genericFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionContext extends ParserRuleContext {
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public JpaNonstandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionContext jpaNonstandardFunction() throws RecognitionException {
		JpaNonstandardFunctionContext _localctx = new JpaNonstandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 230, RULE_jpaNonstandardFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1249);
			match(FUNCTION);
			setState(1250);
			match(LEFT_PAREN);
			setState(1251);
			jpaNonstandardFunctionName();
			setState(1254);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(1252);
				match(COMMA);
				setState(1253);
				genericFunctionArguments();
				}
			}

			setState(1256);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionNameContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public JpaNonstandardFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() throws RecognitionException {
		JpaNonstandardFunctionNameContext _localctx = new JpaNonstandardFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 232, RULE_jpaNonstandardFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1258);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionContext extends ParserRuleContext {
		public GenericFunctionNameContext genericFunctionName() {
			return getRuleContext(GenericFunctionNameContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public NthSideClauseContext nthSideClause() {
			return getRuleContext(NthSideClauseContext.class,0);
		}
		public NullsClauseContext nullsClause() {
			return getRuleContext(NullsClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public GenericFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionContext genericFunction() throws RecognitionException {
		GenericFunctionContext _localctx = new GenericFunctionContext(_ctx, getState());
		enterRule(_localctx, 234, RULE_genericFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1260);
			genericFunctionName();
			setState(1261);
			match(LEFT_PAREN);
			setState(1264);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_INTEGER_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case HEX_LITERAL:
			case STRING_LITERAL:
			case BINARY_LITERAL:
			case TIMESTAMP_ESCAPE_START:
			case DATE_ESCAPE_START:
			case TIME_ESCAPE_START:
			case LEFT_PAREN:
			case LEFT_BRACE:
			case PLUS:
			case MINUS:
			case COLON:
			case QUESTION_MARK:
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case TRUE:
			case FALSE:
			case NULL:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1262);
				genericFunctionArguments();
				}
				break;
			case ASTERISK:
				{
				setState(1263);
				match(ASTERISK);
				}
				break;
			case RIGHT_PAREN:
				break;
			default:
				break;
			}
			setState(1266);
			match(RIGHT_PAREN);
			setState(1268);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,128,_ctx) ) {
			case 1:
				{
				setState(1267);
				nthSideClause();
				}
				break;
			}
			setState(1271);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,129,_ctx) ) {
			case 1:
				{
				setState(1270);
				nullsClause();
				}
				break;
			}
			setState(1274);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,130,_ctx) ) {
			case 1:
				{
				setState(1273);
				withinGroupClause();
				}
				break;
			}
			setState(1277);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,131,_ctx) ) {
			case 1:
				{
				setState(1276);
				filterClause();
				}
				break;
			}
			setState(1280);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,132,_ctx) ) {
			case 1:
				{
				setState(1279);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionNameContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public GenericFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionNameContext genericFunctionName() throws RecognitionException {
		GenericFunctionNameContext _localctx = new GenericFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 236, RULE_genericFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1282);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionArgumentsContext extends ParserRuleContext {
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GenericFunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionArgumentsContext genericFunctionArguments() throws RecognitionException {
		GenericFunctionArgumentsContext _localctx = new GenericFunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 238, RULE_genericFunctionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1288);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,133,_ctx) ) {
			case 1:
				{
				setState(1284);
				match(DISTINCT);
				}
				break;
			case 2:
				{
				setState(1285);
				datetimeField();
				setState(1286);
				match(COMMA);
				}
				break;
			}
			setState(1290);
			expressionOrPredicate();
			setState(1295);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1291);
				match(COMMA);
				setState(1292);
				expressionOrPredicate();
				}
				}
				setState(1297);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionSizeFunctionContext extends ParserRuleContext {
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollectionSizeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionSizeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionSizeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionSizeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionSizeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionSizeFunctionContext collectionSizeFunction() throws RecognitionException {
		CollectionSizeFunctionContext _localctx = new CollectionSizeFunctionContext(_ctx, getState());
		enterRule(_localctx, 240, RULE_collectionSizeFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1298);
			match(SIZE);
			setState(1299);
			match(LEFT_PAREN);
			setState(1300);
			path();
			setState(1301);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public IndexAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexAggregateFunctionContext indexAggregateFunction() throws RecognitionException {
		IndexAggregateFunctionContext _localctx = new IndexAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 242, RULE_indexAggregateFunction);
		try {
			setState(1345);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXINDEX:
				enterOuterAlt(_localctx, 1);
				{
				setState(1303);
				match(MAXINDEX);
				setState(1304);
				match(LEFT_PAREN);
				setState(1305);
				path();
				setState(1306);
				match(RIGHT_PAREN);
				}
				break;
			case MININDEX:
				enterOuterAlt(_localctx, 2);
				{
				setState(1308);
				match(MININDEX);
				setState(1309);
				match(LEFT_PAREN);
				setState(1310);
				path();
				setState(1311);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1313);
				match(MAX);
				setState(1314);
				match(LEFT_PAREN);
				setState(1315);
				match(INDICES);
				setState(1316);
				match(LEFT_PAREN);
				setState(1317);
				path();
				setState(1318);
				match(RIGHT_PAREN);
				setState(1319);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1321);
				match(MIN);
				setState(1322);
				match(LEFT_PAREN);
				setState(1323);
				match(INDICES);
				setState(1324);
				match(LEFT_PAREN);
				setState(1325);
				path();
				setState(1326);
				match(RIGHT_PAREN);
				setState(1327);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1329);
				match(SUM);
				setState(1330);
				match(LEFT_PAREN);
				setState(1331);
				match(INDICES);
				setState(1332);
				match(LEFT_PAREN);
				setState(1333);
				path();
				setState(1334);
				match(RIGHT_PAREN);
				setState(1335);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1337);
				match(AVG);
				setState(1338);
				match(LEFT_PAREN);
				setState(1339);
				match(INDICES);
				setState(1340);
				match(LEFT_PAREN);
				setState(1341);
				path();
				setState(1342);
				match(RIGHT_PAREN);
				setState(1343);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ElementAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public ElementAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementAggregateFunctionContext elementAggregateFunction() throws RecognitionException {
		ElementAggregateFunctionContext _localctx = new ElementAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 244, RULE_elementAggregateFunction);
		try {
			setState(1389);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXELEMENT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1347);
				match(MAXELEMENT);
				setState(1348);
				match(LEFT_PAREN);
				setState(1349);
				path();
				setState(1350);
				match(RIGHT_PAREN);
				}
				break;
			case MINELEMENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1352);
				match(MINELEMENT);
				setState(1353);
				match(LEFT_PAREN);
				setState(1354);
				path();
				setState(1355);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1357);
				match(MAX);
				setState(1358);
				match(LEFT_PAREN);
				setState(1359);
				match(ELEMENTS);
				setState(1360);
				match(LEFT_PAREN);
				setState(1361);
				path();
				setState(1362);
				match(RIGHT_PAREN);
				setState(1363);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1365);
				match(MIN);
				setState(1366);
				match(LEFT_PAREN);
				setState(1367);
				match(ELEMENTS);
				setState(1368);
				match(LEFT_PAREN);
				setState(1369);
				path();
				setState(1370);
				match(RIGHT_PAREN);
				setState(1371);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1373);
				match(SUM);
				setState(1374);
				match(LEFT_PAREN);
				setState(1375);
				match(ELEMENTS);
				setState(1376);
				match(LEFT_PAREN);
				setState(1377);
				path();
				setState(1378);
				match(RIGHT_PAREN);
				setState(1379);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1381);
				match(AVG);
				setState(1382);
				match(LEFT_PAREN);
				setState(1383);
				match(ELEMENTS);
				setState(1384);
				match(LEFT_PAREN);
				setState(1385);
				path();
				setState(1386);
				match(RIGHT_PAREN);
				setState(1387);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionFunctionMisuseContext extends ParserRuleContext {
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public CollectionFunctionMisuseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionFunctionMisuse; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionFunctionMisuse(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionFunctionMisuse(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionFunctionMisuse(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionFunctionMisuseContext collectionFunctionMisuse() throws RecognitionException {
		CollectionFunctionMisuseContext _localctx = new CollectionFunctionMisuseContext(_ctx, getState());
		enterRule(_localctx, 246, RULE_collectionFunctionMisuse);
		try {
			setState(1401);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
				enterOuterAlt(_localctx, 1);
				{
				setState(1391);
				match(ELEMENTS);
				setState(1392);
				match(LEFT_PAREN);
				setState(1393);
				path();
				setState(1394);
				match(RIGHT_PAREN);
				}
				break;
			case INDICES:
				enterOuterAlt(_localctx, 2);
				{
				setState(1396);
				match(INDICES);
				setState(1397);
				match(LEFT_PAREN);
				setState(1398);
				path();
				setState(1399);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AggregateFunctionContext extends ParserRuleContext {
		public EveryFunctionContext everyFunction() {
			return getRuleContext(EveryFunctionContext.class,0);
		}
		public AnyFunctionContext anyFunction() {
			return getRuleContext(AnyFunctionContext.class,0);
		}
		public ListaggFunctionContext listaggFunction() {
			return getRuleContext(ListaggFunctionContext.class,0);
		}
		public AggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_aggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AggregateFunctionContext aggregateFunction() throws RecognitionException {
		AggregateFunctionContext _localctx = new AggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 248, RULE_aggregateFunction);
		try {
			setState(1406);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ALL:
			case EVERY:
				enterOuterAlt(_localctx, 1);
				{
				setState(1403);
				everyFunction();
				}
				break;
			case ANY:
			case SOME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1404);
				anyFunction();
				}
				break;
			case LISTAGG:
				enterOuterAlt(_localctx, 3);
				{
				setState(1405);
				listaggFunction();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EveryFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public EveryFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryFunctionContext everyFunction() throws RecognitionException {
		EveryFunctionContext _localctx = new EveryFunctionContext(_ctx, getState());
		enterRule(_localctx, 250, RULE_everyFunction);
		int _la;
		try {
			setState(1429);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,141,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1408);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1409);
				match(LEFT_PAREN);
				setState(1410);
				predicate(0);
				setState(1411);
				match(RIGHT_PAREN);
				setState(1413);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,139,_ctx) ) {
				case 1:
					{
					setState(1412);
					filterClause();
					}
					break;
				}
				setState(1416);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,140,_ctx) ) {
				case 1:
					{
					setState(1415);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1418);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1419);
				match(LEFT_PAREN);
				setState(1420);
				subquery();
				setState(1421);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1423);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1424);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1425);
				match(LEFT_PAREN);
				setState(1426);
				simplePath();
				setState(1427);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AnyFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public AnyFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnyFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnyFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnyFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnyFunctionContext anyFunction() throws RecognitionException {
		AnyFunctionContext _localctx = new AnyFunctionContext(_ctx, getState());
		enterRule(_localctx, 252, RULE_anyFunction);
		int _la;
		try {
			setState(1452);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,144,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1431);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1432);
				match(LEFT_PAREN);
				setState(1433);
				predicate(0);
				setState(1434);
				match(RIGHT_PAREN);
				setState(1436);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,142,_ctx) ) {
				case 1:
					{
					setState(1435);
					filterClause();
					}
					break;
				}
				setState(1439);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,143,_ctx) ) {
				case 1:
					{
					setState(1438);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1441);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1442);
				match(LEFT_PAREN);
				setState(1443);
				subquery();
				setState(1444);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1446);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1447);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1448);
				match(LEFT_PAREN);
				setState(1449);
				simplePath();
				setState(1450);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ListaggFunctionContext extends ParserRuleContext {
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public OnOverflowClauseContext onOverflowClause() {
			return getRuleContext(OnOverflowClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public ListaggFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_listaggFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterListaggFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitListaggFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitListaggFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ListaggFunctionContext listaggFunction() throws RecognitionException {
		ListaggFunctionContext _localctx = new ListaggFunctionContext(_ctx, getState());
		enterRule(_localctx, 254, RULE_listaggFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1454);
			match(LISTAGG);
			setState(1455);
			match(LEFT_PAREN);
			setState(1457);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,145,_ctx) ) {
			case 1:
				{
				setState(1456);
				match(DISTINCT);
				}
				break;
			}
			setState(1459);
			expressionOrPredicate();
			setState(1460);
			match(COMMA);
			setState(1461);
			expressionOrPredicate();
			setState(1463);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(1462);
				onOverflowClause();
				}
			}

			setState(1465);
			match(RIGHT_PAREN);
			setState(1467);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,147,_ctx) ) {
			case 1:
				{
				setState(1466);
				withinGroupClause();
				}
				break;
			}
			setState(1470);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,148,_ctx) ) {
			case 1:
				{
				setState(1469);
				filterClause();
				}
				break;
			}
			setState(1473);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,149,_ctx) ) {
			case 1:
				{
				setState(1472);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OnOverflowClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OnOverflowClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_onOverflowClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOnOverflowClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOnOverflowClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOnOverflowClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OnOverflowClauseContext onOverflowClause() throws RecognitionException {
		OnOverflowClauseContext _localctx = new OnOverflowClauseContext(_ctx, getState());
		enterRule(_localctx, 256, RULE_onOverflowClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1475);
			match(ON);
			setState(1476);
			match(OVERFLOW);
			setState(1484);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ERROR:
				{
				setState(1477);
				match(ERROR);
				}
				break;
			case TRUNCATE:
				{
				{
				setState(1478);
				match(TRUNCATE);
				setState(1480);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,150,_ctx) ) {
				case 1:
					{
					setState(1479);
					expression(0);
					}
					break;
				}
				setState(1482);
				_la = _input.LA(1);
				if ( !(_la==WITH || _la==WITHOUT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1483);
				match(COUNT);
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WithinGroupClauseContext extends ParserRuleContext {
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public WithinGroupClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withinGroupClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithinGroupClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithinGroupClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithinGroupClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithinGroupClauseContext withinGroupClause() throws RecognitionException {
		WithinGroupClauseContext _localctx = new WithinGroupClauseContext(_ctx, getState());
		enterRule(_localctx, 258, RULE_withinGroupClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1486);
			match(WITHIN);
			setState(1487);
			match(GROUP);
			setState(1488);
			match(LEFT_PAREN);
			setState(1489);
			orderByClause();
			setState(1490);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FilterClauseContext extends ParserRuleContext {
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_filterClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFilterClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFilterClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFilterClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FilterClauseContext filterClause() throws RecognitionException {
		FilterClauseContext _localctx = new FilterClauseContext(_ctx, getState());
		enterRule(_localctx, 260, RULE_filterClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1492);
			match(FILTER);
			setState(1493);
			match(LEFT_PAREN);
			setState(1494);
			whereClause();
			setState(1495);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsClauseContext extends ParserRuleContext {
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public NullsClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsClauseContext nullsClause() throws RecognitionException {
		NullsClauseContext _localctx = new NullsClauseContext(_ctx, getState());
		enterRule(_localctx, 262, RULE_nullsClause);
		try {
			setState(1501);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case RESPECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1497);
				match(RESPECT);
				setState(1498);
				match(NULLS);
				}
				break;
			case IGNORE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1499);
				match(IGNORE);
				setState(1500);
				match(NULLS);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NthSideClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NthSideClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nthSideClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNthSideClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNthSideClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNthSideClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NthSideClauseContext nthSideClause() throws RecognitionException {
		NthSideClauseContext _localctx = new NthSideClauseContext(_ctx, getState());
		enterRule(_localctx, 264, RULE_nthSideClause);
		try {
			setState(1507);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,153,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1503);
				match(FROM);
				setState(1504);
				match(FIRST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1505);
				match(FROM);
				setState(1506);
				match(LAST);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverClauseContext extends ParserRuleContext {
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PartitionClauseContext partitionClause() {
			return getRuleContext(PartitionClauseContext.class,0);
		}
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public FrameClauseContext frameClause() {
			return getRuleContext(FrameClauseContext.class,0);
		}
		public OverClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverClauseContext overClause() throws RecognitionException {
		OverClauseContext _localctx = new OverClauseContext(_ctx, getState());
		enterRule(_localctx, 266, RULE_overClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1509);
			match(OVER);
			setState(1510);
			match(LEFT_PAREN);
			setState(1512);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==PARTITION) {
				{
				setState(1511);
				partitionClause();
				}
			}

			setState(1515);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ORDER) {
				{
				setState(1514);
				orderByClause();
				}
			}

			setState(1518);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==GROUPS || _la==RANGE || _la==ROWS) {
				{
				setState(1517);
				frameClause();
				}
			}

			setState(1520);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PartitionClauseContext extends ParserRuleContext {
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public PartitionClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_partitionClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPartitionClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPartitionClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPartitionClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PartitionClauseContext partitionClause() throws RecognitionException {
		PartitionClauseContext _localctx = new PartitionClauseContext(_ctx, getState());
		enterRule(_localctx, 268, RULE_partitionClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1522);
			match(PARTITION);
			setState(1523);
			match(BY);
			setState(1524);
			expression(0);
			setState(1529);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1525);
				match(COMMA);
				setState(1526);
				expression(0);
				}
				}
				setState(1531);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameClauseContext extends ParserRuleContext {
		public FrameStartContext frameStart() {
			return getRuleContext(FrameStartContext.class,0);
		}
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public FrameExclusionContext frameExclusion() {
			return getRuleContext(FrameExclusionContext.class,0);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public FrameEndContext frameEnd() {
			return getRuleContext(FrameEndContext.class,0);
		}
		public FrameClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameClauseContext frameClause() throws RecognitionException {
		FrameClauseContext _localctx = new FrameClauseContext(_ctx, getState());
		enterRule(_localctx, 270, RULE_frameClause);
		int _la;
		try {
			setState(1545);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,160,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1532);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1533);
				frameStart();
				setState(1535);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1534);
					frameExclusion();
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1537);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1538);
				match(BETWEEN);
				setState(1539);
				frameStart();
				setState(1540);
				match(AND);
				setState(1541);
				frameEnd();
				setState(1543);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1542);
					frameExclusion();
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameStartContext extends ParserRuleContext {
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public FrameStartContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameStart; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameStart(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameStart(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameStart(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameStartContext frameStart() throws RecognitionException {
		FrameStartContext _localctx = new FrameStartContext(_ctx, getState());
		enterRule(_localctx, 272, RULE_frameStart);
		try {
			setState(1557);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,161,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1547);
				match(UNBOUNDED);
				setState(1548);
				match(PRECEDING);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1549);
				expression(0);
				setState(1550);
				match(PRECEDING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1552);
				match(CURRENT);
				setState(1553);
				match(ROW);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1554);
				expression(0);
				setState(1555);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameEndContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public FrameEndContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameEnd; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameEnd(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameEnd(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameEnd(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameEndContext frameEnd() throws RecognitionException {
		FrameEndContext _localctx = new FrameEndContext(_ctx, getState());
		enterRule(_localctx, 274, RULE_frameEnd);
		try {
			setState(1569);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,162,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1559);
				expression(0);
				setState(1560);
				match(PRECEDING);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1562);
				match(CURRENT);
				setState(1563);
				match(ROW);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1564);
				expression(0);
				setState(1565);
				match(FOLLOWING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1567);
				match(UNBOUNDED);
				setState(1568);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameExclusionContext extends ParserRuleContext {
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public FrameExclusionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameExclusion; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameExclusion(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameExclusion(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameExclusion(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameExclusionContext frameExclusion() throws RecognitionException {
		FrameExclusionContext _localctx = new FrameExclusionContext(_ctx, getState());
		enterRule(_localctx, 276, RULE_frameExclusion);
		try {
			setState(1581);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,163,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1571);
				match(EXCLUDE);
				setState(1572);
				match(CURRENT);
				setState(1573);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1574);
				match(EXCLUDE);
				setState(1575);
				match(GROUP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1576);
				match(EXCLUDE);
				setState(1577);
				match(TIES);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1578);
				match(EXCLUDE);
				setState(1579);
				match(NO);
				setState(1580);
				match(OTHERS);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class StandardFunctionContext extends ParserRuleContext {
		public CastFunctionContext castFunction() {
			return getRuleContext(CastFunctionContext.class,0);
		}
		public ExtractFunctionContext extractFunction() {
			return getRuleContext(ExtractFunctionContext.class,0);
		}
		public FormatFunctionContext formatFunction() {
			return getRuleContext(FormatFunctionContext.class,0);
		}
		public CollateFunctionContext collateFunction() {
			return getRuleContext(CollateFunctionContext.class,0);
		}
		public SubstringFunctionContext substringFunction() {
			return getRuleContext(SubstringFunctionContext.class,0);
		}
		public OverlayFunctionContext overlayFunction() {
			return getRuleContext(OverlayFunctionContext.class,0);
		}
		public TrimFunctionContext trimFunction() {
			return getRuleContext(TrimFunctionContext.class,0);
		}
		public PadFunctionContext padFunction() {
			return getRuleContext(PadFunctionContext.class,0);
		}
		public PositionFunctionContext positionFunction() {
			return getRuleContext(PositionFunctionContext.class,0);
		}
		public CurrentDateFunctionContext currentDateFunction() {
			return getRuleContext(CurrentDateFunctionContext.class,0);
		}
		public CurrentTimeFunctionContext currentTimeFunction() {
			return getRuleContext(CurrentTimeFunctionContext.class,0);
		}
		public CurrentTimestampFunctionContext currentTimestampFunction() {
			return getRuleContext(CurrentTimestampFunctionContext.class,0);
		}
		public InstantFunctionContext instantFunction() {
			return getRuleContext(InstantFunctionContext.class,0);
		}
		public LocalDateFunctionContext localDateFunction() {
			return getRuleContext(LocalDateFunctionContext.class,0);
		}
		public LocalTimeFunctionContext localTimeFunction() {
			return getRuleContext(LocalTimeFunctionContext.class,0);
		}
		public LocalDateTimeFunctionContext localDateTimeFunction() {
			return getRuleContext(LocalDateTimeFunctionContext.class,0);
		}
		public OffsetDateTimeFunctionContext offsetDateTimeFunction() {
			return getRuleContext(OffsetDateTimeFunctionContext.class,0);
		}
		public CubeContext cube() {
			return getRuleContext(CubeContext.class,0);
		}
		public RollupContext rollup() {
			return getRuleContext(RollupContext.class,0);
		}
		public StandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_standardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StandardFunctionContext standardFunction() throws RecognitionException {
		StandardFunctionContext _localctx = new StandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 278, RULE_standardFunction);
		try {
			setState(1602);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,164,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1583);
				castFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1584);
				extractFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1585);
				formatFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1586);
				collateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1587);
				substringFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1588);
				overlayFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1589);
				trimFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1590);
				padFunction();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1591);
				positionFunction();
				}
				break;
			case 10:
				enterOuterAlt(_localctx, 10);
				{
				setState(1592);
				currentDateFunction();
				}
				break;
			case 11:
				enterOuterAlt(_localctx, 11);
				{
				setState(1593);
				currentTimeFunction();
				}
				break;
			case 12:
				enterOuterAlt(_localctx, 12);
				{
				setState(1594);
				currentTimestampFunction();
				}
				break;
			case 13:
				enterOuterAlt(_localctx, 13);
				{
				setState(1595);
				instantFunction();
				}
				break;
			case 14:
				enterOuterAlt(_localctx, 14);
				{
				setState(1596);
				localDateFunction();
				}
				break;
			case 15:
				enterOuterAlt(_localctx, 15);
				{
				setState(1597);
				localTimeFunction();
				}
				break;
			case 16:
				enterOuterAlt(_localctx, 16);
				{
				setState(1598);
				localDateTimeFunction();
				}
				break;
			case 17:
				enterOuterAlt(_localctx, 17);
				{
				setState(1599);
				offsetDateTimeFunction();
				}
				break;
			case 18:
				enterOuterAlt(_localctx, 18);
				{
				setState(1600);
				cube();
				}
				break;
			case 19:
				enterOuterAlt(_localctx, 19);
				{
				setState(1601);
				rollup();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastFunctionContext extends ParserRuleContext {
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CastFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastFunctionContext castFunction() throws RecognitionException {
		CastFunctionContext _localctx = new CastFunctionContext(_ctx, getState());
		enterRule(_localctx, 280, RULE_castFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1604);
			match(CAST);
			setState(1605);
			match(LEFT_PAREN);
			setState(1606);
			expression(0);
			setState(1607);
			match(AS);
			setState(1608);
			castTarget();
			setState(1609);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetContext extends ParserRuleContext {
		public CastTargetTypeContext castTargetType() {
			return getRuleContext(CastTargetTypeContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<TerminalNode> INTEGER_LITERAL() { return getTokens(HqlParser.INTEGER_LITERAL); }
		public TerminalNode INTEGER_LITERAL(int i) {
			return getToken(HqlParser.INTEGER_LITERAL, i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public CastTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetContext castTarget() throws RecognitionException {
		CastTargetContext _localctx = new CastTargetContext(_ctx, getState());
		enterRule(_localctx, 282, RULE_castTarget);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1611);
			castTargetType();
			setState(1619);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN) {
				{
				setState(1612);
				match(LEFT_PAREN);
				setState(1613);
				match(INTEGER_LITERAL);
				setState(1616);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1614);
					match(COMMA);
					setState(1615);
					match(INTEGER_LITERAL);
					}
				}

				setState(1618);
				match(RIGHT_PAREN);
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetTypeContext extends ParserRuleContext {
		public String fullTargetName;
		public IdentifierContext i;
		public IdentifierContext c;
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public CastTargetTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTargetType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTargetType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTargetType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTargetType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetTypeContext castTargetType() throws RecognitionException {
		CastTargetTypeContext _localctx = new CastTargetTypeContext(_ctx, getState());
		enterRule(_localctx, 284, RULE_castTargetType);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			{
			setState(1621);
			((CastTargetTypeContext)_localctx).i = identifier();
			 ((CastTargetTypeContext)_localctx).fullTargetName =  _localctx.i.getText(); 
			}
			setState(1630);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(1624);
				match(DOT);
				setState(1625);
				((CastTargetTypeContext)_localctx).c = identifier();
				 _localctx.fullTargetName += ("." + _localctx.c.getText() ); 
				}
				}
				setState(1632);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionContext extends ParserRuleContext {
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SubstringFunctionStartArgumentContext substringFunctionStartArgument() {
			return getRuleContext(SubstringFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() {
			return getRuleContext(SubstringFunctionLengthArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public SubstringFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionContext substringFunction() throws RecognitionException {
		SubstringFunctionContext _localctx = new SubstringFunctionContext(_ctx, getState());
		enterRule(_localctx, 286, RULE_substringFunction);
		int _la;
		try {
			setState(1655);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,170,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1633);
				match(SUBSTRING);
				setState(1634);
				match(LEFT_PAREN);
				setState(1635);
				expression(0);
				setState(1636);
				match(COMMA);
				setState(1637);
				substringFunctionStartArgument();
				setState(1640);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1638);
					match(COMMA);
					setState(1639);
					substringFunctionLengthArgument();
					}
				}

				setState(1642);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1644);
				match(SUBSTRING);
				setState(1645);
				match(LEFT_PAREN);
				setState(1646);
				expression(0);
				setState(1647);
				match(FROM);
				setState(1648);
				substringFunctionStartArgument();
				setState(1651);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FOR) {
					{
					setState(1649);
					match(FOR);
					setState(1650);
					substringFunctionLengthArgument();
					}
				}

				setState(1653);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionStartArgumentContext substringFunctionStartArgument() throws RecognitionException {
		SubstringFunctionStartArgumentContext _localctx = new SubstringFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 288, RULE_substringFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1657);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() throws RecognitionException {
		SubstringFunctionLengthArgumentContext _localctx = new SubstringFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 290, RULE_substringFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1659);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimFunctionContext extends ParserRuleContext {
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TrimSpecificationContext trimSpecification() {
			return getRuleContext(TrimSpecificationContext.class,0);
		}
		public TrimCharacterContext trimCharacter() {
			return getRuleContext(TrimCharacterContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimFunctionContext trimFunction() throws RecognitionException {
		TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
		enterRule(_localctx, 292, RULE_trimFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1661);
			match(TRIM);
			setState(1662);
			match(LEFT_PAREN);
			setState(1664);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,171,_ctx) ) {
			case 1:
				{
				setState(1663);
				trimSpecification();
				}
				break;
			}
			setState(1667);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,172,_ctx) ) {
			case 1:
				{
				setState(1666);
				trimCharacter();
				}
				break;
			}
			setState(1670);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,173,_ctx) ) {
			case 1:
				{
				setState(1669);
				match(FROM);
				}
				break;
			}
			setState(1672);
			expression(0);
			setState(1673);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TrimSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimSpecificationContext trimSpecification() throws RecognitionException {
		TrimSpecificationContext _localctx = new TrimSpecificationContext(_ctx, getState());
		enterRule(_localctx, 294, RULE_trimSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1675);
			_la = _input.LA(1);
			if ( !(_la==BOTH || _la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TrimCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimCharacterContext trimCharacter() throws RecognitionException {
		TrimCharacterContext _localctx = new TrimCharacterContext(_ctx, getState());
		enterRule(_localctx, 296, RULE_trimCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1677);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadFunctionContext extends ParserRuleContext {
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public PadLengthContext padLength() {
			return getRuleContext(PadLengthContext.class,0);
		}
		public PadSpecificationContext padSpecification() {
			return getRuleContext(PadSpecificationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PadCharacterContext padCharacter() {
			return getRuleContext(PadCharacterContext.class,0);
		}
		public PadFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadFunctionContext padFunction() throws RecognitionException {
		PadFunctionContext _localctx = new PadFunctionContext(_ctx, getState());
		enterRule(_localctx, 298, RULE_padFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1679);
			match(PAD);
			setState(1680);
			match(LEFT_PAREN);
			setState(1681);
			expression(0);
			setState(1682);
			match(WITH);
			setState(1683);
			padLength();
			setState(1684);
			padSpecification();
			setState(1686);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==STRING_LITERAL) {
				{
				setState(1685);
				padCharacter();
				}
			}

			setState(1688);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public PadSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadSpecificationContext padSpecification() throws RecognitionException {
		PadSpecificationContext _localctx = new PadSpecificationContext(_ctx, getState());
		enterRule(_localctx, 300, RULE_padSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1690);
			_la = _input.LA(1);
			if ( !(_la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public PadCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadCharacterContext padCharacter() throws RecognitionException {
		PadCharacterContext _localctx = new PadCharacterContext(_ctx, getState());
		enterRule(_localctx, 302, RULE_padCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1692);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadLengthContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PadLengthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padLength; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadLength(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadLength(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadLength(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadLengthContext padLength() throws RecognitionException {
		PadLengthContext _localctx = new PadLengthContext(_ctx, getState());
		enterRule(_localctx, 304, RULE_padLength);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1694);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionContext extends ParserRuleContext {
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OverlayFunctionStringArgumentContext overlayFunctionStringArgument() {
			return getRuleContext(OverlayFunctionStringArgumentContext.class,0);
		}
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() {
			return getRuleContext(OverlayFunctionReplacementArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public OverlayFunctionStartArgumentContext overlayFunctionStartArgument() {
			return getRuleContext(OverlayFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() {
			return getRuleContext(OverlayFunctionLengthArgumentContext.class,0);
		}
		public OverlayFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionContext overlayFunction() throws RecognitionException {
		OverlayFunctionContext _localctx = new OverlayFunctionContext(_ctx, getState());
		enterRule(_localctx, 306, RULE_overlayFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1696);
			match(OVERLAY);
			setState(1697);
			match(LEFT_PAREN);
			setState(1698);
			overlayFunctionStringArgument();
			setState(1699);
			match(PLACING);
			setState(1700);
			overlayFunctionReplacementArgument();
			setState(1701);
			match(FROM);
			setState(1702);
			overlayFunctionStartArgument();
			setState(1705);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FOR) {
				{
				setState(1703);
				match(FOR);
				setState(1704);
				overlayFunctionLengthArgument();
				}
			}

			setState(1707);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStringArgumentContext overlayFunctionStringArgument() throws RecognitionException {
		OverlayFunctionStringArgumentContext _localctx = new OverlayFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 308, RULE_overlayFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1709);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionReplacementArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionReplacementArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionReplacementArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionReplacementArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionReplacementArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionReplacementArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() throws RecognitionException {
		OverlayFunctionReplacementArgumentContext _localctx = new OverlayFunctionReplacementArgumentContext(_ctx, getState());
		enterRule(_localctx, 310, RULE_overlayFunctionReplacementArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1711);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStartArgumentContext overlayFunctionStartArgument() throws RecognitionException {
		OverlayFunctionStartArgumentContext _localctx = new OverlayFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 312, RULE_overlayFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1713);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() throws RecognitionException {
		OverlayFunctionLengthArgumentContext _localctx = new OverlayFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 314, RULE_overlayFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1715);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentDateFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public CurrentDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentDateFunctionContext currentDateFunction() throws RecognitionException {
		CurrentDateFunctionContext _localctx = new CurrentDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 316, RULE_currentDateFunction);
		try {
			setState(1724);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1717);
				match(CURRENT_DATE);
				setState(1720);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,176,_ctx) ) {
				case 1:
					{
					setState(1718);
					match(LEFT_PAREN);
					setState(1719);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1722);
				match(CURRENT);
				setState(1723);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimeFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public CurrentTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimeFunctionContext currentTimeFunction() throws RecognitionException {
		CurrentTimeFunctionContext _localctx = new CurrentTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 318, RULE_currentTimeFunction);
		try {
			setState(1733);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1726);
				match(CURRENT_TIME);
				setState(1729);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,178,_ctx) ) {
				case 1:
					{
					setState(1727);
					match(LEFT_PAREN);
					setState(1728);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1731);
				match(CURRENT);
				setState(1732);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimestampFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public CurrentTimestampFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimestampFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimestampFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimestampFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimestampFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimestampFunctionContext currentTimestampFunction() throws RecognitionException {
		CurrentTimestampFunctionContext _localctx = new CurrentTimestampFunctionContext(_ctx, getState());
		enterRule(_localctx, 320, RULE_currentTimestampFunction);
		try {
			setState(1742);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIMESTAMP:
				enterOuterAlt(_localctx, 1);
				{
				setState(1735);
				match(CURRENT_TIMESTAMP);
				setState(1738);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,180,_ctx) ) {
				case 1:
					{
					setState(1736);
					match(LEFT_PAREN);
					setState(1737);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1740);
				match(CURRENT);
				setState(1741);
				match(TIMESTAMP);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public InstantFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantFunctionContext instantFunction() throws RecognitionException {
		InstantFunctionContext _localctx = new InstantFunctionContext(_ctx, getState());
		enterRule(_localctx, 322, RULE_instantFunction);
		try {
			setState(1750);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_INSTANT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1744);
				match(CURRENT_INSTANT);
				setState(1747);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,182,_ctx) ) {
				case 1:
					{
					setState(1745);
					match(LEFT_PAREN);
					setState(1746);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case INSTANT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1749);
				match(INSTANT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public LocalDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeFunctionContext localDateTimeFunction() throws RecognitionException {
		LocalDateTimeFunctionContext _localctx = new LocalDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 324, RULE_localDateTimeFunction);
		try {
			setState(1759);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1752);
				match(LOCAL_DATETIME);
				setState(1755);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,184,_ctx) ) {
				case 1:
					{
					setState(1753);
					match(LEFT_PAREN);
					setState(1754);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1757);
				match(LOCAL);
				setState(1758);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeFunctionContext offsetDateTimeFunction() throws RecognitionException {
		OffsetDateTimeFunctionContext _localctx = new OffsetDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 326, RULE_offsetDateTimeFunction);
		try {
			setState(1768);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1761);
				match(OFFSET_DATETIME);
				setState(1764);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,186,_ctx) ) {
				case 1:
					{
					setState(1762);
					match(LEFT_PAREN);
					setState(1763);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1766);
				match(OFFSET);
				setState(1767);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public LocalDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateFunctionContext localDateFunction() throws RecognitionException {
		LocalDateFunctionContext _localctx = new LocalDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 328, RULE_localDateFunction);
		try {
			setState(1777);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1770);
				match(LOCAL_DATE);
				setState(1773);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,188,_ctx) ) {
				case 1:
					{
					setState(1771);
					match(LEFT_PAREN);
					setState(1772);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1775);
				match(LOCAL);
				setState(1776);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public LocalTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalTimeFunctionContext localTimeFunction() throws RecognitionException {
		LocalTimeFunctionContext _localctx = new LocalTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 330, RULE_localTimeFunction);
		try {
			setState(1786);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1779);
				match(LOCAL_TIME);
				setState(1782);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,190,_ctx) ) {
				case 1:
					{
					setState(1780);
					match(LEFT_PAREN);
					setState(1781);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1784);
				match(LOCAL);
				setState(1785);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatFunctionContext extends ParserRuleContext {
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public FormatContext format() {
			return getRuleContext(FormatContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FormatFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_formatFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormatFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormatFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormatFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatFunctionContext formatFunction() throws RecognitionException {
		FormatFunctionContext _localctx = new FormatFunctionContext(_ctx, getState());
		enterRule(_localctx, 332, RULE_formatFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1788);
			match(FORMAT);
			setState(1789);
			match(LEFT_PAREN);
			setState(1790);
			expression(0);
			setState(1791);
			match(AS);
			setState(1792);
			format();
			setState(1793);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public FormatContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_format; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormat(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormat(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormat(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatContext format() throws RecognitionException {
		FormatContext _localctx = new FormatContext(_ctx, getState());
		enterRule(_localctx, 334, RULE_format);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1795);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFunctionContext extends ParserRuleContext {
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExtractFieldContext extractField() {
			return getRuleContext(ExtractFieldContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ExtractFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFunctionContext extractFunction() throws RecognitionException {
		ExtractFunctionContext _localctx = new ExtractFunctionContext(_ctx, getState());
		enterRule(_localctx, 336, RULE_extractFunction);
		try {
			setState(1809);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case EXTRACT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1797);
				match(EXTRACT);
				setState(1798);
				match(LEFT_PAREN);
				setState(1799);
				extractField();
				setState(1800);
				match(FROM);
				setState(1801);
				expression(0);
				setState(1802);
				match(RIGHT_PAREN);
				}
				break;
			case DAY:
			case HOUR:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case QUARTER:
			case SECOND:
			case WEEK:
			case YEAR:
				enterOuterAlt(_localctx, 2);
				{
				setState(1804);
				datetimeField();
				setState(1805);
				match(LEFT_PAREN);
				setState(1806);
				expression(0);
				setState(1807);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFieldContext extends ParserRuleContext {
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public DayFieldContext dayField() {
			return getRuleContext(DayFieldContext.class,0);
		}
		public WeekFieldContext weekField() {
			return getRuleContext(WeekFieldContext.class,0);
		}
		public TimeZoneFieldContext timeZoneField() {
			return getRuleContext(TimeZoneFieldContext.class,0);
		}
		public DateOrTimeFieldContext dateOrTimeField() {
			return getRuleContext(DateOrTimeFieldContext.class,0);
		}
		public ExtractFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFieldContext extractField() throws RecognitionException {
		ExtractFieldContext _localctx = new ExtractFieldContext(_ctx, getState());
		enterRule(_localctx, 338, RULE_extractField);
		try {
			setState(1816);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,193,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1811);
				datetimeField();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1812);
				dayField();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1813);
				weekField();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1814);
				timeZoneField();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1815);
				dateOrTimeField();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DatetimeFieldContext extends ParserRuleContext {
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public DatetimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_datetimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDatetimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDatetimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDatetimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DatetimeFieldContext datetimeField() throws RecognitionException {
		DatetimeFieldContext _localctx = new DatetimeFieldContext(_ctx, getState());
		enterRule(_localctx, 340, RULE_datetimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1818);
			_la = _input.LA(1);
			if ( !(_la==DAY || _la==HOUR || ((((_la - 132)) & ~0x3f) == 0 && ((1L << (_la - 132)) & ((1L << (MINUTE - 132)) | (1L << (MONTH - 132)) | (1L << (NANOSECOND - 132)) | (1L << (QUARTER - 132)) | (1L << (SECOND - 132)) | (1L << (WEEK - 132)) | (1L << (YEAR - 132)))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayFieldContext extends ParserRuleContext {
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public DayFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dayField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDayField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDayField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDayField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayFieldContext dayField() throws RecognitionException {
		DayFieldContext _localctx = new DayFieldContext(_ctx, getState());
		enterRule(_localctx, 342, RULE_dayField);
		try {
			setState(1829);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,194,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1820);
				match(DAY);
				setState(1821);
				match(OF);
				setState(1822);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1823);
				match(DAY);
				setState(1824);
				match(OF);
				setState(1825);
				match(WEEK);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1826);
				match(DAY);
				setState(1827);
				match(OF);
				setState(1828);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WeekFieldContext extends ParserRuleContext {
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public WeekFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_weekField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWeekField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWeekField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWeekField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WeekFieldContext weekField() throws RecognitionException {
		WeekFieldContext _localctx = new WeekFieldContext(_ctx, getState());
		enterRule(_localctx, 344, RULE_weekField);
		try {
			setState(1837);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,195,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1831);
				match(WEEK);
				setState(1832);
				match(OF);
				setState(1833);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1834);
				match(WEEK);
				setState(1835);
				match(OF);
				setState(1836);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeZoneFieldContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TimeZoneFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeZoneField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeZoneField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeZoneField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeZoneField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeZoneFieldContext timeZoneField() throws RecognitionException {
		TimeZoneFieldContext _localctx = new TimeZoneFieldContext(_ctx, getState());
		enterRule(_localctx, 346, RULE_timeZoneField);
		int _la;
		try {
			setState(1845);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET:
				enterOuterAlt(_localctx, 1);
				{
				setState(1839);
				match(OFFSET);
				setState(1841);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==HOUR || _la==MINUTE) {
					{
					setState(1840);
					_la = _input.LA(1);
					if ( !(_la==HOUR || _la==MINUTE) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				}
				break;
			case TIMEZONE_HOUR:
				enterOuterAlt(_localctx, 2);
				{
				setState(1843);
				match(TIMEZONE_HOUR);
				}
				break;
			case TIMEZONE_MINUTE:
				enterOuterAlt(_localctx, 3);
				{
				setState(1844);
				match(TIMEZONE_MINUTE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateOrTimeFieldContext extends ParserRuleContext {
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public DateOrTimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateOrTimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateOrTimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateOrTimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateOrTimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateOrTimeFieldContext dateOrTimeField() throws RecognitionException {
		DateOrTimeFieldContext _localctx = new DateOrTimeFieldContext(_ctx, getState());
		enterRule(_localctx, 348, RULE_dateOrTimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1847);
			_la = _input.LA(1);
			if ( !(_la==DATE || _la==TIME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionContext extends ParserRuleContext {
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PositionFunctionPatternArgumentContext positionFunctionPatternArgument() {
			return getRuleContext(PositionFunctionPatternArgumentContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public PositionFunctionStringArgumentContext positionFunctionStringArgument() {
			return getRuleContext(PositionFunctionStringArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PositionFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionContext positionFunction() throws RecognitionException {
		PositionFunctionContext _localctx = new PositionFunctionContext(_ctx, getState());
		enterRule(_localctx, 350, RULE_positionFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1849);
			match(POSITION);
			setState(1850);
			match(LEFT_PAREN);
			setState(1851);
			positionFunctionPatternArgument();
			setState(1852);
			match(IN);
			setState(1853);
			positionFunctionStringArgument();
			setState(1854);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionPatternArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionPatternArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionPatternArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionPatternArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionPatternArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionPatternArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionPatternArgumentContext positionFunctionPatternArgument() throws RecognitionException {
		PositionFunctionPatternArgumentContext _localctx = new PositionFunctionPatternArgumentContext(_ctx, getState());
		enterRule(_localctx, 352, RULE_positionFunctionPatternArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1856);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionStringArgumentContext positionFunctionStringArgument() throws RecognitionException {
		PositionFunctionStringArgumentContext _localctx = new PositionFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 354, RULE_positionFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1858);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CubeContext extends ParserRuleContext {
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CubeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cube; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCube(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCube(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCube(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CubeContext cube() throws RecognitionException {
		CubeContext _localctx = new CubeContext(_ctx, getState());
		enterRule(_localctx, 356, RULE_cube);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1860);
			match(CUBE);
			setState(1861);
			match(LEFT_PAREN);
			setState(1862);
			expressionOrPredicate();
			setState(1867);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1863);
				match(COMMA);
				setState(1864);
				expressionOrPredicate();
				}
				}
				setState(1869);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(1870);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class RollupContext extends ParserRuleContext {
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public RollupContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rollup; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRollup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRollup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRollup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RollupContext rollup() throws RecognitionException {
		RollupContext _localctx = new RollupContext(_ctx, getState());
		enterRule(_localctx, 358, RULE_rollup);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1872);
			match(ROLLUP);
			setState(1873);
			match(LEFT_PAREN);
			setState(1874);
			expressionOrPredicate();
			setState(1879);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1875);
				match(COMMA);
				setState(1876);
				expressionOrPredicate();
				}
				}
				setState(1881);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(1882);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NakedIdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(HqlParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(HqlParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public TerminalNode MICROSECOND() { return getToken(HqlParser.MICROSECOND, 0); }
		public TerminalNode MILLISECOND() { return getToken(HqlParser.MILLISECOND, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public NakedIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nakedIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNakedIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNakedIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNakedIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NakedIdentifierContext nakedIdentifier() throws RecognitionException {
		NakedIdentifierContext _localctx = new NakedIdentifierContext(_ctx, getState());
		enterRule(_localctx, 360, RULE_nakedIdentifier);
		int _la;
		try {
			setState(1888);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1884);
				match(IDENTIFIER);
				}
				break;
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(1885);
				match(QUOTED_IDENTIFIER);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
				enterOuterAlt(_localctx, 3);
				{
				setState(1886);
				_la = _input.LA(1);
				if ( !(((((_la - 41)) & ~0x3f) == 0 && ((1L << (_la - 41)) & ((1L << (ID - 41)) | (1L << (VERSION - 41)) | (1L << (VERSIONED - 41)) | (1L << (NATURALID - 41)) | (1L << (ALL - 41)) | (1L << (AND - 41)) | (1L << (ANY - 41)) | (1L << (AS - 41)) | (1L << (ASC - 41)) | (1L << (AVG - 41)) | (1L << (BETWEEN - 41)) | (1L << (BOTH - 41)) | (1L << (BY - 41)) | (1L << (CASE - 41)) | (1L << (CAST - 41)) | (1L << (COLLATE - 41)) | (1L << (COUNT - 41)) | (1L << (CROSS - 41)) | (1L << (CUBE - 41)) | (1L << (CURRENT - 41)) | (1L << (CURRENT_DATE - 41)) | (1L << (CURRENT_INSTANT - 41)) | (1L << (CURRENT_TIME - 41)) | (1L << (CURRENT_TIMESTAMP - 41)) | (1L << (DATE - 41)) | (1L << (DATETIME - 41)) | (1L << (DAY - 41)) | (1L << (DELETE - 41)) | (1L << (DESC - 41)) | (1L << (DISTINCT - 41)) | (1L << (ELEMENT - 41)) | (1L << (ELEMENTS - 41)) | (1L << (ELSE - 41)) | (1L << (EMPTY - 41)) | (1L << (END - 41)) | (1L << (ENTRY - 41)) | (1L << (ERROR - 41)) | (1L << (ESCAPE - 41)) | (1L << (EVERY - 41)) | (1L << (EXCEPT - 41)) | (1L << (EXCLUDE - 41)) | (1L << (EXISTS - 41)) | (1L << (EXTRACT - 41)) | (1L << (FETCH - 41)) | (1L << (FILTER - 41)) | (1L << (FIRST - 41)) | (1L << (FOLLOWING - 41)) | (1L << (FOR - 41)) | (1L << (FORMAT - 41)) | (1L << (FROM - 41)) | (1L << (FUNCTION - 41)) | (1L << (GROUP - 41)) | (1L << (GROUPS - 41)) | (1L << (HAVING - 41)) | (1L << (HOUR - 41)) | (1L << (IGNORE - 41)) | (1L << (ILIKE - 41)) | (1L << (IN - 41)) | (1L << (INDEX - 41)) | (1L << (INDICES - 41)) | (1L << (INSERT - 41)))) != 0) || ((((_la - 105)) & ~0x3f) == 0 && ((1L << (_la - 105)) & ((1L << (INSTANT - 105)) | (1L << (INTERSECT - 105)) | (1L << (INTO - 105)) | (1L << (IS - 105)) | (1L << (JOIN - 105)) | (1L << (KEY - 105)) | (1L << (LAST - 105)) | (1L << (LEADING - 105)) | (1L << (LIKE - 105)) | (1L << (LIMIT - 105)) | (1L << (LIST - 105)) | (1L << (LISTAGG - 105)) | (1L << (LOCAL - 105)) | (1L << (LOCAL_DATE - 105)) | (1L << (LOCAL_DATETIME - 105)) | (1L << (LOCAL_TIME - 105)) | (1L << (MAP - 105)) | (1L << (MAX - 105)) | (1L << (MAXELEMENT - 105)) | (1L << (MAXINDEX - 105)) | (1L << (MEMBER - 105)) | (1L << (MICROSECOND - 105)) | (1L << (MILLISECOND - 105)) | (1L << (MIN - 105)) | (1L << (MINELEMENT - 105)) | (1L << (MININDEX - 105)) | (1L << (MINUTE - 105)) | (1L << (MONTH - 105)) | (1L << (NANOSECOND - 105)) | (1L << (NEW - 105)) | (1L << (NEXT - 105)) | (1L << (NO - 105)) | (1L << (NOT - 105)) | (1L << (NULLS - 105)) | (1L << (OBJECT - 105)) | (1L << (OF - 105)) | (1L << (OFFSET - 105)) | (1L << (OFFSET_DATETIME - 105)) | (1L << (ON - 105)) | (1L << (ONLY - 105)) | (1L << (OR - 105)) | (1L << (ORDER - 105)) | (1L << (OTHERS - 105)) | (1L << (OVER - 105)) | (1L << (OVERFLOW - 105)) | (1L << (OVERLAY - 105)) | (1L << (PAD - 105)) | (1L << (PARTITION - 105)) | (1L << (PERCENT - 105)) | (1L << (PLACING - 105)) | (1L << (POSITION - 105)) | (1L << (PRECEDING - 105)) | (1L << (QUARTER - 105)) | (1L << (RANGE - 105)) | (1L << (RESPECT - 105)) | (1L << (ROLLUP - 105)) | (1L << (ROW - 105)) | (1L << (ROWS - 105)) | (1L << (SECOND - 105)) | (1L << (SELECT - 105)) | (1L << (SET - 105)))) != 0) || ((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & ((1L << (SIZE - 169)) | (1L << (SOME - 169)) | (1L << (SUBSTRING - 169)) | (1L << (SUM - 169)) | (1L << (THEN - 169)) | (1L << (TIES - 169)) | (1L << (TIME - 169)) | (1L << (TIMESTAMP - 169)) | (1L << (TIMEZONE_HOUR - 169)) | (1L << (TIMEZONE_MINUTE - 169)) | (1L << (TRAILING - 169)) | (1L << (TREAT - 169)) | (1L << (TRIM - 169)) | (1L << (TRUNCATE - 169)) | (1L << (TYPE - 169)) | (1L << (UNBOUNDED - 169)) | (1L << (UNION - 169)) | (1L << (UPDATE - 169)) | (1L << (VALUE - 169)) | (1L << (VALUES - 169)) | (1L << (WEEK - 169)) | (1L << (WHEN - 169)) | (1L << (WHERE - 169)) | (1L << (WITH - 169)) | (1L << (WITHIN - 169)) | (1L << (WITHOUT - 169)) | (1L << (YEAR - 169)))) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IdentifierContext extends ParserRuleContext {
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 362, RULE_identifier);
		int _la;
		try {
			setState(1893);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case DATE:
			case DATETIME:
			case DAY:
			case DELETE:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1890);
				nakedIdentifier();
				}
				break;
			case FULL:
			case INNER:
			case LEFT:
			case OUTER:
			case RIGHT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1891);
				_la = _input.LA(1);
				if ( !(((((_la - 92)) & ~0x3f) == 0 && ((1L << (_la - 92)) & ((1L << (FULL - 92)) | (1L << (INNER - 92)) | (1L << (LEFT - 92)) | (1L << (OUTER - 92)))) != 0) || _la==RIGHT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public boolean sempred(RuleContext _localctx, int ruleIndex, int predIndex) {
		switch (ruleIndex) {
		case 66:
			return predicate_sempred((PredicateContext)_localctx, predIndex);
		case 70:
			return expression_sempred((ExpressionContext)_localctx, predIndex);
		}
		return true;
	}
	private boolean predicate_sempred(PredicateContext _localctx, int predIndex) {
		switch (predIndex) {
		case 0:
			return precpred(_ctx, 3);
		case 1:
			return precpred(_ctx, 2);
		}
		return true;
	}
	private boolean expression_sempred(ExpressionContext _localctx, int predIndex) {
		switch (predIndex) {
		case 2:
			return precpred(_ctx, 3);
		case 3:
			return precpred(_ctx, 2);
		case 4:
			return precpred(_ctx, 1);
		case 5:
			return precpred(_ctx, 5);
		case 6:
			return precpred(_ctx, 4);
		}
		return true;
	}

	public static final String _serializedATN =
		"\3\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964\3\u00ca\u076a\4\2\t"+
		"\2\4\3\t\3\4\4\t\4\4\5\t\5\4\6\t\6\4\7\t\7\4\b\t\b\4\t\t\t\4\n\t\n\4\13"+
		"\t\13\4\f\t\f\4\r\t\r\4\16\t\16\4\17\t\17\4\20\t\20\4\21\t\21\4\22\t\22"+
		"\4\23\t\23\4\24\t\24\4\25\t\25\4\26\t\26\4\27\t\27\4\30\t\30\4\31\t\31"+
		"\4\32\t\32\4\33\t\33\4\34\t\34\4\35\t\35\4\36\t\36\4\37\t\37\4 \t \4!"+
		"\t!\4\"\t\"\4#\t#\4$\t$\4%\t%\4&\t&\4\'\t\'\4(\t(\4)\t)\4*\t*\4+\t+\4"+
		",\t,\4-\t-\4.\t.\4/\t/\4\60\t\60\4\61\t\61\4\62\t\62\4\63\t\63\4\64\t"+
		"\64\4\65\t\65\4\66\t\66\4\67\t\67\48\t8\49\t9\4:\t:\4;\t;\4<\t<\4=\t="+
		"\4>\t>\4?\t?\4@\t@\4A\tA\4B\tB\4C\tC\4D\tD\4E\tE\4F\tF\4G\tG\4H\tH\4I"+
		"\tI\4J\tJ\4K\tK\4L\tL\4M\tM\4N\tN\4O\tO\4P\tP\4Q\tQ\4R\tR\4S\tS\4T\tT"+
		"\4U\tU\4V\tV\4W\tW\4X\tX\4Y\tY\4Z\tZ\4[\t[\4\\\t\\\4]\t]\4^\t^\4_\t_\4"+
		"`\t`\4a\ta\4b\tb\4c\tc\4d\td\4e\te\4f\tf\4g\tg\4h\th\4i\ti\4j\tj\4k\t"+
		"k\4l\tl\4m\tm\4n\tn\4o\to\4p\tp\4q\tq\4r\tr\4s\ts\4t\tt\4u\tu\4v\tv\4"+
		"w\tw\4x\tx\4y\ty\4z\tz\4{\t{\4|\t|\4}\t}\4~\t~\4\177\t\177\4\u0080\t\u0080"+
		"\4\u0081\t\u0081\4\u0082\t\u0082\4\u0083\t\u0083\4\u0084\t\u0084\4\u0085"+
		"\t\u0085\4\u0086\t\u0086\4\u0087\t\u0087\4\u0088\t\u0088\4\u0089\t\u0089"+
		"\4\u008a\t\u008a\4\u008b\t\u008b\4\u008c\t\u008c\4\u008d\t\u008d\4\u008e"+
		"\t\u008e\4\u008f\t\u008f\4\u0090\t\u0090\4\u0091\t\u0091\4\u0092\t\u0092"+
		"\4\u0093\t\u0093\4\u0094\t\u0094\4\u0095\t\u0095\4\u0096\t\u0096\4\u0097"+
		"\t\u0097\4\u0098\t\u0098\4\u0099\t\u0099\4\u009a\t\u009a\4\u009b\t\u009b"+
		"\4\u009c\t\u009c\4\u009d\t\u009d\4\u009e\t\u009e\4\u009f\t\u009f\4\u00a0"+
		"\t\u00a0\4\u00a1\t\u00a1\4\u00a2\t\u00a2\4\u00a3\t\u00a3\4\u00a4\t\u00a4"+
		"\4\u00a5\t\u00a5\4\u00a6\t\u00a6\4\u00a7\t\u00a7\4\u00a8\t\u00a8\4\u00a9"+
		"\t\u00a9\4\u00aa\t\u00aa\4\u00ab\t\u00ab\4\u00ac\t\u00ac\4\u00ad\t\u00ad"+
		"\4\u00ae\t\u00ae\4\u00af\t\u00af\4\u00b0\t\u00b0\4\u00b1\t\u00b1\4\u00b2"+
		"\t\u00b2\4\u00b3\t\u00b3\4\u00b4\t\u00b4\4\u00b5\t\u00b5\4\u00b6\t\u00b6"+
		"\4\u00b7\t\u00b7\3\2\3\2\3\2\3\2\5\2\u0173\n\2\3\2\3\2\3\3\3\3\3\4\3\4"+
		"\3\5\3\5\5\5\u017d\n\5\3\6\3\6\5\6\u0181\n\6\3\6\3\6\5\6\u0185\n\6\3\7"+
		"\3\7\5\7\u0189\n\7\3\7\3\7\3\7\5\7\u018e\n\7\3\b\3\b\3\b\3\b\7\b\u0194"+
		"\n\b\f\b\16\b\u0197\13\b\3\t\3\t\3\t\3\t\3\n\3\n\5\n\u019f\n\n\3\n\3\n"+
		"\3\n\3\n\5\n\u01a5\n\n\3\13\3\13\3\13\3\13\7\13\u01ab\n\13\f\13\16\13"+
		"\u01ae\13\13\3\13\3\13\3\f\3\f\3\f\3\f\7\f\u01b6\n\f\f\f\16\f\u01b9\13"+
		"\f\3\r\3\r\3\r\3\r\7\r\u01bf\n\r\f\r\16\r\u01c2\13\r\3\r\3\r\3\16\3\16"+
		"\3\16\3\16\3\16\6\16\u01cb\n\16\r\16\16\16\u01cc\5\16\u01cf\n\16\3\17"+
		"\3\17\5\17\u01d3\n\17\3\17\3\17\3\17\3\17\5\17\u01d9\n\17\5\17\u01db\n"+
		"\17\3\20\3\20\5\20\u01df\n\20\3\20\3\20\5\20\u01e3\n\20\3\20\3\20\5\20"+
		"\u01e7\n\20\5\20\u01e9\n\20\3\21\3\21\5\21\u01ed\n\21\3\21\5\21\u01f0"+
		"\n\21\3\21\5\21\u01f3\n\21\3\22\3\22\5\22\u01f7\n\22\3\22\5\22\u01fa\n"+
		"\22\3\22\3\22\5\22\u01fe\n\22\5\22\u0200\n\22\3\22\3\22\5\22\u0204\n\22"+
		"\3\22\3\22\5\22\u0208\n\22\5\22\u020a\n\22\3\22\5\22\u020d\n\22\5\22\u020f"+
		"\n\22\3\23\3\23\3\23\3\23\7\23\u0215\n\23\f\23\16\23\u0218\13\23\3\24"+
		"\3\24\3\24\3\24\7\24\u021e\n\24\f\24\16\24\u0221\13\24\3\25\3\25\5\25"+
		"\u0225\n\25\3\26\3\26\3\26\7\26\u022a\n\26\f\26\16\26\u022d\13\26\3\27"+
		"\3\27\3\27\5\27\u0232\n\27\3\30\3\30\3\30\3\30\5\30\u0238\n\30\3\31\3"+
		"\31\3\31\3\31\3\31\3\31\5\31\u0240\n\31\3\32\3\32\3\32\5\32\u0245\n\32"+
		"\3\32\3\32\5\32\u0249\n\32\3\33\5\33\u024c\n\33\3\33\5\33\u024f\n\33\3"+
		"\33\5\33\u0252\n\33\5\33\u0254\n\33\3\34\3\34\5\34\u0258\n\34\3\35\3\35"+
		"\3\35\3\36\3\36\5\36\u025f\n\36\3\36\3\36\3\37\3\37\3\37\7\37\u0266\n"+
		"\37\f\37\16\37\u0269\13\37\3 \3 \5 \u026d\n \3!\3!\3!\3!\5!\u0273\n!\3"+
		"\"\3\"\3\"\3\"\3\"\3#\3#\3#\3#\3#\3#\3$\3$\3$\5$\u0283\n$\3%\3%\3%\7%"+
		"\u0288\n%\f%\16%\u028b\13%\3&\3&\5&\u028f\n&\3\'\3\'\5\'\u0293\n\'\3("+
		"\3(\3(\3(\3(\3)\3)\7)\u029c\n)\f)\16)\u029f\13)\3*\3*\3*\3+\3+\5+\u02a6"+
		"\n+\3+\5+\u02a9\n+\3,\3,\3,\3-\3-\3-\3-\3-\3-\5-\u02b4\n-\3.\3.\5.\u02b8"+
		"\n.\3/\3/\3/\3/\3/\5/\u02bf\n/\3\60\3\60\3\60\3\60\3\60\3\60\3\60\5\60"+
		"\u02c8\n\60\3\61\3\61\3\61\3\61\3\61\5\61\u02cf\n\61\3\62\3\62\3\62\3"+
		"\62\3\62\5\62\u02d6\n\62\3\63\3\63\3\63\3\63\3\63\7\63\u02dd\n\63\f\63"+
		"\16\63\u02e0\13\63\3\64\3\64\3\64\5\64\u02e5\n\64\3\65\3\65\3\65\3\66"+
		"\3\66\3\66\3\66\3\66\7\66\u02ef\n\66\f\66\16\66\u02f2\13\66\3\67\3\67"+
		"\3\67\7\67\u02f7\n\67\f\67\16\67\u02fa\13\67\38\38\58\u02fe\n8\38\58\u0301"+
		"\n8\39\39\39\3:\3:\3:\5:\u0309\n:\3;\3;\3<\3<\3<\3<\3<\3<\3<\3=\3=\3>"+
		"\3>\3>\3?\3?\3?\5?\u031c\n?\3@\3@\3@\3@\3@\3@\5@\u0324\n@\3@\3@\3@\3@"+
		"\5@\u032a\n@\3A\3A\5A\u032e\nA\3B\3B\3B\3B\5B\u0334\nB\3C\3C\3C\3D\3D"+
		"\3D\3D\3D\3D\3D\3D\5D\u0341\nD\3D\3D\3D\3D\3D\5D\u0348\nD\3D\3D\3D\3D"+
		"\5D\u034e\nD\3D\3D\3D\3D\3D\5D\u0355\nD\3D\3D\3D\3D\3D\3D\3D\5D\u035e"+
		"\nD\3D\3D\3D\5D\u0363\nD\3D\3D\3D\3D\3D\3D\3D\3D\3D\3D\3D\3D\3D\3D\5D"+
		"\u0373\nD\3D\3D\5D\u0377\nD\3D\3D\3D\3D\3D\5D\u037e\nD\3D\3D\3D\3D\3D"+
		"\3D\7D\u0386\nD\fD\16D\u0389\13D\3E\3E\3E\3E\3E\3E\3E\3E\3E\3E\3E\3E\3"+
		"E\5E\u0398\nE\3F\3F\3F\3F\3F\3F\3F\3F\3F\7F\u03a3\nF\fF\16F\u03a6\13F"+
		"\5F\u03a8\nF\3F\3F\3F\3F\3F\3F\5F\u03b0\nF\3G\3G\3G\5G\u03b5\nG\3H\3H"+
		"\3H\3H\3H\3H\3H\3H\3H\6H\u03c0\nH\rH\16H\u03c1\3H\3H\3H\3H\3H\3H\3H\3"+
		"H\3H\3H\3H\3H\3H\5H\u03d1\nH\3H\3H\3H\3H\3H\3H\3H\3H\3H\3H\3H\3H\3H\3"+
		"H\3H\3H\7H\u03e3\nH\fH\16H\u03e6\13H\3I\3I\3I\3I\3I\3I\3I\3I\3I\3I\5I"+
		"\u03f2\nI\3I\3I\5I\u03f6\nI\3J\3J\5J\u03fa\nJ\3K\3K\3L\3L\3M\3M\3N\3N"+
		"\3N\3N\5N\u0406\nN\3N\3N\3O\3O\3O\3O\3O\5O\u040f\nO\3P\3P\3P\3P\3P\3Q"+
		"\3Q\3Q\3Q\3Q\5Q\u041b\nQ\3R\3R\3R\3R\3R\3S\3S\5S\u0424\nS\3T\3T\3T\6T"+
		"\u0429\nT\rT\16T\u042a\3T\5T\u042e\nT\3T\3T\3U\3U\3U\3U\3U\3V\3V\3V\3"+
		"W\3W\6W\u043c\nW\rW\16W\u043d\3W\5W\u0441\nW\3W\3W\3X\3X\3X\3X\3X\3Y\3"+
		"Y\3Y\3Y\3Y\3Y\3Y\5Y\u0451\nY\3Z\3Z\3[\3[\3\\\3\\\3\\\3\\\3\\\7\\\u045c"+
		"\n\\\f\\\16\\\u045f\13\\\3\\\5\\\u0462\n\\\3]\3]\3]\3]\3]\3]\5]\u046a"+
		"\n]\3^\3^\3^\3^\3^\3^\5^\u0472\n^\3_\3_\3_\3_\3_\3_\5_\u047a\n_\3`\3`"+
		"\3`\3`\3`\3`\5`\u0482\n`\3a\3a\3a\3a\5a\u0488\na\3b\3b\3b\3b\3b\3b\3c"+
		"\3c\3c\3c\3c\5c\u0495\nc\3d\3d\3d\3d\5d\u049b\nd\3e\3e\3f\3f\3g\3g\3h"+
		"\3h\3i\3i\3j\3j\3k\3k\3k\5k\u04ac\nk\3k\5k\u04af\nk\3l\3l\3l\5l\u04b4"+
		"\nl\3l\3l\3m\3m\3m\5m\u04bb\nm\3m\3m\3n\3n\3n\5n\u04c2\nn\3n\3n\3o\3o"+
		"\3p\3p\3p\3p\3p\3p\3q\3q\3r\3r\3s\3s\3s\3s\5s\u04d6\ns\5s\u04d8\ns\3t"+
		"\3t\3t\3t\3t\3t\3t\3t\5t\u04e2\nt\3u\3u\3u\3u\3u\5u\u04e9\nu\3u\3u\3v"+
		"\3v\3w\3w\3w\3w\5w\u04f3\nw\3w\3w\5w\u04f7\nw\3w\5w\u04fa\nw\3w\5w\u04fd"+
		"\nw\3w\5w\u0500\nw\3w\5w\u0503\nw\3x\3x\3y\3y\3y\3y\5y\u050b\ny\3y\3y"+
		"\3y\7y\u0510\ny\fy\16y\u0513\13y\3z\3z\3z\3z\3z\3{\3{\3{\3{\3{\3{\3{\3"+
		"{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3"+
		"{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\3{\5{\u0544\n{\3|\3|\3|\3|\3|\3|\3|\3"+
		"|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3"+
		"|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\3|\5|\u0570\n|\3}\3}\3}\3}\3}\3}\3}\3"+
		"}\3}\3}\5}\u057c\n}\3~\3~\3~\5~\u0581\n~\3\177\3\177\3\177\3\177\3\177"+
		"\5\177\u0588\n\177\3\177\5\177\u058b\n\177\3\177\3\177\3\177\3\177\3\177"+
		"\3\177\3\177\3\177\3\177\3\177\3\177\5\177\u0598\n\177\3\u0080\3\u0080"+
		"\3\u0080\3\u0080\3\u0080\5\u0080\u059f\n\u0080\3\u0080\5\u0080\u05a2\n"+
		"\u0080\3\u0080\3\u0080\3\u0080\3\u0080\3\u0080\3\u0080\3\u0080\3\u0080"+
		"\3\u0080\3\u0080\3\u0080\5\u0080\u05af\n\u0080\3\u0081\3\u0081\3\u0081"+
		"\5\u0081\u05b4\n\u0081\3\u0081\3\u0081\3\u0081\3\u0081\5\u0081\u05ba\n"+
		"\u0081\3\u0081\3\u0081\5\u0081\u05be\n\u0081\3\u0081\5\u0081\u05c1\n\u0081"+
		"\3\u0081\5\u0081\u05c4\n\u0081\3\u0082\3\u0082\3\u0082\3\u0082\3\u0082"+
		"\5\u0082\u05cb\n\u0082\3\u0082\3\u0082\5\u0082\u05cf\n\u0082\3\u0083\3"+
		"\u0083\3\u0083\3\u0083\3\u0083\3\u0083\3\u0084\3\u0084\3\u0084\3\u0084"+
		"\3\u0084\3\u0085\3\u0085\3\u0085\3\u0085\5\u0085\u05e0\n\u0085\3\u0086"+
		"\3\u0086\3\u0086\3\u0086\5\u0086\u05e6\n\u0086\3\u0087\3\u0087\3\u0087"+
		"\5\u0087\u05eb\n\u0087\3\u0087\5\u0087\u05ee\n\u0087\3\u0087\5\u0087\u05f1"+
		"\n\u0087\3\u0087\3\u0087\3\u0088\3\u0088\3\u0088\3\u0088\3\u0088\7\u0088"+
		"\u05fa\n\u0088\f\u0088\16\u0088\u05fd\13\u0088\3\u0089\3\u0089\3\u0089"+
		"\5\u0089\u0602\n\u0089\3\u0089\3\u0089\3\u0089\3\u0089\3\u0089\3\u0089"+
		"\5\u0089\u060a\n\u0089\5\u0089\u060c\n\u0089\3\u008a\3\u008a\3\u008a\3"+
		"\u008a\3\u008a\3\u008a\3\u008a\3\u008a\3\u008a\3\u008a\5\u008a\u0618\n"+
		"\u008a\3\u008b\3\u008b\3\u008b\3\u008b\3\u008b\3\u008b\3\u008b\3\u008b"+
		"\3\u008b\3\u008b\5\u008b\u0624\n\u008b\3\u008c\3\u008c\3\u008c\3\u008c"+
		"\3\u008c\3\u008c\3\u008c\3\u008c\3\u008c\3\u008c\5\u008c\u0630\n\u008c"+
		"\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d"+
		"\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d\3\u008d"+
		"\3\u008d\5\u008d\u0645\n\u008d\3\u008e\3\u008e\3\u008e\3\u008e\3\u008e"+
		"\3\u008e\3\u008e\3\u008f\3\u008f\3\u008f\3\u008f\3\u008f\5\u008f\u0653"+
		"\n\u008f\3\u008f\5\u008f\u0656\n\u008f\3\u0090\3\u0090\3\u0090\3\u0090"+
		"\3\u0090\3\u0090\3\u0090\7\u0090\u065f\n\u0090\f\u0090\16\u0090\u0662"+
		"\13\u0090\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091\5\u0091"+
		"\u066b\n\u0091\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091\3\u0091"+
		"\3\u0091\3\u0091\5\u0091\u0676\n\u0091\3\u0091\3\u0091\5\u0091\u067a\n"+
		"\u0091\3\u0092\3\u0092\3\u0093\3\u0093\3\u0094\3\u0094\3\u0094\5\u0094"+
		"\u0683\n\u0094\3\u0094\5\u0094\u0686\n\u0094\3\u0094\5\u0094\u0689\n\u0094"+
		"\3\u0094\3\u0094\3\u0094\3\u0095\3\u0095\3\u0096\3\u0096\3\u0097\3\u0097"+
		"\3\u0097\3\u0097\3\u0097\3\u0097\3\u0097\5\u0097\u0699\n\u0097\3\u0097"+
		"\3\u0097\3\u0098\3\u0098\3\u0099\3\u0099\3\u009a\3\u009a\3\u009b\3\u009b"+
		"\3\u009b\3\u009b\3\u009b\3\u009b\3\u009b\3\u009b\3\u009b\5\u009b\u06ac"+
		"\n\u009b\3\u009b\3\u009b\3\u009c\3\u009c\3\u009d\3\u009d\3\u009e\3\u009e"+
		"\3\u009f\3\u009f\3\u00a0\3\u00a0\3\u00a0\5\u00a0\u06bb\n\u00a0\3\u00a0"+
		"\3\u00a0\5\u00a0\u06bf\n\u00a0\3\u00a1\3\u00a1\3\u00a1\5\u00a1\u06c4\n"+
		"\u00a1\3\u00a1\3\u00a1\5\u00a1\u06c8\n\u00a1\3\u00a2\3\u00a2\3\u00a2\5"+
		"\u00a2\u06cd\n\u00a2\3\u00a2\3\u00a2\5\u00a2\u06d1\n\u00a2\3\u00a3\3\u00a3"+
		"\3\u00a3\5\u00a3\u06d6\n\u00a3\3\u00a3\5\u00a3\u06d9\n\u00a3\3\u00a4\3"+
		"\u00a4\3\u00a4\5\u00a4\u06de\n\u00a4\3\u00a4\3\u00a4\5\u00a4\u06e2\n\u00a4"+
		"\3\u00a5\3\u00a5\3\u00a5\5\u00a5\u06e7\n\u00a5\3\u00a5\3\u00a5\5\u00a5"+
		"\u06eb\n\u00a5\3\u00a6\3\u00a6\3\u00a6\5\u00a6\u06f0\n\u00a6\3\u00a6\3"+
		"\u00a6\5\u00a6\u06f4\n\u00a6\3\u00a7\3\u00a7\3\u00a7\5\u00a7\u06f9\n\u00a7"+
		"\3\u00a7\3\u00a7\5\u00a7\u06fd\n\u00a7\3\u00a8\3\u00a8\3\u00a8\3\u00a8"+
		"\3\u00a8\3\u00a8\3\u00a8\3\u00a9\3\u00a9\3\u00aa\3\u00aa\3\u00aa\3\u00aa"+
		"\3\u00aa\3\u00aa\3\u00aa\3\u00aa\3\u00aa\3\u00aa\3\u00aa\3\u00aa\5\u00aa"+
		"\u0714\n\u00aa\3\u00ab\3\u00ab\3\u00ab\3\u00ab\3\u00ab\5\u00ab\u071b\n"+
		"\u00ab\3\u00ac\3\u00ac\3\u00ad\3\u00ad\3\u00ad\3\u00ad\3\u00ad\3\u00ad"+
		"\3\u00ad\3\u00ad\3\u00ad\5\u00ad\u0728\n\u00ad\3\u00ae\3\u00ae\3\u00ae"+
		"\3\u00ae\3\u00ae\3\u00ae\5\u00ae\u0730\n\u00ae\3\u00af\3\u00af\5\u00af"+
		"\u0734\n\u00af\3\u00af\3\u00af\5\u00af\u0738\n\u00af\3\u00b0\3\u00b0\3"+
		"\u00b1\3\u00b1\3\u00b1\3\u00b1\3\u00b1\3\u00b1\3\u00b1\3\u00b2\3\u00b2"+
		"\3\u00b3\3\u00b3\3\u00b4\3\u00b4\3\u00b4\3\u00b4\3\u00b4\7\u00b4\u074c"+
		"\n\u00b4\f\u00b4\16\u00b4\u074f\13\u00b4\3\u00b4\3\u00b4\3\u00b5\3\u00b5"+
		"\3\u00b5\3\u00b5\3\u00b5\7\u00b5\u0758\n\u00b5\f\u00b5\16\u00b5\u075b"+
		"\13\u00b5\3\u00b5\3\u00b5\3\u00b6\3\u00b6\3\u00b6\3\u00b6\5\u00b6\u0763"+
		"\n\u00b6\3\u00b7\3\u00b7\3\u00b7\5\u00b7\u0768\n\u00b7\3\u00b7\2\4\u0086"+
		"\u008e\u00b8\2\4\6\b\n\f\16\20\22\24\26\30\32\34\36 \"$&(*,.\60\62\64"+
		"\668:<>@BDFHJLNPRTVXZ\\^`bdfhjlnprtvxz|~\u0080\u0082\u0084\u0086\u0088"+
		"\u008a\u008c\u008e\u0090\u0092\u0094\u0096\u0098\u009a\u009c\u009e\u00a0"+
		"\u00a2\u00a4\u00a6\u00a8\u00aa\u00ac\u00ae\u00b0\u00b2\u00b4\u00b6\u00b8"+
		"\u00ba\u00bc\u00be\u00c0\u00c2\u00c4\u00c6\u00c8\u00ca\u00cc\u00ce\u00d0"+
		"\u00d2\u00d4\u00d6\u00d8\u00da\u00dc\u00de\u00e0\u00e2\u00e4\u00e6\u00e8"+
		"\u00ea\u00ec\u00ee\u00f0\u00f2\u00f4\u00f6\u00f8\u00fa\u00fc\u00fe\u0100"+
		"\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118"+
		"\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130"+
		"\u0132\u0134\u0136\u0138\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148"+
		"\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160"+
		"\u0162\u0164\u0166\u0168\u016a\u016c\2\34\5\2^^ss\u00a4\u00a4\4\2\u0092"+
		"\u0092\u00c2\u00c2\4\2JJ\u00bd\u00bd\4\2ggpp\4\2YYqq\4\2\64\64HH\3\2\u00a6"+
		"\u00a7\4\2YY\u008a\u008a\4\2eett\4\2KKhh\3\2!#\3\2\37 \3\2\u00c6\u00c7"+
		"\3\2\5\13\4\2\5\5\7\7\4\2\60\60RR\4\2\62\62\u00ac\u00ac\4\2\u00c2\u00c2"+
		"\u00c4\u00c4\5\2aa\u00a2\u00a2\u00a7\u00a7\5\2\67\67rr\u00b5\u00b5\4\2"+
		"rr\u00b5\u00b5\t\2FFcc\u0086\u0088\u00a1\u00a1\u00a8\u00a8\u00bf\u00bf"+
		"\u00c5\u00c5\4\2cc\u0086\u0086\4\2DD\u00b1\u00b1\t\2+.\60]_hjrt\u0096"+
		"\u0098\u00a3\u00a5\u00c5\7\2^^iiss\u0097\u0097\u00a4\u00a4\2\u07e6\2\u0172"+
		"\3\2\2\2\4\u0176\3\2\2\2\6\u0178\3\2\2\2\b\u017a\3\2\2\2\n\u017e\3\2\2"+
		"\2\f\u0186\3\2\2\2\16\u018f\3\2\2\2\20\u0198\3\2\2\2\22\u019c\3\2\2\2"+
		"\24\u01a6\3\2\2\2\26\u01b1\3\2\2\2\30\u01ba\3\2\2\2\32\u01ce\3\2\2\2\34"+
		"\u01da\3\2\2\2\36\u01e8\3\2\2\2 \u01ea\3\2\2\2\"\u020e\3\2\2\2$\u0210"+
		"\3\2\2\2&\u0219\3\2\2\2(\u0222\3\2\2\2*\u0226\3\2\2\2,\u0231\3\2\2\2."+
		"\u0233\3\2\2\2\60\u0239\3\2\2\2\62\u0241\3\2\2\2\64\u0253\3\2\2\2\66\u0255"+
		"\3\2\2\28\u0259\3\2\2\2:\u025c\3\2\2\2<\u0262\3\2\2\2>\u026a\3\2\2\2@"+
		"\u0272\3\2\2\2B\u0274\3\2\2\2D\u0279\3\2\2\2F\u0282\3\2\2\2H\u0284\3\2"+
		"\2\2J\u028c\3\2\2\2L\u0292\3\2\2\2N\u0294\3\2\2\2P\u0299\3\2\2\2R\u02a0"+
		"\3\2\2\2T\u02a8\3\2\2\2V\u02aa\3\2\2\2X\u02b3\3\2\2\2Z\u02b5\3\2\2\2\\"+
		"\u02b9\3\2\2\2^\u02c0\3\2\2\2`\u02c9\3\2\2\2b\u02d0\3\2\2\2d\u02d7\3\2"+
		"\2\2f\u02e4\3\2\2\2h\u02e6\3\2\2\2j\u02e9\3\2\2\2l\u02f3\3\2\2\2n\u02fb"+
		"\3\2\2\2p\u0302\3\2\2\2r\u0308\3\2\2\2t\u030a\3\2\2\2v\u030c\3\2\2\2x"+
		"\u0313\3\2\2\2z\u0315\3\2\2\2|\u0318\3\2\2\2~\u031d\3\2\2\2\u0080\u032d"+
		"\3\2\2\2\u0082\u0333\3\2\2\2\u0084\u0335\3\2\2\2\u0086\u037d\3\2\2\2\u0088"+
		"\u0397\3\2\2\2\u008a\u03af\3\2\2\2\u008c\u03b1\3\2\2\2\u008e\u03d0\3\2"+
		"\2\2\u0090\u03f5\3\2\2\2\u0092\u03f9\3\2\2\2\u0094\u03fb\3\2\2\2\u0096"+
		"\u03fd\3\2\2\2\u0098\u03ff\3\2\2\2\u009a\u0401\3\2\2\2\u009c\u0409\3\2"+
		"\2\2\u009e\u0410\3\2\2\2\u00a0\u0415\3\2\2\2\u00a2\u041c\3\2\2\2\u00a4"+
		"\u0423\3\2\2\2\u00a6\u0425\3\2\2\2\u00a8\u0431\3\2\2\2\u00aa\u0436\3\2"+
		"\2\2\u00ac\u0439\3\2\2\2\u00ae\u0444\3\2\2\2\u00b0\u0450\3\2\2\2\u00b2"+
		"\u0452\3\2\2\2\u00b4\u0454\3\2\2\2\u00b6\u0461\3\2\2\2\u00b8\u0469\3\2"+
		"\2\2\u00ba\u0471\3\2\2\2\u00bc\u0479\3\2\2\2\u00be\u0481\3\2\2\2\u00c0"+
		"\u0483\3\2\2\2\u00c2\u0489\3\2\2\2\u00c4\u048f\3\2\2\2\u00c6\u0496\3\2"+
		"\2\2\u00c8\u049c\3\2\2\2\u00ca\u049e\3\2\2\2\u00cc\u04a0\3\2\2\2\u00ce"+
		"\u04a2\3\2\2\2\u00d0\u04a4\3\2\2\2\u00d2\u04a6\3\2\2\2\u00d4\u04ae\3\2"+
		"\2\2\u00d6\u04b0\3\2\2\2\u00d8\u04b7\3\2\2\2\u00da\u04be\3\2\2\2\u00dc"+
		"\u04c5\3\2\2\2\u00de\u04c7\3\2\2\2\u00e0\u04cd\3\2\2\2\u00e2\u04cf\3\2"+
		"\2\2\u00e4\u04d7\3\2\2\2\u00e6\u04e1\3\2\2\2\u00e8\u04e3\3\2\2\2\u00ea"+
		"\u04ec\3\2\2\2\u00ec\u04ee\3\2\2\2\u00ee\u0504\3\2\2\2\u00f0\u050a\3\2"+
		"\2\2\u00f2\u0514\3\2\2\2\u00f4\u0543\3\2\2\2\u00f6\u056f\3\2\2\2\u00f8"+
		"\u057b\3\2\2\2\u00fa\u0580\3\2\2\2\u00fc\u0597\3\2\2\2\u00fe\u05ae\3\2"+
		"\2\2\u0100\u05b0\3\2\2\2\u0102\u05c5\3\2\2\2\u0104\u05d0\3\2\2\2\u0106"+
		"\u05d6\3\2\2\2\u0108\u05df\3\2\2\2\u010a\u05e5\3\2\2\2\u010c\u05e7\3\2"+
		"\2\2\u010e\u05f4\3\2\2\2\u0110\u060b\3\2\2\2\u0112\u0617\3\2\2\2\u0114"+
		"\u0623\3\2\2\2\u0116\u062f\3\2\2\2\u0118\u0644\3\2\2\2\u011a\u0646\3\2"+
		"\2\2\u011c\u064d\3\2\2\2\u011e\u0657\3\2\2\2\u0120\u0679\3\2\2\2\u0122"+
		"\u067b\3\2\2\2\u0124\u067d\3\2\2\2\u0126\u067f\3\2\2\2\u0128\u068d\3\2"+
		"\2\2\u012a\u068f\3\2\2\2\u012c\u0691\3\2\2\2\u012e\u069c\3\2\2\2\u0130"+
		"\u069e\3\2\2\2\u0132\u06a0\3\2\2\2\u0134\u06a2\3\2\2\2\u0136\u06af\3\2"+
		"\2\2\u0138\u06b1\3\2\2\2\u013a\u06b3\3\2\2\2\u013c\u06b5\3\2\2\2\u013e"+
		"\u06be\3\2\2\2\u0140\u06c7\3\2\2\2\u0142\u06d0\3\2\2\2\u0144\u06d8\3\2"+
		"\2\2\u0146\u06e1\3\2\2\2\u0148\u06ea\3\2\2\2\u014a\u06f3\3\2\2\2\u014c"+
		"\u06fc\3\2\2\2\u014e\u06fe\3\2\2\2\u0150\u0705\3\2\2\2\u0152\u0713\3\2"+
		"\2\2\u0154\u071a\3\2\2\2\u0156\u071c\3\2\2\2\u0158\u0727\3\2\2\2\u015a"+
		"\u072f\3\2\2\2\u015c\u0737\3\2\2\2\u015e\u0739\3\2\2\2\u0160\u073b\3\2"+
		"\2\2\u0162\u0742\3\2\2\2\u0164\u0744\3\2\2\2\u0166\u0746\3\2\2\2\u0168"+
		"\u0752\3\2\2\2\u016a\u0762\3\2\2\2\u016c\u0767\3\2\2\2\u016e\u0173\5\4"+
		"\3\2\u016f\u0173\5\f\7\2\u0170\u0173\5\n\6\2\u0171\u0173\5\22\n\2\u0172"+
		"\u016e\3\2\2\2\u0172\u016f\3\2\2\2\u0172\u0170\3\2\2\2\u0172\u0171\3\2"+
		"\2\2\u0173\u0174\3\2\2\2\u0174\u0175\7\2\2\3\u0175\3\3\2\2\2\u0176\u0177"+
		"\5\32\16\2\u0177\5\3\2\2\2\u0178\u0179\5\32\16\2\u0179\7\3\2\2\2\u017a"+
		"\u017c\5*\26\2\u017b\u017d\5,\27\2\u017c\u017b\3\2\2\2\u017c\u017d\3\2"+
		"\2\2\u017d\t\3\2\2\2\u017e\u0180\7G\2\2\u017f\u0181\7]\2\2\u0180\u017f"+
		"\3\2\2\2\u0180\u0181\3\2\2\2\u0181\u0182\3\2\2\2\u0182\u0184\5\b\5\2\u0183"+
		"\u0185\5\u0084C\2\u0184\u0183\3\2\2\2\u0184\u0185\3\2\2\2\u0185\13\3\2"+
		"\2\2\u0186\u0188\7\u00bc\2\2\u0187\u0189\7-\2\2\u0188\u0187\3\2\2\2\u0188"+
		"\u0189\3\2\2\2\u0189\u018a\3\2\2\2\u018a\u018b\5\b\5\2\u018b\u018d\5\16"+
		"\b\2\u018c\u018e\5\u0084C\2\u018d\u018c\3\2\2\2\u018d\u018e\3\2\2\2\u018e"+
		"\r\3\2\2\2\u018f\u0190\7\u00aa\2\2\u0190\u0195\5\20\t\2\u0191\u0192\7"+
		"\27\2\2\u0192\u0194\5\20\t\2\u0193\u0191\3\2\2\2\u0194\u0197\3\2\2\2\u0195"+
		"\u0193\3\2\2\2\u0195\u0196\3\2\2\2\u0196\17\3\2\2\2\u0197\u0195\3\2\2"+
		"\2\u0198\u0199\5P)\2\u0199\u019a\7\21\2\2\u019a\u019b\5\u0092J\2\u019b"+
		"\21\3\2\2\2\u019c\u019e\7j\2\2\u019d\u019f\7m\2\2\u019e\u019d\3\2\2\2"+
		"\u019e\u019f\3\2\2\2\u019f\u01a0\3\2\2\2\u01a0\u01a1\5\b\5\2\u01a1\u01a4"+
		"\5\24\13\2\u01a2\u01a5\5\32\16\2\u01a3\u01a5\5\26\f\2\u01a4\u01a2\3\2"+
		"\2\2\u01a4\u01a3\3\2\2\2\u01a5\23\3\2\2\2\u01a6\u01a7\7\31\2\2\u01a7\u01ac"+
		"\5P)\2\u01a8\u01a9\7\27\2\2\u01a9\u01ab\5P)\2\u01aa\u01a8\3\2\2\2\u01ab"+
		"\u01ae\3\2\2\2\u01ac\u01aa\3\2\2\2\u01ac\u01ad\3\2\2\2\u01ad\u01af\3\2"+
		"\2\2\u01ae\u01ac\3\2\2\2\u01af\u01b0\7\32\2\2\u01b0\25\3\2\2\2\u01b1\u01b2"+
		"\7\u00be\2\2\u01b2\u01b7\5\30\r\2\u01b3\u01b4\7\27\2\2\u01b4\u01b6\5\30"+
		"\r\2\u01b5\u01b3\3\2\2\2\u01b6\u01b9\3\2\2\2\u01b7\u01b5\3\2\2\2\u01b7"+
		"\u01b8\3\2\2\2\u01b8\27\3\2\2\2\u01b9\u01b7\3\2\2\2\u01ba\u01bb\7\31\2"+
		"\2\u01bb\u01c0\5\u0092J\2\u01bc\u01bd\7\27\2\2\u01bd\u01bf\5\u0092J\2"+
		"\u01be\u01bc\3\2\2\2\u01bf\u01c2\3\2\2\2\u01c0\u01be\3\2\2\2\u01c0\u01c1"+
		"\3\2\2\2\u01c1\u01c3\3\2\2\2\u01c2\u01c0\3\2\2\2\u01c3\u01c4\7\32\2\2"+
		"\u01c4\31\3\2\2\2\u01c5\u01cf\5\34\17\2\u01c6\u01ca\5\34\17\2\u01c7\u01c8"+
		"\5\36\20\2\u01c8\u01c9\5\34\17\2\u01c9\u01cb\3\2\2\2\u01ca\u01c7\3\2\2"+
		"\2\u01cb\u01cc\3\2\2\2\u01cc\u01ca\3\2\2\2\u01cc\u01cd\3\2\2\2\u01cd\u01cf"+
		"\3\2\2\2\u01ce\u01c5\3\2\2\2\u01ce\u01c6\3\2\2\2\u01cf\33\3\2\2\2\u01d0"+
		"\u01d2\5\"\22\2\u01d1\u01d3\5 \21\2\u01d2\u01d1\3\2\2\2\u01d2\u01d3\3"+
		"\2\2\2\u01d3\u01db\3\2\2\2\u01d4\u01d5\7\31\2\2\u01d5\u01d6\5\32\16\2"+
		"\u01d6\u01d8\7\32\2\2\u01d7\u01d9\5 \21\2\u01d8\u01d7\3\2\2\2\u01d8\u01d9"+
		"\3\2\2\2\u01d9\u01db\3\2\2\2\u01da\u01d0\3\2\2\2\u01da\u01d4\3\2\2\2\u01db"+
		"\35\3\2\2\2\u01dc\u01de\7\u00bb\2\2\u01dd\u01df\7\60\2\2\u01de\u01dd\3"+
		"\2\2\2\u01de\u01df\3\2\2\2\u01df\u01e9\3\2\2\2\u01e0\u01e2\7l\2\2\u01e1"+
		"\u01e3\7\60\2\2\u01e2\u01e1\3\2\2\2\u01e2\u01e3\3\2\2\2\u01e3\u01e9\3"+
		"\2\2\2\u01e4\u01e6\7S\2\2\u01e5\u01e7\7\60\2\2\u01e6\u01e5\3\2\2\2\u01e6"+
		"\u01e7\3\2\2\2\u01e7\u01e9\3\2\2\2\u01e8\u01dc\3\2\2\2\u01e8\u01e0\3\2"+
		"\2\2\u01e8\u01e4\3\2\2\2\u01e9\37\3\2\2\2\u01ea\u01ec\5j\66\2\u01eb\u01ed"+
		"\5z>\2\u01ec\u01eb\3\2\2\2\u01ec\u01ed\3\2\2\2\u01ed\u01ef\3\2\2\2\u01ee"+
		"\u01f0\5|?\2\u01ef\u01ee\3\2\2\2\u01ef\u01f0\3\2\2\2\u01f0\u01f2\3\2\2"+
		"\2\u01f1\u01f3\5~@\2\u01f2\u01f1\3\2\2\2\u01f2\u01f3\3\2\2\2\u01f3!\3"+
		"\2\2\2\u01f4\u01f6\5:\36\2\u01f5\u01f7\5$\23\2\u01f6\u01f5\3\2\2\2\u01f6"+
		"\u01f7\3\2\2\2\u01f7\u01f9\3\2\2\2\u01f8\u01fa\5\u0084C\2\u01f9\u01f8"+
		"\3\2\2\2\u01f9\u01fa\3\2\2\2\u01fa\u01ff\3\2\2\2\u01fb\u01fd\5d\63\2\u01fc"+
		"\u01fe\5h\65\2\u01fd\u01fc\3\2\2\2\u01fd\u01fe\3\2\2\2\u01fe\u0200\3\2"+
		"\2\2\u01ff\u01fb\3\2\2\2\u01ff\u0200\3\2\2\2\u0200\u020f\3\2\2\2\u0201"+
		"\u0203\5$\23\2\u0202\u0204\5\u0084C\2\u0203\u0202\3\2\2\2\u0203\u0204"+
		"\3\2\2\2\u0204\u0209\3\2\2\2\u0205\u0207\5d\63\2\u0206\u0208\5h\65\2\u0207"+
		"\u0206\3\2\2\2\u0207\u0208\3\2\2\2\u0208\u020a\3\2\2\2\u0209\u0205\3\2"+
		"\2\2\u0209\u020a\3\2\2\2\u020a\u020c\3\2\2\2\u020b\u020d\5:\36\2\u020c"+
		"\u020b\3\2\2\2\u020c\u020d\3\2\2\2\u020d\u020f\3\2\2\2\u020e\u01f4\3\2"+
		"\2\2\u020e\u0201\3\2\2\2\u020f#\3\2\2\2\u0210\u0211\7]\2\2\u0211\u0216"+
		"\5&\24\2\u0212\u0213\7\27\2\2\u0213\u0215\5&\24\2\u0214\u0212\3\2\2\2"+
		"\u0215\u0218\3\2\2\2\u0216\u0214\3\2\2\2\u0216\u0217\3\2\2\2\u0217%\3"+
		"\2\2\2\u0218\u0216\3\2\2\2\u0219\u021f\5(\25\2\u021a\u021e\5\62\32\2\u021b"+
		"\u021e\5.\30\2\u021c\u021e\5\60\31\2\u021d\u021a\3\2\2\2\u021d\u021b\3"+
		"\2\2\2\u021d\u021c\3\2\2\2\u021e\u0221\3\2\2\2\u021f\u021d\3\2\2\2\u021f"+
		"\u0220\3\2\2\2\u0220\'\3\2\2\2\u0221\u021f\3\2\2\2\u0222\u0224\5*\26\2"+
		"\u0223\u0225\5,\27\2\u0224\u0223\3\2\2\2\u0224\u0225\3\2\2\2\u0225)\3"+
		"\2\2\2\u0226\u022b\5\u016c\u00b7\2\u0227\u0228\7\30\2\2\u0228\u022a\5"+
		"\u016c\u00b7\2\u0229\u0227\3\2\2\2\u022a\u022d\3\2\2\2\u022b\u0229\3\2"+
		"\2\2\u022b\u022c\3\2\2\2\u022c+\3\2\2\2\u022d\u022b\3\2\2\2\u022e\u022f"+
		"\7\63\2\2\u022f\u0232\5\u016c\u00b7\2\u0230\u0232\5\u016a\u00b6\2\u0231"+
		"\u022e\3\2\2\2\u0231\u0230\3\2\2\2\u0232-\3\2\2\2\u0233\u0234\7=\2\2\u0234"+
		"\u0235\7o\2\2\u0235\u0237\5*\26\2\u0236\u0238\5,\27\2\u0237\u0236\3\2"+
		"\2\2\u0237\u0238\3\2\2\2\u0238/\3\2\2\2\u0239\u023a\7\27\2\2\u023a\u023b"+
		"\7f\2\2\u023b\u023c\7\31\2\2\u023c\u023d\5T+\2\u023d\u023f\7\32\2\2\u023e"+
		"\u0240\5,\27\2\u023f\u023e\3\2\2\2\u023f\u0240\3\2\2\2\u0240\61\3\2\2"+
		"\2\u0241\u0242\5\64\33\2\u0242\u0244\7o\2\2\u0243\u0245\7W\2\2\u0244\u0243"+
		"\3\2\2\2\u0244\u0245\3\2\2\2\u0245\u0246\3\2\2\2\u0246\u0248\5\66\34\2"+
		"\u0247\u0249\58\35\2\u0248\u0247\3\2\2\2\u0248\u0249\3\2\2\2\u0249\63"+
		"\3\2\2\2\u024a\u024c\7i\2\2\u024b\u024a\3\2\2\2\u024b\u024c\3\2\2\2\u024c"+
		"\u0254\3\2\2\2\u024d\u024f\t\2\2\2\u024e\u024d\3\2\2\2\u024e\u024f\3\2"+
		"\2\2\u024f\u0251\3\2\2\2\u0250\u0252\7\u0097\2\2\u0251\u0250\3\2\2\2\u0251"+
		"\u0252\3\2\2\2\u0252\u0254\3\2\2\2\u0253\u024b\3\2\2\2\u0253\u024e\3\2"+
		"\2\2\u0254\65\3\2\2\2\u0255\u0257\5T+\2\u0256\u0258\5,\27\2\u0257\u0256"+
		"\3\2\2\2\u0257\u0258\3\2\2\2\u0258\67\3\2\2\2\u0259\u025a\t\3\2\2\u025a"+
		"\u025b\5\u0086D\2\u025b9\3\2\2\2\u025c\u025e\7\u00a9\2\2\u025d\u025f\7"+
		"I\2\2\u025e\u025d\3\2\2\2\u025e\u025f\3\2\2\2\u025f\u0260\3\2\2\2\u0260"+
		"\u0261\5<\37\2\u0261;\3\2\2\2\u0262\u0267\5> \2\u0263\u0264\7\27\2\2\u0264"+
		"\u0266\5> \2\u0265\u0263\3\2\2\2\u0266\u0269\3\2\2\2\u0267\u0265\3\2\2"+
		"\2\u0267\u0268\3\2\2\2\u0268=\3\2\2\2\u0269\u0267\3\2\2\2\u026a\u026c"+
		"\5@!\2\u026b\u026d\5,\27\2\u026c\u026b\3\2\2\2\u026c\u026d\3\2\2\2\u026d"+
		"?\3\2\2\2\u026e\u0273\5D#\2\u026f\u0273\5B\"\2\u0270\u0273\5N(\2\u0271"+
		"\u0273\5\u0092J\2\u0272\u026e\3\2\2\2\u0272\u026f\3\2\2\2\u0272\u0270"+
		"\3\2\2\2\u0272\u0271\3\2\2\2\u0273A\3\2\2\2\u0274\u0275\7O\2\2\u0275\u0276"+
		"\7\31\2\2\u0276\u0277\5T+\2\u0277\u0278\7\32\2\2\u0278C\3\2\2\2\u0279"+
		"\u027a\7\u0089\2\2\u027a\u027b\5F$\2\u027b\u027c\7\31\2\2\u027c\u027d"+
		"\5H%\2\u027d\u027e\7\32\2\2\u027eE\3\2\2\2\u027f\u0283\7v\2\2\u0280\u0283"+
		"\7|\2\2\u0281\u0283\5P)\2\u0282\u027f\3\2\2\2\u0282\u0280\3\2\2\2\u0282"+
		"\u0281\3\2\2\2\u0283G\3\2\2\2\u0284\u0289\5J&\2\u0285\u0286\7\27\2\2\u0286"+
		"\u0288\5J&\2\u0287\u0285\3\2\2\2\u0288\u028b\3\2\2\2\u0289\u0287\3\2\2"+
		"\2\u0289\u028a\3\2\2\2\u028aI\3\2\2\2\u028b\u0289\3\2\2\2\u028c\u028e"+
		"\5L\'\2\u028d\u028f\5,\27\2\u028e\u028d\3\2\2\2\u028e\u028f\3\2\2\2\u028f"+
		"K\3\2\2\2\u0290\u0293\5\u0092J\2\u0291\u0293\5D#\2\u0292\u0290\3\2\2\2"+
		"\u0292\u0291\3\2\2\2\u0293M\3\2\2\2\u0294\u0295\7\u008e\2\2\u0295\u0296"+
		"\7\31\2\2\u0296\u0297\5\u016c\u00b7\2\u0297\u0298\7\32\2\2\u0298O\3\2"+
		"\2\2\u0299\u029d\5\u016c\u00b7\2\u029a\u029c\5R*\2\u029b\u029a\3\2\2\2"+
		"\u029c\u029f\3\2\2\2\u029d\u029b\3\2\2\2\u029d\u029e\3\2\2\2\u029eQ\3"+
		"\2\2\2\u029f\u029d\3\2\2\2\u02a0\u02a1\7\30\2\2\u02a1\u02a2\5\u016c\u00b7"+
		"\2\u02a2S\3\2\2\2\u02a3\u02a5\5X-\2\u02a4\u02a6\5V,\2\u02a5\u02a4\3\2"+
		"\2\2\u02a5\u02a6\3\2\2\2\u02a6\u02a9\3\2\2\2\u02a7\u02a9\5Z.\2\u02a8\u02a3"+
		"\3\2\2\2\u02a8\u02a7\3\2\2\2\u02a9U\3\2\2\2\u02aa\u02ab\7\30\2\2\u02ab"+
		"\u02ac\5P)\2\u02acW\3\2\2\2\u02ad\u02b4\5^\60\2\u02ae\u02b4\5`\61\2\u02af"+
		"\u02b4\5b\62\2\u02b0\u02b1\5P)\2\u02b1\u02b2\5\\/\2\u02b2\u02b4\3\2\2"+
		"\2\u02b3\u02ad\3\2\2\2\u02b3\u02ae\3\2\2\2\u02b3\u02af\3\2\2\2\u02b3\u02b0"+
		"\3\2\2\2\u02b4Y\3\2\2\2\u02b5\u02b7\5P)\2\u02b6\u02b8\5\\/\2\u02b7\u02b6"+
		"\3\2\2\2\u02b7\u02b8\3\2\2\2\u02b8[\3\2\2\2\u02b9\u02ba\7\33\2\2\u02ba"+
		"\u02bb\5\u008eH\2\u02bb\u02be\7\34\2\2\u02bc\u02bd\7\30\2\2\u02bd\u02bf"+
		"\5Z.\2\u02be\u02bc\3\2\2\2\u02be\u02bf\3\2\2\2\u02bf]\3\2\2\2\u02c0\u02c1"+
		"\7\u00b6\2\2\u02c1\u02c2\7\31\2\2\u02c2\u02c3\5T+\2\u02c3\u02c4\7\63\2"+
		"\2\u02c4\u02c5\5P)\2\u02c5\u02c7\7\32\2\2\u02c6\u02c8\5V,\2\u02c7\u02c6"+
		"\3\2\2\2\u02c7\u02c8\3\2\2\2\u02c8_\3\2\2\2\u02c9\u02ca\t\4\2\2\u02ca"+
		"\u02cb\7\31\2\2\u02cb\u02cc\5T+\2\u02cc\u02ce\7\32\2\2\u02cd\u02cf\5V"+
		",\2\u02ce\u02cd\3\2\2\2\u02ce\u02cf\3\2\2\2\u02cfa\3\2\2\2\u02d0\u02d1"+
		"\t\5\2\2\u02d1\u02d2\7\31\2\2\u02d2\u02d3\5T+\2\u02d3\u02d5\7\32\2\2\u02d4"+
		"\u02d6\5V,\2\u02d5\u02d4\3\2\2\2\u02d5\u02d6\3\2\2\2\u02d6c\3\2\2\2\u02d7"+
		"\u02d8\7`\2\2\u02d8\u02d9\78\2\2\u02d9\u02de\5f\64\2\u02da\u02db\7\27"+
		"\2\2\u02db\u02dd\5f\64\2\u02dc\u02da\3\2\2\2\u02dd\u02e0\3\2\2\2\u02de"+
		"\u02dc\3\2\2\2\u02de\u02df\3\2\2\2\u02dfe\3\2\2\2\u02e0\u02de\3\2\2\2"+
		"\u02e1\u02e5\5\u016c\u00b7\2\u02e2\u02e5\7\5\2\2\u02e3\u02e5\5\u008eH"+
		"\2\u02e4\u02e1\3\2\2\2\u02e4\u02e2\3\2\2\2\u02e4\u02e3\3\2\2\2\u02e5g"+
		"\3\2\2\2\u02e6\u02e7\7b\2\2\u02e7\u02e8\5\u0086D\2\u02e8i\3\2\2\2\u02e9"+
		"\u02ea\7\u0095\2\2\u02ea\u02eb\78\2\2\u02eb\u02f0\5n8\2\u02ec\u02ed\7"+
		"\27\2\2\u02ed\u02ef\5n8\2\u02ee\u02ec\3\2\2\2\u02ef\u02f2\3\2\2\2\u02f0"+
		"\u02ee\3\2\2\2\u02f0\u02f1\3\2\2\2\u02f1k\3\2\2\2\u02f2\u02f0\3\2\2\2"+
		"\u02f3\u02f8\5n8\2\u02f4\u02f5\7\27\2\2\u02f5\u02f7\5n8\2\u02f6\u02f4"+
		"\3\2\2\2\u02f7\u02fa\3\2\2\2\u02f8\u02f6\3\2\2\2\u02f8\u02f9\3\2\2\2\u02f9"+
		"m\3\2\2\2\u02fa\u02f8\3\2\2\2\u02fb\u02fd\5r:\2\u02fc\u02fe\5t;\2\u02fd"+
		"\u02fc\3\2\2\2\u02fd\u02fe\3\2\2\2\u02fe\u0300\3\2\2\2\u02ff\u0301\5p"+
		"9\2\u0300\u02ff\3\2\2\2\u0300\u0301\3\2\2\2\u0301o\3\2\2\2\u0302\u0303"+
		"\7\u008d\2\2\u0303\u0304\t\6\2\2\u0304q\3\2\2\2\u0305\u0309\5\u016c\u00b7"+
		"\2\u0306\u0309\7\5\2\2\u0307\u0309\5\u008eH\2\u0308\u0305\3\2\2\2\u0308"+
		"\u0306\3\2\2\2\u0308\u0307\3\2\2\2\u0309s\3\2\2\2\u030a\u030b\t\7\2\2"+
		"\u030bu\3\2\2\2\u030c\u030d\7;\2\2\u030d\u030e\7\31\2\2\u030e\u030f\5"+
		"\u008eH\2\u030f\u0310\7\63\2\2\u0310\u0311\5x=\2\u0311\u0312\7\32\2\2"+
		"\u0312w\3\2\2\2\u0313\u0314\5P)\2\u0314y\3\2\2\2\u0315\u0316\7u\2\2\u0316"+
		"\u0317\5\u0080A\2\u0317{\3\2\2\2\u0318\u0319\7\u0090\2\2\u0319\u031b\5"+
		"\u0080A\2\u031a\u031c\t\b\2\2\u031b\u031a\3\2\2\2\u031b\u031c\3\2\2\2"+
		"\u031c}\3\2\2\2\u031d\u031e\7W\2\2\u031e\u0323\t\t\2\2\u031f\u0324\5\u0080"+
		"A\2\u0320\u0321\5\u0082B\2\u0321\u0322\7\u009d\2\2\u0322\u0324\3\2\2\2"+
		"\u0323\u031f\3\2\2\2\u0323\u0320\3\2\2\2\u0324\u0325\3\2\2\2\u0325\u0329"+
		"\t\b\2\2\u0326\u032a\7\u0093\2\2\u0327\u0328\7\u00c2\2\2\u0328\u032a\7"+
		"\u00b0\2\2\u0329\u0326\3\2\2\2\u0329\u0327\3\2\2\2\u032a\177\3\2\2\2\u032b"+
		"\u032e\5\u00e4s\2\u032c\u032e\7\5\2\2\u032d\u032b\3\2\2\2\u032d\u032c"+
		"\3\2\2\2\u032e\u0081\3\2\2\2\u032f\u0334\5\u00e4s\2\u0330\u0334\7\5\2"+
		"\2\u0331\u0334\7\7\2\2\u0332\u0334\7\b\2\2\u0333\u032f\3\2\2\2\u0333\u0330"+
		"\3\2\2\2\u0333\u0331\3\2\2\2\u0333\u0332\3\2\2\2\u0334\u0083\3\2\2\2\u0335"+
		"\u0336\7\u00c1\2\2\u0336\u0337\5\u0086D\2\u0337\u0085\3\2\2\2\u0338\u0339"+
		"\bD\1\2\u0339\u033a\7\31\2\2\u033a\u033b\5\u0086D\2\u033b\u033c\7\32\2"+
		"\2\u033c\u037e\3\2\2\2\u033d\u033e\5\u008eH\2\u033e\u0340\7n\2\2\u033f"+
		"\u0341\7\u008c\2\2\u0340\u033f\3\2\2\2\u0340\u0341\3\2\2\2\u0341\u0342"+
		"\3\2\2\2\u0342\u0343\7\u00c8\2\2\u0343\u037e\3\2\2\2\u0344\u0345\5\u008e"+
		"H\2\u0345\u0347\7n\2\2\u0346\u0348\7\u008c\2\2\u0347\u0346\3\2\2\2\u0347"+
		"\u0348\3\2\2\2\u0348\u0349\3\2\2\2\u0349\u034a\7M\2\2\u034a\u037e\3\2"+
		"\2\2\u034b\u034d\5\u008eH\2\u034c\u034e\7\u008c\2\2\u034d\u034c\3\2\2"+
		"\2\u034d\u034e\3\2\2\2\u034e\u034f\3\2\2\2\u034f\u0350\7f\2\2\u0350\u0351"+
		"\5\u008aF\2\u0351\u037e\3\2\2\2\u0352\u0354\5\u008eH\2\u0353\u0355\7\u008c"+
		"\2\2\u0354\u0353\3\2\2\2\u0354\u0355\3\2\2\2\u0355\u0356\3\2\2\2\u0356"+
		"\u0357\7\66\2\2\u0357\u0358\5\u008eH\2\u0358\u0359\7\61\2\2\u0359\u035a"+
		"\5\u008eH\2\u035a\u037e\3\2\2\2\u035b\u035d\5\u008eH\2\u035c\u035e\7\u008c"+
		"\2\2\u035d\u035c\3\2\2\2\u035d\u035e\3\2\2\2\u035e\u035f\3\2\2\2\u035f"+
		"\u0360\t\n\2\2\u0360\u0362\5\u008eH\2\u0361\u0363\5\u008cG\2\u0362\u0361"+
		"\3\2\2\2\u0362\u0363\3\2\2\2\u0363\u037e\3\2\2\2\u0364\u0365\5\u008eH"+
		"\2\u0365\u0366\5\u0088E\2\u0366\u0367\5\u008eH\2\u0367\u037e\3\2\2\2\u0368"+
		"\u0369\7U\2\2\u0369\u036a\t\13\2\2\u036a\u036b\7\31\2\2\u036b\u036c\5"+
		"P)\2\u036c\u036d\7\32\2\2\u036d\u037e\3\2\2\2\u036e\u036f\7U\2\2\u036f"+
		"\u037e\5\u008eH\2\u0370\u0372\5\u008eH\2\u0371\u0373\7\u008c\2\2\u0372"+
		"\u0371\3\2\2\2\u0372\u0373\3\2\2\2\u0373\u0374\3\2\2\2\u0374\u0376\7\u0080"+
		"\2\2\u0375\u0377\7\u008f\2\2\u0376\u0375\3\2\2\2\u0376\u0377\3\2\2\2\u0377"+
		"\u0378\3\2\2\2\u0378\u0379\5T+\2\u0379\u037e\3\2\2\2\u037a\u037b\7\u008c"+
		"\2\2\u037b\u037e\5\u0086D\6\u037c\u037e\5\u008eH\2\u037d\u0338\3\2\2\2"+
		"\u037d\u033d\3\2\2\2\u037d\u0344\3\2\2\2\u037d\u034b\3\2\2\2\u037d\u0352"+
		"\3\2\2\2\u037d\u035b\3\2\2\2\u037d\u0364\3\2\2\2\u037d\u0368\3\2\2\2\u037d"+
		"\u036e\3\2\2\2\u037d\u0370\3\2\2\2\u037d\u037a\3\2\2\2\u037d\u037c\3\2"+
		"\2\2\u037e\u0387\3\2\2\2\u037f\u0380\f\5\2\2\u0380\u0381\7\61\2\2\u0381"+
		"\u0386\5\u0086D\6\u0382\u0383\f\4\2\2\u0383\u0384\7\u0094\2\2\u0384\u0386"+
		"\5\u0086D\5\u0385\u037f\3\2\2\2\u0385\u0382\3\2\2\2\u0386\u0389\3\2\2"+
		"\2\u0387\u0385\3\2\2\2\u0387\u0388\3\2\2\2\u0388\u0087\3\2\2\2\u0389\u0387"+
		"\3\2\2\2\u038a\u0398\7\21\2\2\u038b\u0398\7\22\2\2\u038c\u0398\7\23\2"+
		"\2\u038d\u0398\7\24\2\2\u038e\u0398\7\25\2\2\u038f\u0398\7\26\2\2\u0390"+
		"\u0391\7n\2\2\u0391\u0392\7I\2\2\u0392\u0398\7]\2\2\u0393\u0394\7n\2\2"+
		"\u0394\u0395\7\u008c\2\2\u0395\u0396\7I\2\2\u0396\u0398\7]\2\2\u0397\u038a"+
		"\3\2\2\2\u0397\u038b\3\2\2\2\u0397\u038c\3\2\2\2\u0397\u038d\3\2\2\2\u0397"+
		"\u038e\3\2\2\2\u0397\u038f\3\2\2\2\u0397\u0390\3\2\2\2\u0397\u0393\3\2"+
		"\2\2\u0398\u0089\3\2\2\2\u0399\u039a\t\13\2\2\u039a\u039b\7\31\2\2\u039b"+
		"\u039c\5P)\2\u039c\u039d\7\32\2\2\u039d\u03b0\3\2\2\2\u039e\u03a7\7\31"+
		"\2\2\u039f\u03a4\5\u0092J\2\u03a0\u03a1\7\27\2\2\u03a1\u03a3\5\u0092J"+
		"\2\u03a2\u03a0\3\2\2\2\u03a3\u03a6\3\2\2\2\u03a4\u03a2\3\2\2\2\u03a4\u03a5"+
		"\3\2\2\2\u03a5\u03a8\3\2\2\2\u03a6\u03a4\3\2\2\2\u03a7\u039f\3\2\2\2\u03a7"+
		"\u03a8\3\2\2\2\u03a8\u03a9\3\2\2\2\u03a9\u03b0\7\32\2\2\u03aa\u03ab\7"+
		"\31\2\2\u03ab\u03ac\5\6\4\2\u03ac\u03ad\7\32\2\2\u03ad\u03b0\3\2\2\2\u03ae"+
		"\u03b0\5\u00e4s\2\u03af\u0399\3\2\2\2\u03af\u039e\3\2\2\2\u03af\u03aa"+
		"\3\2\2\2\u03af\u03ae\3\2\2\2\u03b0\u008b\3\2\2\2\u03b1\u03b4\7Q\2\2\u03b2"+
		"\u03b5\7\f\2\2\u03b3\u03b5\5\u00e4s\2\u03b4\u03b2\3\2\2\2\u03b4\u03b3"+
		"\3\2\2\2\u03b5\u008d\3\2\2\2\u03b6\u03b7\bH\1\2\u03b7\u03b8\7\31\2\2\u03b8"+
		"\u03b9\5\u008eH\2\u03b9\u03ba\7\32\2\2\u03ba\u03d1\3\2\2\2\u03bb\u03bc"+
		"\7\31\2\2\u03bc\u03bf\5\u0092J\2\u03bd\u03be\7\27\2\2\u03be\u03c0\5\u0092"+
		"J\2\u03bf\u03bd\3\2\2\2\u03c0\u03c1\3\2\2\2\u03c1\u03bf\3\2\2\2\u03c1"+
		"\u03c2\3\2\2\2\u03c2\u03c3\3\2\2\2\u03c3\u03c4\7\32\2\2\u03c4\u03d1\3"+
		"\2\2\2\u03c5\u03c6\7\31\2\2\u03c6\u03c7\5\6\4\2\u03c7\u03c8\7\32\2\2\u03c8"+
		"\u03d1\3\2\2\2\u03c9\u03d1\5\u0090I\2\u03ca\u03cb\5\u0098M\2\u03cb\u03cc"+
		"\5\u00b4[\2\u03cc\u03d1\3\2\2\2\u03cd\u03ce\5\u0098M\2\u03ce\u03cf\5\u008e"+
		"H\b\u03cf\u03d1\3\2\2\2\u03d0\u03b6\3\2\2\2\u03d0\u03bb\3\2\2\2\u03d0"+
		"\u03c5\3\2\2\2\u03d0\u03c9\3\2\2\2\u03d0\u03ca\3\2\2\2\u03d0\u03cd\3\2"+
		"\2\2\u03d1\u03e4\3\2\2\2\u03d2\u03d3\f\5\2\2\u03d3\u03d4\5\u0094K\2\u03d4"+
		"\u03d5\5\u008eH\6\u03d5\u03e3\3\2\2\2\u03d6\u03d7\f\4\2\2\u03d7\u03d8"+
		"\5\u0096L\2\u03d8\u03d9\5\u008eH\5\u03d9\u03e3\3\2\2\2\u03da\u03db\f\3"+
		"\2\2\u03db\u03dc\7(\2\2\u03dc\u03e3\5\u008eH\4\u03dd\u03de\f\7\2\2\u03de"+
		"\u03e3\5\u0156\u00ac\2\u03df\u03e0\f\6\2\2\u03e0\u03e1\78\2\2\u03e1\u03e3"+
		"\5\u0156\u00ac\2\u03e2\u03d2\3\2\2\2\u03e2\u03d6\3\2\2\2\u03e2\u03da\3"+
		"\2\2\2\u03e2\u03dd\3\2\2\2\u03e2\u03df\3\2\2\2\u03e3\u03e6\3\2\2\2\u03e4"+
		"\u03e2\3\2\2\2\u03e4\u03e5\3\2\2\2\u03e5\u008f\3\2\2\2\u03e6\u03e4\3\2"+
		"\2\2\u03e7\u03f6\5\u00a4S\2\u03e8\u03f6\5\u00b0Y\2\u03e9\u03f6\5\u00e4"+
		"s\2\u03ea\u03f6\5\u009aN\2\u03eb\u03f6\5\u009cO\2\u03ec\u03f6\5\u009e"+
		"P\2\u03ed\u03f6\5\u00a0Q\2\u03ee\u03f6\5\u00a2R\2\u03ef\u03f1\5X-\2\u03f0"+
		"\u03f2\5V,\2\u03f1\u03f0\3\2\2\2\u03f1\u03f2\3\2\2\2\u03f2\u03f6\3\2\2"+
		"\2\u03f3\u03f6\5\u00e6t\2\u03f4\u03f6\5Z.\2\u03f5\u03e7\3\2\2\2\u03f5"+
		"\u03e8\3\2\2\2\u03f5\u03e9\3\2\2\2\u03f5\u03ea\3\2\2\2\u03f5\u03eb\3\2"+
		"\2\2\u03f5\u03ec\3\2\2\2\u03f5\u03ed\3\2\2\2\u03f5\u03ee\3\2\2\2\u03f5"+
		"\u03ef\3\2\2\2\u03f5\u03f3\3\2\2\2\u03f5\u03f4\3\2\2\2\u03f6\u0091\3\2"+
		"\2\2\u03f7\u03fa\5\u008eH\2\u03f8\u03fa\5\u0086D\2\u03f9\u03f7\3\2\2\2"+
		"\u03f9\u03f8\3\2\2\2\u03fa\u0093\3\2\2\2\u03fb\u03fc\t\f\2\2\u03fc\u0095"+
		"\3\2\2\2\u03fd\u03fe\t\r\2\2\u03fe\u0097\3\2\2\2\u03ff\u0400\t\r\2\2\u0400"+
		"\u0099\3\2\2\2\u0401\u0402\7\u00b9\2\2\u0402\u0405\7\31\2\2\u0403\u0406"+
		"\5T+\2\u0404\u0406\5\u00e4s\2\u0405\u0403\3\2\2\2\u0405\u0404\3\2\2\2"+
		"\u0406\u0407\3\2\2\2\u0407\u0408\7\32\2\2\u0408\u009b\3\2\2\2\u0409\u040a"+
		"\7+\2\2\u040a\u040b\7\31\2\2\u040b\u040c\5T+\2\u040c\u040e\7\32\2\2\u040d"+
		"\u040f\5V,\2\u040e\u040d\3\2\2\2\u040e\u040f\3\2\2\2\u040f\u009d\3\2\2"+
		"\2\u0410\u0411\7,\2\2\u0411\u0412\7\31\2\2\u0412\u0413\5T+\2\u0413\u0414"+
		"\7\32\2\2\u0414\u009f\3\2\2\2\u0415\u0416\7.\2\2\u0416\u0417\7\31\2\2"+
		"\u0417\u0418\5T+\2\u0418\u041a\7\32\2\2\u0419\u041b\5V,\2\u041a\u0419"+
		"\3\2\2\2\u041a\u041b\3\2\2\2\u041b\u00a1\3\2\2\2\u041c\u041d\7/\2\2\u041d"+
		"\u041e\7\31\2\2\u041e\u041f\5T+\2\u041f\u0420\7\32\2\2\u0420\u00a3\3\2"+
		"\2\2\u0421\u0424\5\u00a6T\2\u0422\u0424\5\u00acW\2\u0423\u0421\3\2\2\2"+
		"\u0423\u0422\3\2\2\2\u0424\u00a5\3\2\2\2\u0425\u0426\79\2\2\u0426\u0428"+
		"\5\u0092J\2\u0427\u0429\5\u00a8U\2\u0428\u0427\3\2\2\2\u0429\u042a\3\2"+
		"\2\2\u042a\u0428\3\2\2\2\u042a\u042b\3\2\2\2\u042b\u042d\3\2\2\2\u042c"+
		"\u042e\5\u00aaV\2\u042d\u042c\3\2\2\2\u042d\u042e\3\2\2\2\u042e\u042f"+
		"\3\2\2\2\u042f\u0430\7N\2\2\u0430\u00a7\3\2\2\2\u0431\u0432\7\u00c0\2"+
		"\2\u0432\u0433\5\u008eH\2\u0433\u0434\7\u00af\2\2\u0434\u0435\5\u0092"+
		"J\2\u0435\u00a9\3\2\2\2\u0436\u0437\7L\2\2\u0437\u0438\5\u0092J\2\u0438"+
		"\u00ab\3\2\2\2\u0439\u043b\79\2\2\u043a\u043c\5\u00aeX\2\u043b\u043a\3"+
		"\2\2\2\u043c\u043d\3\2\2\2\u043d\u043b\3\2\2\2\u043d\u043e\3\2\2\2\u043e"+
		"\u0440\3\2\2\2\u043f\u0441\5\u00aaV\2\u0440\u043f\3\2\2\2\u0440\u0441"+
		"\3\2\2\2\u0441\u0442\3\2\2\2\u0442\u0443\7N\2\2\u0443\u00ad\3\2\2\2\u0444"+
		"\u0445\7\u00c0\2\2\u0445\u0446\5\u0086D\2\u0446\u0447\7\u00af\2\2\u0447"+
		"\u0448\5\u0092J\2\u0448\u00af\3\2\2\2\u0449\u0451\7\f\2\2\u044a\u0451"+
		"\7\u00c8\2\2\u044b\u0451\5\u00b2Z\2\u044c\u0451\5\u00b4[\2\u044d\u0451"+
		"\5\u00b6\\\2\u044e\u0451\5\u00b8]\2\u044f\u0451\5\u00dep\2\u0450\u0449"+
		"\3\2\2\2\u0450\u044a\3\2\2\2\u0450\u044b\3\2\2\2\u0450\u044c\3\2\2\2\u0450"+
		"\u044d\3\2\2\2\u0450\u044e\3\2\2\2\u0450\u044f\3\2\2\2\u0451\u00b1\3\2"+
		"\2\2\u0452\u0453\t\16\2\2\u0453\u00b3\3\2\2\2\u0454\u0455\t\17\2\2\u0455"+
		"\u00b5\3\2\2\2\u0456\u0462\7\r\2\2\u0457\u0458\7\35\2\2\u0458\u045d\7"+
		"\13\2\2\u0459\u045a\7\27\2\2\u045a\u045c\7\13\2\2\u045b\u0459\3\2\2\2"+
		"\u045c\u045f\3\2\2\2\u045d\u045b\3\2\2\2\u045d\u045e\3\2\2\2\u045e\u0460"+
		"\3\2\2\2\u045f\u045d\3\2\2\2\u0460\u0462\7\36\2\2\u0461\u0456\3\2\2\2"+
		"\u0461\u0457\3\2\2\2\u0462\u00b7\3\2\2\2\u0463\u046a\5\u00ba^\2\u0464"+
		"\u046a\5\u00bc_\2\u0465\u046a\5\u00be`\2\u0466\u046a\5\u00d6l\2\u0467"+
		"\u046a\5\u00d8m\2\u0468\u046a\5\u00dan\2\u0469\u0463\3\2\2\2\u0469\u0464"+
		"\3\2\2\2\u0469\u0465\3\2\2\2\u0469\u0466\3\2\2\2\u0469\u0467\3\2\2\2\u0469"+
		"\u0468\3\2\2\2\u046a\u00b9\3\2\2\2\u046b\u046c\7\35\2\2\u046c\u046d\5"+
		"\u00c0a\2\u046d\u046e\7\36\2\2\u046e\u0472\3\2\2\2\u046f\u0470\7E\2\2"+
		"\u0470\u0472\5\u00c0a\2\u0471\u046b\3\2\2\2\u0471\u046f\3\2\2\2\u0472"+
		"\u00bb\3\2\2\2\u0473\u0474\7\35\2\2\u0474\u0475\5\u00c2b\2\u0475\u0476"+
		"\7\36\2\2\u0476\u047a\3\2\2\2\u0477\u0478\7D\2\2\u0478\u047a\5\u00c2b"+
		"\2\u0479\u0473\3\2\2\2\u0479\u0477\3\2\2\2\u047a\u00bd\3\2\2\2\u047b\u047c"+
		"\7\35\2\2\u047c\u047d\5\u00c4c\2\u047d\u047e\7\36\2\2\u047e\u0482\3\2"+
		"\2\2\u047f\u0480\7\u00b1\2\2\u0480\u0482\5\u00c4c\2\u0481\u047b\3\2\2"+
		"\2\u0481\u047f\3\2\2\2\u0482\u00bf\3\2\2\2\u0483\u0484\5\u00c2b\2\u0484"+
		"\u0487\5\u00c4c\2\u0485\u0488\5\u00d4k\2\u0486\u0488\5\u00c6d\2\u0487"+
		"\u0485\3\2\2\2\u0487\u0486\3\2\2\2\u0487\u0488\3\2\2\2\u0488\u00c1\3\2"+
		"\2\2\u0489\u048a\5\u00c8e\2\u048a\u048b\7 \2\2\u048b\u048c\5\u00caf\2"+
		"\u048c\u048d\7 \2\2\u048d\u048e\5\u00ccg\2\u048e\u00c3\3\2\2\2\u048f\u0490"+
		"\5\u00ceh\2\u0490\u0491\7&\2\2\u0491\u0494\5\u00d0i\2\u0492\u0493\7&\2"+
		"\2\u0493\u0495\5\u00d2j\2\u0494\u0492\3\2\2\2\u0494\u0495\3\2\2\2\u0495"+
		"\u00c5\3\2\2\2\u0496\u0497\t\r\2\2\u0497\u049a\5\u00ceh\2\u0498\u0499"+
		"\7&\2\2\u0499\u049b\5\u00d0i\2\u049a\u0498\3\2\2\2\u049a\u049b\3\2\2\2"+
		"\u049b\u00c7\3\2\2\2\u049c\u049d\7\5\2\2\u049d\u00c9\3\2\2\2\u049e\u049f"+
		"\7\5\2\2\u049f\u00cb\3\2\2\2\u04a0\u04a1\7\5\2\2\u04a1\u00cd\3\2\2\2\u04a2"+
		"\u04a3\7\5\2\2\u04a3\u00cf\3\2\2\2\u04a4\u04a5\7\5\2\2\u04a5\u00d1\3\2"+
		"\2\2\u04a6\u04a7\t\20\2\2\u04a7\u00d3\3\2\2\2\u04a8\u04ab\7\u00c9\2\2"+
		"\u04a9\u04aa\7\"\2\2\u04aa\u04ac\7\u00c9\2\2\u04ab\u04a9\3\2\2\2\u04ab"+
		"\u04ac\3\2\2\2\u04ac\u04af\3\2\2\2\u04ad\u04af\7\f\2\2\u04ae\u04a8\3\2"+
		"\2\2\u04ae\u04ad\3\2\2\2\u04af\u00d5\3\2\2\2\u04b0\u04b3\7\16\2\2\u04b1"+
		"\u04b4\5\u00c0a\2\u04b2\u04b4\5\u00dco\2\u04b3\u04b1\3\2\2\2\u04b3\u04b2"+
		"\3\2\2\2\u04b4\u04b5\3\2\2\2\u04b5\u04b6\7\36\2\2\u04b6\u00d7\3\2\2\2"+
		"\u04b7\u04ba\7\17\2\2\u04b8\u04bb\5\u00c2b\2\u04b9\u04bb\5\u00dco\2\u04ba"+
		"\u04b8\3\2\2\2\u04ba\u04b9\3\2\2\2\u04bb\u04bc\3\2\2\2\u04bc\u04bd\7\36"+
		"\2\2\u04bd\u00d9\3\2\2\2\u04be\u04c1\7\20\2\2\u04bf\u04c2\5\u00c4c\2\u04c0"+
		"\u04c2\5\u00dco\2\u04c1\u04bf\3\2\2\2\u04c1\u04c0\3\2\2\2\u04c2\u04c3"+
		"\3\2\2\2\u04c3\u04c4\7\36\2\2\u04c4\u00db\3\2\2\2\u04c5\u04c6\7\f\2\2"+
		"\u04c6\u00dd\3\2\2\2\u04c7\u04c8\7\35\2\2\u04c8\u04c9\5\u00e0q\2\u04c9"+
		"\u04ca\7&\2\2\u04ca\u04cb\5\u00e2r\2\u04cb\u04cc\7\36\2\2\u04cc\u00df"+
		"\3\2\2\2\u04cd\u04ce\7\f\2\2\u04ce\u00e1\3\2\2\2\u04cf\u04d0\7\f\2\2\u04d0"+
		"\u00e3\3\2\2\2\u04d1\u04d2\7&\2\2\u04d2\u04d8\5\u016c\u00b7\2\u04d3\u04d5"+
		"\7)\2\2\u04d4\u04d6\7\5\2\2\u04d5\u04d4\3\2\2\2\u04d5\u04d6\3\2\2\2\u04d6"+
		"\u04d8\3\2\2\2\u04d7\u04d1\3\2\2\2\u04d7\u04d3\3\2\2\2\u04d8\u00e5\3\2"+
		"\2\2\u04d9\u04e2\5\u0118\u008d\2\u04da\u04e2\5\u00fa~\2\u04db\u04e2\5"+
		"\u00f2z\2\u04dc\u04e2\5\u00f4{\2\u04dd\u04e2\5\u00f6|\2\u04de\u04e2\5"+
		"\u00f8}\2\u04df\u04e2\5\u00e8u\2\u04e0\u04e2\5\u00ecw\2\u04e1\u04d9\3"+
		"\2\2\2\u04e1\u04da\3\2\2\2\u04e1\u04db\3\2\2\2\u04e1\u04dc\3\2\2\2\u04e1"+
		"\u04dd\3\2\2\2\u04e1\u04de\3\2\2\2\u04e1\u04df\3\2\2\2\u04e1\u04e0\3\2"+
		"\2\2\u04e2\u00e7\3\2\2\2\u04e3\u04e4\7_\2\2\u04e4\u04e5\7\31\2\2\u04e5"+
		"\u04e8\5\u00eav\2\u04e6\u04e7\7\27\2\2\u04e7\u04e9\5\u00f0y\2\u04e8\u04e6"+
		"\3\2\2\2\u04e8\u04e9\3\2\2\2\u04e9\u04ea\3\2\2\2\u04ea\u04eb\7\32\2\2"+
		"\u04eb\u00e9\3\2\2\2\u04ec\u04ed\7\f\2\2\u04ed\u00eb\3\2\2\2\u04ee\u04ef"+
		"\5\u00eex\2\u04ef\u04f2\7\31\2\2\u04f0\u04f3\5\u00f0y\2\u04f1\u04f3\7"+
		"!\2\2\u04f2\u04f0\3\2\2\2\u04f2\u04f1\3\2\2\2\u04f2\u04f3\3\2\2\2\u04f3"+
		"\u04f4\3\2\2\2\u04f4\u04f6\7\32\2\2\u04f5\u04f7\5\u010a\u0086\2\u04f6"+
		"\u04f5\3\2\2\2\u04f6\u04f7\3\2\2\2\u04f7\u04f9\3\2\2\2\u04f8\u04fa\5\u0108"+
		"\u0085\2\u04f9\u04f8\3\2\2\2\u04f9\u04fa\3\2\2\2\u04fa\u04fc\3\2\2\2\u04fb"+
		"\u04fd\5\u0104\u0083\2\u04fc\u04fb\3\2\2\2\u04fc\u04fd\3\2\2\2\u04fd\u04ff"+
		"\3\2\2\2\u04fe\u0500\5\u0106\u0084\2\u04ff\u04fe\3\2\2\2\u04ff\u0500\3"+
		"\2\2\2\u0500\u0502\3\2\2\2\u0501\u0503\5\u010c\u0087\2\u0502\u0501\3\2"+
		"\2\2\u0502\u0503\3\2\2\2\u0503\u00ed\3\2\2\2\u0504\u0505\5P)\2\u0505\u00ef"+
		"\3\2\2\2\u0506\u050b\7I\2\2\u0507\u0508\5\u0156\u00ac\2\u0508\u0509\7"+
		"\27\2\2\u0509\u050b\3\2\2\2\u050a\u0506\3\2\2\2\u050a\u0507\3\2\2\2\u050a"+
		"\u050b\3\2\2\2\u050b\u050c\3\2\2\2\u050c\u0511\5\u0092J\2\u050d\u050e"+
		"\7\27\2\2\u050e\u0510\5\u0092J\2\u050f\u050d\3\2\2\2\u0510\u0513\3\2\2"+
		"\2\u0511\u050f\3\2\2\2\u0511\u0512\3\2\2\2\u0512\u00f1\3\2\2\2\u0513\u0511"+
		"\3\2\2\2\u0514\u0515\7\u00ab\2\2\u0515\u0516\7\31\2\2\u0516\u0517\5T+"+
		"\2\u0517\u0518\7\32\2\2\u0518\u00f3\3\2\2\2\u0519\u051a\7\177\2\2\u051a"+
		"\u051b\7\31\2\2\u051b\u051c\5T+\2\u051c\u051d\7\32\2\2\u051d\u0544\3\2"+
		"\2\2\u051e\u051f\7\u0085\2\2\u051f\u0520\7\31\2\2\u0520\u0521\5T+\2\u0521"+
		"\u0522\7\32\2\2\u0522\u0544\3\2\2\2\u0523\u0524\7}\2\2\u0524\u0525\7\31"+
		"\2\2\u0525\u0526\7h\2\2\u0526\u0527\7\31\2\2\u0527\u0528\5T+\2\u0528\u0529"+
		"\7\32\2\2\u0529\u052a\7\32\2\2\u052a\u0544\3\2\2\2\u052b\u052c\7\u0083"+
		"\2\2\u052c\u052d\7\31\2\2\u052d\u052e\7h\2\2\u052e\u052f\7\31\2\2\u052f"+
		"\u0530\5T+\2\u0530\u0531\7\32\2\2\u0531\u0532\7\32\2\2\u0532\u0544\3\2"+
		"\2\2\u0533\u0534\7\u00ae\2\2\u0534\u0535\7\31\2\2\u0535\u0536\7h\2\2\u0536"+
		"\u0537\7\31\2\2\u0537\u0538\5T+\2\u0538\u0539\7\32\2\2\u0539\u053a\7\32"+
		"\2\2\u053a\u0544\3\2\2\2\u053b\u053c\7\65\2\2\u053c\u053d\7\31\2\2\u053d"+
		"\u053e\7h\2\2\u053e\u053f\7\31\2\2\u053f\u0540\5T+\2\u0540\u0541\7\32"+
		"\2\2\u0541\u0542\7\32\2\2\u0542\u0544\3\2\2\2\u0543\u0519\3\2\2\2\u0543"+
		"\u051e\3\2\2\2\u0543\u0523\3\2\2\2\u0543\u052b\3\2\2\2\u0543\u0533\3\2"+
		"\2\2\u0543\u053b\3\2\2\2\u0544\u00f5\3\2\2\2\u0545\u0546\7~\2\2\u0546"+
		"\u0547\7\31\2\2\u0547\u0548\5T+\2\u0548\u0549\7\32\2\2\u0549\u0570\3\2"+
		"\2\2\u054a\u054b\7\u0084\2\2\u054b\u054c\7\31\2\2\u054c\u054d\5T+\2\u054d"+
		"\u054e\7\32\2\2\u054e\u0570\3\2\2\2\u054f\u0550\7}\2\2\u0550\u0551\7\31"+
		"\2\2\u0551\u0552\7K\2\2\u0552\u0553\7\31\2\2\u0553\u0554\5T+\2\u0554\u0555"+
		"\7\32\2\2\u0555\u0556\7\32\2\2\u0556\u0570\3\2\2\2\u0557\u0558\7\u0083"+
		"\2\2\u0558\u0559\7\31\2\2\u0559\u055a\7K\2\2\u055a\u055b\7\31\2\2\u055b"+
		"\u055c\5T+\2\u055c\u055d\7\32\2\2\u055d\u055e\7\32\2\2\u055e\u0570\3\2"+
		"\2\2\u055f\u0560\7\u00ae\2\2\u0560\u0561\7\31\2\2\u0561\u0562\7K\2\2\u0562"+
		"\u0563\7\31\2\2\u0563\u0564\5T+\2\u0564\u0565\7\32\2\2\u0565\u0566\7\32"+
		"\2\2\u0566\u0570\3\2\2\2\u0567\u0568\7\65\2\2\u0568\u0569\7\31\2\2\u0569"+
		"\u056a\7K\2\2\u056a\u056b\7\31\2\2\u056b\u056c\5T+\2\u056c\u056d\7\32"+
		"\2\2\u056d\u056e\7\32\2\2\u056e\u0570\3\2\2\2\u056f\u0545\3\2\2\2\u056f"+
		"\u054a\3\2\2\2\u056f\u054f\3\2\2\2\u056f\u0557\3\2\2\2\u056f\u055f\3\2"+
		"\2\2\u056f\u0567\3\2\2\2\u0570\u00f7\3\2\2\2\u0571\u0572\7K\2\2\u0572"+
		"\u0573\7\31\2\2\u0573\u0574\5T+\2\u0574\u0575\7\32\2\2\u0575\u057c\3\2"+
		"\2\2\u0576\u0577\7h\2\2\u0577\u0578\7\31\2\2\u0578\u0579\5T+\2\u0579\u057a"+
		"\7\32\2\2\u057a\u057c\3\2\2\2\u057b\u0571\3\2\2\2\u057b\u0576\3\2\2\2"+
		"\u057c\u00f9\3\2\2\2\u057d\u0581\5\u00fc\177\2\u057e\u0581\5\u00fe\u0080"+
		"\2\u057f\u0581\5\u0100\u0081\2\u0580\u057d\3\2\2\2\u0580\u057e\3\2\2\2"+
		"\u0580\u057f\3\2\2\2\u0581\u00fb\3\2\2\2\u0582\u0583\t\21\2\2\u0583\u0584"+
		"\7\31\2\2\u0584\u0585\5\u0086D\2\u0585\u0587\7\32\2\2\u0586\u0588\5\u0106"+
		"\u0084\2\u0587\u0586\3\2\2\2\u0587\u0588\3\2\2\2\u0588\u058a\3\2\2\2\u0589"+
		"\u058b\5\u010c\u0087\2\u058a\u0589\3\2\2\2\u058a\u058b\3\2\2\2\u058b\u0598"+
		"\3\2\2\2\u058c\u058d\t\21\2\2\u058d\u058e\7\31\2\2\u058e\u058f\5\6\4\2"+
		"\u058f\u0590\7\32\2\2\u0590\u0598\3\2\2\2\u0591\u0592\t\21\2\2\u0592\u0593"+
		"\t\13\2\2\u0593\u0594\7\31\2\2\u0594\u0595\5P)\2\u0595\u0596\7\32\2\2"+
		"\u0596\u0598\3\2\2\2\u0597\u0582\3\2\2\2\u0597\u058c\3\2\2\2\u0597\u0591"+
		"\3\2\2\2\u0598\u00fd\3\2\2\2\u0599\u059a\t\22\2\2\u059a\u059b\7\31\2\2"+
		"\u059b\u059c\5\u0086D\2\u059c\u059e\7\32\2\2\u059d\u059f\5\u0106\u0084"+
		"\2\u059e\u059d\3\2\2\2\u059e\u059f\3\2\2\2\u059f\u05a1\3\2\2\2\u05a0\u05a2"+
		"\5\u010c\u0087\2\u05a1\u05a0\3\2\2\2\u05a1\u05a2\3\2\2\2\u05a2\u05af\3"+
		"\2\2\2\u05a3\u05a4\t\22\2\2\u05a4\u05a5\7\31\2\2\u05a5\u05a6\5\6\4\2\u05a6"+
		"\u05a7\7\32\2\2\u05a7\u05af\3\2\2\2\u05a8\u05a9\t\22\2\2\u05a9\u05aa\t"+
		"\13\2\2\u05aa\u05ab\7\31\2\2\u05ab\u05ac\5P)\2\u05ac\u05ad\7\32\2\2\u05ad"+
		"\u05af\3\2\2\2\u05ae\u0599\3\2\2\2\u05ae\u05a3\3\2\2\2\u05ae\u05a8\3\2"+
		"\2\2\u05af\u00ff\3\2\2\2\u05b0\u05b1\7w\2\2\u05b1\u05b3\7\31\2\2\u05b2"+
		"\u05b4\7I\2\2\u05b3\u05b2\3\2\2\2\u05b3\u05b4\3\2\2\2\u05b4\u05b5\3\2"+
		"\2\2\u05b5\u05b6\5\u0092J\2\u05b6\u05b7\7\27\2\2\u05b7\u05b9\5\u0092J"+
		"\2\u05b8\u05ba\5\u0102\u0082\2\u05b9\u05b8\3\2\2\2\u05b9\u05ba\3\2\2\2"+
		"\u05ba\u05bb\3\2\2\2\u05bb\u05bd\7\32\2\2\u05bc\u05be\5\u0104\u0083\2"+
		"\u05bd\u05bc\3\2\2\2\u05bd\u05be\3\2\2\2\u05be\u05c0\3\2\2\2\u05bf\u05c1"+
		"\5\u0106\u0084\2\u05c0\u05bf\3\2\2\2\u05c0\u05c1\3\2\2\2\u05c1\u05c3\3"+
		"\2\2\2\u05c2\u05c4\5\u010c\u0087\2\u05c3\u05c2\3\2\2\2\u05c3\u05c4\3\2"+
		"\2\2\u05c4\u0101\3\2\2\2\u05c5\u05c6\7\u0092\2\2\u05c6\u05ce\7\u0099\2"+
		"\2\u05c7\u05cf\7P\2\2\u05c8\u05ca\7\u00b8\2\2\u05c9\u05cb\5\u008eH\2\u05ca"+
		"\u05c9\3\2\2\2\u05ca\u05cb\3\2\2\2\u05cb\u05cc\3\2\2\2\u05cc\u05cd\t\23"+
		"\2\2\u05cd\u05cf\7<\2\2\u05ce\u05c7\3\2\2\2\u05ce\u05c8\3\2\2\2\u05cf"+
		"\u0103\3\2\2\2\u05d0\u05d1\7\u00c3\2\2\u05d1\u05d2\7`\2\2\u05d2\u05d3"+
		"\7\31\2\2\u05d3\u05d4\5j\66\2\u05d4\u05d5\7\32\2\2\u05d5\u0105\3\2\2\2"+
		"\u05d6\u05d7\7X\2\2\u05d7\u05d8\7\31\2\2\u05d8\u05d9\5\u0084C\2\u05d9"+
		"\u05da\7\32\2\2\u05da\u0107\3\2\2\2\u05db\u05dc\7\u00a3\2\2\u05dc\u05e0"+
		"\7\u008d\2\2\u05dd\u05de\7d\2\2\u05de\u05e0\7\u008d\2\2\u05df\u05db\3"+
		"\2\2\2\u05df\u05dd\3\2\2\2\u05e0\u0109\3\2\2\2\u05e1\u05e2\7]\2\2\u05e2"+
		"\u05e6\7Y\2\2\u05e3\u05e4\7]\2\2\u05e4\u05e6\7q\2\2\u05e5\u05e1\3\2\2"+
		"\2\u05e5\u05e3\3\2\2\2\u05e6\u010b\3\2\2\2\u05e7\u05e8\7\u0098\2\2\u05e8"+
		"\u05ea\7\31\2\2\u05e9\u05eb\5\u010e\u0088\2\u05ea\u05e9\3\2\2\2\u05ea"+
		"\u05eb\3\2\2\2\u05eb\u05ed\3\2\2\2\u05ec\u05ee\5j\66\2\u05ed\u05ec\3\2"+
		"\2\2\u05ed\u05ee\3\2\2\2\u05ee\u05f0\3\2\2\2\u05ef\u05f1\5\u0110\u0089"+
		"\2\u05f0\u05ef\3\2\2\2\u05f0\u05f1\3\2\2\2\u05f1\u05f2\3\2\2\2\u05f2\u05f3"+
		"\7\32\2\2\u05f3\u010d\3\2\2\2\u05f4\u05f5\7\u009c\2\2\u05f5\u05f6\78\2"+
		"\2\u05f6\u05fb\5\u008eH\2\u05f7\u05f8\7\27\2\2\u05f8\u05fa\5\u008eH\2"+
		"\u05f9\u05f7\3\2\2\2\u05fa\u05fd\3\2\2\2\u05fb\u05f9\3\2\2\2\u05fb\u05fc"+
		"\3\2\2\2\u05fc\u010f\3\2\2\2\u05fd\u05fb\3\2\2\2\u05fe\u05ff\t\24\2\2"+
		"\u05ff\u0601\5\u0112\u008a\2\u0600\u0602\5\u0116\u008c\2\u0601\u0600\3"+
		"\2\2\2\u0601\u0602\3\2\2\2\u0602\u060c\3\2\2\2\u0603\u0604\t\24\2\2\u0604"+
		"\u0605\7\66\2\2\u0605\u0606\5\u0112\u008a\2\u0606\u0607\7\61\2\2\u0607"+
		"\u0609\5\u0114\u008b\2\u0608\u060a\5\u0116\u008c\2\u0609\u0608\3\2\2\2"+
		"\u0609\u060a\3\2\2\2\u060a\u060c\3\2\2\2\u060b\u05fe\3\2\2\2\u060b\u0603"+
		"\3\2\2\2\u060c\u0111\3\2\2\2\u060d\u060e\7\u00ba\2\2\u060e\u0618\7\u00a0"+
		"\2\2\u060f\u0610\5\u008eH\2\u0610\u0611\7\u00a0\2\2\u0611\u0618\3\2\2"+
		"\2\u0612\u0613\7?\2\2\u0613\u0618\7\u00a6\2\2\u0614\u0615\5\u008eH\2\u0615"+
		"\u0616\7Z\2\2\u0616\u0618\3\2\2\2\u0617\u060d\3\2\2\2\u0617\u060f\3\2"+
		"\2\2\u0617\u0612\3\2\2\2\u0617\u0614\3\2\2\2\u0618\u0113\3\2\2\2\u0619"+
		"\u061a\5\u008eH\2\u061a\u061b\7\u00a0\2\2\u061b\u0624\3\2\2\2\u061c\u061d"+
		"\7?\2\2\u061d\u0624\7\u00a6\2\2\u061e\u061f\5\u008eH\2\u061f\u0620\7Z"+
		"\2\2\u0620\u0624\3\2\2\2\u0621\u0622\7\u00ba\2\2\u0622\u0624\7Z\2\2\u0623"+
		"\u0619\3\2\2\2\u0623\u061c\3\2\2\2\u0623\u061e\3\2\2\2\u0623\u0621\3\2"+
		"\2\2\u0624\u0115\3\2\2\2\u0625\u0626\7T\2\2\u0626\u0627\7?\2\2\u0627\u0630"+
		"\7\u00a6\2\2\u0628\u0629\7T\2\2\u0629\u0630\7`\2\2\u062a\u062b\7T\2\2"+
		"\u062b\u0630\7\u00b0\2\2\u062c\u062d\7T\2\2\u062d\u062e\7\u008b\2\2\u062e"+
		"\u0630\7\u0096\2\2\u062f\u0625\3\2\2\2\u062f\u0628\3\2\2\2\u062f\u062a"+
		"\3\2\2\2\u062f\u062c\3\2\2\2\u0630\u0117\3\2\2\2\u0631\u0645\5\u011a\u008e"+
		"\2\u0632\u0645\5\u0152\u00aa\2\u0633\u0645\5\u014e\u00a8\2\u0634\u0645"+
		"\5v<\2\u0635\u0645\5\u0120\u0091\2\u0636\u0645\5\u0134\u009b\2\u0637\u0645"+
		"\5\u0126\u0094\2\u0638\u0645\5\u012c\u0097\2\u0639\u0645\5\u0160\u00b1"+
		"\2\u063a\u0645\5\u013e\u00a0\2\u063b\u0645\5\u0140\u00a1\2\u063c\u0645"+
		"\5\u0142\u00a2\2\u063d\u0645\5\u0144\u00a3\2\u063e\u0645\5\u014a\u00a6"+
		"\2\u063f\u0645\5\u014c\u00a7\2\u0640\u0645\5\u0146\u00a4\2\u0641\u0645"+
		"\5\u0148\u00a5\2\u0642\u0645\5\u0166\u00b4\2\u0643\u0645\5\u0168\u00b5"+
		"\2\u0644\u0631\3\2\2\2\u0644\u0632\3\2\2\2\u0644\u0633\3\2\2\2\u0644\u0634"+
		"\3\2\2\2\u0644\u0635\3\2\2\2\u0644\u0636\3\2\2\2\u0644\u0637\3\2\2\2\u0644"+
		"\u0638\3\2\2\2\u0644\u0639\3\2\2\2\u0644\u063a\3\2\2\2\u0644\u063b\3\2"+
		"\2\2\u0644\u063c\3\2\2\2\u0644\u063d\3\2\2\2\u0644\u063e\3\2\2\2\u0644"+
		"\u063f\3\2\2\2\u0644\u0640\3\2\2\2\u0644\u0641\3\2\2\2\u0644\u0642\3\2"+
		"\2\2\u0644\u0643\3\2\2\2\u0645\u0119\3\2\2\2\u0646\u0647\7:\2\2\u0647"+
		"\u0648\7\31\2\2\u0648\u0649\5\u008eH\2\u0649\u064a\7\63\2\2\u064a\u064b"+
		"\5\u011c\u008f\2\u064b\u064c\7\32\2\2\u064c\u011b\3\2\2\2\u064d\u0655"+
		"\5\u011e\u0090\2\u064e\u064f\7\31\2\2\u064f\u0652\7\5\2\2\u0650\u0651"+
		"\7\27\2\2\u0651\u0653\7\5\2\2\u0652\u0650\3\2\2\2\u0652\u0653\3\2\2\2"+
		"\u0653\u0654\3\2\2\2\u0654\u0656\7\32\2\2\u0655\u064e\3\2\2\2\u0655\u0656"+
		"\3\2\2\2\u0656\u011d\3\2\2\2\u0657\u0658\5\u016c\u00b7\2\u0658\u0659\b"+
		"\u0090\1\2\u0659\u0660\3\2\2\2\u065a\u065b\7\30\2\2\u065b\u065c\5\u016c"+
		"\u00b7\2\u065c\u065d\b\u0090\1\2\u065d\u065f\3\2\2\2\u065e\u065a\3\2\2"+
		"\2\u065f\u0662\3\2\2\2\u0660\u065e\3\2\2\2\u0660\u0661\3\2\2\2\u0661\u011f"+
		"\3\2\2\2\u0662\u0660\3\2\2\2\u0663\u0664\7\u00ad\2\2\u0664\u0665\7\31"+
		"\2\2\u0665\u0666\5\u008eH\2\u0666\u0667\7\27\2\2\u0667\u066a\5\u0122\u0092"+
		"\2\u0668\u0669\7\27\2\2\u0669\u066b\5\u0124\u0093\2\u066a\u0668\3\2\2"+
		"\2\u066a\u066b\3\2\2\2\u066b\u066c\3\2\2\2\u066c\u066d\7\32\2\2\u066d"+
		"\u067a\3\2\2\2\u066e\u066f\7\u00ad\2\2\u066f\u0670\7\31\2\2\u0670\u0671"+
		"\5\u008eH\2\u0671\u0672\7]\2\2\u0672\u0675\5\u0122\u0092\2\u0673\u0674"+
		"\7[\2\2\u0674\u0676\5\u0124\u0093\2\u0675\u0673\3\2\2\2\u0675\u0676\3"+
		"\2\2\2\u0676\u0677\3\2\2\2\u0677\u0678\7\32\2\2\u0678\u067a\3\2\2\2\u0679"+
		"\u0663\3\2\2\2\u0679\u066e\3\2\2\2\u067a\u0121\3\2\2\2\u067b\u067c\5\u008e"+
		"H\2\u067c\u0123\3\2\2\2\u067d\u067e\5\u008eH\2\u067e\u0125\3\2\2\2\u067f"+
		"\u0680\7\u00b7\2\2\u0680\u0682\7\31\2\2\u0681\u0683\5\u0128\u0095\2\u0682"+
		"\u0681\3\2\2\2\u0682\u0683\3\2\2\2\u0683\u0685\3\2\2\2\u0684\u0686\5\u012a"+
		"\u0096\2\u0685\u0684\3\2\2\2\u0685\u0686\3\2\2\2\u0686\u0688\3\2\2\2\u0687"+
		"\u0689\7]\2\2\u0688\u0687\3\2\2\2\u0688\u0689\3\2\2\2\u0689\u068a\3\2"+
		"\2\2\u068a\u068b\5\u008eH\2\u068b\u068c\7\32\2\2\u068c\u0127\3\2\2\2\u068d"+
		"\u068e\t\25\2\2\u068e\u0129\3\2\2\2\u068f\u0690\7\f\2\2\u0690\u012b\3"+
		"\2\2\2\u0691\u0692\7\u009b\2\2\u0692\u0693\7\31\2\2\u0693\u0694\5\u008e"+
		"H\2\u0694\u0695\7\u00c2\2\2\u0695\u0696\5\u0132\u009a\2\u0696\u0698\5"+
		"\u012e\u0098\2\u0697\u0699\5\u0130\u0099\2\u0698\u0697\3\2\2\2\u0698\u0699"+
		"\3\2\2\2\u0699\u069a\3\2\2\2\u069a\u069b\7\32\2\2\u069b\u012d\3\2\2\2"+
		"\u069c\u069d\t\26\2\2\u069d\u012f\3\2\2\2\u069e\u069f\7\f\2\2\u069f\u0131"+
		"\3\2\2\2\u06a0\u06a1\5\u008eH\2\u06a1\u0133\3\2\2\2\u06a2\u06a3\7\u009a"+
		"\2\2\u06a3\u06a4\7\31\2\2\u06a4\u06a5\5\u0136\u009c\2\u06a5\u06a6\7\u009e"+
		"\2\2\u06a6\u06a7\5\u0138\u009d\2\u06a7\u06a8\7]\2\2\u06a8\u06ab\5\u013a"+
		"\u009e\2\u06a9\u06aa\7[\2\2\u06aa\u06ac\5\u013c\u009f\2\u06ab\u06a9\3"+
		"\2\2\2\u06ab\u06ac\3\2\2\2\u06ac\u06ad\3\2\2\2\u06ad\u06ae\7\32\2\2\u06ae"+
		"\u0135\3\2\2\2\u06af\u06b0\5\u008eH\2\u06b0\u0137\3\2\2\2\u06b1\u06b2"+
		"\5\u008eH\2\u06b2\u0139\3\2\2\2\u06b3\u06b4\5\u008eH\2\u06b4\u013b\3\2"+
		"\2\2\u06b5\u06b6\5\u008eH\2\u06b6\u013d\3\2\2\2\u06b7\u06ba\7@\2\2\u06b8"+
		"\u06b9\7\31\2\2\u06b9\u06bb\7\32\2\2\u06ba\u06b8\3\2\2\2\u06ba\u06bb\3"+
		"\2\2\2\u06bb\u06bf\3\2\2\2\u06bc\u06bd\7?\2\2\u06bd\u06bf\7D\2\2\u06be"+
		"\u06b7\3\2\2\2\u06be\u06bc\3\2\2\2\u06bf\u013f\3\2\2\2\u06c0\u06c3\7B"+
		"\2\2\u06c1\u06c2\7\31\2\2\u06c2\u06c4\7\32\2\2\u06c3\u06c1\3\2\2\2\u06c3"+
		"\u06c4\3\2\2\2\u06c4\u06c8\3\2\2\2\u06c5\u06c6\7?\2\2\u06c6\u06c8\7\u00b1"+
		"\2\2\u06c7\u06c0\3\2\2\2\u06c7\u06c5\3\2\2\2\u06c8\u0141\3\2\2\2\u06c9"+
		"\u06cc\7C\2\2\u06ca\u06cb\7\31\2\2\u06cb\u06cd\7\32\2\2\u06cc\u06ca\3"+
		"\2\2\2\u06cc\u06cd\3\2\2\2\u06cd\u06d1\3\2\2\2\u06ce\u06cf\7?\2\2\u06cf"+
		"\u06d1\7\u00b2\2\2\u06d0\u06c9\3\2\2\2\u06d0\u06ce\3\2\2\2\u06d1\u0143"+
		"\3\2\2\2\u06d2\u06d5\7A\2\2\u06d3\u06d4\7\31\2\2\u06d4\u06d6\7\32\2\2"+
		"\u06d5\u06d3\3\2\2\2\u06d5\u06d6\3\2\2\2\u06d6\u06d9\3\2\2\2\u06d7\u06d9"+
		"\7k\2\2\u06d8\u06d2\3\2\2\2\u06d8\u06d7\3\2\2\2\u06d9\u0145\3\2\2\2\u06da"+
		"\u06dd\7z\2\2\u06db\u06dc\7\31\2\2\u06dc\u06de\7\32\2\2\u06dd\u06db\3"+
		"\2\2\2\u06dd\u06de\3\2\2\2\u06de\u06e2\3\2\2\2\u06df\u06e0\7x\2\2\u06e0"+
		"\u06e2\7E\2\2\u06e1\u06da\3\2\2\2\u06e1\u06df\3\2\2\2\u06e2\u0147\3\2"+
		"\2\2\u06e3\u06e6\7\u0091\2\2\u06e4\u06e5\7\31\2\2\u06e5\u06e7\7\32\2\2"+
		"\u06e6\u06e4\3\2\2\2\u06e6\u06e7\3\2\2\2\u06e7\u06eb\3\2\2\2\u06e8\u06e9"+
		"\7\u0090\2\2\u06e9\u06eb\7E\2\2\u06ea\u06e3\3\2\2\2\u06ea\u06e8\3\2\2"+
		"\2\u06eb\u0149\3\2\2\2\u06ec\u06ef\7y\2\2\u06ed\u06ee\7\31\2\2\u06ee\u06f0"+
		"\7\32\2\2\u06ef\u06ed\3\2\2\2\u06ef\u06f0\3\2\2\2\u06f0\u06f4\3\2\2\2"+
		"\u06f1\u06f2\7x\2\2\u06f2\u06f4\7D\2\2\u06f3\u06ec\3\2\2\2\u06f3\u06f1"+
		"\3\2\2\2\u06f4\u014b\3\2\2\2\u06f5\u06f8\7{\2\2\u06f6\u06f7\7\31\2\2\u06f7"+
		"\u06f9\7\32\2\2\u06f8\u06f6\3\2\2\2\u06f8\u06f9\3\2\2\2\u06f9\u06fd\3"+
		"\2\2\2\u06fa\u06fb\7x\2\2\u06fb\u06fd\7\u00b1\2\2\u06fc\u06f5\3\2\2\2"+
		"\u06fc\u06fa\3\2\2\2\u06fd\u014d\3\2\2\2\u06fe\u06ff\7\\\2\2\u06ff\u0700"+
		"\7\31\2\2\u0700\u0701\5\u008eH\2\u0701\u0702\7\63\2\2\u0702\u0703\5\u0150"+
		"\u00a9\2\u0703\u0704\7\32\2\2\u0704\u014f\3\2\2\2\u0705\u0706\7\f\2\2"+
		"\u0706\u0151\3\2\2\2\u0707\u0708\7V\2\2\u0708\u0709\7\31\2\2\u0709\u070a"+
		"\5\u0154\u00ab\2\u070a\u070b\7]\2\2\u070b\u070c\5\u008eH\2\u070c\u070d"+
		"\7\32\2\2\u070d\u0714\3\2\2\2\u070e\u070f\5\u0156\u00ac\2\u070f\u0710"+
		"\7\31\2\2\u0710\u0711\5\u008eH\2\u0711\u0712\7\32\2\2\u0712\u0714\3\2"+
		"\2\2\u0713\u0707\3\2\2\2\u0713\u070e\3\2\2\2\u0714\u0153\3\2\2\2\u0715"+
		"\u071b\5\u0156\u00ac\2\u0716\u071b\5\u0158\u00ad\2\u0717\u071b\5\u015a"+
		"\u00ae\2\u0718\u071b\5\u015c\u00af\2\u0719\u071b\5\u015e\u00b0\2\u071a"+
		"\u0715\3\2\2\2\u071a\u0716\3\2\2\2\u071a\u0717\3\2\2\2\u071a\u0718\3\2"+
		"\2\2\u071a\u0719\3\2\2\2\u071b\u0155\3\2\2\2\u071c\u071d\t\27\2\2\u071d"+
		"\u0157\3\2\2\2\u071e\u071f\7F\2\2\u071f\u0720\7\u008f\2\2\u0720\u0728"+
		"\7\u0087\2\2\u0721\u0722\7F\2\2\u0722\u0723\7\u008f\2\2\u0723\u0728\7"+
		"\u00bf\2\2\u0724\u0725\7F\2\2\u0725\u0726\7\u008f\2\2\u0726\u0728\7\u00c5"+
		"\2\2\u0727\u071e\3\2\2\2\u0727\u0721\3\2\2\2\u0727\u0724\3\2\2\2\u0728"+
		"\u0159\3\2\2\2\u0729\u072a\7\u00bf\2\2\u072a\u072b\7\u008f\2\2\u072b\u0730"+
		"\7\u0087\2\2\u072c\u072d\7\u00bf\2\2\u072d\u072e\7\u008f\2\2\u072e\u0730"+
		"\7\u00c5\2\2\u072f\u0729\3\2\2\2\u072f\u072c\3\2\2\2\u0730\u015b\3\2\2"+
		"\2\u0731\u0733\7\u0090\2\2\u0732\u0734\t\30\2\2\u0733\u0732\3\2\2\2\u0733"+
		"\u0734\3\2\2\2\u0734\u0738\3\2\2\2\u0735\u0738\7\u00b3\2\2\u0736\u0738"+
		"\7\u00b4\2\2\u0737\u0731\3\2\2\2\u0737\u0735\3\2\2\2\u0737\u0736\3\2\2"+
		"\2\u0738\u015d\3\2\2\2\u0739\u073a\t\31\2\2\u073a\u015f\3\2\2\2\u073b"+
		"\u073c\7\u009f\2\2\u073c\u073d\7\31\2\2\u073d\u073e\5\u0162\u00b2\2\u073e"+
		"\u073f\7f\2\2\u073f\u0740\5\u0164\u00b3\2\u0740\u0741\7\32\2\2\u0741\u0161"+
		"\3\2\2\2\u0742\u0743\5\u008eH\2\u0743\u0163\3\2\2\2\u0744\u0745\5\u008e"+
		"H\2\u0745\u0165\3\2\2\2\u0746\u0747\7>\2\2\u0747\u0748\7\31\2\2\u0748"+
		"\u074d\5\u0092J\2\u0749\u074a\7\27\2\2\u074a\u074c\5\u0092J\2\u074b\u0749"+
		"\3\2\2\2\u074c\u074f\3\2\2\2\u074d\u074b\3\2\2\2\u074d\u074e\3\2\2\2\u074e"+
		"\u0750\3\2\2\2\u074f\u074d\3\2\2\2\u0750\u0751\7\32\2\2\u0751\u0167\3"+
		"\2\2\2\u0752\u0753\7\u00a5\2\2\u0753\u0754\7\31\2\2\u0754\u0759\5\u0092"+
		"J\2\u0755\u0756\7\27\2\2\u0756\u0758\5\u0092J\2\u0757\u0755\3\2\2\2\u0758"+
		"\u075b\3\2\2\2\u0759\u0757\3\2\2\2\u0759\u075a\3\2\2\2\u075a\u075c\3\2"+
		"\2\2\u075b\u0759\3\2\2\2\u075c\u075d\7\32\2\2\u075d\u0169\3\2\2\2\u075e"+
		"\u0763\7\u00c9\2\2\u075f\u0763\7\u00ca\2\2\u0760\u0761\t\32\2\2\u0761"+
		"\u0763\b\u00b6\1\2\u0762\u075e\3\2\2\2\u0762\u075f\3\2\2\2\u0762\u0760"+
		"\3\2\2\2\u0763\u016b\3\2\2\2\u0764\u0768\5\u016a\u00b6\2\u0765\u0766\t"+
		"\33\2\2\u0766\u0768\b\u00b7\1\2\u0767\u0764\3\2\2\2\u0767\u0765\3\2\2"+
		"\2\u0768\u016d\3\2\2\2\u00cc\u0172\u017c\u0180\u0184\u0188\u018d\u0195"+
		"\u019e\u01a4\u01ac\u01b7\u01c0\u01cc\u01ce\u01d2\u01d8\u01da\u01de\u01e2"+
		"\u01e6\u01e8\u01ec\u01ef\u01f2\u01f6\u01f9\u01fd\u01ff\u0203\u0207\u0209"+
		"\u020c\u020e\u0216\u021d\u021f\u0224\u022b\u0231\u0237\u023f\u0244\u0248"+
		"\u024b\u024e\u0251\u0253\u0257\u025e\u0267\u026c\u0272\u0282\u0289\u028e"+
		"\u0292\u029d\u02a5\u02a8\u02b3\u02b7\u02be\u02c7\u02ce\u02d5\u02de\u02e4"+
		"\u02f0\u02f8\u02fd\u0300\u0308\u031b\u0323\u0329\u032d\u0333\u0340\u0347"+
		"\u034d\u0354\u035d\u0362\u0372\u0376\u037d\u0385\u0387\u0397\u03a4\u03a7"+
		"\u03af\u03b4\u03c1\u03d0\u03e2\u03e4\u03f1\u03f5\u03f9\u0405\u040e\u041a"+
		"\u0423\u042a\u042d\u043d\u0440\u0450\u045d\u0461\u0469\u0471\u0479\u0481"+
		"\u0487\u0494\u049a\u04ab\u04ae\u04b3\u04ba\u04c1\u04d5\u04d7\u04e1\u04e8"+
		"\u04f2\u04f6\u04f9\u04fc\u04ff\u0502\u050a\u0511\u0543\u056f\u057b\u0580"+
		"\u0587\u058a\u0597\u059e\u05a1\u05ae\u05b3\u05b9\u05bd\u05c0\u05c3\u05ca"+
		"\u05ce\u05df\u05e5\u05ea\u05ed\u05f0\u05fb\u0601\u0609\u060b\u0617\u0623"+
		"\u062f\u0644\u0652\u0655\u0660\u066a\u0675\u0679\u0682\u0685\u0688\u0698"+
		"\u06ab\u06ba\u06be\u06c3\u06c7\u06cc\u06d0\u06d5\u06d8\u06dd\u06e1\u06e6"+
		"\u06ea\u06ef\u06f3\u06f8\u06fc\u0713\u071a\u0727\u072f\u0733\u0737\u074d"+
		"\u0759\u0762\u0767";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
