
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.ordering;

import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.*;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class OrderingLexer extends Lexer {
	static { RuntimeMetaData.checkVersion("4.9.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, INTEGER_LITERAL=2, LONG_LITERAL=3, BIG_INTEGER_LITERAL=4, HEX_LITERAL=5, 
		OCTAL_LITERAL=6, FLOAT_LITERAL=7, DOUBLE_LITERAL=8, BIG_DECIMAL_LITERAL=9, 
		CHARACTER_LITERAL=10, STRING_LITERAL=11, COLLATE=12, NULLS=13, FIRST=14, 
		LAST=15, ASC=16, DESC=17, IDENTIFIER=18, QUOTED_IDENTIFIER=19, OPEN_PAREN=20, 
		CLOSE_PAREN=21, COMMA=22, DOT=23, PLUS=24, MINUS=25, MULTIPLY=26, DIVIDE=27, 
		MODULO=28;
	public static String[] channelNames = {
		"DEFAULT_TOKEN_CHANNEL", "HIDDEN"
	};

	public static String[] modeNames = {
		"DEFAULT_MODE"
	};

	private static String[] makeRuleNames() {
		return new String[] {
			"WS", "EOL", "DIGIT", "INTEGER_LITERAL", "INTEGER_NUMBER", "LONG_LITERAL", 
			"BIG_INTEGER_LITERAL", "HEX_LITERAL", "HEX_DIGIT", "OCTAL_LITERAL", "FLOAT_LITERAL", 
			"FLOATING_POINT_NUMBER", "DOUBLE_LITERAL", "BIG_DECIMAL_LITERAL", "EXPONENT", 
			"SINGLE_QUOTE", "DOUBLE_QUOTE", "CHARACTER_LITERAL", "STRING_LITERAL", 
			"ESCAPE_SEQUENCE", "OCTAL_ESCAPE", "UNICODE_ESCAPE", "COLLATE", "NULLS", 
			"FIRST", "LAST", "ASC", "DESC", "LETTER", "IDENTIFIER", "BACKTICK", "QUOTED_IDENTIFIER", 
			"OPEN_PAREN", "CLOSE_PAREN", "COMMA", "DOT", "PLUS", "MINUS", "MULTIPLY", 
			"DIVIDE", "MODULO"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, null, null, null, null, null, null, null, "'('", "')'", "','", 
			"'.'", "'+'", "'-'", "'*'", "'/'", "'%'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "INTEGER_LITERAL", "LONG_LITERAL", "BIG_INTEGER_LITERAL", 
			"HEX_LITERAL", "OCTAL_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "BIG_DECIMAL_LITERAL", 
			"CHARACTER_LITERAL", "STRING_LITERAL", "COLLATE", "NULLS", "FIRST", "LAST", 
			"ASC", "DESC", "IDENTIFIER", "QUOTED_IDENTIFIER", "OPEN_PAREN", "CLOSE_PAREN", 
			"COMMA", "DOT", "PLUS", "MINUS", "MULTIPLY", "DIVIDE", "MODULO"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}


	public OrderingLexer(CharStream input) {
		super(input);
		_interp = new LexerATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	@Override
	public String getGrammarFileName() { return "OrderingLexer.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public String[] getChannelNames() { return channelNames; }

	@Override
	public String[] getModeNames() { return modeNames; }

	@Override
	public ATN getATN() { return _ATN; }

	public static final String _serializedATN =
		"\3\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964\2\36\u016d\b\1\4\2"+
		"\t\2\4\3\t\3\4\4\t\4\4\5\t\5\4\6\t\6\4\7\t\7\4\b\t\b\4\t\t\t\4\n\t\n\4"+
		"\13\t\13\4\f\t\f\4\r\t\r\4\16\t\16\4\17\t\17\4\20\t\20\4\21\t\21\4\22"+
		"\t\22\4\23\t\23\4\24\t\24\4\25\t\25\4\26\t\26\4\27\t\27\4\30\t\30\4\31"+
		"\t\31\4\32\t\32\4\33\t\33\4\34\t\34\4\35\t\35\4\36\t\36\4\37\t\37\4 \t"+
		" \4!\t!\4\"\t\"\4#\t#\4$\t$\4%\t%\4&\t&\4\'\t\'\4(\t(\4)\t)\4*\t*\3\2"+
		"\3\2\5\2X\n\2\3\2\3\2\3\3\6\3]\n\3\r\3\16\3^\3\4\3\4\3\5\3\5\3\6\3\6\3"+
		"\6\7\6h\n\6\f\6\16\6k\13\6\5\6m\n\6\3\7\3\7\3\7\3\b\3\b\3\b\3\b\3\b\5"+
		"\bw\n\b\3\t\3\t\3\t\6\t|\n\t\r\t\16\t}\3\t\5\t\u0081\n\t\3\n\3\n\5\n\u0085"+
		"\n\n\3\13\3\13\6\13\u0089\n\13\r\13\16\13\u008a\3\13\5\13\u008e\n\13\3"+
		"\f\3\f\5\f\u0092\n\f\3\r\6\r\u0095\n\r\r\r\16\r\u0096\3\r\3\r\7\r\u009b"+
		"\n\r\f\r\16\r\u009e\13\r\3\r\5\r\u00a1\n\r\3\r\3\r\6\r\u00a5\n\r\r\r\16"+
		"\r\u00a6\3\r\5\r\u00aa\n\r\3\r\6\r\u00ad\n\r\r\r\16\r\u00ae\3\r\3\r\3"+
		"\r\6\r\u00b4\n\r\r\r\16\r\u00b5\5\r\u00b8\n\r\3\16\3\16\3\16\3\17\3\17"+
		"\3\17\3\17\3\17\5\17\u00c2\n\17\3\20\3\20\5\20\u00c6\n\20\3\20\6\20\u00c9"+
		"\n\20\r\20\16\20\u00ca\3\21\3\21\3\22\3\22\3\23\3\23\3\23\3\23\3\23\3"+
		"\23\5\23\u00d7\n\23\3\23\3\23\3\24\3\24\3\24\3\24\3\24\3\24\7\24\u00e1"+
		"\n\24\f\24\16\24\u00e4\13\24\3\24\3\24\3\24\3\24\3\24\3\24\3\24\3\24\7"+
		"\24\u00ee\n\24\f\24\16\24\u00f1\13\24\3\24\3\24\5\24\u00f5\n\24\3\25\3"+
		"\25\3\25\3\25\3\25\5\25\u00fc\n\25\3\25\3\25\5\25\u0100\n\25\3\26\3\26"+
		"\3\26\3\26\3\26\3\26\3\26\3\26\3\26\5\26\u010b\n\26\3\27\3\27\3\27\3\27"+
		"\3\27\3\27\3\27\3\30\3\30\3\30\3\30\3\30\3\30\3\30\3\30\3\31\3\31\3\31"+
		"\3\31\3\31\3\31\3\32\3\32\3\32\3\32\3\32\3\32\3\33\3\33\3\33\3\33\3\33"+
		"\3\34\3\34\3\34\3\34\3\34\3\34\3\34\3\34\3\34\5\34\u0136\n\34\3\35\3\35"+
		"\3\35\3\35\3\35\3\35\3\35\3\35\3\35\3\35\5\35\u0142\n\35\3\36\3\36\3\37"+
		"\3\37\3\37\7\37\u0149\n\37\f\37\16\37\u014c\13\37\3 \3 \3!\3!\3!\3!\3"+
		"!\7!\u0155\n!\f!\16!\u0158\13!\3!\3!\3\"\3\"\3#\3#\3$\3$\3%\3%\3&\3&\3"+
		"\'\3\'\3(\3(\3)\3)\3*\3*\2\2+\3\3\5\2\7\2\t\4\13\2\r\5\17\6\21\7\23\2"+
		"\25\b\27\t\31\2\33\n\35\13\37\2!\2#\2%\f\'\r)\2+\2-\2/\16\61\17\63\20"+
		"\65\21\67\229\23;\2=\24?\2A\25C\26E\27G\30I\31K\32M\33O\34Q\35S\36\3\2"+
		"\34\5\2\13\13\16\16\"\"\4\2\f\f\17\17\3\2\62;\4\2NNnn\4\2ZZzz\4\2CHch"+
		"\4\2HHhh\4\2FFff\4\2GGgg\4\2--//\3\2))\3\2$$\7\2ddhhppttvv\4\2))^^\4\2"+
		"EEee\4\2QQqq\4\2CCcc\4\2VVvv\4\2PPpp\4\2WWww\4\2UUuu\4\2KKkk\4\2TTtt\4"+
		"\2IIii\7\2&&C\\aac|\u0082\0\3\2bb\2\u018d\2\3\3\2\2\2\2\t\3\2\2\2\2\r"+
		"\3\2\2\2\2\17\3\2\2\2\2\21\3\2\2\2\2\25\3\2\2\2\2\27\3\2\2\2\2\33\3\2"+
		"\2\2\2\35\3\2\2\2\2%\3\2\2\2\2\'\3\2\2\2\2/\3\2\2\2\2\61\3\2\2\2\2\63"+
		"\3\2\2\2\2\65\3\2\2\2\2\67\3\2\2\2\29\3\2\2\2\2=\3\2\2\2\2A\3\2\2\2\2"+
		"C\3\2\2\2\2E\3\2\2\2\2G\3\2\2\2\2I\3\2\2\2\2K\3\2\2\2\2M\3\2\2\2\2O\3"+
		"\2\2\2\2Q\3\2\2\2\2S\3\2\2\2\3W\3\2\2\2\5\\\3\2\2\2\7`\3\2\2\2\tb\3\2"+
		"\2\2\13l\3\2\2\2\rn\3\2\2\2\17q\3\2\2\2\21x\3\2\2\2\23\u0084\3\2\2\2\25"+
		"\u0086\3\2\2\2\27\u008f\3\2\2\2\31\u00b7\3\2\2\2\33\u00b9\3\2\2\2\35\u00bc"+
		"\3\2\2\2\37\u00c3\3\2\2\2!\u00cc\3\2\2\2#\u00ce\3\2\2\2%\u00d0\3\2\2\2"+
		"\'\u00f4\3\2\2\2)\u00ff\3\2\2\2+\u010a\3\2\2\2-\u010c\3\2\2\2/\u0113\3"+
		"\2\2\2\61\u011b\3\2\2\2\63\u0121\3\2\2\2\65\u0127\3\2\2\2\67\u012c\3\2"+
		"\2\29\u0137\3\2\2\2;\u0143\3\2\2\2=\u0145\3\2\2\2?\u014d\3\2\2\2A\u014f"+
		"\3\2\2\2C\u015b\3\2\2\2E\u015d\3\2\2\2G\u015f\3\2\2\2I\u0161\3\2\2\2K"+
		"\u0163\3\2\2\2M\u0165\3\2\2\2O\u0167\3\2\2\2Q\u0169\3\2\2\2S\u016b\3\2"+
		"\2\2UX\t\2\2\2VX\5\5\3\2WU\3\2\2\2WV\3\2\2\2XY\3\2\2\2YZ\b\2\2\2Z\4\3"+
		"\2\2\2[]\t\3\2\2\\[\3\2\2\2]^\3\2\2\2^\\\3\2\2\2^_\3\2\2\2_\6\3\2\2\2"+
		"`a\t\4\2\2a\b\3\2\2\2bc\5\13\6\2c\n\3\2\2\2dm\7\62\2\2ei\4\63;\2fh\5\7"+
		"\4\2gf\3\2\2\2hk\3\2\2\2ig\3\2\2\2ij\3\2\2\2jm\3\2\2\2ki\3\2\2\2ld\3\2"+
		"\2\2le\3\2\2\2m\f\3\2\2\2no\5\13\6\2op\t\5\2\2p\16\3\2\2\2qv\5\13\6\2"+
		"rs\7d\2\2sw\7k\2\2tu\7D\2\2uw\7K\2\2vr\3\2\2\2vt\3\2\2\2w\20\3\2\2\2x"+
		"y\7\62\2\2y{\t\6\2\2z|\5\23\n\2{z\3\2\2\2|}\3\2\2\2}{\3\2\2\2}~\3\2\2"+
		"\2~\u0080\3\2\2\2\177\u0081\t\5\2\2\u0080\177\3\2\2\2\u0080\u0081\3\2"+
		"\2\2\u0081\22\3\2\2\2\u0082\u0085\5\7\4\2\u0083\u0085\t\7\2\2\u0084\u0082"+
		"\3\2\2\2\u0084\u0083\3\2\2\2\u0085\24\3\2\2\2\u0086\u0088\7\62\2\2\u0087"+
		"\u0089\4\629\2\u0088\u0087\3\2\2\2\u0089\u008a\3\2\2\2\u008a\u0088\3\2"+
		"\2\2\u008a\u008b\3\2\2\2\u008b\u008d\3\2\2\2\u008c\u008e\t\5\2\2\u008d"+
		"\u008c\3\2\2\2\u008d\u008e\3\2\2\2\u008e\26\3\2\2\2\u008f\u0091\5\31\r"+
		"\2\u0090\u0092\t\b\2\2\u0091\u0090\3\2\2\2\u0091\u0092\3\2\2\2\u0092\30"+
		"\3\2\2\2\u0093\u0095\5\7\4\2\u0094\u0093\3\2\2\2\u0095\u0096\3\2\2\2\u0096"+
		"\u0094\3\2\2\2\u0096\u0097\3\2\2\2\u0097\u0098\3\2\2\2\u0098\u009c\7\60"+
		"\2\2\u0099\u009b\5\7\4\2\u009a\u0099\3\2\2\2\u009b\u009e\3\2\2\2\u009c"+
		"\u009a\3\2\2\2\u009c\u009d\3\2\2\2\u009d\u00a0\3\2\2\2\u009e\u009c\3\2"+
		"\2\2\u009f\u00a1\5\37\20\2\u00a0\u009f\3\2\2\2\u00a0\u00a1\3\2\2\2\u00a1"+
		"\u00b8\3\2\2\2\u00a2\u00a4\7\60\2\2\u00a3\u00a5\5\7\4\2\u00a4\u00a3\3"+
		"\2\2\2\u00a5\u00a6\3\2\2\2\u00a6\u00a4\3\2\2\2\u00a6\u00a7\3\2\2\2\u00a7"+
		"\u00a9\3\2\2\2\u00a8\u00aa\5\37\20\2\u00a9\u00a8\3\2\2\2\u00a9\u00aa\3"+
		"\2\2\2\u00aa\u00b8\3\2\2\2\u00ab\u00ad\5\7\4\2\u00ac\u00ab\3\2\2\2\u00ad"+
		"\u00ae\3\2\2\2\u00ae\u00ac\3\2\2\2\u00ae\u00af\3\2\2\2\u00af\u00b0\3\2"+
		"\2\2\u00b0\u00b1\5\37\20\2\u00b1\u00b8\3\2\2\2\u00b2\u00b4\5\7\4\2\u00b3"+
		"\u00b2\3\2\2\2\u00b4\u00b5\3\2\2\2\u00b5\u00b3\3\2\2\2\u00b5\u00b6\3\2"+
		"\2\2\u00b6\u00b8\3\2\2\2\u00b7\u0094\3\2\2\2\u00b7\u00a2\3\2\2\2\u00b7"+
		"\u00ac\3\2\2\2\u00b7\u00b3\3\2\2\2\u00b8\32\3\2\2\2\u00b9\u00ba\5\31\r"+
		"\2\u00ba\u00bb\t\t\2\2\u00bb\34\3\2\2\2\u00bc\u00c1\5\31\r\2\u00bd\u00be"+
		"\7d\2\2\u00be\u00c2\7f\2\2\u00bf\u00c0\7D\2\2\u00c0\u00c2\7F\2\2\u00c1"+
		"\u00bd\3\2\2\2\u00c1\u00bf\3\2\2\2\u00c2\36\3\2\2\2\u00c3\u00c5\t\n\2"+
		"\2\u00c4\u00c6\t\13\2\2\u00c5\u00c4\3\2\2\2\u00c5\u00c6\3\2\2\2\u00c6"+
		"\u00c8\3\2\2\2\u00c7\u00c9\5\7\4\2\u00c8\u00c7\3\2\2\2\u00c9\u00ca\3\2"+
		"\2\2\u00ca\u00c8\3\2\2\2\u00ca\u00cb\3\2\2\2\u00cb \3\2\2\2\u00cc\u00cd"+
		"\7)\2\2\u00cd\"\3\2\2\2\u00ce\u00cf\7$\2\2\u00cf$\3\2\2\2\u00d0\u00d6"+
		"\5!\21\2\u00d1\u00d7\5)\25\2\u00d2\u00d3\5!\21\2\u00d3\u00d4\5!\21\2\u00d4"+
		"\u00d7\3\2\2\2\u00d5\u00d7\n\f\2\2\u00d6\u00d1\3\2\2\2\u00d6\u00d2\3\2"+
		"\2\2\u00d6\u00d5\3\2\2\2\u00d7\u00d8\3\2\2\2\u00d8\u00d9\5!\21\2\u00d9"+
		"&\3\2\2\2\u00da\u00e2\5#\22\2\u00db\u00e1\5)\25\2\u00dc\u00dd\5#\22\2"+
		"\u00dd\u00de\5#\22\2\u00de\u00e1\3\2\2\2\u00df\u00e1\n\r\2\2\u00e0\u00db"+
		"\3\2\2\2\u00e0\u00dc\3\2\2\2\u00e0\u00df\3\2\2\2\u00e1\u00e4\3\2\2\2\u00e2"+
		"\u00e0\3\2\2\2\u00e2\u00e3\3\2\2\2\u00e3\u00e5\3\2\2\2\u00e4\u00e2\3\2"+
		"\2\2\u00e5\u00e6\5#\22\2\u00e6\u00f5\3\2\2\2\u00e7\u00ef\5!\21\2\u00e8"+
		"\u00ee\5)\25\2\u00e9\u00ea\5!\21\2\u00ea\u00eb\5!\21\2\u00eb\u00ee\3\2"+
		"\2\2\u00ec\u00ee\n\f\2\2\u00ed\u00e8\3\2\2\2\u00ed\u00e9\3\2\2\2\u00ed"+
		"\u00ec\3\2\2\2\u00ee\u00f1\3\2\2\2\u00ef\u00ed\3\2\2\2\u00ef\u00f0\3\2"+
		"\2\2\u00f0\u00f2\3\2\2\2\u00f1\u00ef\3\2\2\2\u00f2\u00f3\5!\21\2\u00f3"+
		"\u00f5\3\2\2\2\u00f4\u00da\3\2\2\2\u00f4\u00e7\3\2\2\2\u00f5(\3\2\2\2"+
		"\u00f6\u00fb\7^\2\2\u00f7\u00fc\t\16\2\2\u00f8\u00f9\7^\2\2\u00f9\u00fc"+
		"\7$\2\2\u00fa\u00fc\t\17\2\2\u00fb\u00f7\3\2\2\2\u00fb\u00f8\3\2\2\2\u00fb"+
		"\u00fa\3\2\2\2\u00fc\u0100\3\2\2\2\u00fd\u0100\5-\27\2\u00fe\u0100\5+"+
		"\26\2\u00ff\u00f6\3\2\2\2\u00ff\u00fd\3\2\2\2\u00ff\u00fe\3\2\2\2\u0100"+
		"*\3\2\2\2\u0101\u0102\7^\2\2\u0102\u0103\4\62\65\2\u0103\u0104\4\629\2"+
		"\u0104\u010b\4\629\2\u0105\u0106\7^\2\2\u0106\u0107\4\629\2\u0107\u010b"+
		"\4\629\2\u0108\u0109\7^\2\2\u0109\u010b\4\629\2\u010a\u0101\3\2\2\2\u010a"+
		"\u0105\3\2\2\2\u010a\u0108\3\2\2\2\u010b,\3\2\2\2\u010c\u010d\7^\2\2\u010d"+
		"\u010e\7w\2\2\u010e\u010f\5\23\n\2\u010f\u0110\5\23\n\2\u0110\u0111\5"+
		"\23\n\2\u0111\u0112\5\23\n\2\u0112.\3\2\2\2\u0113\u0114\t\20\2\2\u0114"+
		"\u0115\t\21\2\2\u0115\u0116\t\5\2\2\u0116\u0117\t\5\2\2\u0117\u0118\t"+
		"\22\2\2\u0118\u0119\t\23\2\2\u0119\u011a\t\n\2\2\u011a\60\3\2\2\2\u011b"+
		"\u011c\t\24\2\2\u011c\u011d\t\25\2\2\u011d\u011e\t\5\2\2\u011e\u011f\t"+
		"\5\2\2\u011f\u0120\t\26\2\2\u0120\62\3\2\2\2\u0121\u0122\t\b\2\2\u0122"+
		"\u0123\t\27\2\2\u0123\u0124\t\30\2\2\u0124\u0125\t\26\2\2\u0125\u0126"+
		"\t\23\2\2\u0126\64\3\2\2\2\u0127\u0128\t\5\2\2\u0128\u0129\t\22\2\2\u0129"+
		"\u012a\t\26\2\2\u012a\u012b\t\23\2\2\u012b\66\3\2\2\2\u012c\u012d\t\22"+
		"\2\2\u012d\u012e\t\26\2\2\u012e\u0135\t\20\2\2\u012f\u0130\t\n\2\2\u0130"+
		"\u0131\t\24\2\2\u0131\u0132\t\t\2\2\u0132\u0133\t\27\2\2\u0133\u0134\t"+
		"\24\2\2\u0134\u0136\t\31\2\2\u0135\u012f\3\2\2\2\u0135\u0136\3\2\2\2\u0136"+
		"8\3\2\2\2\u0137\u0138\t\t\2\2\u0138\u0139\t\n\2\2\u0139\u013a\t\26\2\2"+
		"\u013a\u0141\t\20\2\2\u013b\u013c\t\n\2\2\u013c\u013d\t\24\2\2\u013d\u013e"+
		"\t\t\2\2\u013e\u013f\t\27\2\2\u013f\u0140\t\24\2\2\u0140\u0142\t\31\2"+
		"\2\u0141\u013b\3\2\2\2\u0141\u0142\3\2\2\2\u0142:\3\2\2\2\u0143\u0144"+
		"\t\32\2\2\u0144<\3\2\2\2\u0145\u014a\5;\36\2\u0146\u0149\5;\36\2\u0147"+
		"\u0149\5\7\4\2\u0148\u0146\3\2\2\2\u0148\u0147\3\2\2\2\u0149\u014c\3\2"+
		"\2\2\u014a\u0148\3\2\2\2\u014a\u014b\3\2\2\2\u014b>\3\2\2\2\u014c\u014a"+
		"\3\2\2\2\u014d\u014e\7b\2\2\u014e@\3\2\2\2\u014f\u0156\5? \2\u0150\u0155"+
		"\5)\25\2\u0151\u0152\7^\2\2\u0152\u0155\5? \2\u0153\u0155\n\33\2\2\u0154"+
		"\u0150\3\2\2\2\u0154\u0151\3\2\2\2\u0154\u0153\3\2\2\2\u0155\u0158\3\2"+
		"\2\2\u0156\u0154\3\2\2\2\u0156\u0157\3\2\2\2\u0157\u0159\3\2\2\2\u0158"+
		"\u0156\3\2\2\2\u0159\u015a\5? \2\u015aB\3\2\2\2\u015b\u015c\7*\2\2\u015c"+
		"D\3\2\2\2\u015d\u015e\7+\2\2\u015eF\3\2\2\2\u015f\u0160\7.\2\2\u0160H"+
		"\3\2\2\2\u0161\u0162\7\60\2\2\u0162J\3\2\2\2\u0163\u0164\7-\2\2\u0164"+
		"L\3\2\2\2\u0165\u0166\7/\2\2\u0166N\3\2\2\2\u0167\u0168\7,\2\2\u0168P"+
		"\3\2\2\2\u0169\u016a\7\61\2\2\u016aR\3\2\2\2\u016b\u016c\7\'\2\2\u016c"+
		"T\3\2\2\2(\2W^ilv}\u0080\u0084\u008a\u008d\u0091\u0096\u009c\u00a0\u00a6"+
		"\u00a9\u00ae\u00b5\u00b7\u00c1\u00c5\u00ca\u00d6\u00e0\u00e2\u00ed\u00ef"+
		"\u00f4\u00fb\u00ff\u010a\u0135\u0141\u0148\u014a\u0154\u0156\3\b\2\2";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
