/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html
 */
package org.hibernate.query.hql.spi;

import org.hibernate.Incubating;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;

/**
 * SqmCreationProcessingState specialization for processing a SQM query-spec
 *
 * @author Steve Ebersole
 */
@Incubating
public interface SqmQuerySpecCreationProcessingState extends SqmCreationProcessingState {
	@Override
	SqmSelectQuery<?> getProcessingQuery();
}
