/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.BasicCollectionPersister;

@Incubating
public class PersistentSortedMap<K, E>
extends PersistentMap<K, E>
implements SortedMap<K, E> {
    protected Comparator<? super K> comparator;

    public PersistentSortedMap() {
    }

    public PersistentSortedMap(SharedSessionContractImplementor session, Comparator<K> comparator) {
        super(session);
        this.comparator = comparator;
    }

    public PersistentSortedMap(SharedSessionContractImplementor session, SortedMap<K, E> map) {
        super(session, map);
        this.comparator = map.comparator();
    }

    protected Serializable snapshot(BasicCollectionPersister persister) throws HibernateException {
        TreeMap clonedMap = new TreeMap(this.comparator);
        for (Map.Entry e : this.map.entrySet()) {
            clonedMap.put(e.getKey(), persister.getElementType().deepCopy(e.getValue(), persister.getFactory()));
        }
        return clonedMap;
    }

    public void setComparator(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public SortedMap<K, E> subMap(K fromKey, K toKey) {
        this.read();
        SortedMap subMap = ((SortedMap)this.map).subMap(fromKey, toKey);
        return new SortedSubMap(subMap);
    }

    @Override
    public SortedMap<K, E> headMap(K toKey) {
        this.read();
        SortedMap headMap = ((SortedMap)this.map).headMap(toKey);
        return new SortedSubMap(headMap);
    }

    @Override
    public SortedMap<K, E> tailMap(K fromKey) {
        this.read();
        SortedMap tailMap = ((SortedMap)this.map).tailMap(fromKey);
        return new SortedSubMap(tailMap);
    }

    @Override
    public K firstKey() {
        this.read();
        return ((SortedMap)this.map).firstKey();
    }

    @Override
    public K lastKey() {
        this.read();
        return ((SortedMap)this.map).lastKey();
    }

    class SortedSubMap
    implements SortedMap<K, E> {
        SortedMap<K, E> subMap;

        SortedSubMap(SortedMap<K, E> subMap) {
            this.subMap = subMap;
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.subMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.subMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object key) {
            return this.subMap.containsValue(key);
        }

        @Override
        public E get(Object key) {
            return this.subMap.get(key);
        }

        @Override
        public E put(K key, E value) {
            PersistentSortedMap.this.write();
            return this.subMap.put(key, value);
        }

        @Override
        public E remove(Object key) {
            PersistentSortedMap.this.write();
            return this.subMap.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends E> other) {
            PersistentSortedMap.this.write();
            this.subMap.putAll(other);
        }

        @Override
        public void clear() {
            PersistentSortedMap.this.write();
            this.subMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return new AbstractPersistentCollection.SetProxy(PersistentSortedMap.this, this.subMap.keySet());
        }

        @Override
        public Collection<E> values() {
            return new AbstractPersistentCollection.SetProxy(PersistentSortedMap.this, this.subMap.values());
        }

        @Override
        public Set<Map.Entry<K, E>> entrySet() {
            return new PersistentMap.EntrySetProxy(PersistentSortedMap.this, this.subMap.entrySet());
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.subMap.comparator();
        }

        @Override
        public SortedMap<K, E> subMap(K fromKey, K toKey) {
            SortedMap subMap = this.subMap.subMap(fromKey, toKey);
            return new SortedSubMap(subMap);
        }

        @Override
        public SortedMap<K, E> headMap(K toKey) {
            SortedMap headMap = this.subMap.headMap(toKey);
            return new SortedSubMap(headMap);
        }

        @Override
        public SortedMap<K, E> tailMap(K fromKey) {
            SortedMap tailMap = this.subMap.tailMap(fromKey);
            return new SortedSubMap(tailMap);
        }

        @Override
        public K firstKey() {
            return this.subMap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.subMap.lastKey();
        }
    }
}

