/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.CockroachSqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.PostgreSQLInetJdbcType;
import org.hibernate.dialect.PostgreSQLIntervalSecondJdbcType;
import org.hibernate.dialect.PostgreSQLJsonJdbcType;
import org.hibernate.dialect.PostgreSQLJsonbJdbcType;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.NullOrdering;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.InstantAsTimestampWithTimeZoneJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class CockroachDialect
extends Dialect {
    private final PostgreSQLDriverKind driverKind;

    public CockroachDialect() {
        this(DatabaseVersion.make(19, 2));
    }

    public CockroachDialect(DialectResolutionInfo info) {
        super(info);
        this.driverKind = PostgreSQLDriverKind.determineKind(info);
    }

    public CockroachDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = PostgreSQLDriverKind.PG_JDBC;
    }

    public CockroachDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return "string($l)";
            }
            case 2005: 
            case 2011: {
                return "string";
            }
            case -3: 
            case -2: {
                return "bytes($l)";
            }
            case 2004: {
                return "bytes";
            }
            case 3003: {
                return this.columnType(2014);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "string";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytes";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new Scale6IntervalSecondDdlType(this));
        if (this.getVersion().isSameOrAfter(20)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3002, "inet", this));
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "jsonb", this));
        } else {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        }
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == 1111) {
            switch (columnTypeName) {
                case "uuid": {
                    jdbcTypeCode = 3000;
                    break;
                }
                case "json": 
                case "jsonb": {
                    jdbcTypeCode = 3001;
                    break;
                }
                case "inet": {
                    jdbcTypeCode = 3002;
                    break;
                }
                case "geometry": 
                case "geography": {
                    jdbcTypeCode = 3200;
                }
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(3003, InstantAsTimestampWithTimeZoneJdbcType.INSTANCE);
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLIntervalSecondJdbcType.INSTANCE);
            if (this.getVersion().isSameOrAfter(20, 0)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLJsonbJdbcType.INSTANCE);
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLJsonJdbcType.INSTANCE);
            }
        }
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(queryEngine);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.overlay();
        functionFactory.position();
        functionFactory.substringFromFor();
        functionFactory.locate_positionSubstring();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.reverse();
        functionFactory.repeat();
        functionFactory.md5();
        functionFactory.sha1();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.cbrt();
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.pi();
        functionFactory.trunc();
        queryEngine.getSqmFunctionRegistry().register("format", new FormatFunction("experimental_strftime", queryEngine.getTypeConfiguration()));
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("string");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select sequence_name,sequence_schema,sequence_catalog,start_value,minimum_value,maximum_value,increment from information_schema.sequences";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new CockroachSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
            case SECOND: {
                return "(extract(second from ?2)+extract(microsecond from ?2)/1e6)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        switch (unit) {
            case NANOSECOND: {
                return "(?3+(?2)/1e3*interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3+(?2)*interval '1 microsecond')";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3 month')";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7 day')";
            }
        }
        return "(?3+(?2)*interval '1 ?1')";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        switch (unit) {
            case YEAR: {
                return "(extract(year from ?3)-extract(year from ?2))";
            }
            case QUARTER: {
                return "(extract(year from ?3)*4-extract(year from ?2)*4+extract(month from ?3)//3-extract(month from ?2)//3)";
            }
            case MONTH: {
                return "(extract(year from ?3)*12-extract(year from ?2)*12+extract(month from ?3)-extract(month from ?2))";
            }
        }
        if (toTemporalType != TemporalType.TIMESTAMP && fromTemporalType != TemporalType.TIMESTAMP) {
            return "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, this);
        }
        switch (unit) {
            case WEEK: {
                return "extract_duration(hour from ?3-?2)/168";
            }
            case DAY: {
                return "extract_duration(hour from ?3-?2)/24";
            }
            case NANOSECOND: {
                return "extract_duration(microsecond from ?3-?2)*1e3";
            }
        }
        return "extract_duration(?1 from ?3-?2)";
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        return unit == TemporalUnit.NATIVE ? "microsecond" : super.translateDurationField(unit);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SpannerDialect.datetimeFormat(format).result());
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(LockOptions lockOptions) {
        if (this.getVersion().isBefore(20, 1)) {
            return "";
        }
        return super.getForUpdateString(lockOptions);
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (this.getVersion().isBefore(20, 1)) {
            return "";
        }
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
            while (itr.hasNext()) {
                Map.Entry<String, LockMode> entry = itr.next();
                LockMode lm = entry.getValue();
                if (!lm.greaterThan(lockMode)) continue;
                aliases = entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.getVersion().isSameOrAfter(20, 1) ? RowLockStrategy.TABLE : RowLockStrategy.NONE;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }
}

