/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class InverseNonAggregatedIdentifierMapping
extends EmbeddedAttributeMapping
implements NonAggregatedIdentifierMapping {
    private final IdClassEmbeddable idClassEmbeddable;
    private final NonAggregatedIdentifierMapping.IdentifierValueMapper identifierValueMapper;

    InverseNonAggregatedIdentifierMapping(ManagedMappingType keyDeclaringType, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, NonAggregatedIdentifierMapping inverseModelPart, EmbeddableMappingType embeddableTypeDescriptor, MappingModelCreationProcess creationProcess) {
        super(keyDeclaringType, declaringTableGroupProducer, selectableMappings, inverseModelPart, embeddableTypeDescriptor, creationProcess);
        if (inverseModelPart.getIdClassEmbeddable() == null) {
            this.idClassEmbeddable = null;
            this.identifierValueMapper = (NonAggregatedIdentifierMapping.IdentifierValueMapper)super.getEmbeddableTypeDescriptor();
        } else {
            this.idClassEmbeddable = (IdClassEmbeddable)inverseModelPart.getIdClassEmbeddable().createInverseMappingType(this, declaringTableGroupProducer, selectableMappings, creationProcess);
            this.identifierValueMapper = this.idClassEmbeddable;
        }
    }

    @Override
    public Object instantiate() {
        return null;
    }

    @Override
    public String getPartName() {
        return super.getPartName();
    }

    @Override
    public EmbeddableMappingType getPartMappingType() {
        return (EmbeddableMappingType)super.getPartMappingType();
    }

    @Override
    public IdClassEmbeddable getIdClassEmbeddable() {
        return this.idClassEmbeddable;
    }

    @Override
    public VirtualIdEmbeddable getVirtualIdEmbeddable() {
        return (VirtualIdEmbeddable)this.getMappedType();
    }

    @Override
    public NonAggregatedIdentifierMapping.IdentifierValueMapper getIdentifierValueMapper() {
        return this.identifierValueMapper;
    }

    @Override
    public boolean hasContainingClass() {
        return this.idClassEmbeddable != null;
    }

    @Override
    public EmbeddableMappingType getMappedIdEmbeddableTypeDescriptor() {
        return this.identifierValueMapper;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.disassemble(value, session);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.forEachJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        if (this.hasContainingClass()) {
            EmbeddableMappingType selectableMappings = this.getEmbeddableTypeDescriptor();
            ArrayList columnReferences = CollectionHelper.arrayList(selectableMappings.getJdbcTypeCount());
            NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
            TableReference defaultTableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
            int offset = 0;
            for (AttributeMapping attributeMapping : this.identifierValueMapper.getAttributeMappings()) {
                offset += attributeMapping.forEachSelectable(offset, (columnIndex, selection) -> {
                    TableReference tableReference = defaultTableReference.resolveTableReference(selection.getContainingTableExpression()) != null ? defaultTableReference : tableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                    Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), selection, sqlAstCreationState.getCreationContext().getSessionFactory()));
                    columnReferences.add((ColumnReference)columnReference);
                });
            }
            return new SqlTuple(columnReferences, this);
        }
        return super.toSqlExpression(tableGroup, clause, walker, sqlAstCreationState);
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        return this.getIdentifier(entity);
    }

    @Override
    public Object getIdentifier(Object entity) {
        if (this.hasContainingClass()) {
            Object id = this.identifierValueMapper.getRepresentationStrategy().getInstantiator().instantiate(null, null);
            List<AttributeMapping> attributeMappings = this.getEmbeddableTypeDescriptor().getAttributeMappings();
            List<AttributeMapping> idClassAttributeMappings = this.identifierValueMapper.getAttributeMappings();
            Object[] propertyValues = new Object[attributeMappings.size()];
            for (int i = 0; i < propertyValues.length; ++i) {
                AttributeMapping attributeMapping = attributeMappings.get(i);
                Object o = attributeMapping.getPropertyAccess().getGetter().get(entity);
                if (o == null) {
                    AttributeMapping idClassAttributeMapping = idClassAttributeMappings.get(i);
                    if (idClassAttributeMapping.getPropertyAccess().getGetter().getReturnTypeClass().isPrimitive()) {
                        propertyValues[i] = idClassAttributeMapping.getExpressibleJavaType().getDefaultValue();
                        continue;
                    }
                    propertyValues[i] = null;
                    continue;
                }
                if (attributeMapping instanceof ToOneAttributeMapping && !(idClassAttributeMappings.get(i) instanceof ToOneAttributeMapping)) {
                    ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                    ModelPart targetPart = toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature().inverse());
                    if (targetPart instanceof EntityIdentifierMapping) {
                        propertyValues[i] = ((EntityIdentifierMapping)targetPart).getIdentifier(o);
                        continue;
                    }
                    propertyValues[i] = o;
                    assert (false);
                    continue;
                }
                propertyValues[i] = o;
            }
            this.identifierValueMapper.setValues(id, propertyValues);
            return id;
        }
        return entity;
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        List<AttributeMapping> mappedIdAttributeMappings = this.identifierValueMapper.getAttributeMappings();
        Object[] propertyValues = new Object[mappedIdAttributeMappings.size()];
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister entityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entity.getClass());
        this.getEmbeddableTypeDescriptor().forEachAttributeMapping((position, attribute) -> {
            AttributeMapping mappedIdAttributeMapping = (AttributeMapping)mappedIdAttributeMappings.get(position);
            Object o = mappedIdAttributeMapping.getPropertyAccess().getGetter().get(id);
            if (attribute instanceof ToOneAttributeMapping && !(mappedIdAttributeMapping instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attribute;
                EntityPersister entityPersister = toOneAttributeMapping.getEntityMappingType().getEntityPersister();
                EntityKey entityKey = session.generateEntityKey(o, entityPersister);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                propertyValues[position] = persistenceContext.getProxy(entityKey);
                if (propertyValues[position] == null) {
                    propertyValues[position] = persistenceContext.getEntity(entityKey);
                    if (propertyValues[position] == null) {
                        propertyValues[position] = entityDescriptor.getPropertyValue(entity, toOneAttributeMapping.getAttributeName());
                    }
                }
            } else {
                propertyValues[position] = o;
            }
        });
        this.getEmbeddableTypeDescriptor().setValues(entity, propertyValues);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        assert (domainValue instanceof Object[]);
        this.identifierValueMapper.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.identifierValueMapper.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.identifierValueMapper.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public String getSqlAliasStem() {
        return "id";
    }

    @Override
    public String getFetchableName() {
        return "{id}";
    }

    @Override
    public int getNumberOfFetchables() {
        return this.identifierValueMapper.getNumberOfFetchables();
    }
}

