/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ZonedDateTimeComparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ZonedDateTimeJavaType
extends AbstractTemporalJavaType<ZonedDateTime>
implements VersionJavaType<ZonedDateTime> {
    public static final ZonedDateTimeJavaType INSTANCE = new ZonedDateTimeJavaType();

    public ZonedDateTimeJavaType() {
        super(ZonedDateTime.class, ImmutableMutabilityPlan.instance(), ZonedDateTimeComparator.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        TemporalType temporalPrecision = stdIndicators.getTemporalPrecision();
        JdbcTypeRegistry jdbcTypeRegistry = stdIndicators.getTypeConfiguration().getJdbcTypeRegistry();
        if (temporalPrecision == null || temporalPrecision == TemporalType.TIMESTAMP) {
            switch (stdIndicators.getDefaultTimeZoneStorageStrategy()) {
                case NORMALIZE: {
                    return jdbcTypeRegistry.getDescriptor(93);
                }
                case NORMALIZE_UTC: {
                    return jdbcTypeRegistry.getDescriptor(3003);
                }
            }
            return jdbcTypeRegistry.getDescriptor(2014);
        }
        switch (temporalPrecision) {
            case TIME: {
                return jdbcTypeRegistry.getDescriptor(92);
            }
            case DATE: {
                return jdbcTypeRegistry.getDescriptor(91);
            }
        }
        throw new IllegalArgumentException("Unexpected jakarta.persistence.TemporalType : " + temporalPrecision);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(ZonedDateTime value) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value);
    }

    @Override
    public ZonedDateTime fromString(CharSequence string) {
        return ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(ZonedDateTime zonedDateTime, Class<X> type, WrapperOptions options) {
        if (zonedDateTime == null) {
            return null;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)zonedDateTime;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            if (zonedDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            }
            return (X)Timestamp.from(zonedDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(zonedDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(zonedDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(zonedDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(zonedDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZonedDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return offsetDateTime.toZonedDateTime();
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault());
            }
            return ts.toInstant().atZone(ZoneId.systemDefault());
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Long) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public ZonedDateTime seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return ZonedDateTime.now(ClockHelper.forPrecision(precision, session));
    }

    @Override
    public ZonedDateTime next(ZonedDateTime current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return ZonedDateTime.now(ClockHelper.forPrecision(precision, session));
    }
}

